/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.plot;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import javax.swing.JPanel;
import jcm.core.cur.curvar;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.cur.makederiv;
import jcm.core.par.param;
import jcm.core.register;
import jcm.core.report;
import jcm.gui.gen.lookandfeel;
import jcm.gui.nav.jcmMenu;
import jcm.gui.nav.paramValueChooser;
import jcm.gui.plot.baseplot;

public class XYplot
extends baseplot {
    param sy;
    param ey;
    curveset qqx;
    curveset qqy;
    curvar qqv;

    public XYplot(curveset curveset2) {
        this(new Object[]{curveset2});
    }

    public XYplot(Object[] objectArray) {
        for (Object object : objectArray) {
            if (object instanceof curvar) {
                this.qqv = (curvar)object;
                this.qq = this.qqv;
            }
            try {
                this.scalesetup.add(Float.valueOf(Float.parseFloat(object.toString())));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.qqy = this.qqv.linkqq.get(0);
        this.qqx = this.qqv.linkqq.get(1);
        double d = Math.max(this.qqy.sy, this.qqx.sy);
        double d2 = Math.min(this.qqy.ey, this.qqx.ey);
        this.sy = new param(new Object[]{"from", 2002, d, d2, "year"}){

            @Override
            public void precalc() {
                XYplot.this.ey.min = this.val - 1.0;
            }
        };
        this.ey = new param("until", 2002, d, d2, "year");
        register.addlink(this, this.sy);
        register.addlink(this, this.ey);
        this.setup();
        this.xsv.setMinimumSize(new Dimension(0, 40));
        this.plot.add((Component)new paramValueChooser(this.sy, new Object[0]), "North");
        this.plot.add((Component)new paramValueChooser(this.ey, new Object[0]), "North");
    }

    @Override
    public void doplot() {
        super.repaint();
    }

    @Override
    void makeplot() {
        this.plot = new scatter();
    }

    @Override
    void makescales() {
        this.yscale = this.qqy.getyscale();
        this.xscale = this.qqx.getyscale();
        this.xscale.type = param.Type.Xscale;
    }

    @Override
    public void fillMenu(jcmMenu jcmMenu2) {
        jcmMenu2.add(makederiv.makeDerivMenu(curve.Type.extra, this.qq));
        jcmMenu2.addSeparator();
        super.fillMenu(jcmMenu2);
    }

    void plot(Graphics2D graphics2D, curveset curveset2, curveset curveset3, float f, float f2) {
        GeneralPath generalPath = new GeneralPath();
        for (Object object : curveset3.map.keySet()) {
            if (!curveset2.map.containsKey(object)) continue;
            graphics2D.setColor(curveset3.map.get((Object)object).color);
            if ((int)this.sy.getval() < (int)this.ey.getval()) {
                generalPath.reset();
                generalPath.moveTo(curveset2.get(object, (int)this.sy.val) * f, curveset3.get(object, (int)this.sy.val));
                for (int i = (int)this.sy.val + 1; i <= (int)this.ey.val; ++i) {
                    generalPath.lineTo(curveset2.get(object, i) * f, curveset3.get(object, i));
                }
                try {
                    graphics2D.draw(generalPath);
                }
                catch (Error error) {
                    report.deb(error, "line drawing error");
                }
                continue;
            }
            float f3 = -12.0f / f2;
            graphics2D.draw(new Ellipse2D.Float(curveset2.get(object, (int)this.sy.val) * f - f3, curveset3.get(object, (int)this.sy.val) - f3, f3, f3));
        }
    }

    class scatter
    extends JPanel {
        scatter() {
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            lookandfeel.setAntiAlias(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            AffineTransform affineTransform = graphics2D.getTransform();
            float f = (float)this.getWidth() / XYplot.this.xscale.range();
            float f2 = (float)(-this.getHeight()) / XYplot.this.yscale.range();
            float f3 = f / f2;
            graphics2D.scale(f2, f2);
            graphics2D.translate(-XYplot.this.xscale.min() * f3, -XYplot.this.yscale.max());
            graphics2D.setStroke(new BasicStroke(Math.abs(XYplot.this.yscale.range()) / 250.0f));
            for (curveset curveset2 : XYplot.this.qqv.linkqq) {
                if (curveset2 == XYplot.this.qqx) continue;
                XYplot.this.plot(graphics2D, XYplot.this.qqx, curveset2, f3, f2);
            }
            graphics2D.setTransform(affineTransform);
            graphics2D.dispose();
            XYplot.this.ready = true;
        }
    }
}

