/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.nav;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import jcm.StartJCM;
import jcm.core.complexity;
import jcm.core.itf.menuFiller;
import jcm.core.loop;
import jcm.core.ob.infob;
import jcm.core.register;
import jcm.core.report;
import jcm.core.setup;
import jcm.gui.doc.docview;
import jcm.gui.doc.labman;
import jcm.gui.doc.sourceview;
import jcm.gui.gen.iconFinder;
import jcm.gui.gen.lookandfeel;
import jcm.gui.nav.capwin;
import jcm.gui.nav.dragdrop;
import jcm.gui.nav.jcmAction;
import jcm.gui.nav.jcmMenu;
import jcm.gui.nav.jcmTabbedPane;
import jcm.gui.nav.jcmTree;
import jcm.gui.nav.topMenus;
import jcm.java6methods;

public class showpan {
    public static JFrame mf;
    public static dragdrop moulist;
    public static JMenuBar mb;
    public static Color bg;

    public static Rectangle screenbounds() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
    }

    public static Point screencenter() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
    }

    public static Point pointForCenter(Component component) {
        return showpan.pointForCenter(component.getSize());
    }

    public static Point pointForCenter(Dimension dimension) {
        return new Point(showpan.screencenter().x - dimension.width / 2, showpan.screencenter().y - dimension.height / 2);
    }

    public static JFrame makeMainframeDefSize() {
        Dimension dimension = new Dimension(800, 600);
        return showpan.makeMainframe(showpan.pointForCenter(dimension), dimension);
    }

    public static JFrame makeMainframeMaximised() {
        return showpan.makeMainframe(showpan.screenbounds());
    }

    public static JFrame makeMainframe(Rectangle rectangle) {
        return showpan.makeMainframe(rectangle.getLocation(), rectangle.getSize());
    }

    public static JFrame makeMainframe(Point point, Dimension dimension) {
        lookandfeel.lookAndFeelParam.precalc();
        mf = new JFrame("Java Climate Model ( www.climate.be / jcm ) [version:" + StartJCM.revisiondate + "]");
        mf.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                showpan.close();
            }
        });
        mf.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                lookandfeel.setFontSizeForFrame();
            }
        });
        JSplitPane jSplitPane = new JSplitPane(0, new jcmTabbedPane(), new jcmTabbedPane());
        JSplitPane jSplitPane2 = new JSplitPane(1, new jcmTabbedPane(), jSplitPane);
        jSplitPane.setResizeWeight(0.5);
        jSplitPane2.setResizeWeight(0.3);
        mf.setContentPane(jSplitPane2);
        mf.setJMenuBar(mb);
        mf.setLocation(point);
        mf.setPreferredSize(dimension);
        try {
            mf.setIconImage(((ImageIcon)iconFinder.findIcon("worldicon")).getImage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        topMenus.makemenus();
        java6methods.setIconImage(mf);
        mf.validate();
        mf.pack();
        mf.setVisible(true);
        try {
            mf.toFront();
        }
        catch (Exception exception) {
            report.deb(exception, "couldn't bring JCM main window to front!");
        }
        report.logn("(showpan) ====================JCM Main Window Ready========================\n");
        return mf;
    }

    public static JDesktopPane makejdp() {
        JDesktopPane jDesktopPane = new JDesktopPane();
        showpan.addpanmenu(jDesktopPane);
        return jDesktopPane;
    }

    public static void close() {
        try {
            labman.saveonexit();
        }
        catch (Exception exception) {
            report.deb(exception, "close: error during labman saveonexit");
        }
        try {
            setup.savesetupdefault();
        }
        catch (Exception exception) {
            report.deb(exception, "close: error during setup savedefault");
        }
        loop.waitUntilLoopDone();
        System.exit(0);
    }

    public static JComponent findContainerAbsolute(Point point) {
        JRootPane jRootPane = mf.getRootPane();
        Point point2 = jRootPane.getLocationOnScreen();
        return showpan.findContainer(jRootPane.findComponentAt(point.x - point2.x, point.y - point2.y));
    }

    public static JComponent findContainer(Point point) {
        return showpan.findContainer(mf.getRootPane().findComponentAt(point));
    }

    public static JComponent findContainer(Component component) {
        while (component != null && component != component.getParent() && !(component instanceof jcmTabbedPane) && !(component instanceof JDesktopPane)) {
            component = component.getParent();
        }
        return (JComponent)component;
    }

    public static jcmTabbedPane findTabbedPane(Component component) {
        return (jcmTabbedPane)showpan.findContainer(component);
    }

    public static void dispose(JComponent jComponent) {
        try {
            Container container = jComponent.getRootPane().getParent();
            jComponent.removeNotify();
            if (container != null && container != mf && (container instanceof JInternalFrame || container instanceof JFrame)) {
                try {
                    container.removeAll();
                    container.removeNotify();
                    if (container instanceof JInternalFrame) {
                        ((JInternalFrame)container).dispose();
                    }
                    if (container instanceof JFrame) {
                        ((JFrame)container).dispose();
                    }
                    return;
                }
                catch (Exception exception) {
                    report.deb(exception, "showpan error disposing frame " + jComponent);
                    return;
                }
            }
            showpan.findTabbedPane(jComponent).remove(jComponent);
        }
        catch (Exception exception) {
            report.deb(exception, "showpan error disposing " + jComponent);
        }
    }

    public static void toFront(JComponent jComponent) {
        try {
            Container container = jComponent.getRootPane().getParent();
            if (container instanceof JInternalFrame) {
                ((JInternalFrame)container).toFront();
                return;
            }
            if (container instanceof JFrame && container != mf) {
                ((JFrame)container).toFront();
                return;
            }
            showpan.findTabbedPane(jComponent).setSelectedComponent(jComponent);
        }
        catch (Exception exception) {
            report.deb(exception, "showpan: error setting toFront " + jComponent);
        }
    }

    public static Container show(JComponent jComponent, Object ... objectArray) {
        Object object;
        String string = jComponent.getName();
        Point point = null;
        Icon icon = null;
        Component component = null;
        for (Object object2 : objectArray) {
            if (object2 == null) continue;
            if (object2 instanceof String) {
                string = (String)object2;
            }
            if (object2 instanceof Point) {
                point = (Point)object2;
            }
            if (object2 instanceof Icon) {
                icon = (Icon)object2;
            }
            if (object2 instanceof Component) {
                component = (Component)object2;
            }
            if (!(object2 instanceof infob) || icon != null) continue;
            icon = ((infob)object2).getIcon();
        }
        if (icon == null) {
            icon = iconFinder.findIcon(string);
        }
        if (icon == null) {
            icon = iconFinder.findIcon(jComponent);
        }
        if (component == null) {
            if (point == null) {
                Point point2 = jComponent instanceof jcmTree ? new Point(100, 100) : (jComponent instanceof docview || jComponent instanceof sourceview ? new Point(mf.getWidth() - 100, 100) : (point = jComponent instanceof report || jComponent instanceof Box ? new Point(mf.getWidth() / 2, mf.getHeight() - 100) : new Point(mf.getWidth() / 2, mf.getHeight() / 2)));
            }
            if ((component = showpan.findContainer(point)) == null) {
                point.translate(-20, -20);
                component = showpan.findContainer(point);
            }
            if (component == null) {
                point.translate(40, 40);
                component = showpan.findContainer(point);
            }
            if (component == null) {
                mf.getGlassPane().setVisible(true);
                mf.getGlassPane().getGraphics().fillRect(point.x - 10, point.y - 10, 20, 20);
            }
            if (component == null) {
                report.deb("Try to Show " + jComponent + "\n in " + component + "\n at " + point);
            }
        }
        if (component instanceof jcmTabbedPane) {
            object = (jcmTabbedPane)component;
            if (icon != null) {
                ((jcmTabbedPane)object).addTab(labman.getTitle(string) + "  ", icon, jComponent);
            } else {
                ((jcmTabbedPane)object).addTab(labman.getTitle(string) + "  ", jComponent);
            }
            showpan.toFront(jComponent);
            return object;
        }
        if (component instanceof JDesktopPane) {
            object = (JDesktopPane)component;
            JInternalFrame[] jInternalFrameArray = ((JDesktopPane)object).getAllFrames();
            point = jInternalFrameArray.length > 0 ? new Point((jInternalFrameArray[jInternalFrameArray.length - 1].getX() + 40) % ((JComponent)object).getWidth(), (jInternalFrameArray[jInternalFrameArray.length - 1].getY() + 40) % ((JComponent)object).getHeight()) : new Point(20, 20);
            JInternalFrame jInternalFrame = new JInternalFrame(labman.getTitle(string), true, true, true);
            jInternalFrame.add(jComponent);
            jInternalFrame.pack();
            if (icon != null) {
                jInternalFrame.setFrameIcon(icon);
            }
            ((Container)object).add(jInternalFrame);
            jInternalFrame.setLocation(point);
            jInternalFrame.setVisible(true);
            showpan.toFront(jComponent);
            return jInternalFrame;
        }
        if (component instanceof JFrame) {
            object = (JFrame)component;
            ((Container)object).add(jComponent);
            ((Window)object).pack();
            if (icon != null && icon instanceof ImageIcon) {
                ((JFrame)object).setIconImage(((ImageIcon)icon).getImage());
            }
            if (point != null) {
                ((Window)object).setLocation(point);
            }
            ((Window)object).setVisible(true);
            showpan.toFront(jComponent);
            return object;
        }
        return null;
    }

    public static jcmAction pan(Class<? extends JComponent> clazz) {
        return showpan.pan(clazz.getSimpleName(), clazz, null);
    }

    public static jcmAction pan(Class<? extends JComponent> clazz, complexity complexity2) {
        return showpan.pan(clazz.getSimpleName(), clazz, null, complexity2);
    }

    public static jcmAction pan(Class<? extends JComponent> clazz, Object object) {
        return showpan.pan(object.toString(), clazz, object);
    }

    public static jcmAction pan(String string, Class<? extends JComponent> clazz, Object object) {
        return showpan.pan(string, clazz, object, complexity.simplest);
    }

    public static jcmAction pan(String string, final Class<? extends JComponent> clazz, final Object object, complexity complexity2) {
        jcmAction jcmAction2 = new jcmAction(string, complexity2){

            @Override
            public void act() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        showpan.makepan(clazz, object, new Object[0]);
                    }
                });
            }
        };
        jcmAction2.addIcon(string, object, clazz);
        return jcmAction2;
    }

    public static JComponent makepan(Class<? extends JComponent> clazz, Object object, Object ... objectArray) {
        try {
            Serializable serializable;
            JComponent jComponent;
            if (object == null) {
                jComponent = clazz.newInstance();
            } else {
                serializable = object.getClass();
                Constructor<? extends JComponent> constructor = null;
                while (true) {
                    try {
                        constructor = clazz.getConstructor(new Class[]{serializable});
                    }
                    catch (Exception exception) {
                        Class<?> clazz2;
                        if ((serializable = ((Class)serializable).isArray() ? ((clazz2 = ((Class)serializable).getComponentType().getSuperclass()) != null ? Array.newInstance(clazz2, 1).getClass() : null) : ((Class)serializable).getSuperclass()) != null) continue;
                    }
                    break;
                }
                if (constructor == null) {
                    report.deb("can't find constructor for " + clazz + " / " + object);
                    return null;
                }
                jComponent = constructor.newInstance(object);
            }
            serializable = jComponent;
            SwingUtilities.invokeLater(new Runnable((JComponent)serializable, objectArray){
                final /* synthetic */ JComponent val$com2;
                final /* synthetic */ Object[] val$args;
                {
                    this.val$com2 = jComponent;
                    this.val$args = objectArray;
                }

                @Override
                public void run() {
                    showpan.show(this.val$com2, this.val$args);
                }
            });
            register.addargs(jComponent, object);
            return jComponent;
        }
        catch (Exception exception) {
            report.deb(exception);
            return null;
        }
    }

    public static void addpanmenu(final JComponent jComponent) {
        new jcmMenu(jComponent, new menuFiller(){

            @Override
            public void fillMenu(jcmMenu jcmMenu2) {
                if (jComponent instanceof jcmTabbedPane) {
                    jcmMenu2.add(new jcmAction("Convert to Internal Frames"){

                        @Override
                        public void act() {
                            JDesktopPane jDesktopPane = showpan.makejdp();
                            JSplitPane jSplitPane = (JSplitPane)jComponent.getParent();
                            jcmTabbedPane jcmTabbedPane2 = (jcmTabbedPane)jComponent;
                            if (jSplitPane.getTopComponent() == jComponent) {
                                jSplitPane.setTopComponent(jDesktopPane);
                            } else {
                                jSplitPane.setBottomComponent(jDesktopPane);
                            }
                            mf.validate();
                            int n = 0;
                            while (n < jcmTabbedPane2.getTabCount()) {
                                showpan.show((JComponent)jcmTabbedPane2.getComponentAt(n), jDesktopPane, jcmTabbedPane2.getIconAt(n), jcmTabbedPane2.getTitleAt(n));
                            }
                        }
                    });
                }
                if (jComponent instanceof JDesktopPane) {
                    jcmMenu2.add(new jcmAction("Convert to Tabbed Pane"){

                        @Override
                        public void act() {
                            jcmTabbedPane jcmTabbedPane2 = new jcmTabbedPane();
                            JSplitPane jSplitPane = (JSplitPane)jComponent.getParent();
                            if (jSplitPane.getTopComponent() == jComponent) {
                                jSplitPane.setTopComponent(jcmTabbedPane2);
                            } else {
                                jSplitPane.setBottomComponent(jcmTabbedPane2);
                            }
                            mf.validate();
                            for (JInternalFrame jInternalFrame : ((JDesktopPane)jComponent).getAllFrames()) {
                                showpan.show((JComponent)jInternalFrame.getContentPane(), jcmTabbedPane2, jInternalFrame.getFrameIcon(), jInternalFrame.getTitle());
                                jInternalFrame.dispose();
                            }
                        }
                    });
                }
                jcmMenu2.add(new jcmAction("Remove Panel"){

                    @Override
                    public void act() {
                        JSplitPane jSplitPane = (JSplitPane)jComponent.getParent();
                        JSplitPane jSplitPane2 = (JSplitPane)jSplitPane.getParent();
                        JComponent jComponent = (JComponent)(jSplitPane.getTopComponent() == jComponent ? jSplitPane.getBottomComponent() : jSplitPane.getTopComponent());
                        if (jSplitPane2.getTopComponent() == jSplitPane) {
                            jSplitPane2.setTopComponent(jComponent);
                        } else {
                            jSplitPane2.setBottomComponent(jComponent);
                        }
                    }
                });
                jcmMenu2.add(new jcmAction("Split Vertical"){

                    @Override
                    public void act() {
                        showpan.split(jComponent, true);
                    }
                });
                jcmMenu2.add(new jcmAction("Split Horizontal"){

                    @Override
                    public void act() {
                        showpan.split(jComponent, false);
                    }
                });
            }
        });
    }

    static JComponent split(JComponent jComponent, boolean bl) {
        JSplitPane jSplitPane = (JSplitPane)jComponent.getParent();
        JSplitPane jSplitPane2 = new JSplitPane(bl ? 0 : 1);
        jSplitPane2.setResizeWeight(0.5);
        jcmTabbedPane jcmTabbedPane2 = new jcmTabbedPane();
        if (jSplitPane.getTopComponent() == jComponent) {
            jSplitPane.setTopComponent(jSplitPane2);
        } else {
            jSplitPane.setBottomComponent(jSplitPane2);
        }
        jSplitPane2.setTopComponent(jComponent);
        jSplitPane2.setBottomComponent(jcmTabbedPane2);
        return jcmTabbedPane2;
    }

    public static void addwindow(JComponent jComponent) {
        showpan.addwindow(jComponent, new Point(200, 200));
    }

    public static void addwindow(JComponent jComponent, Point point) {
        JLayeredPane jLayeredPane = mf.getLayeredPane();
        jLayeredPane.add(jComponent);
        jLayeredPane.setLayer(jComponent, JLayeredPane.POPUP_LAYER);
        jComponent.setLocation(point);
    }

    public static void topwindow(Window window, JComponent jComponent, Point point) {
        Rectangle rectangle = new Rectangle(point.x, point.y, jComponent.getSize().width + 10, jComponent.getSize().height + 10);
        capwin capwin2 = new capwin(window, rectangle);
        capwin2.add(jComponent);
        try {
            capwin2.setAlwaysOnTop(true);
        }
        catch (SecurityException securityException) {
            report.deb(securityException, "Can't Set OnTop");
        }
        capwin2.setLocation(point);
        capwin2.pack();
        capwin2.setVisible(true);
    }

    static {
        moulist = new dragdrop();
        mb = new JMenuBar();
        bg = new Color(217, 255, 217);
    }
}

