/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.nav;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import jcm.core.report;
import jcm.gui.doc.labman;
import jcm.gui.gen.lookandfeel;
import jcm.gui.nav.showpan;

public class jcmTabbedPane
extends JTabbedPane {
    List<Rectangle> rect = new LinkedList<Rectangle>();
    JSplitPane jsp;
    List<String> names = new LinkedList<String>();

    public jcmTabbedPane() {
        this.setPreferredSize(new Dimension(100, 200));
        this.addMouseListener(showpan.moulist);
        this.addMouseMotionListener(showpan.moulist);
        this.setOpaque(false);
        showpan.addpanmenu(this);
    }

    @Override
    public void addTab(String string, Component component) {
        this.addTab(string, null, component);
    }

    @Override
    public void addTab(String string, Icon icon, Component component) {
        this.names.add(string);
        super.addTab(labman.getTitle(string), icon, component);
        int n = this.getTabCount() - 1;
        this.setToolTipTextAt(n, labman.getTitle(this.names.get(n)));
        this.adjustToSpace();
    }

    void adjustToSpace() {
        int n;
        if (this.getTabRunCount() < 2) {
            for (n = 0; n < this.getTabCount(); ++n) {
                this.setTitleAt(n, labman.getTitle(this.names.get(n)));
            }
        }
        this.revalidate();
        if (this.getTabRunCount() > 1) {
            for (n = 0; n < this.getTabCount(); ++n) {
                this.setTitleAt(n, labman.getShort(this.names.get(n)));
            }
        }
        this.revalidate();
        if (this.getTabRunCount() > 1) {
            for (n = 0; n < this.getTabCount(); ++n) {
                this.setTitleAt(n, "");
            }
        }
    }

    @Override
    public void doLayout() {
        try {
            super.doLayout();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void remove(int n) {
        this.remove(this.getComponentAt(n));
    }

    @Override
    public void remove(Component component) {
        int n = this.indexOfComponent(component);
        this.names.remove(n);
        super.remove(component);
        try {
            component.removeNotify();
        }
        catch (Exception exception) {
            report.deb(exception, " removing tabbed pane");
        }
        component = null;
        this.revalidate();
        this.adjustToSpace();
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.adjustToSpace();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        try {
            lookandfeel.setAntiAlias(graphics);
            super.paintComponent(graphics);
            this.rect.clear();
            for (int i = 0; i < this.getTabCount(); ++i) {
                Rectangle rectangle = this.getUI().getTabBounds(this, i);
                int n = 9;
                int n2 = 9;
                int n3 = rectangle.x + rectangle.width - 5 - n;
                int n4 = rectangle.y + rectangle.height / 2 - n2 / 2;
                this.rect.add(new Rectangle(n3, n4, n, n2));
                graphics.setColor(Color.red);
                graphics.drawRoundRect(n3, n4, n, n2, 4, 4);
                graphics.drawLine(n3 + n, n4, n3, n4 + n2);
                graphics.drawLine(n3, n4, n3 + n, n4 + n2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    int intab(MouseEvent mouseEvent) {
        try {
            for (int i = 0; i < this.getTabCount(); ++i) {
                if (!this.getUI().getTabBounds(this, i).contains(mouseEvent.getPoint())) continue;
                return i;
            }
            return -1;
        }
        catch (Exception exception) {
            report.deb("JCMTabbedPane intab=> " + exception);
            return -1;
        }
    }

    void tryclose(MouseEvent mouseEvent) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            try {
                if (!this.rect.get(i).contains(mouseEvent.getPoint())) continue;
                this.remove(i);
                continue;
            }
            catch (Exception exception) {
                report.deb("! ---- Problem closing tab ----");
            }
        }
    }
}

