/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.nav;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import jcm.core.cur.curveset;
import jcm.core.ob.infob;
import jcm.core.par.param;
import jcm.core.report;
import jcm.gui.nav.jcmTabbedPane;
import jcm.gui.nav.jcmTree;
import jcm.gui.nav.paramValueChooser;
import jcm.gui.nav.showpan;
import jcm.gui.plot.lineplot;

public class dragdrop
implements MouseListener,
MouseMotionListener {
    JComponent source;
    public Object carrying;
    String dragname;
    Icon dragicon;
    int x;
    int y;
    int oldx = 0;
    int oldy = 0;
    int w;
    int h;
    int iw;
    int ih;
    Point p;
    Point rp;
    boolean inside;
    boolean maysplit;
    public Map<Component, infob> cimap = new WeakHashMap<Component, infob>();

    boolean getAbsLocation(MouseEvent mouseEvent) {
        try {
            this.source = (JComponent)mouseEvent.getComponent();
            this.p = this.source.getLocationOnScreen();
            this.rp = showpan.mf.getRootPane().getLocationOnScreen();
            this.x = this.p.x - this.rp.x + mouseEvent.getX() - 10;
            this.y = this.p.y - this.rp.y + mouseEvent.getY() - 10;
            this.w = this.source.getWidth();
            this.h = this.source.getHeight();
            this.inside = this.source.contains(mouseEvent.getPoint()) && (!(this.source instanceof JInternalFrame) || !((JInternalFrame)this.source).getRootPane().getContentPane().contains(mouseEvent.getPoint()));
            this.maysplit = this.inside && this.source instanceof jcmTabbedPane && ((jcmTabbedPane)this.source).intab(mouseEvent) < 0;
            return true;
        }
        catch (Exception exception) {
            report.deb("\n!-- dragdrop can't locate:" + this.source.getName() + " " + exception);
            return false;
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.carrying != null && this.dragicon != null) {
            this.getAbsLocation(mouseEvent);
            int n = this.dragicon.getIconWidth();
            int n2 = this.dragicon.getIconHeight();
            Graphics graphics = showpan.mf.getRootPane().getGlassPane().getGraphics();
            graphics.setColor(this.maysplit && mouseEvent.getY() < this.h / 2 ? Color.red : Color.white);
            graphics.drawLine(this.p.x - this.rp.x + this.w / 2, this.p.y - this.rp.y, this.p.x - this.rp.x + this.w / 2, this.p.y - this.rp.y + this.h);
            graphics.setColor(this.maysplit && mouseEvent.getY() >= this.h / 2 ? Color.red : Color.white);
            graphics.drawLine(this.p.x - this.rp.x, this.p.y - this.rp.y + this.h / 2, this.p.x - this.rp.x + this.w, this.p.y - this.rp.y + this.h / 2);
            graphics.setClip(this.oldx, this.oldy, n, n2);
            showpan.mf.getRootPane().paint(graphics);
            graphics.setClip(this.x, this.y, n, n2);
            this.dragicon.paintIcon(showpan.mf.getRootPane().getGlassPane(), graphics, this.x, this.y);
            this.oldx = this.x;
            this.oldy = this.y;
            graphics.dispose();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n;
        Object object;
        this.getAbsLocation(mouseEvent);
        if (this.cimap.get(this.source) != null && !(this.source instanceof paramValueChooser.jcmslider)) {
            object = this.cimap.get(this.source);
            this.dragicon = ((infob)object).getIcon();
            this.dragname = ((infob)object).getName();
            this.carrying = object;
        }
        if (this.source instanceof JTree) {
            object = (JTree)this.source;
            TreePath treePath = ((JTree)object).getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            Object object2 = treePath.getLastPathComponent();
            if (object2 instanceof infob && !(object2 instanceof param)) {
                infob infob2 = (infob)object2;
                this.dragicon = infob2.getIcon();
                this.dragname = infob2.getName();
                this.carrying = infob2;
            }
        }
        if (this.source instanceof jcmTabbedPane && (n = ((jcmTabbedPane)(object = (jcmTabbedPane)this.source)).intab(mouseEvent)) >= 0) {
            this.carrying = (JComponent)((JTabbedPane)object).getComponentAt(n);
            this.dragicon = ((JTabbedPane)object).getIconAt(n);
            this.dragname = ((jcmTabbedPane)object).names.get(n);
        }
        if (this.source instanceof JInternalFrame) {
            report.deb("MousePressed JIF");
            if (this.inside) {
                this.carrying = (JComponent)((JInternalFrame)this.source).getContentPane();
                this.dragicon = ((JInternalFrame)this.source).getFrameIcon();
            }
        }
        if (this.carrying != null) {
            showpan.mf.getRootPane().getGlassPane().setVisible(true);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.getAbsLocation(mouseEvent);
        if (this.source instanceof jcmTabbedPane) {
            ((jcmTabbedPane)this.source).tryclose(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.getAbsLocation(mouseEvent)) {
            return;
        }
        showpan.mf.getRootPane().getGlassPane().setVisible(false);
        if (this.carrying != null) {
            if (this.maysplit) {
                this.drop(showpan.split(this.source, mouseEvent.getY() > this.h / 2));
            } else if (!this.inside) {
                if (!showpan.mf.contains(new Point(this.x, this.y))) {
                    JFrame jFrame = new JFrame(this.dragname);
                    jFrame.setLocation(new Point(this.p.x + mouseEvent.getX(), this.p.y + mouseEvent.getY()));
                    jcmTabbedPane jcmTabbedPane2 = new jcmTabbedPane();
                    jFrame.setSize(this.source.getSize());
                    jFrame.show();
                    jcmTabbedPane2.setSize(this.source.getSize());
                    jFrame.add(jcmTabbedPane2);
                    this.drop(jcmTabbedPane2);
                } else {
                    this.drop(showpan.findContainer(new Point(this.x, this.y)));
                }
            }
            this.carrying = null;
            this.source = null;
        }
    }

    void drop(Container container) {
        if (this.carrying != null) {
            if (this.carrying instanceof JComponent) {
                if (this.source != null) {
                    this.source.remove((JComponent)this.carrying);
                }
                showpan.show((JComponent)this.carrying, container, this.dragicon, this.dragname);
            } else if (this.carrying instanceof curveset) {
                showpan.makepan(lineplot.class, this.carrying, container, this.dragicon, this.dragname);
            } else if (this.carrying instanceof infob) {
                showpan.makepan(jcmTree.class, new Object[]{this.carrying}, container, this.dragicon, this.dragname);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

