/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.gen;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.File;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import jcm.core.complexity;
import jcm.core.par.param;
import jcm.core.register;
import jcm.core.report;
import jcm.core.tls.fileio;
import jcm.gui.gen.colfont;
import jcm.gui.nav.showpan;
import jcm.java6methods;

public class lookandfeel {
    static final MetalTheme ocean = MetalLookAndFeel.getCurrentTheme();
    static final MetalTheme metal = new DefaultMetalTheme();
    static UIManager.LookAndFeelInfo systemlf;
    static UIManager.LookAndFeelInfo substance;
    static UIManager.LookAndFeelInfo nimrod;
    static UIManager.LookAndFeelInfo lastchosen;
    static UIManager.LookAndFeelInfo deflaf;
    public static boolean gotmac;
    public static param antiAlias;
    public static param fontSize;
    public static param bigscales;
    public static param<UIManager.LookAndFeelInfo> lookAndFeelParam;
    public static param macMenuBar;

    public static void setFontSizeForFrame() {
        int n = (int)(12.0 * (double)showpan.mf.getWidth() / 1024.0);
        if (n < 8) {
            n = 10;
        }
        if (n > 16) {
            n = 16;
        }
        if ((int)fontSize.getval() != n) {
            fontSize.set(n);
        }
    }

    public static void setAntiAlias(Graphics graphics) {
        if (antiAlias.istrue()) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
    }

    static void setlf(UIManager.LookAndFeelInfo lookAndFeelInfo) {
        if (lookAndFeelInfo != null) {
            String string = lookAndFeelInfo.getName();
            String string2 = lookAndFeelInfo.getClassName();
            if (string.startsWith("Metal")) {
                MetalLookAndFeel.setCurrentTheme(metal);
            }
            if (string.equals("Ocean")) {
                MetalLookAndFeel.setCurrentTheme(ocean);
            }
            try {
                UIManager.setLookAndFeel(string2);
                report.deb("L&F updating UI");
                if (showpan.mf != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SwingUtilities.updateComponentTreeUI(showpan.mf);
                        }
                    });
                }
            }
            catch (Exception exception) {
                report.deb(exception, "problem for " + string2 + " look & feel: ");
            }
        }
    }

    static {
        gotmac = false;
        try {
            int n;
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            int n2 = lookAndFeelInfoArray.length;
            for (n = 0; n < n2; ++n) {
                UIManager.LookAndFeelInfo lookAndFeelInfo = lookAndFeelInfoArray[n];
                if (!lookAndFeelInfo.getName().contains("Mac")) continue;
                gotmac = true;
                report.deb("Found Mac Look and Feel");
            }
            UIManager.installLookAndFeel("Ocean", "javax.swing.plaf.metal.MetalLookAndFeel");
            java6methods.installSubstance();
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray2 = lookAndFeelInfoArray = fileio.loadtab(new File(fileio.getOutDir("lookfeel"), "lookandfeel.info"), ",");
            n = lookAndFeelInfoArray2.length;
            for (int i = 0; i < n; ++i) {
                UIManager.LookAndFeelInfo lookAndFeelInfo = lookAndFeelInfoArray2[i];
                if (((UIManager.LookAndFeelInfo)lookAndFeelInfo).length <= 0) continue;
                UIManager.installLookAndFeel((String)((Object)lookAndFeelInfo[0]), (String)((Object)lookAndFeelInfo[1]));
            }
        }
        catch (Exception exception) {
            report.deb(exception, "look&feel install not complete: ");
        }
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : UIManager.getInstalledLookAndFeels()) {
            if (lookAndFeelInfo.getClassName().equals(UIManager.getSystemLookAndFeelClassName())) {
                systemlf = lookAndFeelInfo;
            }
            if (lookAndFeelInfo.getName().equals("Substance")) {
                substance = lookAndFeelInfo;
            }
            if (!lookAndFeelInfo.getName().equals("NimROD")) continue;
            nimrod = lookAndFeelInfo;
        }
        deflaf = gotmac ? systemlf : (nimrod != null ? nimrod : (substance != null ? substance : systemlf));
        antiAlias = new param(new Object[]{"AntiAlias", true}){

            @Override
            public void precalc() {
                if (showpan.mf != null) {
                    showpan.mf.repaint();
                }
            }
        };
        fontSize = new param(new Object[]{"FontSize", "", Float.valueOf(12.0f), Float.valueOf(0.0f), Float.valueOf(36.0f), complexity.simplest}){

            @Override
            public void precalc() {
                colfont.setFontSize(this.val);
                if (showpan.mf != null) {
                    showpan.mf.repaint();
                }
            }
        };
        bigscales = new param(new Object[]{"Larger Scales", false}){

            @Override
            public void precalc() {
                if (showpan.mf != null) {
                    showpan.mf.repaint();
                }
            }
        };
        lookAndFeelParam = new param<UIManager.LookAndFeelInfo>(new Object[]{"lookandfeelmenu", UIManager.getInstalledLookAndFeels(), deflaf, complexity.simplest}){

            @Override
            public void precalc() {
                if (this.chosen != null && !((UIManager.LookAndFeelInfo)this.chosen).equals(lastchosen)) {
                    lookandfeel.setlf((UIManager.LookAndFeelInfo)this.getchosen());
                }
                lastchosen = (UIManager.LookAndFeelInfo)this.chosen;
            }
        };
        macMenuBar = new param(new Object[]{"Use Mac Menu Bar", false}){

            @Override
            public void precalc() {
                System.setProperty("apple.laf.useScreenMenuBar", Boolean.toString(this.istrue()));
                if (lastchosen.getName().contains("Mac")) {
                    lookandfeel.setlf(lastchosen);
                }
            }
        };
        register.setAlwaysOutput(lookAndFeelParam);
        register.setAlwaysOutput(antiAlias);
        register.setAlwaysOutput(fontSize);
        register.setAlwaysOutput(bigscales);
        if (gotmac) {
            register.setAlwaysOutput(macMenuBar);
        }
    }
}

