/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.gen;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import jcm.core.complexity;
import jcm.core.itf.menuFiller;
import jcm.core.itf.plotlink;
import jcm.core.loop;
import jcm.core.ob.interacob;
import jcm.core.ob.loopcalc;
import jcm.core.par.param;
import jcm.core.register;
import jcm.core.report;
import jcm.gui.doc.docview;
import jcm.gui.doc.labman;
import jcm.gui.gen.colfont;
import jcm.gui.gen.imagesaver;
import jcm.gui.gen.lookandfeel;
import jcm.gui.nav.filter;
import jcm.gui.nav.jcmAction;
import jcm.gui.nav.jcmMenu;
import jcm.gui.nav.jcmTree;
import jcm.gui.nav.showpan;

public class interacmap
extends JPanel
implements Runnable,
plotlink {
    Map<interacob, node> map = new HashMap<interacob, node>();
    Set<node> vis = new HashSet<node>();
    Set<filter.filtertype> filters = new HashSet<filter.filtertype>(Arrays.asList(filter.filtertype.NeededParams, filter.filtertype.Curves, filter.filtertype.Maps));
    int z = 1000;
    int z2 = 1000;
    float edgepushfac = 1000.0f;
    int nstep = 0;
    int w;
    int h;
    int cx = 0;
    int cy = 0;
    int initrun = 0;
    int initsteps = 1000;
    int minlev = 1;
    boolean running = false;
    boolean painting = false;
    boolean firsttime = true;
    node centre = new node();
    node zoomcentre = new node();
    node closest = null;
    node focus = null;
    node lastfocus = null;
    JMenuBar mb;
    JLabel foclab = new JLabel("-no focus-");
    static Font bold = new Font("Arial", 1, 12);
    static Font plain = new Font("Arial", 0, 9);
    static Font italic = new Font("Arial", 2, 9);
    static interacmap cfc;
    Thread mythread;
    param level = complexity.defaultcomplexity;
    float pullfac = 0.1f;
    float pushfac = 1000.0f;
    float avdistcentre;
    float avd;

    public interacmap() {
        this((interacob)null);
    }

    public interacmap(interacob interacob2) {
        this.setName("JCM Interactions");
        intmap intmap2 = new intmap();
        cfc = this;
        this.mb = new JMenuBar();
        this.setCursor(new Cursor(13));
        this.setLayout(new BorderLayout());
        this.add((Component)intmap2, "Center");
        this.mb.add(this.foclab);
        this.mb.add(new JButton(new jcmAction("adjust"){

            @Override
            public void act() {
                interacmap.this.start();
            }
        }));
        this.mb.add(filter.getToolBar(this.filters, this, this.level));
        this.add((Component)this.mb, "North");
        report.deb("\n initial run of interacmap, cfc=" + cfc);
        if (interacob2 != null) {
            if (!this.map.containsKey(interacob2)) {
                this.map.put(interacob2, new node(interacob2));
            }
            intmap2.setfocus(this.map.get(interacob2), true, false);
        }
        loop.gonow(false);
        this.start();
        register.addlink(this, this.level);
    }

    @Override
    public void removeNotify() {
        this.running = false;
        if (cfc == this) {
            cfc = null;
        }
    }

    @Override
    public void hide() {
        if (cfc == this) {
            cfc = null;
        }
        super.hide();
    }

    @Override
    public void show() {
        cfc = this;
        super.show();
    }

    @Override
    public void doplot() {
        this.step(true, true);
        this.repaint();
    }

    public static void reset() {
        if (cfc != null) {
            block4: {
                if (!interacmap.cfc.firsttime) {
                    for (interacob object : register.alliobs) {
                        if (!object.changed || !object.needed) continue;
                        break block4;
                    }
                    return;
                }
            }
            report.deb("reset interacmap");
            interacmap.cfc.firsttime = false;
            interacmap.cfc.running = false;
            cfc.setup();
            cfc.step(true, false);
            cfc.repaint();
            for (node node2 : interacmap.cfc.map.values()) {
                node2.setlevel();
            }
        }
    }

    public void setup() {
        for (interacob interacob2 : register.alliobs) {
            if (!this.map.containsKey(interacob2)) {
                this.map.put(interacob2, new node(interacob2));
            }
            this.map.get(interacob2).setnc();
        }
        Iterator<interacob> iterator = this.map.keySet().iterator();
        while (iterator.hasNext()) {
            interacob interacob2;
            interacob2 = iterator.next();
            if (interacob2 != null && !interacob2.disposed) continue;
            iterator.remove();
        }
    }

    public void start() {
        this.running = true;
        this.initrun = 0;
        this.nstep = 0;
        this.mythread = new Thread((Runnable)cfc, "InteracMap");
        this.mythread.setPriority(1);
        this.mythread.start();
    }

    @Override
    public void run() {
        report.deb("Interacmap run ");
        while (this.running) {
            this.step(true, true);
            Thread.currentThread();
            Thread.yield();
            ++this.nstep;
            this.nstep %= 50;
            if (this.nstep == 0 && this.isShowing()) {
                this.repaint();
            }
            if (this.initrun >= this.initsteps) {
                this.running = false;
            }
            if (this.initrun >= this.initsteps) continue;
            ++this.initrun;
        }
    }

    void step(boolean bl, boolean bl2) {
        while (Thread.currentThread() == this.mythread && this.painting) {
            interacmap interacmap2 = this;
            interacmap2.mythread.yield();
        }
        if (bl2) {
            loop.waitUntilLoopDone();
        }
        this.vis.clear();
        for (node node2 : this.map.values()) {
            if (node2.lev <= this.minlev) continue;
            this.vis.add(node2);
        }
        if (bl) {
            for (node node2 : this.vis) {
                node2.random((50 - this.nstep) / 10);
            }
        }
        for (node node2 : this.vis) {
            node2.cgx = 0.0f;
            node2.cgy = 0.0f;
            node2.cj = 0;
        }
        for (node node2 : this.vis) {
            for (interacob interacob2 : node2.i.vaffectedby) {
                node node3 = this.map.get(interacob2);
                if (node3 == null || node3.lev <= this.minlev) continue;
                node2.cgx += node3.x;
                node2.cgy += node3.y;
                ++node2.cj;
                node3.cgx += node2.x;
                node3.cgy += node2.y;
                ++node3.cj;
            }
        }
        for (node node2 : this.vis) {
            if (node2.cj <= 0) continue;
            node2.x += (node2.cgx / (float)node2.cj - node2.x) / 2.0f;
            node2.y += (node2.cgy / (float)node2.cj - node2.y) / 2.0f;
        }
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        for (node node4 : this.vis) {
            f += node4.x;
            f2 += node4.y;
        }
        f3 = this.centre.x - f / (float)this.vis.size();
        f4 = this.centre.y - f2 / (float)this.vis.size();
        for (node node4 : this.vis) {
            node4.x += f3;
            node4.y += f4;
        }
        for (node node4 : this.vis) {
            node4.x += (this.centre.x - node4.x) / 80.0f;
            node4.y += (this.centre.y - node4.y) / 80.0f;
        }
        for (node node4 : this.vis) {
            node4.dx = 0.0f;
            node4.dy = 0.0f;
            node4.done = false;
        }
        for (node node4 : this.vis) {
            node4.done = true;
            for (node node5 : this.vis) {
                if (node5.done) continue;
                node4.push(node5, node4.lev * node5.lev);
            }
        }
        this.avd = 0.0f;
        for (node node4 : this.vis) {
            this.avd = (float)((double)this.avd + Math.sqrt(node4.dx * node4.dx + node4.dy * node4.dy));
        }
        this.avd /= (float)this.vis.size();
        this.pushfac = 50.0f / this.avd;
        if (this.avd > 0.0f) {
            for (node node4 : this.vis) {
                node4.move(this.pushfac);
            }
        }
    }

    class node {
        float dx;
        float dy;
        float cgx = 0.0f;
        float cgy = 0.0f;
        int cj = 0;
        float x;
        float y;
        interacob i;
        int lev = 1;
        boolean output = false;
        boolean needed = false;
        boolean changed = false;
        boolean done = false;

        node(interacob interacob2) {
            this.i = interacob2;
            this.x = (float)interacmap.this.z * (float)Math.random();
            this.y = (float)interacmap.this.z * (float)Math.random();
            this.dx = 0.0f;
            this.dy = 0.0f;
        }

        node() {
            this.x = interacmap.this.z / 2;
            this.y = interacmap.this.z / 2;
            this.dx = 0.0f;
            this.dy = 0.0f;
        }

        void setnc() {
            this.output = this.i.output;
            this.needed = this.i.needed;
            this.changed = this.i.changed;
        }

        Color getColor() {
            return this.output ? (this.changed ? colfont.purple : colfont.red) : (this.needed ? (this.changed ? colfont.blue : colfont.green) : (this.changed ? colfont.ltblue : colfont.grey));
        }

        Color getColorTo(node node2) {
            boolean bl;
            boolean bl2 = bl = this.i instanceof loopcalc && node2.i instanceof loopcalc && register.follows.containsKey(node2.i) && register.follows.get(node2.i).contains(this.i);
            return node2.needed ? (this.changed ? (bl ? colfont.dkpurple : colfont.blue) : (bl ? colfont.green : colfont.cyan)) : (this.changed ? (bl ? colfont.pink : colfont.ltblue) : (bl ? colfont.yellow : colfont.grey));
        }

        int px() {
            return interacmap.this.cx + (int)((this.x - interacmap.this.zoomcentre.x) * (float)interacmap.this.w / (float)interacmap.this.z2);
        }

        int py() {
            return interacmap.this.cy + (int)((this.y - interacmap.this.zoomcentre.y) * (float)interacmap.this.h / (float)interacmap.this.z2);
        }

        void move(int n, int n2) {
            this.x = interacmap.this.zoomcentre.x + (float)((n - interacmap.this.cx) * interacmap.this.z2 / interacmap.this.w);
            this.y = interacmap.this.zoomcentre.y + (float)((n2 - interacmap.this.cy) * interacmap.this.z2 / interacmap.this.h);
        }

        float dist(node node2) {
            return (float)Math.sqrt((node2.x - this.x) * (node2.x - this.x) + (node2.y - this.y) * (node2.y - this.y));
        }

        void setlevel() {
            block8: {
                boolean bl;
                boolean bl2 = bl = this.i.checkcomplexity() && this.i.checkenabled(interacmap.this.filters);
                if (!(bl |= register.checkneededforplotexcept(this.i, jcmTree.class))) {
                    this.lev = 0;
                    return;
                }
                int n = this.lev = this.i instanceof loopcalc ? 3 : 1;
                if (interacmap.this.focus != null) {
                    if (this == interacmap.this.focus) {
                        this.lev += 4;
                    } else if (this.i.affectedby(interacmap.this.focus.i) || this.i.affects(interacmap.this.focus.i)) {
                        this.lev += 2;
                    } else {
                        for (interacob interacob2 : this.i.vaffectedby) {
                            if (!interacob2.affectedby(interacmap.this.focus.i) && !interacob2.affects(interacmap.this.focus.i)) continue;
                            ++this.lev;
                            break block8;
                        }
                        for (interacob interacob2 : this.i.vaffects) {
                            if (!interacob2.affectedby(interacmap.this.focus.i) && !interacob2.affects(interacmap.this.focus.i)) continue;
                            ++this.lev;
                            break;
                        }
                    }
                }
            }
        }

        void random(float f) {
            this.x += (float)((double)f * (Math.random() - 0.5));
            this.y += (float)((double)f * (Math.random() - 0.5));
        }

        void push(node node2, float f) {
            float f2 = (node2.x - this.x) * (node2.x - this.x) + (node2.y - this.y) * (node2.y - this.y);
            if (f2 > 1.0f) {
                this.dx -= f / f2 * (node2.x - this.x);
                node2.dx += f / f2 * (node2.x - this.x);
                this.dy -= f / f2 * (node2.y - this.y);
                node2.dy += f / f2 * (node2.y - this.y);
            } else {
                this.dx -= f;
                node2.dx += f;
                this.dy -= f;
                node2.dy += f;
            }
        }

        void move(float f) {
            this.x += f * this.dx;
            this.y += f * this.dy;
        }
    }

    public class intmap
    extends JPanel
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener,
    menuFiller {
        Component added = null;

        public intmap() {
            this.setBackground(Color.white);
            this.setPreferredSize(new Dimension(600, 600));
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addMouseWheelListener(this);
            new jcmMenu(this);
            this.setLayout(null);
        }

        public void setfocus(node node2, boolean bl, boolean bl2) {
            interacmap.this.focus = bl ? node2 : null;
            interacmap.this.foclab.setText(interacmap.this.focus == null ? "- no focus -" : labman.getShort(interacmap.this.focus.i.name));
            if (bl2) {
                for (int i = 0; i < 5; ++i) {
                    interacmap.this.step(false, true);
                }
                this.repaint();
            }
            for (node node3 : interacmap.cfc.map.values()) {
                node3.setlevel();
            }
        }

        @Override
        public void paintComponent(Graphics graphics) {
            interacmap.this.painting = true;
            lookandfeel.setAntiAlias(graphics);
            interacmap.this.w = this.getSize().width;
            interacmap.this.h = this.getSize().height;
            if (interacmap.this.cx == 0) {
                interacmap.this.cx = interacmap.this.w / 2;
                interacmap.this.cy = interacmap.this.h / 2;
            }
            super.paintComponent(graphics);
            interacmap.this.vis.clear();
            for (node node2 : interacmap.this.map.values()) {
                if (node2.lev <= interacmap.this.minlev) continue;
                interacmap.this.vis.add(node2);
            }
            for (node node2 : interacmap.this.vis) {
                for (interacob interacob2 : node2.i.vaffectedby) {
                    int n;
                    int n2;
                    int n3;
                    node node3 = interacmap.this.map.get(interacob2);
                    if (node3 == null || node3.lev <= interacmap.this.minlev || (n3 = (int)Math.sqrt((n2 = node3.px() - node2.px()) * n2 + (n = node3.py() - node2.py()) * n)) <= 0) continue;
                    int n4 = node2.lev * n / n3;
                    int n5 = -node2.lev * n2 / n3;
                    int n6 = node3.lev * n / n3;
                    int n7 = -node3.lev * n2 / n3;
                    Polygon polygon = new Polygon();
                    polygon.addPoint(n4 + node2.px(), n5 + node2.py());
                    polygon.addPoint(-n4 + node2.px(), -n5 + node2.py());
                    polygon.addPoint(-n6 + node3.px(), -n7 + node3.py());
                    polygon.addPoint(n6 + node3.px(), n7 + node3.py());
                    Polygon polygon2 = new Polygon();
                    polygon2.addPoint(node2.px(), node2.py());
                    if (node2.i.affects(node3.i)) {
                        polygon2.addPoint((node3.px() + node2.px() + n6 + n4) / 2, (node3.py() + node2.py() + n7 + n5) / 2);
                        polygon2.addPoint(node3.px(), node3.py());
                        polygon2.addPoint((node3.px() + node2.px() - n6 - n4) / 2, (node3.py() + node2.py() - n7 - n5) / 2);
                    } else {
                        polygon2.addPoint(n6 + node3.px(), n7 + node3.py());
                        polygon2.addPoint(-n6 + node3.px(), -n7 + node3.py());
                    }
                    graphics.setColor(node3.getColorTo(node2).brighter());
                    graphics.fillPolygon(polygon2);
                }
            }
            for (node node2 : interacmap.this.vis) {
                Object object;
                if (node2.lev > interacmap.this.minlev + 1) {
                    object = node2.i.getIcon();
                    if (object == null) {
                        object = node2.i.owner.getIcon();
                    }
                    if (object != null) {
                        object.paintIcon(this, graphics, node2.px() - 10, node2.py() - 10);
                    }
                }
                object = labman.getShort(node2.i.name);
                int n = register.calclist.indexOf(node2.i);
                if (n >= 0) {
                    object = "" + n + " " + (String)object;
                }
                if (node2.i.timespent != 0L) {
                    object = (String)object + " " + (int)(node2.i.timespent / 1000L);
                }
                graphics.setFont(new Font("Arial", 0, node2.lev * 2 + 6));
                graphics.setColor(node2.getColor().darker());
                graphics.drawString((String)object, node2.px() + (node2.lev > interacmap.this.minlev + 1 ? 20 : 2), node2.py() + 3 + node2.lev);
            }
            interacmap.this.painting = false;
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (this.added != null) {
                interacmap.this.mb.remove(this.added);
                this.added = null;
            }
            if (interacmap.this.closest != null) {
                this.added = interacmap.this.closest.i.getComponent(new Object[0]);
                interacmap.this.mb.add(this.added);
                interacmap.this.mb.revalidate();
                interacmap.this.mb.repaint();
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            double d = 20.0;
            interacmap.this.closest = null;
            for (node node2 : interacmap.this.vis) {
                double d2 = Math.sqrt((mouseEvent.getX() - node2.px()) * (mouseEvent.getX() - node2.px()) + (mouseEvent.getY() - node2.py()) * (mouseEvent.getY() - node2.py()));
                if (!(d2 < d)) continue;
                d = d2;
                interacmap.this.closest = node2;
            }
            interacmap.this.zoomcentre.move(mouseEvent.getX(), mouseEvent.getY());
            interacmap.this.cx = mouseEvent.getX();
            interacmap.this.cy = mouseEvent.getY();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (interacmap.this.closest != null) {
                interacmap.this.closest.move(mouseEvent.getX(), mouseEvent.getY());
            } else {
                interacmap.this.cx = mouseEvent.getX();
                interacmap.this.cy = mouseEvent.getY();
            }
            interacmap.this.step(false, true);
            this.repaint();
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            interacmap.this.z2 = (int)((float)interacmap.this.z2 * (1.0f + (float)mouseWheelEvent.getWheelRotation() * 0.05f));
            this.repaint();
        }

        @Override
        public void fillMenu(jcmMenu jcmMenu2) {
            if (interacmap.this.closest != null) {
                jcmMenu2.add(new jcmAction(interacmap.this.focus == interacmap.this.closest ? "de-Focus" : "Focus on &" + interacmap.this.closest.i.name){

                    @Override
                    public void act() {
                        intmap.this.setfocus(interacmap.this.closest, interacmap.this.focus != interacmap.this.closest, true);
                    }
                });
                interacmap.this.closest.i.fillMenu(jcmMenu2);
            } else {
                jcmMenu2.add(showpan.pan("doc&interacmap", docview.class, "interacmap"));
                jcmMenu2.add(imagesaver.copyaction(this));
                jcmMenu2.add(imagesaver.saveimagemenu(this, "JCM-Interactions"));
            }
        }
    }
}

