/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.gen;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import jcm.core.ob.infob;
import jcm.core.report;
import jcm.core.tls.fileio;
import jcm.core.tls.txt;
import jcm.gui.doc.docview;
import jcm.gui.nav.jcmTree;

public class iconFinder {
    private static Map<URL, ImageIcon> icons;
    private static Map<String, String> iconalias;

    public static String get(String string) {
        return string == null ? null : iconalias.get(string.toLowerCase());
    }

    public static String findAlias(String string) {
        String string2 = iconFinder.get(string);
        if (string2 == null) {
            string2 = iconFinder.get(infob.removepackagename(string));
        }
        return iconFinder.get(string2);
    }

    public static String findAlias(infob infob2) {
        String string = iconFinder.get(infob2.name.toLowerCase());
        if (string == null && infob2.name.indexOf("&") > 0) {
            String string2;
            String[] stringArray = txt.split(infob2.name, "&");
            int n = stringArray.length;
            for (int i = 0; i < n && (string = iconFinder.get((string2 = stringArray[i]).toLowerCase())) == null; ++i) {
            }
        }
        if (string == null) {
            string = iconFinder.get(infob2.type());
        }
        return string;
    }

    public static String findAlias(Object object) {
        String string;
        if (object instanceof infob) {
            return iconFinder.findAlias((infob)object);
        }
        if (object instanceof String) {
            return iconFinder.findAlias((String)object);
        }
        if (object instanceof Enum) {
            return iconFinder.findAlias(object.toString());
        }
        String string2 = object instanceof jcmTree ? iconFinder.get(((jcmTree)object).getRoot().name) : (string = object instanceof docview ? iconFinder.get(((docview)object).page) : null);
        if (string == null) {
            string = iconFinder.findAlias(object.getClass().getSimpleName());
        }
        return string;
    }

    public static Icon findIcon(String string) {
        return iconFinder.getIcon(iconFinder.findAlias(string));
    }

    public static Icon findIcon(infob infob2) {
        return iconFinder.getIcon(iconFinder.findAlias(infob2));
    }

    public static Icon findIcon(Object object) {
        return iconFinder.getIcon(iconFinder.findAlias(object));
    }

    public static Icon getIcon(String string) {
        try {
            URL uRL = fileio.getURL("png/" + string + ".png");
            if (uRL != null) {
                return iconFinder.filter(uRL);
            }
            if (string != null) {
                return iconFinder.texticon(string);
            }
        }
        catch (Exception exception) {
            report.deb(exception, "can't make icon " + string);
        }
        return null;
    }

    public static Icon texticon(final String string) {
        return new Icon(){

            @Override
            public int getIconHeight() {
                return 20;
            }

            @Override
            public int getIconWidth() {
                return 20;
            }

            @Override
            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                graphics.drawRoundRect(n + 1, n2 + 1, 18, 18, 6, 6);
                Rectangle rectangle = graphics.getClipBounds();
                graphics.setClip(0, 0, 20, 20);
                graphics.drawString(string, n + 2, n2 + 16);
                graphics.setClip(rectangle);
            }
        };
    }

    static ImageIcon filter(URL uRL) {
        if (icons.get(uRL) == null) {
            try {
                BufferedImage bufferedImage = ImageIO.read(uRL);
                BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
                int n = bufferedImage.getRGB(0, 0);
                for (int i = 0; i < bufferedImage.getWidth(); ++i) {
                    for (int j = 0; j < bufferedImage.getHeight(); ++j) {
                        bufferedImage2.setRGB(i, j, bufferedImage.getRGB(i, j) == n ? 0 : bufferedImage.getRGB(i, j));
                    }
                }
                icons.put(uRL, new ImageIcon(bufferedImage2));
            }
            catch (Exception exception) {
                report.deb(exception);
                return null;
            }
        }
        return icons.get(uRL);
    }

    static {
        String[][] stringArray;
        icons = new HashMap<URL, ImageIcon>();
        iconalias = new HashMap<String, String>();
        String[][] stringArray2 = stringArray = fileio.loadtab("png/iconnames.txt", ",");
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String[] stringArray3;
            for (String string : stringArray3 = stringArray2[i]) {
                iconalias.put(string.toLowerCase(), stringArray3[0]);
            }
        }
    }
}

