/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.gen;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JButton;
import jcm.core.complexity;
import jcm.core.par.param;
import jcm.gui.doc.labman;
import jcm.gui.gen.colfont;
import jcm.gui.gen.lookandfeel;

public class Gauge
extends JButton
implements MouseListener,
MouseMotionListener {
    public int lev;
    public int max;
    public int ov = -1;
    int w;
    int h;
    int xs = 6;
    int ys = 5;
    Color ca = colfont.dkred;
    Color cb = colfont.dkgreen;
    Color cc = colfont.orange;
    param<complexity> p;

    public Gauge(int n, int n2) {
        this.lev = n;
        this.max = n2;
        this.setSize();
    }

    public Gauge(param<complexity> param2) {
        this.p = param2;
        this.lev = ((complexity)((Object)param2.chosen)).ordinal();
        complexity cfr_ignored_0 = (complexity)((Object)param2.chosen);
        this.max = complexity.values().length;
        this.setTip();
        this.setSize();
    }

    void setSize() {
        this.w = this.max * this.xs + 2;
        this.h = this.max * this.ys + 4;
        Dimension dimension = new Dimension(this.w + 4, this.h + 2);
        this.setPreferredSize(dimension);
        this.setMinimumSize(dimension);
        this.setMaximumSize(dimension);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    void setTip() {
        this.setToolTipText(labman.getShort("complexity&colon&" + ((complexity)((Object)this.p.chosen)).toString()));
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        lookandfeel.setAntiAlias(graphics);
        for (int i = 0; i < this.max; ++i) {
            int n = (i + 1) * this.ys;
            Color color = i == this.ov ? this.cc : (i <= this.lev ? this.ca : this.cb);
            graphics.setColor(color.brighter());
            graphics.drawRect(1 + i * this.xs, this.h - (i + 1) * this.ys - 2, this.xs - 1, n);
            graphics.setColor(color.darker());
            graphics.drawRect(2 + i * this.xs, this.h - (i + 1) * this.ys - 1, this.xs - 2, n - 1);
            graphics.setColor(color);
            graphics.fillRect(2 + i * this.xs, this.h - (i + 1) * this.ys - 1, this.xs - 2, n - 1);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        int n = mouseEvent.getX() / this.xs;
        if (n != this.ov) {
            this.ov = n;
            this.repaint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        int n = mouseEvent.getX() / this.xs;
        this.lev = this.ov;
        if (this.p != null) {
            this.p.set(this.lev);
            this.setTip();
        }
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.ov = -1;
        this.repaint();
    }
}

