/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.doc;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import jcm.core.complexity;
import jcm.core.par.param;
import jcm.core.register;
import jcm.core.report;
import jcm.core.tls.fileio;
import jcm.core.tls.txt;
import jcm.gui.doc.autodoc;
import jcm.gui.doc.label;
import jcm.gui.gen.processdialog;
import jcm.gui.nav.jcmAction;

public class labman {
    private static Map<String, label> ldm = new TreeMap<String, label>();
    static Map<label.langcode, Set<String>> loaded = new EnumMap<label.langcode, Set<String>>(label.langcode.class);
    public static Set<String> category = new HashSet<String>();
    static int sy = 1;
    public static param<label.langcode> language = new param(new Object[]{"languagemenu", label.langcode.values(), label.langcode.en, complexity.simplest});
    public static boolean recordchanged = false;
    public static Action loadchangesaction;
    public static Action savechangesaction;
    public static Action savecopyaction;
    static Comparator<label> labcomp;
    static String meta;
    static String style;
    static String extlink;
    static String[] opencat;
    static String[] closecat;
    static String[] openkey;
    static String[] closekey;
    static String[] closeentry;
    static String[] filesuffix;
    static String[] head;
    static String[] foot;
    public static param<label.langcode> currentlangchooser;
    public static String searchstring;
    public static boolean anywords;
    public static boolean titlesonly;

    public static void saveonexit() {
        labman.savedoc(fileio.getOutDir("labdocchanges"), true);
    }

    public static void loaddefaultchanges() {
        try {
            File file = fileio.getOutDir("labdocchanges");
            if (file.listFiles().length > 0) {
                labman.loadFromDirectory(file);
            }
        }
        catch (Exception exception) {
            report.deb(exception);
        }
    }

    public static void loadFromDirectory(File file) {
        labman.loadFromJar(label.langcode.en, "");
        String string = file.getName();
        if (string.startsWith(".")) {
            return;
        }
        if (file.isDirectory()) {
            report.deb("Updating labels from " + file);
            for (File file2 : file.listFiles()) {
                labman.loadFromDirectory(file2);
            }
        } else {
            try {
                int n = string.indexOf("_");
                int n2 = string.lastIndexOf("_");
                String string2 = n == n2 ? "" : string.substring(n + 1, n2);
                label.langcode langcode2 = label.langcode.valueOf(string.substring(n2 + 1, n2 + 3));
                if (langcode2 == null) {
                    report.deb("couldn't identify language of " + string);
                }
                labman.loadFromJar(langcode2, string2);
                labman.interpret(fileio.loadstring(file, "UTF8"), langcode2, string2);
            }
            catch (Exception exception) {
                report.deb(exception, "couldn't load file " + file);
            }
        }
    }

    public static void loadAllJarWithDialog() {
        new processdialog("Loading Labels", new JLabel("Please  wait while loading labels"), new Runnable(){

            @Override
            public void run() {
                labman.loadAllJar();
            }
        });
    }

    public static void loadAllJar() {
        for (label.langcode langcode2 : label.langcode.values()) {
            labman.loadFromJar(langcode2, "");
            for (String string : category) {
                labman.loadFromJar(langcode2, string);
            }
        }
    }

    public static void loadFromJar(label.langcode langcode2, String string) {
        if (loaded.get((Object)langcode2) == null) {
            loaded.put(langcode2, new HashSet());
        } else if (loaded.get((Object)langcode2).contains(string)) {
            return;
        }
        loaded.get((Object)langcode2).add(string);
        String string2 = string == "" ? "lab" : "doc_" + string;
        String string3 = langcode2 == label.langcode.it ? fileio.loadstring("labdoc/" + string2 + "_" + (Object)((Object)langcode2) + ".txt") : fileio.loadstring("labdoc/" + string2 + "_" + (Object)((Object)langcode2) + ".txt", "UTF8");
        recordchanged = false;
        labman.interpret(string3, langcode2, string);
        recordchanged = true;
    }

    static void interpret(String string, label.langcode langcode2, String string2) {
        if (string.length() < 1) {
            return;
        }
        report.deb("-" + (Object)((Object)langcode2) + " " + string2);
        String[] stringArray = txt.split(string, "#");
        category.add(string2);
        int n = label.smd.values().length;
        int[] nArray = new int[n + 1];
        for (String string3 : stringArray) {
            try {
                String string4;
                if (string3.indexOf("===>") >= 0) {
                    string2 = string3.substring(string3.indexOf("===>") + 4, string3.indexOf("<===")).trim();
                    category.add(string2);
                    string4 = "";
                } else {
                    string4 = labman.convertkey(txt.tonextspace(string3, 0));
                }
                label label2 = ldm.get(string4);
                if (label2 == null) {
                    if (langcode2 != label.langcode.en) {
                        report.deb((Object)((Object)langcode2) + " added " + string4);
                    }
                    label2 = new label(string4, string2);
                    ldm.put(string4, label2);
                }
                if (label2.cat != string2) {
                    label2.cat = string2;
                }
                for (label.smd smd2 : label.smd.values()) {
                    nArray[smd2.ordinal()] = string3.indexOf(smd2.getcode());
                }
                nArray[n] = string3.length();
                for (int i = n - 1; i >= 0; --i) {
                    if (nArray[i] == -1 || nArray[i] >= nArray[i + 1]) {
                        nArray[i] = nArray[i + 1];
                        continue;
                    }
                    String string5 = string3.substring(nArray[i] + 1, nArray[i + 1]).trim();
                    if (i == 0) {
                        if (langcode2 == label.langcode.en) {
                            label2.set(langcode2, label.smd.i, string5);
                        }
                    }
                    if (i == 1) {
                        label2.set(langcode2, label.smd.s, string5);
                    }
                    if (i == 2) {
                        label2.set(langcode2, label.smd.m, string5);
                    }
                    if (i == 3) {
                        label2.set(langcode2, label.smd.d, string5);
                    }
                    if (i != 4) continue;
                    label2.icon = string5;
                }
            }
            catch (Exception exception) {
                report.deb("Problem parsing " + string3);
            }
        }
        System.gc();
    }

    public static void savedoc(File file, boolean bl) {
        ArrayList<label> arrayList = new ArrayList<label>(ldm.values());
        Collections.sort(arrayList, labcomp);
        EnumSet<label.langcode> enumSet = EnumSet.complementOf(EnumSet.of(label.langcode.sc));
        String string = "dummy";
        EnumMap enumMap = new EnumMap(label.langcode.class);
        for (Object object : enumSet) {
            if (object == label.langcode.sc) continue;
            enumMap.put((label.langcode)((Object)object), new HashMap());
            for (String string2 : category) {
                ((Map)enumMap.get(object)).put(string2, new StringBuffer());
            }
        }
        EnumSet<label.langcode> enumSet2 = EnumSet.noneOf(label.langcode.class);
        for (label label2 : arrayList) {
            if (!string.equals(label2.cat)) {
                string = label2.cat;
                for (label.langcode langcode2 : enumSet) {
                    enumSet2.add(langcode2);
                }
            }
            String string3 = opencat[sy] + label2.cat + closecat[sy];
            String string4 = openkey[sy] + labman.ntb(label2.key) + closekey[sy];
            for (label.langcode langcode2 : enumSet) {
                String string5 = string4 + label2.savetext(langcode2, label.smd.i, sy);
                if (!bl && label2.isdeleted(langcode2)) continue;
                if (!(bl && label2.getchanged(langcode2, label.smd.s) == 0L && label2.getchanged(langcode2, label.smd.m) == 0L || langcode2 != label.langcode.en && label2.getorig(langcode2, label.smd.s) == null && label2.getorig(langcode2, label.smd.m) == null)) {
                    if (enumSet2.contains((Object)langcode2)) {
                        ((StringBuffer)((Map)enumMap.get((Object)langcode2)).get("")).append(string3);
                        enumSet2.remove((Object)langcode2);
                    }
                    ((StringBuffer)((Map)enumMap.get((Object)langcode2)).get("")).append("\n" + string5 + label2.savetext(langcode2, label.smd.s, sy) + label2.savetext(langcode2, label.smd.m, sy) + closeentry[sy]);
                }
                if (bl && label2.getchanged(langcode2, label.smd.d) == 0L || label2.getorig(langcode2, label.smd.d) == null) continue;
                ((StringBuffer)((Map)enumMap.get((Object)langcode2)).get(label2.cat)).append("\n\n" + string5 + label2.savetext(langcode2, label.smd.d, sy) + closeentry[sy]);
            }
        }
        if (!file.exists()) {
            file.mkdir();
        }
        for (String string6 : category) {
            for (label.langcode langcode2 : enumSet) {
                if (((StringBuffer)((Map)enumMap.get((Object)langcode2)).get(string6)).length() <= 0) continue;
                report.deb("saving " + (Object)((Object)langcode2) + " " + string6);
                fileio.savetextfile(file, (string6 == "" ? "lab" : "doc_" + string6) + "_" + (Object)((Object)langcode2) + filesuffix[sy], head[sy] + ((StringBuffer)((Map)enumMap.get((Object)langcode2)).get(string6)).toString() + foot[sy], "UTF8");
            }
        }
    }

    public static boolean gotLabelForKey(String string) {
        return ldm.containsKey(labman.convertkey(string));
    }

    public static void addLabel(String string, label label2) {
        ldm.put(labman.convertkey(string), label2);
    }

    public static label getLabel(String string) {
        return ldm.get(labman.convertkey(string));
    }

    public static List<label> getLabelList() {
        return new ArrayList<label>(ldm.values());
    }

    public static String convertkey(String string) {
        return string.trim().toLowerCase().replace(" ", "_");
    }

    public static String getShort(String string) {
        return labman.getlabeltext(string, label.smd.s);
    }

    public static String getTitle(String string) {
        return labman.getlabeltext(string, label.smd.m);
    }

    public static String getTitleIfDifferent(String string) {
        String string2 = labman.getTitle(string);
        if (!string2.equals(labman.getShort(string)) && !string2.equals(labman.getDoc(string))) {
            return "(" + string2 + ") ";
        }
        return "";
    }

    public static String getShortIfDifferent(String string) {
        String string2 = labman.getShort(string);
        if (!string2.equals(labman.getTitle(string)) && !string2.equals(labman.getDoc(string))) {
            return "(" + string2 + ") ";
        }
        return "";
    }

    public static String getDoc(String string) {
        if (string.equals("doclist")) {
            return labman.doclist();
        }
        if (string.equals("docsearch")) {
            return labman.docsearch();
        }
        return labman.getlabeltext(string, label.smd.d);
    }

    public static String getlabeltext(String string, String string2) {
        for (label.smd smd2 : label.smd.values()) {
            if (!smd2.getcode().equals(string2)) continue;
            return labman.getlabeltext(string, smd2);
        }
        return labman.getlabeltext(string, label.smd.s);
    }

    public static String getlabeltext(String string, label.smd smd2) {
        try {
            return labman.getlabeltext(string, smd2, (label.langcode)((Object)labman.currentlangchooser.chosen));
        }
        catch (Exception exception) {
            return labman.getlabeltext(string, smd2, label.langcode.en);
        }
    }

    public static String getlabeltext(String string, label.smd smd2, label.langcode langcode2) {
        String string2 = labman.convertkey(string);
        try {
            if (langcode2 == label.langcode.sc && smd2 != label.smd.d) {
                return string2;
            }
            if (string2 == "") {
                return "";
            }
            labman.loadFromJar(label.langcode.en, "");
            labman.loadFromJar(langcode2, "");
            label label2 = ldm.get(string2);
            if (label2 == null) {
                int n = string2.indexOf("&");
                if (n < 0) {
                    return smd2 != label.smd.d ? string.replace("_", " ") : "";
                }
                if (n >= string2.length() - 1) {
                    return labman.getlabeltext(string2.substring(0, n), smd2);
                }
                String string3 = labman.getlabeltext(string2.substring(0, n), smd2);
                String string4 = labman.getlabeltext(string2.substring(n + 1), smd2);
                return string3 + (string3.length() > 1 ? " " : "") + string4;
            }
            if (smd2 == label.smd.d) {
                labman.loadFromJar(label.langcode.en, label2.cat);
                labman.loadFromJar(langcode2, label2.cat);
            }
            return label2.get(langcode2, smd2);
        }
        catch (RuntimeException runtimeException) {
            report.deb(" getlabel " + (Object)((Object)smd2) + " " + string2 + " : " + runtimeException);
            return (smd2 != label.smd.d ? "!" : "can't find ") + string2;
        }
    }

    public static String ntb(String string) {
        return string == null ? "" : string;
    }

    public static void search(String string, boolean bl, boolean bl2) {
        searchstring = string;
        anywords = bl;
        titlesonly = bl2;
    }

    public static String docsearch() {
        return labman.searchresults();
    }

    public static String searchresults() {
        if (searchstring.equals("")) {
            return "\u00a3\u00a7aboutsearch";
        }
        TreeMap<Float, String> treeMap = new TreeMap<Float, String>();
        String[] stringArray = txt.split(searchstring.trim(), " ", true);
        for (label object : ldm.values()) {
            boolean bl = !anywords;
            float f = 1.0f;
            try {
                for (int runtimeException = 0; runtimeException < stringArray.length; ++runtimeException) {
                    String string = stringArray[runtimeException].toLowerCase();
                    boolean bl2 = false;
                    float f2 = 0.0f;
                    EnumSet<label.langcode> enumSet = EnumSet.complementOf(EnumSet.of(label.langcode.sc));
                    for (label.smd smd2 : label.smd.values()) {
                        String string2;
                        if (smd2 == label.smd.i || titlesonly && smd2 == label.smd.d || (string2 = (smd2 != label.smd.d ? labman.getlabeltext(object.key, smd2) : autodoc.parse(labman.getlabeltext(object.key, smd2), register.findiob(object.key), false)).toLowerCase()).length() <= 0) continue;
                        int n = -1;
                        while ((n = string2.indexOf(string, n + 1)) > 0) {
                            bl2 = true;
                            f2 = (float)((double)f2 + 10.0 / Math.pow(1000 + string2.length(), 0.33));
                        }
                    }
                    bl = anywords ? (bl |= bl2) : (bl &= bl2);
                    f *= f2;
                }
                if (!bl) continue;
                treeMap.put(Float.valueOf(100.0f - f), "<li>(" + (int)f + ") @" + object.key + " " + labman.getTitleIfDifferent(object.key));
            }
            catch (RuntimeException string) {
                report.deb(string, "Search error" + object.key);
            }
        }
        StringBuffer stringBuffer = new StringBuffer(" \u00a3\u00a7aboutsearch ==\u00a3`searchresults : " + searchstring + " ==");
        for (String string : treeMap.values()) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static String doclist() {
        label.langcode langcode2 = (label.langcode)((Object)labman.language.chosen);
        labman.loadFromJar(langcode2, "");
        for (String string : category) {
            labman.loadFromJar(langcode2, string);
        }
        TreeSet treeSet = new TreeSet();
        for (label object2 : ldm.values()) {
            try {
                String string;
                if (object2.key.startsWith("!") || object2.key.equals("doclist") || object2.key.length() <= 1) continue;
                string = " " + (labman.getTitleIfDifferent(object2.key) != labman.getShort(object2.key) ? labman.getTitleIfDifferent(object2.key) + " " : "");
                treeSet.add(object2.get(label.langcode.en, label.smd.d) != null ? autodoc.link(object2.key) + string : "%%" + labman.getShort(object2.key) + string + "%%");
            }
            catch (Exception string) {
                report.deb("doclist problem with key " + object2.key + ": " + string);
            }
        }
        StringBuffer stringBuffer = new StringBuffer("\u00a3\u00a7doclistinfo ");
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string == null) continue;
            stringBuffer.append("<li>" + string);
        }
        return stringBuffer.toString();
    }

    static {
        register.setAlwaysOutput(language);
        loadchangesaction = new jcmAction("Load Changes"){

            @Override
            public void act() {
                labman.loadFromDirectory(fileio.getFileFromDialog("", "labdocchanges", "Choose Directory for Loading LabDoc Changes", "load"));
            }
        };
        savechangesaction = new jcmAction("Save Changes"){

            @Override
            public void act() {
                labman.savedoc(fileio.getFileFromDialog("", "labdocchanges", "Choose Directory for Saving LabDoc Changes", "save"), true);
            }
        };
        savecopyaction = new jcmAction("Save All"){

            @Override
            public void act() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        labman.loadAllJar();
                        labman.savedoc(fileio.getFileFromDialog("..", "labdoc", "Choose Directory for Saving LabDoc", "save"), false);
                    }
                });
            }
        };
        labcomp = new Comparator<label>(){

            @Override
            public int compare(label label2, label label3) {
                return label2.fo.compareTo(label3.fo);
            }
        };
        meta = "<meta http-equiv='Content-Type' content='text/html; charset=UTF-8'/>";
        style = "<style> cat { color: orange font: bold 120% } dt { color: red} lab { color: brown } pop { color: green  } link { color: blue } note { font: italic 70% } icon, info { color: magenta; font: italic  } </style>";
        extlink = "This is part of the labels / documentation for <a href='http://jcm.chooseclimate.org'>Java Climate Model</a><hr/>";
        opencat = new String[]{"</dl><hr/><dl compact><cat>", "\n\n#! ===>"};
        closecat = new String[]{"</cat>", "<==="};
        openkey = new String[]{"<dt>", "#"};
        closekey = new String[]{"</dt><dd> ", ""};
        closeentry = new String[]{"</dd>", ""};
        filesuffix = new String[]{".html", ".txt"};
        head = new String[]{"<html><head>" + meta + style + "</head><body>" + extlink + "<dl  compact>", extlink};
        foot = new String[]{"</dl></html>", ""};
        currentlangchooser = language;
        searchstring = "";
        anywords = false;
        titlesonly = false;
    }
}

