/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.doc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Stack;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.html.FormSubmitEvent;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.rtf.RTFEditorKit;
import jcm.core.complexity;
import jcm.core.itf.hasSetupInfo;
import jcm.core.itf.menuFiller;
import jcm.core.itf.plotlink;
import jcm.core.loop;
import jcm.core.ob.infob;
import jcm.core.par.param;
import jcm.core.register;
import jcm.core.report;
import jcm.core.setup;
import jcm.core.tls.cs;
import jcm.core.tls.txt;
import jcm.gui.doc.autodoc;
import jcm.gui.doc.labdoctable;
import jcm.gui.doc.label;
import jcm.gui.doc.labman;
import jcm.gui.doc.sourceview;
import jcm.gui.gen.colfont;
import jcm.gui.gen.iconFinder;
import jcm.gui.gen.lookandfeel;
import jcm.gui.nav.jcmAction;
import jcm.gui.nav.jcmMenu;
import jcm.gui.nav.jcmTabbedPane;
import jcm.gui.nav.showpan;
import jcm.java6methods;

public class docview
extends JPanel
implements DocumentListener,
plotlink,
menuFiller,
hasSetupInfo {
    public param<label.langcode> language;
    public static param helpmode = new param("helpmode", false);
    public static param autosave = new param("autosave", true);
    public String page;
    public static docview current;
    JSplitPane jsp;
    JCMEditorPane ep;
    JPanel edit;
    JTextField search;
    JTextField key;
    JTextField tfs;
    JTextField tfm;
    JTextField tfc;
    JTextField tfi;
    JLabel jlc;
    JLabel jli;
    JLabel jls;
    JLabel jlm;
    JLabel jld;
    JLabel changeddate;
    JTextArea tal;
    JTextArea tal2;
    label curlab;
    label.langcode lang;
    Stack<String> history;
    Stack<String> forward;
    boolean changepage;
    boolean showedit;
    boolean showhtml;
    static long timelastsave;
    static int countchanges;

    public docview() {
        this("welcome");
    }

    public docview(Object object) {
        this(object.toString());
    }

    public docview(String string) {
        this.language = new param(new Object[]{"languagemenu", label.langcode.values(), labman.language.chosen});
        this.page = "mainmenu";
        this.jsp = new JSplitPane();
        this.ep = new JCMEditorPane();
        this.edit = new JPanel(new GridBagLayout());
        this.search = new JTextField();
        this.key = new JTextField();
        this.tfs = new JTextField();
        this.tfm = new JTextField();
        this.tfc = new JTextField();
        this.tfi = new JTextField();
        this.jlc = new JLabel(" cat ");
        this.jli = new JLabel(" info ");
        this.jls = new JLabel(" sho ");
        this.jlm = new JLabel(" med ");
        this.jld = new JLabel(" chg ");
        this.changeddate = new JLabel("");
        this.tal = new JTextArea();
        this.tal2 = new JTextArea();
        this.history = new Stack();
        this.forward = new Stack();
        this.changepage = true;
        this.showedit = false;
        this.showhtml = false;
        this.setupcomponents();
        this.makeeditlayout();
        this.makemenus();
        current = this;
        this.page = string;
        this.page = this.page.trim().replace(" ", "_");
        this.setpage(this.page);
        register.addlink(this, complexity.defaultcomplexity);
        register.addlink(this, lookandfeel.fontSize);
        register.addlink(this, lookandfeel.antiAlias);
        this.language.register();
        register.addlink(this, this.language);
    }

    void setupcomponents() {
        this.setLayout(new BorderLayout());
        this.jsp.setName("JCM Documentation");
        this.jsp.setOrientation(1);
        this.jsp.setPreferredSize(new Dimension(400, 600));
        this.add((Component)this.jsp, "Center");
        this.setPreferredSize(new Dimension(400, 600));
        this.tfs.getDocument().addDocumentListener(this);
        this.tfm.getDocument().addDocumentListener(this);
        this.tfc.getDocument().addDocumentListener(this);
        this.tfi.getDocument().addDocumentListener(this);
        this.tfc.setMinimumSize(new Dimension(50, 16));
        this.tal.getDocument().addDocumentListener(this);
        this.tal.setFont(colfont.normalfont);
        this.tal2.setFont(colfont.normalfont);
        this.tal2.setEditable(false);
        this.tal2.setForeground(colfont.brown);
        this.tal2.setWrapStyleWord(true);
        this.tal.setWrapStyleWord(true);
        this.tal.setLineWrap(true);
        this.tal2.setLineWrap(true);
        JPanel jPanel = new JPanel(new BorderLayout());
        JCMEditorPane jCMEditorPane = new JCMEditorPane();
        jCMEditorPane.setText(autodoc.maketopmenu());
        jPanel.add((Component)jCMEditorPane, "North");
        jPanel.add((Component)new JScrollPane(this.ep), "Center");
        this.jsp.setLeftComponent(jPanel);
        this.jsp.setRightComponent(this.edit);
        this.jsp.setResizeWeight(1.0);
    }

    void makeeditlayout() {
        JSplitPane jSplitPane = new JSplitPane(0, new JScrollPane(this.tal), new JScrollPane(this.tal2));
        jSplitPane.setResizeWeight(0.7);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        this.edit.add((Component)this.jlc, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.edit.add((Component)this.tfc, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        this.edit.add((Component)this.jli, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        this.edit.add((Component)this.tfi, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        this.edit.add((Component)this.jls, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        this.edit.add((Component)this.tfs, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        this.edit.add((Component)this.jlm, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.edit.add((Component)this.tfm, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        this.edit.add((Component)this.jld, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.edit.add((Component)this.changeddate, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        this.edit.add((Component)jSplitPane, gridBagConstraints);
    }

    @Override
    public void savesetup() {
        List list = register.getargs(this);
        list.clear();
        list.add(this.page);
    }

    public void showpage() {
        this.lang = (label.langcode)((Object)this.language.chosen);
        long l = 0L;
        for (label.smd smd2 : label.smd.values()) {
            l = Math.max(l, this.curlab.getchanged(this.lang, smd2));
        }
        this.changeddate.setText(l == 0L ? "" : new Date(l).toGMTString());
        labman.currentlangchooser = this.language;
        final Rectangle rectangle = this.changepage ? new Rectangle(1, 1, 1, 1) : new Rectangle(this.ep.getVisibleRect());
        this.ep.setText(autodoc.makedoc(this.page));
        labman.currentlangchooser = labman.language;
        rectangle.x = 0;
        rectangle.width = this.ep.getWidth() - 10;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                docview.this.ep.scrollRectToVisible(rectangle);
            }
        });
    }

    @Override
    public void doplot() {
        this.setpage(this.page);
    }

    public void setpage(String string) {
        Object object;
        if ((string = string.trim().replace(" ", "_")).equals("back")) {
            if (!this.history.isEmpty()) {
                this.forward.push(this.page);
                this.page = this.history.pop();
            }
        } else if (string.equals("forward")) {
            if (!this.forward.isEmpty()) {
                this.history.push(this.page);
                this.page = this.forward.pop();
            }
        } else {
            this.history.push(this.page);
            this.page = string;
            autodoc.visited.add(string);
        }
        report.deb("show doc page " + this.page);
        Container container = this.getParent();
        if (container instanceof jcmTabbedPane && ((JTabbedPane)(object = (jcmTabbedPane)container)).getSelectedComponent().equals(this)) {
            ((JTabbedPane)object).setTitleAt(((JTabbedPane)object).getSelectedIndex(), labman.getTitle(this.page));
            ((JTabbedPane)object).setIconAt(((JTabbedPane)object).getSelectedIndex(), iconFinder.findIcon(this.page));
        }
        this.curlab = labman.getLabel(this.page);
        if (this.curlab == null) {
            this.curlab = new label(this.page, "new");
        }
        this.changepage = true;
        labman.currentlangchooser = this.language;
        this.tfs.setText(this.curlab.getorig((label.langcode)((Object)this.language.chosen), label.smd.s));
        this.tfm.setText(this.curlab.getorig((label.langcode)((Object)this.language.chosen), label.smd.m));
        this.tfi.setText(this.curlab.getorig((label.langcode)((Object)this.language.chosen), label.smd.i));
        this.tfc.setText(this.curlab.cat);
        this.tal.setText(this.curlab.getorig((label.langcode)((Object)this.language.chosen), label.smd.d));
        object = autodoc.findob(this.page);
        this.tal2.setText(object == null ? "" : ((infob)object).getExtraDoc());
        this.key.setText(this.page);
        this.changepage = false;
        this.setName(this.page);
        this.showpage();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updatedoc(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updatedoc(documentEvent);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updatedoc(documentEvent);
    }

    public void updatedoc(DocumentEvent documentEvent) {
        if (this.curlab != null && !this.changepage) {
            if (this.curlab.cat.equals("new")) {
                labman.addLabel(this.page, this.curlab);
            }
            Document document = documentEvent.getDocument();
            if (documentEvent.getDocument() == this.tal.getDocument()) {
                this.curlab.set(this.lang, label.smd.d, this.nullifempty(this.tal.getText()));
            } else if (document == this.tfm.getDocument()) {
                this.curlab.set(this.lang, label.smd.m, this.nullifempty(this.tfm.getText()));
            } else if (document == this.tfs.getDocument()) {
                this.curlab.set(this.lang, label.smd.s, this.nullifempty(this.tfs.getText()));
            } else if (document == this.tfi.getDocument()) {
                this.curlab.set(this.lang, label.smd.i, this.nullifempty(this.tfi.getText()));
            } else if (document == this.tfc.getDocument()) {
                this.curlab.cat = this.tfc.getText();
                this.curlab.setchanged(this.lang);
                labman.category.add(this.tfc.getText());
            }
            this.showpage();
            this.autosave();
        }
    }

    String nullifempty(String string) {
        return string.equals("") ? null : string;
    }

    void autosave() {
        if (autosave.istrue()) {
            long l = System.currentTimeMillis() - timelastsave;
            if (++countchanges % 50 == 0) {
                report.deb("doc-edit (unsaved): " + countchanges + " changes during " + l / 60000L + " minutes");
            }
            if (countchanges > 250 && l > 60000L || countchanges > 50 && l > 120000L || countchanges > 10 && l > 300000L) {
                loop.waitUntilLoopDone();
                labman.saveonexit();
                setup.savesetupdefault();
                report.log("Auto-saved labdoc and setup OK");
                System.gc();
                countchanges = 0;
                timelastsave = System.currentTimeMillis();
            }
        }
    }

    void makemenus() {
        new jcmMenu(this.tal, this);
        new jcmMenu(this.tal2, this);
        final JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.language.getMenuItem());
        jcmMenu jcmMenu2 = new jcmMenu(new Object[]{"Edit Doc"});
        jcmMenu2.add(new JCheckBoxMenuItem(new jcmAction("Edit Doc Source"){

            @Override
            public void act() {
                boolean bl = docview.this.showedit = !docview.this.showedit;
                if (docview.this.showedit) {
                    docview.this.edit.setVisible(true);
                    docview.this.jsp.setDividerLocation(0.6);
                    docview.this.setpage(docview.this.page);
                } else {
                    docview.this.edit.setVisible(false);
                }
            }
        }));
        jcmMenu2.add(new JCheckBoxMenuItem(new jcmAction("Show HTML"){

            @Override
            public void act() {
                docview.this.showhtml = !docview.this.showhtml;
                docview.this.ep.setContentType("text/" + (docview.this.showhtml ? "plain;" : "html;"));
                docview.this.ep.setup();
                docview.this.showpage();
            }
        }));
        jcmMenu2.addSeparator();
        jcmMenu2.add(labman.loadchangesaction);
        jcmMenu2.add(labman.savechangesaction);
        jcmMenu2.add(labman.savecopyaction);
        jcmMenu2.add(autosave);
        jcmMenu2.addSeparator();
        jcmMenu2.add(showpan.pan(labdoctable.class));
        jcmMenu2.add(showpan.pan("New Doc Window", docview.class, this.page));
        jcmMenu2.add(showpan.pan("Help about Edit-Doc", docview.class, "EditDoc"));
        jcmMenu2.add(new JCheckBoxMenuItem(new jcmAction("Print"){

            @Override
            public void act() {
                docview.this.print();
            }
        }));
        jcmMenu2.add(new JCheckBoxMenuItem(new jcmAction("Export RTF", complexity.experimental){

            @Override
            public void act() {
                docview.this.exportRTF();
            }
        }));
        jcmMenu2.add(new jcmAction("Change Key"){

            @Override
            public void act() {
                String string = JOptionPane.showInputDialog(docview.this.ep, "New name for this label/doc item?", docview.this.curlab.key).trim().replace(" ", "_");
                docview.this.curlab.changekey(string);
                docview.this.setpage(string);
            }
        });
        jcmMenu2.add(new jcmAction("Delete Key"){

            @Override
            public void act() {
                docview.this.curlab.setdeleted(docview.this.lang);
                docview.this.setpage(docview.this.key.getText());
            }
        });
        jMenuBar.add(jcmMenu2);
        this.key.setPreferredSize(new Dimension(120, 16));
        jMenuBar.add(new JLabel("key:"));
        jMenuBar.add(this.key);
        this.key.addActionListener(new jcmAction("Goto Item"){

            @Override
            public void act() {
                docview.this.setpage(docview.this.key.getText());
            }
        });
        jMenuBar.add(new JLabel("search"));
        jMenuBar.add(this.search);
        this.search.addActionListener(new jcmAction("Search"){

            @Override
            public void act() {
                labman.search(docview.this.search.getText(), false, false);
                docview.this.setpage("docsearch");
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                docview.this.edit.setVisible(false);
                docview.this.add((Component)jMenuBar, "North");
            }
        });
    }

    @Override
    public void fillMenu(jcmMenu jcmMenu2) {
        String string = ((JTextArea)jcmMenu2.getInvoker()).getText();
        jcmMenu2.add("goto subcomponent: ");
        cs cs2 = new cs(string);
        int n = 0;
        while ((n = cs2.s.indexOf("\u00a3", n) + 2) > 1) {
            int n2 = cs2.nextspace(n);
            final String string2 = cs2.s.substring(n, n2);
            jcmMenu2.add(new jcmAction(string2){

                @Override
                public void act() {
                    docview.this.setpage(string2);
                }
            });
            n = n2;
        }
    }

    public static jcmAction showdocaction(final infob infob2) {
        jcmAction jcmAction2 = new jcmAction("Doc&" + infob2.name, infob2.mycomplexity){

            @Override
            public void act() {
                if (helpmode.istrue()) {
                    docview.helponclick(infob2.name);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            showpan.makepan(docview.class, infob2.name, new Object[0]);
                        }
                    });
                }
            }
        };
        jcmAction2.addIcon(infob2.name, infob2, docview.class);
        return jcmAction2;
    }

    public static void helponclick(final String string) {
        if (helpmode.istrue()) {
            if (current == null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        showpan.makepan(docview.class, string, new Object[0]);
                    }
                });
            } else {
                current.setpage(string);
                showpan.toFront(current);
            }
        }
    }

    @Override
    public void removeNotify() {
        if (current == this) {
            current = null;
        }
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        current = this;
        super.addNotify();
    }

    public void print() {
        java6methods.print(this.ep);
    }

    public void exportRTF() {
        Document document = this.ep.getDocument();
        RTFEditorKit rTFEditorKit = new RTFEditorKit();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream("/java/jcm/jcm-svn/test.rtf");
            rTFEditorKit.write(fileOutputStream, document, 0, document.getLength());
            report.deb("exported RTF OK");
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            report.deb("problem creating RTF: " + iOException);
        }
        catch (BadLocationException badLocationException) {
            report.deb("problem creating RTF: " + badLocationException);
        }
    }

    static {
        timelastsave = System.currentTimeMillis();
        countchanges = 0;
    }

    public class JCMEditorPane
    extends JEditorPane
    implements HyperlinkListener,
    MouseListener {
        public JCMEditorPane() {
            this.setContentType("text/html;");
            this.setup();
            this.fixkit();
        }

        void fixkit() {
            EditorKit editorKit = this.getEditorKit();
            if (editorKit instanceof HTMLEditorKit) {
                ((HTMLEditorKit)editorKit).setAutoFormSubmission(false);
            }
        }

        @Override
        public void paintComponent(Graphics graphics) {
            lookandfeel.setAntiAlias(graphics);
            super.paintComponent(graphics);
        }

        void setup() {
            this.setEditable(false);
            this.addHyperlinkListener(this);
            this.addMouseListener(this);
            try {
                ((HTMLDocument)this.getDocument()).setBase(register.class.getResource("/png/"));
            }
            catch (Exception exception) {
                report.deb(exception);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                report.log("linkto: " + hyperlinkEvent.getDescription());
            }
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String string = hyperlinkEvent.getDescription();
                if (hyperlinkEvent instanceof FormSubmitEvent) {
                    string = ((FormSubmitEvent)hyperlinkEvent).getData();
                    report.deb("HTML Form data: " + ((FormSubmitEvent)hyperlinkEvent).getData());
                    string = string.replace("=", "!");
                }
                if (string.startsWith("#")) {
                    docview.this.ep.scrollToReference(hyperlinkEvent.getDescription().substring(1));
                    return;
                }
                if (string.indexOf("!") > 0) {
                    String[] stringArray = txt.split(string, "!");
                    if (stringArray[0].equals("source")) {
                        showpan.makepan(sourceview.class, "src/" + stringArray[1].replace(".", "/") + ".java", new Object[0]);
                    }
                    if (stringArray[0].equals("setup")) {
                        setup.loadpacksetup(stringArray[1].replace(".", "/"));
                    }
                    return;
                }
                docview.this.setpage(string);
            }
        }
    }
}

