/*
 * Decompiled with CFR 0.152.
 */
package jcm.core.tls;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.TreeSet;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import jcm.core.ob.world;
import jcm.core.reg.regman;
import jcm.core.register;
import jcm.core.report;
import jcm.core.tls.meminfo;
import jcm.gui.doc.labman;
import jcm.gui.nav.showpan;

public class memoryChecker
implements Runnable {
    static HTMLDocument report;
    static Map<Object, meminfo> allinfo;
    static Queue<meminfo> checkqueue;

    public static void checkall() {
        new Thread((Runnable)new memoryChecker(), "Memory Checker").start();
    }

    @Override
    public void run() {
        Thread.currentThread().setPriority(1);
        Thread.currentThread();
        Thread.yield();
        allinfo.clear();
        System.gc();
        byte[] byArray = new byte[1000000];
        jcm.core.report.deb("Checking All Objects");
        memoryChecker.show();
        memoryChecker.report("JCM memory use, starting from world.class");
        memoryChecker.report("<i>beware this process itself uses a lot of memory and prevents memory from being cleared!</i><hr>");
        try {
            meminfo.get(world.class);
            while (!checkqueue.isEmpty()) {
                checkqueue.poll().check();
            }
            meminfo.get(regman.class);
            while (!checkqueue.isEmpty()) {
                checkqueue.poll().check();
            }
            meminfo.get(labman.class);
            while (!checkqueue.isEmpty()) {
                checkqueue.poll().check();
            }
            meminfo.get(register.class);
            while (!checkqueue.isEmpty()) {
                checkqueue.poll().check();
            }
            meminfo.get(showpan.class);
            while (!checkqueue.isEmpty()) {
                checkqueue.poll().check();
            }
        }
        catch (Error error) {
            byArray = null;
            System.gc();
            jcm.core.report.deb(error);
            memoryChecker.report("UNFINISHED DUE TO LACK OF MEMORY <hr>");
        }
        byArray = null;
        jcm.core.report.deb("Calc Size");
        for (meminfo iterator2 : allinfo.values()) {
            if (iterator2.parent != null) continue;
            iterator2.sublev = 0;
        }
        for (meminfo meminfo2 : allinfo.values()) {
            meminfo2.calcsizesub();
        }
        for (meminfo meminfo3 : allinfo.values()) {
            if (meminfo3.sub == null) continue;
            Collections.sort(meminfo3.sub);
        }
        Object object = new TreeSet();
        for (meminfo meminfo4 : allinfo.values()) {
            if (meminfo4.sublev >= 1 || meminfo4.size + meminfo4.sizesub <= 0) continue;
            object.add(meminfo4);
        }
        jcm.core.report.deb("Report");
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            meminfo meminfo4;
            meminfo4 = (meminfo)iterator.next();
            memoryChecker.report(meminfo4.report() + "</div>");
        }
        object = null;
        System.gc();
    }

    static void report(String string) {
        try {
            report.insertBeforeEnd(report.getDefaultRootElement(), string);
        }
        catch (Exception exception) {
            jcm.core.report.deb(exception);
        }
    }

    static void show() {
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setContentType("text/html;");
        report = (HTMLDocument)jEditorPane.getDocument();
        jEditorPane.setEditable(false);
        jEditorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    memoryChecker.open(hyperlinkEvent);
                }
            }
        });
        final JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                jFrame.dispose();
                report = null;
                allinfo.clear();
                System.gc();
            }
        });
        jFrame.setSize(800, 800);
        jFrame.setContentPane(new JScrollPane(jEditorPane));
        jFrame.show();
    }

    static void open(HyperlinkEvent hyperlinkEvent) {
        jcm.core.report.deb("open " + hyperlinkEvent.getDescription());
        String string = hyperlinkEvent.getDescription();
        meminfo meminfo2 = null;
        for (meminfo object : allinfo.values()) {
            if (!string.equals(object.code())) continue;
            meminfo2 = object;
            break;
        }
        if (meminfo2 == null) {
            jcm.core.report.deb("Can't find object");
            return;
        }
        try {
            meminfo2.open = !meminfo2.open;
            Object object = meminfo2.report();
            if (meminfo2.open && meminfo2.sub != null) {
                for (meminfo meminfo3 : meminfo2.sub) {
                    if (meminfo3.size + meminfo3.sizesub <= 0) continue;
                    object = (String)object + meminfo3.report() + " </div>";
                }
            }
            object = (String)object + " </div>";
            report.setOuterHTML(report.getElement(string), (String)object);
        }
        catch (Exception exception) {
            jcm.core.report.deb(exception);
        }
    }

    static {
        allinfo = new LinkedHashMap<Object, meminfo>();
        checkqueue = new LinkedList<meminfo>();
    }
}

