/*
 * Decompiled with CFR 0.152.
 */
package jcm.core.tls;

import java.awt.Component;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import jcm.core.ob.infob;
import jcm.core.report;
import jcm.core.tls.memoryChecker;

class meminfo
implements Comparable<meminfo> {
    boolean inc = false;
    boolean open = false;
    int size = 0;
    int sizesub = 0;
    int sublev = 0;
    String name;
    long created = System.currentTimeMillis();
    Object ob;
    meminfo parent = null;
    List<meminfo> sub = null;

    @Override
    public int compareTo(meminfo meminfo2) {
        int n = meminfo2.size + meminfo2.sizesub - (this.size + this.sizesub);
        if (n == 0) {
            n = 1;
        }
        return n;
    }

    meminfo(String string, Object object, int n) {
        this.name = string;
        this.ob = object;
        this.sublev = n;
        memoryChecker.allinfo.put(this.ob, this);
        memoryChecker.checkqueue.add(this);
    }

    static meminfo get(Class clazz) {
        return meminfo.get("", clazz, 0);
    }

    static meminfo get(String string, Object object, int n) {
        if (object == null) {
            return null;
        }
        meminfo meminfo2 = memoryChecker.allinfo.get(object);
        if (meminfo2 != null) {
            return meminfo2;
        }
        if (object instanceof Class) {
            string = "CLASS:_";
        }
        if (!(object instanceof Class)) {
            meminfo.get(object.getClass());
        }
        return new meminfo(string, object, n);
    }

    void addob(String string, Object object) {
        if (object == null || object == this.ob) {
            return;
        }
        meminfo meminfo2 = meminfo.get(string, object, this.sublev + 1);
        if (this.maydescend(meminfo2)) {
            if (meminfo2.parent != null && meminfo2.parent.sub != null) {
                meminfo2.parent.sub.remove(meminfo2);
            }
            if (this.sub == null) {
                this.sub = new ArrayList<meminfo>(4);
            }
            meminfo2.parent = this;
            meminfo2.sublev = this.sublev + 1;
            this.sub.add(meminfo2);
        }
    }

    int calcsizesub() {
        this.inc = true;
        if (this.sub != null) {
            for (meminfo meminfo2 : this.sub) {
                if (meminfo2.inc || meminfo2.parent != this) continue;
                this.sizesub += meminfo2.size + meminfo2.calcsizesub();
            }
        }
        return this.sizesub;
    }

    boolean maydescend(meminfo meminfo2) {
        if (meminfo2 == null) {
            return false;
        }
        if (meminfo2.ob instanceof Class) {
            return false;
        }
        return meminfo2.parent == null || meminfo2.sublev > this.sublev + 1;
    }

    void check() {
        if (this.ob instanceof Class) {
            this.check((Class)this.ob);
        } else {
            this.check(this.ob.getClass());
        }
    }

    void check(Class clazz) {
        if (clazz.isArray()) {
            if (this.ob instanceof Class) {
                return;
            }
            int n = Array.getLength(this.ob);
            Class<?> clazz2 = clazz.getComponentType();
            if (clazz2.isPrimitive()) {
                this.size += n * this.primsize(clazz2);
            } else {
                this.size += n;
                for (int i = 0; i < n; ++i) {
                    Object object = Array.get(this.ob, i);
                    if (object == null) continue;
                    this.addob("[" + i + "]", object);
                }
            }
            return;
        }
        try {
            if (this.ob instanceof Collection) {
                Collection collection = (Collection)this.ob;
                int n = collection.size();
                this.size += 10 + n * 2;
                int n2 = 0;
                for (Object e : collection) {
                    if (e != null) {
                        this.addob("{" + n2 + "}", e);
                    }
                    ++n2;
                }
                return;
            }
            if (this.ob instanceof Map) {
                Map map2 = (Map)this.ob;
                int n = map2.size();
                this.size += 20 + n * 4;
                int n3 = 0;
                for (Object k : map2.keySet()) {
                    this.addob("{key" + n3 + "}", k);
                    if (map2.get(k) != null) {
                        this.addob("{val" + n3 + "}", map2.get(k));
                    }
                    ++n3;
                }
                return;
            }
        }
        catch (Exception exception) {
            report.deb(exception, " in " + this.name);
            return;
        }
        AccessibleObject[] accessibleObjectArray = clazz.getDeclaredFields();
        Field.setAccessible(accessibleObjectArray, true);
        for (AccessibleObject accessibleObject : accessibleObjectArray) {
            if (this.ob instanceof Class != Modifier.isStatic(((Field)accessibleObject).getModifiers())) continue;
            Class<?> clazz3 = ((Field)accessibleObject).getType();
            if (clazz3.isPrimitive()) {
                this.size += this.primsize(clazz3);
                continue;
            }
            try {
                Object object = ((Field)accessibleObject).get(this.ob instanceof Class ? null : this.ob);
                ++this.size;
                if (object == null) continue;
                this.addob(((Field)accessibleObject).getName() != null ? ((Field)accessibleObject).getName() : "(anon)", object);
            }
            catch (Exception exception) {
                report.deb(exception, " in " + this.name + " field: " + ((Field)accessibleObject).getName() + "{" + clazz3.getName() + "} object:" + this.ob);
            }
        }
        if (clazz != Object.class) {
            if (this.ob instanceof Class) {
                meminfo.get(clazz.getSuperclass());
            } else {
                this.check(clazz.getSuperclass());
            }
        }
    }

    int primsize(Class clazz) {
        if (clazz == Boolean.TYPE || clazz == Byte.TYPE) {
            return 1;
        }
        if (clazz == Character.TYPE || clazz == Short.TYPE) {
            return 2;
        }
        if (clazz == Integer.TYPE || clazz == Float.TYPE) {
            return 4;
        }
        if (clazz == Long.TYPE || clazz == Double.TYPE) {
            return 8;
        }
        return 0;
    }

    String code() {
        if (this.ob instanceof Class) {
            return "#" + ((Class)this.ob).getName();
        }
        return "#" + (this.parent != null ? this.parent.name : "") + "_" + this.name + "_" + this.created;
    }

    String report() {
        String string = this.code();
        Class<?> clazz = this.ob instanceof Class ? (Class<?>)this.ob : this.ob.getClass();
        String string2 = " <div id=" + string + "><nobr> ";
        if (this.size + this.sizesub > 1000) {
            string2 = string2 + "<b>";
        }
        for (int i = 0; i < this.sublev; ++i) {
            string2 = string2 + "--";
        }
        if (this.sub != null && this.sub.size() > 0) {
            string2 = string2 + " <a href=" + string + ">[" + (this.open ? "X" : "open") + "]</a> ";
        }
        string2 = string2 + " " + this.size + " (" + this.sizesub + ") " + this.name;
        if (this.ob instanceof String) {
            string2 = string2 + "\"" + this.ob.toString() + "\"";
        } else {
            string2 = clazz.getPackage() != null && clazz.getPackage().getName().startsWith("jcm") ? string2 + " {<font color=red>" + clazz.getName() + "</font>} " : string2 + " {" + clazz.getName() + "} ";
            if (this.ob instanceof infob) {
                string2 = string2 + "<i>" + ((infob)this.ob).name + "</i>";
            } else if (this.ob instanceof Component) {
                string2 = string2 + "<i>" + ((Component)this.ob).getName() + "</i>";
            }
        }
        if (this.size + this.sizesub > 1000) {
            string2 = string2 + "</b>";
        }
        return string2 + " </nobr> ";
    }
}

