/*
 * Decompiled with CFR 0.152.
 */
package jcm.core.tls;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import jcm.JNLP_methods;
import jcm.core.report;
import jcm.gui.nav.showpan;

public class fileio {
    public static boolean use_UTF_16 = false;
    static String outdirname = "jcmout";
    static File outdir = null;
    public static String lastloaded = null;
    public String subfolder;
    public String name;
    public String extension;
    public String fullname;
    public OutputStream os;
    boolean usingJWSsandbox = false;

    public static URL getURL(String string) {
        return fileio.class.getResource("/" + string);
    }

    public static Enumeration<JarEntry> getJarEntries(URL uRL) {
        try {
            JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
            return jarURLConnection.getJarFile().entries();
        }
        catch (Exception exception) {
            report.log(exception, "Can't find Jar of : " + uRL);
            return null;
        }
    }

    static InputStream getStream(String string) {
        return fileio.class.getResourceAsStream("/" + string);
    }

    static InputStream getStream(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (IOException iOException) {
            report.deb(iOException);
            return null;
        }
    }

    static BufferedInputStream getBuffStream(String string) {
        return new BufferedInputStream(fileio.getStream(string));
    }

    static LineNumberReader getLNR(String string) {
        return new LineNumberReader(new BufferedReader(new InputStreamReader(fileio.getStream(string))));
    }

    public static DataInputStream getDIS(String string) {
        return new DataInputStream(fileio.getBuffStream(string));
    }

    static InputStream getStreamFromDialog(String string, String string2, String string3) {
        try {
            try {
                File file = fileio.getFileFromDialog(string, string2, string3, "load");
                return new FileInputStream(file);
            }
            catch (SecurityException securityException) {
                return JNLP_methods.JWS_fos_IS();
            }
        }
        catch (Exception exception) {
            report.msg(exception, "Problem Opening File");
            return null;
        }
    }

    public static String[][] loadtab(String string, String string2) {
        return fileio.loadtab(fileio.getStream(string), string2);
    }

    public static String[][] loadtab(File file, String string) {
        return fileio.loadtab(fileio.getStream(file), string);
    }

    public static String[][] loadtabfromdialog(String string, String string2, String string3, String string4) {
        return fileio.loadtab(fileio.getStreamFromDialog(string, string2, string3), string4);
    }

    public static String[][] loadtabfrompersist(String string, String string2, String string3) {
        return JNLP_methods.JWS_loadtabfrompersist(string, string2, string3);
    }

    public static String[][] loadtab(InputStream inputStream, String string) {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        try {
            String string2;
            LineNumberReader lineNumberReader = new LineNumberReader(new BufferedReader(use_UTF_16 ? new InputStreamReader(inputStream, "UTF-16") : new InputStreamReader(inputStream)));
            while ((string2 = lineNumberReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, string);
                arrayList2.clear();
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList2.add(stringTokenizer.nextToken().trim());
                }
                arrayList.add(arrayList2.toArray(new String[arrayList2.size()]));
            }
        }
        catch (IOException iOException) {
            report.deb(iOException);
        }
        return (String[][])arrayList.toArray((T[])new String[arrayList.size()][]);
    }

    public static String loadstring(String string) {
        return fileio.loadstring(string, null);
    }

    public static String loadstring(String string, String string2) {
        return fileio.loadstring(fileio.getBuffStream(string), string, string2);
    }

    public static String loadstring(File file, String string) {
        return fileio.loadstring(new BufferedInputStream(fileio.getStream(file)), file.getAbsolutePath(), string);
    }

    static String loadstring(File file) {
        return fileio.loadstring(new BufferedInputStream(fileio.getStream(file)), file.getAbsolutePath(), null);
    }

    static String loadstring(BufferedInputStream bufferedInputStream, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            new InputStreamReader((InputStream)bufferedInputStream, string2);
        }
        catch (Exception exception) {
            string2 = null;
        }
        try {
            if (string2 != null) {
                int n;
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)bufferedInputStream, string2);
                while ((n = inputStreamReader.read()) != -1) {
                    stringBuffer.append((char)n);
                }
                inputStreamReader.close();
            } else {
                int n;
                while ((n = bufferedInputStream.read()) != -1) {
                    stringBuffer.append((char)n);
                }
                bufferedInputStream.close();
            }
        }
        catch (IOException iOException) {
            if (fileio.getURL(string) == null) {
                report.deb("! Couldn't locate file: " + string);
                return "";
            }
            report.deb(iOException, "IO Error loading " + string);
            return "";
        }
        return stringBuffer.toString();
    }

    static int readnext(InputStreamReader inputStreamReader) {
        try {
            return inputStreamReader.read();
        }
        catch (IOException iOException) {
            report.deb(iOException);
            try {
                inputStreamReader.skip(1L);
            }
            catch (IOException iOException2) {
                report.deb(iOException2, "noskip ");
            }
            return 0;
        }
    }

    public static String loadtextfile(String string) {
        try {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            FileReader fileReader = new FileReader(string);
            while ((n = fileReader.read()) != -1) {
                stringBuffer.append((char)n);
            }
            fileReader.close();
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            report.log(iOException, "IO Error loading " + string);
            return "";
        }
    }

    static float[] loadfloat(String string, int n) {
        try {
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(new File(string)));
            float[] fArray = new float[n];
            for (int i = 0; i < n; ++i) {
                fArray[i] = dataInputStream.readFloat();
            }
            dataInputStream.close();
            return fArray;
        }
        catch (IOException iOException) {
            report.log(iOException, "loadfloat: " + string);
            return null;
        }
    }

    static File getOutDir() {
        if (outdir != null) {
            return outdir;
        }
        String string = fileio.class.getClassLoader().toString().contains("jnlp") ? "user.home" : "user.dir";
        String string2 = System.getProperty(string);
        if (string2.endsWith("dist")) {
            string2 = string2.substring(0, string2.length() - 5);
        }
        report.deb("home directory is " + string2);
        File file = new File(string2 + File.separator + outdirname);
        fileio.makedir(file);
        outdir = file;
        return file;
    }

    public static File getOutDir(String string) {
        File file = new File(fileio.getOutDir(), string);
        fileio.makedir(file);
        report.deb("dirpath= " + file.getAbsolutePath() + " " + file.isDirectory());
        return file;
    }

    public static void setDefDir() {
        try {
            try {
                outdir = fileio.getFileFromDialog("", "", "Choose Default Directory", "select");
                fileio.makedir(outdir);
            }
            catch (SecurityException securityException) {
                JNLP_methods.JWS_setdir();
            }
        }
        catch (Exception exception) {
            report.msg(exception, "Can't Select Directory");
        }
    }

    static void makedir(File file) {
        if (!file.isDirectory()) {
            try {
                file.mkdir();
            }
            catch (Exception exception) {
                report.msg(exception, "Couldn't Make Directory " + file.getAbsolutePath());
            }
        }
    }

    public static void savetextfile(String string, String string2) {
        try {
            fileio.savetextfile(new FileWriter(new File("").getPath() + string), string2);
        }
        catch (IOException iOException) {
            report.msg(iOException, "Couldn't Save " + string);
        }
    }

    public static void savetextfile(File file, String string, String string2, String string3) {
        String string4 = file.getPath() + "/" + string;
        try {
            fileio.savetextfile(new OutputStreamWriter((OutputStream)new FileOutputStream(string4), string3), string2);
        }
        catch (IOException iOException) {
            report.msg(iOException, "Couldn't Save " + string4);
        }
    }

    public static void savetextfile(String string, String string2, String string3) {
        try {
            try {
                File file = new File(fileio.getOutDir(string), string2);
                fileio.savetextfile(new FileWriter(file), string3);
            }
            catch (SecurityException securityException) {
                fileio.savetextfile(new OutputStreamWriter(JNLP_methods.JWS_PS_getOutputStream(string2)), string3);
            }
        }
        catch (IOException iOException) {
            report.msg(iOException, "Couldn't Save " + string2);
        }
    }

    public static void savetextfile(OutputStreamWriter outputStreamWriter, String string) {
        try {
            for (int i = 0; i < string.length(); i += 100) {
                int n = string.length() - i;
                outputStreamWriter.write(string, i, n > 100 ? 100 : n);
                outputStreamWriter.flush();
            }
            report.log("- saved OK");
            outputStreamWriter.close();
        }
        catch (IOException iOException) {
            report.msg(iOException, "Couldn't Save Text File ");
        }
    }

    public fileio(File file) {
        try {
            this.fullname = file.getName();
            this.os = new FileOutputStream(file);
        }
        catch (IOException iOException) {
            report.msg(iOException, "Can't Get File " + this.fullname);
            this.os = null;
        }
    }

    public fileio(String string, String string2, String string3, String string4, String string5) {
        this.subfolder = string;
        this.name = string2;
        this.extension = string3;
        this.fullname = this.name + "." + string3;
        try {
            File file = fileio.getFileFromDialog(string, this.fullname, string4, string5);
            this.fullname = file.getName();
            try {
                this.os = new FileOutputStream(file);
            }
            catch (IOException iOException) {
                report.msg(iOException, "Can't Get File " + this.fullname);
                this.os = null;
            }
        }
        catch (SecurityException securityException) {
            this.usingJWSsandbox = true;
            this.os = new ByteArrayOutputStream();
        }
    }

    public void save() {
        try {
            if (this.usingJWSsandbox) {
                this.fullname = JNLP_methods.JWS_sfd_getfilename(this.os, this.name, this.extension);
            } else {
                this.os.flush();
                this.os.close();
            }
            report.log("Saved " + this.fullname + " OK");
        }
        catch (Exception exception) {
            report.msg(exception, "Problem Saving " + this.fullname);
        }
    }

    public static File getFileFromDialog(String string, String string2, String string3, String string4) {
        JFileChooser jFileChooser = new JFileChooser(fileio.getOutDir(string));
        jFileChooser.setDialogTitle(string3);
        jFileChooser.setSelectedFile(new File(string2));
        JFrame jFrame = showpan.mf;
        if (string2.equals("")) {
            jFileChooser.setFileSelectionMode(1);
        }
        int n = string4 == "save" ? jFileChooser.showSaveDialog(jFrame) : (string4 == "load" ? jFileChooser.showOpenDialog(jFrame) : jFileChooser.showDialog(jFrame, string4));
        return n == 0 ? jFileChooser.getSelectedFile() : null;
    }
}

