/*
 * Decompiled with CFR 0.152.
 */
package jcm.core;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import jcm.core.complexity;
import jcm.core.cur.curvar;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.cur.makederiv;
import jcm.core.itf.hasSetupInfo;
import jcm.core.loop;
import jcm.core.ob.infob;
import jcm.core.ob.interacob;
import jcm.core.ob.root;
import jcm.core.ob.world;
import jcm.core.par.param;
import jcm.core.register;
import jcm.core.report;
import jcm.core.tls.fileio;
import jcm.gui.doc.labman;
import jcm.gui.gen.lookandfeel;
import jcm.gui.gen.splash;
import jcm.gui.nav.jcmAction;
import jcm.gui.nav.jcmMenu;
import jcm.gui.nav.jcmTabbedPane;
import jcm.gui.nav.jcmTree;
import jcm.gui.nav.showpan;

public class setup {
    public static String savedir = "setup";
    public static String current = "current";
    public static boolean loadcurrent = true;
    public static boolean doingsetup = false;
    public static boolean restart = false;
    static Rectangle orig;
    static Rectangle newr;
    static float sx;
    static float sy;
    static JFrame mf;
    static Set<JComponent> onTop;

    public static void fillMenu(jcmMenu jcmMenu2) {
        jcmMenu2.add(new jcmAction("Reset All Parameters", complexity.simplest){

            @Override
            public void act() {
                register.resetall(true, false);
            }
        });
        jcmMenu2.add(new jcmAction("Reset Sci-Model Params"){

            @Override
            public void act() {
                register.resetall(false, false);
            }
        });
        jcmMenu2.add(new jcmAction("Reset Sci-Model Params +Force All Calc"){

            @Override
            public void act() {
                register.resetall(false, true);
            }
        });
        jcmMenu2.addSeparator();
        jcmMenu2.add(new jcmAction("Load Setup"){

            @Override
            public void act() {
                setup.loadsetupdialog();
            }
        });
        jcmMenu2.add(new jcmAction("Save Setup"){

            @Override
            public void act() {
                setup.savesetupdialog();
            }
        });
        jcmMenu2.add(new jcmAction("Set Directory"){

            @Override
            public void act() {
                fileio.setDefDir();
            }
        });
        jcmMenu2.addSeparator();
        setup.makemenu(jcmMenu2, root.rootob.find("defsetup"));
        jcmMenu2.addSeparator();
    }

    static void makemenu(jcmMenu jcmMenu2, infob infob2) {
        for (infob infob3 : infob2.getObs()) {
            String string;
            if (infob3.getObs() != null) {
                string = infob3.toString().substring(infob3.toString().lastIndexOf(".") + 1);
                jcmMenu jcmMenu3 = new jcmMenu(new Object[]{string, complexity.simplest});
                setup.makemenu(jcmMenu3, infob3);
                jcmMenu2.add(jcmMenu3);
                continue;
            }
            string = infob3.toString();
            int n = string.lastIndexOf(".");
            final String string2 = string.substring(string.lastIndexOf(".", n - 1) + 1, n);
            final String string3 = string.substring(0, n).replace(".", "/") + ".jcms";
            jcmMenu2.add(new jcmAction(string2, complexity.simplest){

                @Override
                public void act() {
                    report.deb("called loadsetup from menu action");
                    setup.loadsetup(fileio.loadtab(string3, "\t"), string2);
                }
            });
        }
    }

    public static void savesetupdialog() {
        fileio fileio2 = new fileio(savedir, current, "jcms", "Save Setup", "save");
        fileio.savetextfile(new OutputStreamWriter(fileio2.os), setup.savesetup());
        fileio2.save();
    }

    public static void savesetupdefault() {
        fileio.savetextfile(savedir, current + ".jcms", setup.savesetup());
    }

    public static String savesetup() {
        mf = showpan.mf;
        String string = "";
        for (world object : world.worlds) {
            string = string + "world\t" + object.getName() + "\t" + object.getColor().getRed() + "\t" + object.getColor().getGreen() + "\t" + object.getColor().getBlue() + "\n";
        }
        for (interacob interacob2 : register.alliobs) {
            if (interacob2 instanceof param && !((param)interacob2).isdefault()) {
                string = string + "param\t" + ((param)interacob2).save();
            }
            if (!(interacob2 instanceof curveset) || !((curveset)interacob2).temporary) continue;
            string = string + setup.saveqtset((curveset)interacob2);
        }
        string = string + setup.savemainwin();
        string = string + setup.recordSplit((JSplitPane)mf.getContentPane()) + "\n";
        for (WeakReference weakReference : register.winmap.keySet()) {
            if (weakReference.get() == null || ((JComponent)weakReference.get()).getParent() == null || !((JComponent)weakReference.get()).getRootPane().isShowing()) continue;
            string = string + setup.savecomp(weakReference);
        }
        return string;
    }

    public static boolean loadcurrentsetup() {
        report.deb("called loadcurrentsetup");
        try {
            if (loadcurrent && setup.loadsetup(fileio.loadtabfrompersist(savedir, current + ".jcms", "\t"), current)) {
                return true;
            }
        }
        catch (Exception exception) {
            report.deb(exception);
        }
        return setup.loadpacksetup("default");
    }

    static boolean loadsetupdialog() {
        report.deb("called loadsetupdialog");
        return setup.loadsetup(fileio.loadtabfromdialog(savedir, current + ".jcms", "Load Setup", "\t"), fileio.lastloaded);
    }

    public static boolean loadpacksetup(String string) {
        report.deb("called loadpacksetup");
        return setup.loadsetup(fileio.loadtab("defsetup/" + string + ".jcms", "\t"), string);
    }

    static boolean loadsetup(final String[][] stringArray, final String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            report.deb("starting new thread for loading setup");
            new Thread("Setup Thread"){

                @Override
                public void run() {
                    setup.loadsetup2(stringArray, string);
                }
            }.start();
            try {
                while (doingsetup) {
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {
                report.deb(interruptedException, "waiting for setup to finish interrupted");
            }
            return true;
        }
        return setup.loadsetup2(stringArray, string);
    }

    static boolean loadsetup2(String[][] stringArray, String string) {
        if (stringArray.length == 0) {
            return false;
        }
        doingsetup = true;
        report.deb("setup start");
        setup.invoke(new String[]{"closeold"});
        for (String[] stringArray2 : stringArray) {
            setup.invoke(stringArray2);
        }
        setup.invoke(new String[]{"loopgonow"});
        setup.setontop();
        report.deb("setup finished");
        doingsetup = false;
        if (restart) {
            restart = false;
            setup.loadcurrentsetup();
        }
        return true;
    }

    static void invoke(final String[] stringArray) {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                report.deb("error - shouldn't call setup from Event Dispatch Thread! - setup ignored ");
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        setup.setup(stringArray);
                    }
                });
            }
        }
        catch (Exception exception) {
            String string = "";
            for (String string2 : stringArray) {
                string = string + " _ " + string2;
            }
            report.deb(exception, "setup error " + string);
        }
    }

    static void setup(String[] stringArray) {
        if (restart) {
            return;
        }
        if (stringArray.length == 0) {
            return;
        }
        String string = stringArray[0];
        if (string.equals("closeold")) {
            setup.closeold();
        }
        if (string.equals("loopgonow")) {
            loop.gonow();
        }
        if (stringArray[0].equals("worlds")) {
            for (int i = 1; i < stringArray.length; ++i) {
                String[] stringArray2 = new String[]{"world", stringArray[i]};
                setup.setup(stringArray2);
            }
            return;
        }
        if (stringArray[0].equals("window") && stringArray[1].equals("Main")) {
            String[] stringArray3 = new String[]{"mainwin", stringArray[4], stringArray[5], stringArray[2], stringArray[3], "maximised"};
            setup.setup(stringArray3);
            return;
        }
        if (stringArray[0].equals("window")) {
            String[] stringArray4 = new String[stringArray.length + 1];
            stringArray4[0] = "panel";
            stringArray4[1] = stringArray[1];
            stringArray4[2] = stringArray[4];
            stringArray4[3] = stringArray[5];
            stringArray4[4] = stringArray[2];
            stringArray4[5] = stringArray[3];
            stringArray4[6] = "true";
            for (int i = 6; i < stringArray.length; ++i) {
                stringArray4[i + 1] = stringArray[i];
            }
            setup.setup(stringArray4);
            return;
        }
        mf = showpan.mf;
        loop.waitUntilLoopDone();
        String string2 = "Setup: ";
        for (String string3 : stringArray) {
            string2 = string2 + " \t " + string3;
        }
        splash.report(string2);
        try {
            interacob interacob2;
            if (stringArray[0].equals("world")) {
                String exception = stringArray[1];
                Color color = stringArray.length > 2 ? new Color(Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]), Integer.parseInt(stringArray[4])) : Color.black;
                world.makeworld(exception, color);
            }
            if (stringArray[0].equals("param") && (interacob2 = register.findiobfullname(stringArray[1])) != null) {
                ((param)interacob2).load(stringArray[2]);
                if (mf != null) {
                    mf.validate();
                }
            }
            if (stringArray[0].equals("qtset")) {
                setup.addqtset(stringArray);
            }
            if (stringArray[0].equals("split")) {
                if (mf == null) {
                    showpan.makeMainframeDefSize();
                }
                setup.applySplit(stringArray, 1, (JSplitPane)mf.getContentPane());
            }
            if (stringArray[0].equals("mainwin")) {
                setup.setmainwin(stringArray);
            }
            if (stringArray[0].equals("panel")) {
                setup.loadcomp(stringArray);
            }
        }
        catch (Exception exception) {
            report.deb(exception, "setup error \n");
        }
    }

    static String saveqtset(curveset curveset2) {
        String string = "qtset\t" + (Object)((Object)curveset2.type);
        if (curveset2.name.startsWith("Compare&")) {
            string = string + "\t" + curveset2.owner.name + "\t" + curveset2.name;
        }
        if (curveset2 instanceof curvar) {
            curvar curvar2 = (curvar)curveset2;
            if (curvar2.linkqq != null) {
                for (curveset curveset3 : curvar2.linkqq) {
                    string = string + "\t" + curveset3.getFullName();
                }
            }
        }
        return string + "\n";
    }

    static void addqtset(String[] stringArray) {
        curve.Type type2 = null;
        ArrayList<curveset> arrayList = new ArrayList<curveset>(3);
        block0: for (int i = 1; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (type2 == null) {
                for (curve.Type type3 : curve.Type.values()) {
                    if (!type3.toString().equals(string)) continue;
                    type2 = type3;
                    continue block0;
                }
            }
            if (string.startsWith("Compare&")) {
                makederiv.addderiv((curveset)arrayList.get(0), makederiv.compareworld((curveset)arrayList.get(0), string.substring(8)));
                return;
            }
            interacob interacob2 = register.findiobfullname(string);
            if (!(interacob2 instanceof curveset)) continue;
            arrayList.add((curveset)interacob2);
        }
        if (type2 == null) {
            report.deb("can't match type " + stringArray[2]);
            return;
        }
        makederiv.addnewderiv(type2, arrayList);
    }

    static void setname(String string) {
        showpan.mf.setTitle(showpan.mf.getTitle() + " :-" + string);
    }

    static String savemainwin() {
        Point point = mf.getLocationOnScreen();
        point.translate(8, 8);
        boolean bl = showpan.screenbounds().contains(point);
        return "mainwin" + setup.sizelocinfo(mf) + "\t" + (bl ? (mf.getExtendedState() == 6 ? "maximised" : "normal") : "other_screen") + "\n";
    }

    static void setmainwin(String[] stringArray) {
        orig = new Rectangle(setup.pin(stringArray[1]), setup.pin(stringArray[2]), setup.pin(stringArray[3]), setup.pin(stringArray[4]));
        if (stringArray.length > 5 && stringArray[5].equals("maximised")) {
            if (mf == null) {
                mf = showpan.makeMainframeMaximised();
            }
            mf.setExtendedState(6);
            newr = showpan.screenbounds();
        } else {
            Rectangle rectangle = newr = stringArray[5].equals("other_screen") ? orig : orig.intersection(showpan.screenbounds());
            if (mf == null) {
                mf = showpan.makeMainframe(newr);
            } else {
                mf.setBounds(newr);
            }
        }
        lookandfeel.setFontSizeForFrame();
        mf.validate();
        setup.setwindim();
        report.deb("main window: scale: " + sx + " " + sy + " origpos:  " + setup.orig.x + " " + setup.orig.y + " newpos: " + setup.newr.x + " " + setup.newr.y);
        Thread.currentThread();
        Thread.yield();
    }

    static void closeold() {
        loop.waitUntilLoopDone();
        report.deb("removing old window refs");
        try {
            for (WeakReference<JComponent> weakReference : register.winmap.keySet()) {
                if (weakReference.get() == null) continue;
                showpan.dispose((JComponent)weakReference.get());
            }
        }
        catch (Exception exception) {
            report.deb(exception, "setup dispose error ");
        }
        register.winmap.clear();
        report.deb("removing temporary interacobs");
        for (interacob interacob2 : register.alliobs) {
            if (!interacob2.temporary) continue;
            interacob2.owner.removeOb(interacob2);
            interacob2.disposeLater();
        }
        report.deb("removing old worlds");
        world.disposeAllButOne();
        report.deb("reset all");
        jcmTree.restruclink.changed = true;
        complexity.defaultcomplexity.changed = true;
        register.resetall(true, true);
        System.gc();
    }

    static String savecomp(WeakReference<JComponent> weakReference) {
        JComponent jComponent = (JComponent)weakReference.get();
        if (jComponent.isShowing()) {
            onTop.add(jComponent);
        }
        if (jComponent instanceof hasSetupInfo) {
            ((hasSetupInfo)((Object)jComponent)).savesetup();
        }
        String string = "panel\t" + jComponent.getClass().getName() + setup.sizelocinfo(jComponent) + "\t" + jComponent.isShowing();
        for (Object object : register.winmap.get(weakReference)) {
            if (object instanceof WeakReference) {
                object = ((WeakReference)object).get();
            }
            if (object instanceof Object[]) {
                for (Object object2 : (Object[])object) {
                    string = string + "\t" + setup.getname(object2);
                }
                continue;
            }
            string = string + "\t" + setup.getname(object);
        }
        string = string + "\n";
        return string;
    }

    static void loadcomp(String[] stringArray) {
        try {
            Serializable serializable;
            Object[] objectArray;
            Object object;
            int n = 7;
            int n2 = stringArray.length - n;
            if (n2 > 1) {
                object = new Object[n2];
                for (int i = 0; i < n2; ++i) {
                    object[i] = setup.findob(stringArray[n + i]);
                }
                objectArray = object;
            } else {
                objectArray = setup.findob(stringArray[n]);
            }
            setup.setwindim();
            object = setup.convert(new Point(Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3])));
            Dimension dimension = setup.convert(new Dimension(Integer.parseInt(stringArray[4]), Integer.parseInt(stringArray[5])));
            Container container = showpan.findContainerAbsolute((Point)object);
            if (container == null) {
                serializable = new Point((Point)object);
                ((Point)serializable).translate(20, 20);
                container = showpan.findContainerAbsolute((Point)serializable);
            }
            if (container == null) {
                serializable = new Point((Point)object);
                ((Point)serializable).translate(-20, -20);
                container = showpan.findContainerAbsolute((Point)serializable);
            }
            if (container == null) {
                serializable = new Point((Point)object);
                ((Point)serializable).translate(-dimension.width / 2, -dimension.height / 2);
                container = new JFrame(labman.getTitle(stringArray.length > 7 ? stringArray[7] : stringArray[1]));
                container.setLocation((Point)serializable);
            }
            serializable = showpan.makepan(Class.forName(stringArray[1]), objectArray, container);
            ((JComponent)serializable).setPreferredSize(dimension);
            if (Boolean.parseBoolean(stringArray[6])) {
                onTop.add((JComponent)serializable);
            }
        }
        catch (Exception exception) {
            report.deb("setup window error" + exception);
        }
    }

    static String sizelocinfo(Component component) {
        try {
            Point point;
            Dimension dimension = component.getSize();
            Point point2 = component.isShowing() ? component.getLocationOnScreen() : (point = component.getParent() != null && component.getParent().isShowing() ? component.getParent().getLocationOnScreen() : new Point(4, 4));
            if (!(component instanceof JFrame)) {
                point.x += dimension.width / 2;
                point.y += dimension.height / 2;
            }
            return "\t" + point.x + "\t" + point.y + "\t" + dimension.width + "\t" + dimension.height;
        }
        catch (Exception exception) {
            report.deb(exception + " for sizeloc of " + component);
            return "\t50\t50\t50\t50";
        }
    }

    static void setwindim() {
        newr = mf.getBounds();
        sx = (float)setup.newr.width / (float)setup.orig.width;
        sy = (float)setup.newr.height / (float)setup.orig.height;
    }

    static Point convert(Point point) {
        return new Point(setup.newr.x + (int)(sx * (float)(point.x - setup.orig.x)), setup.newr.y + (int)(sy * (float)(point.y - setup.orig.y)));
    }

    static Dimension convert(Dimension dimension) {
        return new Dimension((int)(sx * (float)dimension.width), (int)(sy * (float)dimension.height));
    }

    public static void setsizeloc(JComponent jComponent, Point point, Dimension dimension) {
        jcmTabbedPane jcmTabbedPane2 = showpan.findTabbedPane(jComponent);
        if (jcmTabbedPane2 != null) {
            jComponent.setPreferredSize(setup.convert(dimension));
            jcmTabbedPane2.getParent().validate();
        } else {
            setup.setsizeloc(jComponent.getRootPane().getParent(), setup.convert(point), setup.convert(dimension));
        }
    }

    public static void setsizeloc(Container container, Point point, Dimension dimension) {
        container.setLocation(setup.convert(point));
        container.setSize(setup.convert(dimension));
        mf.validate();
        Thread.currentThread();
        Thread.yield();
    }

    static String recordSplit(JSplitPane jSplitPane) {
        String string = "split\t" + jSplitPane.getOrientation() + "\t" + jSplitPane.getDividerLocation();
        Component component = jSplitPane.getTopComponent();
        string = string + "\t" + (component instanceof JSplitPane ? setup.recordSplit((JSplitPane)component) : (component instanceof JTabbedPane ? "tab" : "dtp"));
        component = jSplitPane.getBottomComponent();
        string = string + "\t" + (component instanceof JSplitPane ? setup.recordSplit((JSplitPane)component) : (component instanceof JTabbedPane ? "tab" : "dtp"));
        return string;
    }

    static int applySplit(String[] stringArray, int n, JSplitPane jSplitPane) {
        JSplitPane jSplitPane2;
        int n2 = Integer.parseInt(stringArray[n]);
        int n3 = (int)((float)Integer.parseInt(stringArray[n + 1]) * (n2 == 1 ? sx : sy));
        jSplitPane.setOrientation(n2);
        jSplitPane.setDividerLocation(n3);
        if (stringArray[n += 2].equals("split")) {
            jSplitPane2 = new JSplitPane();
            jSplitPane2.setResizeWeight(0.5);
            jSplitPane.setTopComponent(jSplitPane2);
            n = setup.applySplit(stringArray, n + 1, jSplitPane2);
        } else {
            jSplitPane.setTopComponent(stringArray[n].equals("tab") ? new jcmTabbedPane() : showpan.makejdp());
            ++n;
        }
        if (stringArray[n].equals("split")) {
            jSplitPane2 = new JSplitPane();
            jSplitPane2.setResizeWeight(0.5);
            jSplitPane.setBottomComponent(jSplitPane2);
            n = setup.applySplit(stringArray, n + 1, jSplitPane2);
        } else {
            jSplitPane.setBottomComponent(stringArray[n].equals("tab") ? new jcmTabbedPane() : showpan.makejdp());
            ++n;
        }
        Thread.currentThread();
        Thread.yield();
        return n;
    }

    static void setontop() {
        for (JComponent jComponent : onTop) {
            showpan.toFront(jComponent);
        }
        onTop.clear();
    }

    static int pin(String string) {
        return Integer.parseInt(string);
    }

    static Object findob(String string) {
        interacob interacob2 = register.findiobfullname(string);
        return interacob2 != null ? interacob2 : (string.equals("null") ? null : string);
    }

    static String getname(Object object) {
        return object == null ? "null" : (object instanceof infob ? ((infob)object).getFullName() : object.toString());
    }

    static {
        sx = 1.0f;
        sy = 1.0f;
        onTop = new HashSet<JComponent>(8);
    }
}

