/*
 * Decompiled with CFR 0.152.
 */
package jcm.core.par;

import java.awt.Color;
import java.util.Collection;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jcm.core.complexity;
import jcm.core.cur.curveset;
import jcm.core.cur.units;
import jcm.core.itf.plotlink;
import jcm.core.loop;
import jcm.core.ob.interacob;
import jcm.core.register;
import jcm.core.report;
import jcm.gui.doc.autodoc;
import jcm.gui.doc.labman;
import jcm.gui.nav.filter;
import jcm.gui.nav.jcmAction;
import jcm.gui.nav.jcmMenu;
import jcm.gui.nav.jcmTree;
import jcm.gui.nav.paramMenu;
import jcm.gui.nav.paramOption;
import jcm.gui.nav.paramValueChooser;
import jcm.script.calcscript;

public class param<T>
extends interacob {
    public Type type;
    public T[] menulist;
    public T chosen;
    public T defchosen;
    public int numitems;
    Class listtype;
    public complexity[] itemcomplexity;
    public boolean flag;
    public boolean defflag;
    public double val;
    public double defval;
    public double max;
    public double min;
    public units units;
    public int dp = 2;
    public param pair;
    public static boolean reportchange = true;
    static float pc = 0.0f;

    public param(Object ... objectArray) {
        int n = 0;
        int n2 = 0;
        this.mycomplexity = complexity.normal;
        for (Object object : objectArray) {
            if ((object instanceof Object[] || object instanceof Collection) && this.menulist == null) {
                this.type = Type.menu;
                Object[] objectArray2 = object instanceof Object[] ? (Object[])object : ((Collection)object).toArray();
                this.menulist = objectArray2;
                this.numitems = this.menulist.length;
                this.itemcomplexity = new complexity[this.menulist.length];
                this.listtype = object.getClass().getComponentType();
                continue;
            }
            if (this.menulist != null && this.chosen == null && (this.listtype == null || this.listtype.isInstance(object))) {
                this.chosen = object;
                this.defchosen = object;
                continue;
            }
            if (object instanceof Type) {
                this.type = (Type)((Object)object);
            }
            if (object instanceof Color) {
                this.color = (Color)object;
            }
            if (object instanceof Boolean) {
                this.defflag = this.flag = ((Boolean)object).booleanValue();
                this.type = Type.option;
            }
            if (object instanceof param) {
                this.pair = (param)object;
            }
            if (object instanceof complexity) {
                this.mycomplexity = (complexity)((Object)object);
            }
            if (object instanceof complexity[]) {
                this.itemcomplexity = (complexity[])object;
            }
            if (object instanceof Number) {
                if (this.type == null) {
                    this.type = Type.value;
                }
                double d = ((Number)object).doubleValue();
                if (n == 0) {
                    this.defval = this.val = d;
                    this.min = Double.MAX_VALUE;
                    this.max = Double.MAX_VALUE;
                }
                if (n == 1) {
                    this.min = d;
                }
                if (n == 2) {
                    this.max = d;
                }
                if (n == 3) {
                    this.units.scales = d;
                }
                if (n == 4) {
                    this.units.scaleu = d;
                }
                ++n;
            }
            if (object instanceof String) {
                String string = object.toString();
                if (n2 == 0) {
                    this.name = string;
                }
                if (n2 >= 1) {
                    this.units = new units(string);
                }
                ++n2;
            }
            if (!(object instanceof curveset)) continue;
            ((curveset)object).associate(this);
        }
        if (this.units != null) {
            this.units.checkunitcancel();
            this.units.checkunitfac(this.max - this.min);
        }
        this.register();
        this.addAction(filter.filtertype.Doc);
        this.priority = 1.0f + pc;
        pc = (float)((double)pc - 0.001);
    }

    public String save() {
        return this.getFullName() + "\t" + (this.type == Type.menu ? this.getchosenindex() + "\t" + this.chosen : (this.type == Type.option ? Boolean.valueOf(this.flag) : (this.type == Type.value ? Double.valueOf(this.val) : ""))) + "\n";
    }

    public void load(String string) {
        if (this.type == Type.menu) {
            this.choose(Integer.parseInt(string));
        }
        if (this.type == Type.option) {
            this.flag = string.equals("true");
        }
        if (this.type == Type.value) {
            this.val = Double.valueOf(string);
        }
        this.changed = true;
    }

    public void reset() {
        this.reset(false);
    }

    public void reset(boolean bl) {
        if (this.type == Type.menu && (bl || this.chosen != this.defchosen)) {
            this.chosen = this.defchosen;
            this.changed = true;
        }
        if (this.type == Type.option && (bl || this.flag != this.defflag)) {
            this.flag = this.defflag;
            this.changed = true;
        }
        if (this.type == Type.value && (bl || this.val != this.defval)) {
            this.val = this.defval;
            this.changed = true;
        }
        if (this.type == Type.trigger) {
            this.flag = this.defflag;
        }
    }

    public void next() {
        this.choose((this.getchosenindex() + 1) % this.numitems);
    }

    public void prev() {
        this.choose((this.numitems + this.getchosenindex() - 1) % this.numitems);
    }

    public void choose(int n) {
        if (this.type == Type.menu) {
            int n2 = 0;
            for (T t : this.menulist) {
                if (!this.checkcomplexity(t)) continue;
                if (n == n2) {
                    this.chosen = t;
                    return;
                }
                ++n2;
            }
        }
    }

    public void choose(T t) {
        for (T t2 : this.menulist) {
            if (!t.equals(t2)) continue;
            this.chosen = t2;
        }
    }

    public void putval(double d) {
        this.val = d;
    }

    public void setcomplexity(T t, complexity complexity2) {
        for (int i = 0; i < this.menulist.length; ++i) {
            if (!t.equals(this.menulist[i])) continue;
            this.itemcomplexity[i] = complexity2;
        }
    }

    public void setlist(T[] TArray) {
        int n = TArray.length;
        this.itemcomplexity = new complexity[n];
        for (int i = 0; i < n; ++i) {
            this.itemcomplexity[i] = this.mycomplexity;
        }
        this.menulist = TArray;
    }

    public void set(double d) {
        this.val = d;
        if (this.val < this.min) {
            this.val = this.min;
        } else if (this.val > this.max) {
            this.val = this.max;
        }
        this.respond();
    }

    public void set(boolean bl) {
        this.flag = bl;
        this.respond();
    }

    public void set(T t) {
        this.choose(t);
        this.respond();
    }

    public void set(int n) {
        if (this.type == Type.value) {
            this.set((double)n);
        } else {
            this.choose(n);
            this.respond();
        }
    }

    public void set(String string) {
        if (this.type == Type.option) {
            this.flag = !string.equals("false") && !string.equals("f") && !string.equals("F") && !string.equals("off") && !string.equals("dis") && !string.equals("disabled");
        }
        if (this.type == Type.menu) {
            try {
                this.choose(string);
            }
            catch (Exception exception) {
                report.deb("param " + this.name + " not same type as " + string);
            }
        }
        if (this.type == Type.value) {
            this.putval(Double.valueOf(string));
        }
        this.respond();
    }

    public void respond() {
        this.respond(!calcscript.delayloop());
    }

    public void respond(boolean bl) {
        this.report();
        this.changed = true;
        if (bl) {
            loop.golater("Change " + this.name, this.type != Type.value);
        }
    }

    public void report() {
        if (reportchange) {
            report.log(this.getFullName() + " set to: " + this.getstringval());
        }
    }

    public void precalc() {
    }

    public boolean checkneededforplot() {
        return register.checkneededforplotexcept(this, jcmTree.class);
    }

    public boolean isdefault() {
        if (this.type == Type.menu) {
            return this.chosen == this.defchosen;
        }
        if (this.type == Type.option) {
            return this.flag == this.defflag;
        }
        if (this.type == Type.value) {
            return this.val == this.defval;
        }
        return true;
    }

    public T getchosen() {
        return this.chosen;
    }

    public String getstringval() {
        return "" + (this.type == Type.option ? "" + this.flag : (this.type == Type.menu ? this.chosen.toString() : (this.type == Type.value ? "" + this.units.round(this.val) : "")));
    }

    public complexity getItemComplexity(T t) {
        if (this.itemcomplexity != null) {
            try {
                for (int i = 0; i < this.menulist.length; ++i) {
                    if (!t.equals(this.menulist[i])) continue;
                    return this.itemcomplexity[i] != null ? this.itemcomplexity[i] : complexity.simplest;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                report.deb("param item complexity error");
            }
        }
        return this.mycomplexity;
    }

    public boolean checkcomplexity(T t) {
        return complexity.check(this.getItemComplexity(t));
    }

    public double getval() {
        return this.val;
    }

    public double getdef() {
        return this.defval;
    }

    public double getfrac() {
        return this.val / this.defval;
    }

    public boolean istrue() {
        return this.flag;
    }

    public boolean isfalse() {
        return !this.flag;
    }

    public float min() {
        return (float)this.min;
    }

    public float max() {
        return (float)this.max;
    }

    public float range() {
        return (float)(this.max - this.min);
    }

    public boolean isnotdefault() {
        if (this.type == Type.menu) {
            return this.chosen != this.defchosen;
        }
        if (this.type == Type.value) {
            return this.val != this.defval;
        }
        if (this.type == Type.option) {
            return this.flag != this.defflag;
        }
        return false;
    }

    public String chosenname() {
        return this.chosen.toString();
    }

    public String getname(int n) {
        return this.menulist[n].toString();
    }

    public String getname(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        try {
            return object.getClass().getField("name").get(object).toString();
        }
        catch (Exception exception) {
            try {
                return object.getClass().getMethod("getName", new Class[0]).invoke(object, new Object[0]).toString();
            }
            catch (Exception exception2) {
                if (object instanceof interacob) {
                    return ((interacob)object).name;
                }
                if (object instanceof Enum) {
                    return ((Enum)object).name();
                }
                return object.getClass().getSimpleName();
            }
        }
    }

    public int getchosenindex() {
        int n = 0;
        for (T t : this.menulist) {
            if (this.chosen.equals(t)) {
                return n;
            }
            if (!this.checkcomplexity(t)) continue;
            ++n;
        }
        return -1;
    }

    public String getinfo() {
        return this.getLabel() + this.getstate() + this.addunits();
    }

    public String addunits() {
        return this.type == Type.value ? " \t\t" + labman.getShort(this.units.units) : "";
    }

    public String getstate() {
        block7: {
            block6: {
                if (this.type == Type.menu) {
                    return " \t\t" + labman.getTitle(this.chosen.toString()) + " (def=" + labman.getTitle(this.defchosen.toString()) + ") \n";
                }
                if (this.type == Type.option) {
                    return " \t\t: " + (this.flag ? labman.getTitle("ena") : labman.getTitle("dis")) + " (def=" + (this.defflag ? labman.getTitle("ena") : labman.getTitle("dis")) + ") \n";
                }
                if (this.type == Type.value) {
                    return " val=" + this.units.round(this.val, this.dp) + " (def=" + this.units.round(this.defval, this.dp) + ") \n";
                }
                if (this.type == Type.Xscale) break block6;
                if (this.type != Type.Yscale) break block7;
            }
            return (Object)((Object)this.type) + ": " + this.units.round(this.min) + " - " + this.units.round(this.max) + " " + labman.getShort(this.units.units) + labman.getTitleIfDifferent(this.units.units);
        }
        return "";
    }

    @Override
    public String docSummary() {
        return this.hashcolor() + (this.checkenabled(filter.filtertype.AllParams) ? "" : " //(inactive)// ") + autodoc.link(this) + "</font> " + "\u00a3%" + labman.convertkey(this.name) + "<br>";
    }

    @Override
    public String getExtraDoc() {
        block3: {
            block2: {
                if (this.type == Type.Xscale) break block2;
                if (this.type != Type.Yscale) break block3;
            }
            return this.getinfo();
        }
        return this.getInput() + this.moreinfo() + this.docNotes() + "<hr>" + this.docInteracs() + autodoc.javacode(this);
    }

    public String getInput() {
        return " <object classid=jcm.gui.nav." + (this.type == Type.option ? "paramOption" : (this.type == Type.menu ? "paramMenu" : "paramValueChooser")) + "><param name=paramName value='" + this.name + "'></param></option><br>";
    }

    public String moreinfo() {
        if (this.type == Type.menu) {
            String string = "";
            for (int i = 0; i < this.numitems; ++i) {
                String string2 = labman.convertkey(this.getname(i));
                string = string + "<li>" + autodoc.link(string2) + " \u00a3%" + string2;
            }
            return "<hr> \u00a3`moreinfo <ul>" + string + "</ul>";
        }
        if (this.type == Type.value && this.pair != null) {
            return "<hr>" + this.pair.getInput() + this.pair.moreinfo();
        }
        return "";
    }

    @Override
    public JComponent getComponent(Object ... objectArray) {
        if (this.type == Type.menu) {
            return new paramMenu(this, objectArray);
        }
        if (this.type == Type.value) {
            return new paramValueChooser(this, objectArray);
        }
        if (this.type == Type.option) {
            return new paramOption(this, objectArray);
        }
        return super.getComponent(new Object[0]);
    }

    public JMenuItem getMenuItem() {
        if (this.type == Type.menu) {
            jcmMenu jcmMenu2 = new jcmMenu(new Object[]{this.name});
            ButtonGroup buttonGroup = new ButtonGroup();
            for (final T t : this.menulist) {
                if (!complexity.check(this.getItemComplexity(t))) continue;
                JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(new jcmAction(this.getname(t), this.getItemComplexity(t)){

                    @Override
                    public void act() {
                        param.this.set(t);
                    }
                });
                buttonGroup.add(jRadioButtonMenuItem);
                jcmMenu2.add(jRadioButtonMenuItem);
                if (t != this.chosen) continue;
                jRadioButtonMenuItem.setSelected(true);
            }
            return jcmMenu2;
        }
        if (this.type == Type.option) {
            return new cb(this);
        }
        if (this.type == Type.value) {
            JMenuItem jMenuItem = new JMenuItem();
            JComponent jComponent = this.getComponent("menu");
            jMenuItem.setLayout(null);
            jMenuItem.setEnabled(true);
            jMenuItem.add(jComponent);
            jComponent.revalidate();
            jComponent.setLocation(0, 0);
            jComponent.setSize(jComponent.getPreferredSize());
            jMenuItem.setPreferredSize(jComponent.getPreferredSize());
            return jMenuItem;
        }
        return null;
    }

    class cb
    extends JCheckBoxMenuItem
    implements plotlink,
    ChangeListener {
        public cb(param param3) {
            this.setText(param.this.name);
            this.setSelected(param.this.istrue());
            this.setForeground(param.this.getColor());
            this.addChangeListener(this);
            register.addlink(this, param3);
        }

        @Override
        public void doplot() {
            if (param.this.changed) {
                loop.golater("CB doplot");
            }
            this.setSelected(param.this.istrue());
            this.setToolTipText(param.this.getinfo());
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (param.this.istrue() != this.isSelected()) {
                param.this.set(this.isSelected());
            }
            this.setText(param.this.getLabel());
            this.setToolTipText(param.this.getinfo());
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.doplot();
        }
    }

    public static enum Type {
        menu,
        option,
        value,
        Xscale,
        Yscale,
        trigger;

    }
}

