/*
 * Decompiled with CFR 0.152.
 */
package jcm.core.ob;

import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JOptionPane;
import jcm.core.complexity;
import jcm.core.itf.dataholder;
import jcm.core.loop;
import jcm.core.ob.infob;
import jcm.core.ob.loopcalc;
import jcm.core.ob.module;
import jcm.core.ob.packageob;
import jcm.core.ob.root;
import jcm.core.report;
import jcm.gui.gen.iconFinder;
import jcm.gui.nav.filter;
import jcm.gui.nav.jcmAction;
import jcm.gui.nav.jcmTree;
import jcm.gui.nav.showpan;
import jcm.indata.loaddata;

public class world
extends packageob {
    public static String defname = "World 1";
    public static List<world> worlds = new LinkedList<world>();
    public static packageob worldsob = new packageob("Worlds");
    static Icon wi = iconFinder.findIcon("world");
    static boolean spareworld = false;
    static boolean incdataholder = true;
    public List<module> mods = new LinkedList<module>();
    Map<Class, module> modmap = new LinkedHashMap<Class, module>();

    public world(String string) {
        this(string, string.equals(defname) ? Color.black : world.rcol());
    }

    public world(String string, Color color) {
        super(new Object[0]);
        this.name = string;
        this.color = color;
        this.mycomplexity = complexity.simplest;
        worlds.add(this);
        worldsob.addOb(this);
        this.addAction(filter.filtertype.Worlds, new jcmAction("RemoveWorld"){

            @Override
            public void act() {
                world.this.disposeWorld(true);
            }
        });
        this.addAction(filter.filtertype.Worlds, new jcmAction("ReNameWorld"){

            @Override
            public void act() {
                world.this.name = JOptionPane.showInputDialog(null, (Object)("Enter new name for " + world.this.name));
                world.update();
            }
        });
        this.addAction(filter.filtertype.Worlds, new jcmAction("SetColorOfWorld"){

            @Override
            public void act() {
                new JColorChooser();
                world.this.color = JColorChooser.showDialog(showpan.mf, "Choose Colour for " + world.this.name, world.this.color);
                world.update();
            }
        });
        this.addAction(filter.filtertype.Doc);
        this.addAction(filter.filtertype.Tree);
        this.makemods();
    }

    static void update() {
        jcmTree.restruclink.changed = true;
        loop.golater("World Update");
    }

    public static void makeworld(String string, Color color) {
        if (spareworld) {
            world world2 = worlds.get(0);
            world2.name = string;
            world2.color = color;
            spareworld = false;
        } else {
            new world(string, color);
        }
    }

    public static void disposeAllButOne() {
        while (worlds.size() > 1) {
            try {
                worlds.get(1).disposeWorld(false);
            }
            catch (Exception exception) {
                report.deb(exception, "setup remove old worlds error ");
            }
        }
        if (worlds.size() > 0) {
            spareworld = true;
        }
    }

    public static jcmAction addWorld() {
        return new jcmAction("AddWorld"){

            @Override
            public void act() {
                String string = JOptionPane.showInputDialog(null, (Object)"Enter name for new world ");
                new world(string);
                world.update();
            }
        };
    }

    public void disposeWorld(boolean bl) {
        report.deb("Disposing world: " + this.name);
        world.worldsob.obs.remove(this);
        worlds.remove(this);
        if (bl) {
            this.disposeLater();
        } else {
            this.disposethis();
            jcmTree.restruclink.changed = true;
            loop.gonow();
        }
    }

    public world gm(String string) {
        for (world world2 : worlds) {
            if (!world2.name.equals(string)) continue;
            return world2;
        }
        return null;
    }

    public <T extends module> T gm(Class<T> clazz) {
        if (dataholder.class.isAssignableFrom(clazz)) {
            report.deb("can't get instanceof static dataholder module! " + clazz);
            return null;
        }
        return (T)this.modmap.get(clazz);
    }

    void makemods() {
        this.obs = this.worldtree((infob)root.rootob.find((String)"jcm.mod")).obs;
        this.setupmods();
        incdataholder = false;
        this.setupmods();
    }

    void setupmods() {
        report.logn("================World Setting up " + (incdataholder ? "data" : "other") + " modules: ====================\n ");
        loopcalc.reporttime("Starting world setup: ");
        if (incdataholder) {
            loaddata.getdata(this);
        }
        for (module module2 : this.mods) {
            if (module2 instanceof dataholder != incdataholder) continue;
            report.log("Setup " + module2);
            try {
                module2.initsetup();
                module2.register();
            }
            catch (Exception exception) {
                report.deb(exception, "\n -!-!-!- Error in Initsetup of  " + module2.getName() + " -!-!-!- \n");
                exception.printStackTrace();
            }
        }
        report.logn("==============Finished setup of " + (incdataholder ? "data" : "other") + " modules: ===============\n ");
    }

    public infob worldtree(infob infob2) {
        if (infob2.getObs() != null) {
            packageob packageob2 = new packageob(infob2.getName(), infob2.color, infob2.priority);
            for (infob infob3 : infob2.getObs()) {
                infob infob4 = this.worldtree(infob3);
                if (infob4 != null && (infob4 instanceof module || infob4.getObs() != null && infob4.getObs().size() > 0)) {
                    packageob2.addOb(infob4);
                }
                if (!(infob4 instanceof module)) continue;
                infob4.color = packageob2.color;
            }
            return packageob2;
        }
        return world.createMod(infob2, this);
    }

    public static module createMod(infob infob2, world world2) {
        Class<?> clazz = null;
        try {
            clazz = world2.getClass().getClassLoader().loadClass(infob2.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            report.deb(classNotFoundException, "createMod: " + infob2.name);
            classNotFoundException.printStackTrace();
            return null;
        }
        module module2 = world2.modmap.get(clazz);
        if (module2 != null) {
            return module2;
        }
        try {
            if (!incdataholder && dataholder.class.isAssignableFrom(clazz)) {
                return null;
            }
            if (module.class.isAssignableFrom(clazz)) {
                module2 = (module)clazz.newInstance();
                module2.world = world2;
                module2.checkinfo();
                world2.mods.add(module2);
                world2.modmap.put(module2.getClass(), module2);
                return module2;
            }
        }
        catch (Exception exception) {
            report.deb(exception, "createMod:" + infob2.name);
            exception.printStackTrace();
        }
        return null;
    }

    static {
        worldsob.addAction(filter.filtertype.Worlds, world.addWorld());
        root.rootob.addOb(worldsob);
    }
}

