/*
 * Decompiled with CFR 0.152.
 */
package jcm.core.ob;

import java.awt.Color;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import jcm.core.anno.todo;
import jcm.core.anno.todos;
import jcm.core.complexity;
import jcm.core.cur.curveset;
import jcm.core.itf.hasComplexity;
import jcm.core.itf.menuFiller;
import jcm.core.loop;
import jcm.core.ob.interacob;
import jcm.core.ob.module;
import jcm.core.ob.packageob;
import jcm.core.ob.world;
import jcm.core.par.param;
import jcm.core.report;
import jcm.core.tls.cs;
import jcm.core.tls.ref;
import jcm.gui.doc.autodoc;
import jcm.gui.doc.docview;
import jcm.gui.doc.label;
import jcm.gui.doc.labman;
import jcm.gui.doc.sourceview;
import jcm.gui.gen.colfont;
import jcm.gui.gen.iconFinder;
import jcm.gui.gen.interacmap;
import jcm.gui.nav.filter;
import jcm.gui.nav.jcmAction;
import jcm.gui.nav.jcmMenu;
import jcm.gui.nav.jcmTree;
import jcm.gui.nav.showpan;
import jcm.script.calcscript;

public class infob
implements menuFiller,
Comparable<infob>,
hasComplexity {
    public String name = this.getClass().getSimpleName();
    public infob owner = this;
    public Annotation[] notes = null;
    public Set<infob> obs;
    public Map<jcmAction, filter.filtertype> actions;
    public complexity mycomplexity = complexity.simplest;
    public Color color = Color.black;
    public double priority = 1.0;
    public boolean disposed = false;
    int level = 9999;
    double cump = 0.0;
    boolean expanded = false;
    public static EnumSet singleaction = EnumSet.of(filter.filtertype.Doc, filter.filtertype.Scripts, filter.filtertype.Source, filter.filtertype.Data, filter.filtertype.Maps);

    public infob() {
        this.color = infob.rcol();
    }

    public infob(Object ... objectArray) {
        this.color = null;
        for (Object object : objectArray) {
            if (object instanceof infob) {
                this.owner = (infob)object;
                if (this.color == null) {
                    Color color = this.color = this instanceof world ? infob.rcol() : infob.rcol(this.owner.color);
                }
            }
            if (object instanceof String) {
                this.name = (String)object;
                this.checkinfo();
            }
            if (object instanceof Color) {
                this.color = (Color)object;
            }
            if (object instanceof Number) {
                this.priority = ((Number)object).floatValue();
            }
            if (!(object instanceof complexity)) continue;
            this.mycomplexity = (complexity)((Object)object);
        }
        if (this.color == null) {
            this.color = Color.black;
        }
    }

    void checkinfo() {
        for (Object[] objectArray : packageob.setupinfo) {
            if (!infob.removepackagename(this.name).equals((String)objectArray[0])) continue;
            this.priority = (Double)objectArray[1];
            if (objectArray.length == 3) {
                this.color = (Color)objectArray[2];
            }
            return;
        }
    }

    public void addAction(jcmAction jcmAction2) {
        this.addAction(null, jcmAction2);
    }

    public void addAction(filter.filtertype filtertype2, jcmAction jcmAction2) {
        if (this.actions == null) {
            this.actions = new LinkedHashMap<jcmAction, filter.filtertype>();
        }
        this.actions.put(jcmAction2, filtertype2);
    }

    public void addAction(filter.filtertype filtertype2) {
        if (this.actions != null && this.actions.containsValue((Object)filtertype2)) {
            return;
        }
        if (filtertype2 == filter.filtertype.Doc) {
            this.addAction(filtertype2, docview.showdocaction(this));
        }
        if (filtertype2 == filter.filtertype.Tree) {
            this.addAction(filtertype2, showpan.pan("Tree", jcmTree.class, "[" + this + "]"));
        }
        if (filtertype2 == filter.filtertype.interacmap) {
            this.addAction(filtertype2, showpan.pan("interacmap", interacmap.class, this));
        }
        if (filtertype2 == filter.filtertype.Source) {
            this.addAction(filtertype2, showpan.pan("Source", sourceview.class, this.getSourceFileName()));
        }
        if (filtertype2 == filter.filtertype.Data) {
            this.addAction(filtertype2, showpan.pan("Data", sourceview.class, this.getDataFileName()));
        }
    }

    String getDataFileName() {
        String string = this.getName().replace(".", "/");
        int n = string.lastIndexOf("/");
        if (n > 0 && n < string.length()) {
            string = string.substring(0, n) + "." + string.substring(n + 1, string.length());
        }
        return string;
    }

    String getSourceFileName() {
        String string = this instanceof module ? this.getClass().getName() : this.getName();
        return "src/" + string.replace(".", "/") + ".java";
    }

    void addClassActions() {
        try {
            final Class<?> clazz = Class.forName(this.getName());
            if (Modifier.isPublic(clazz.getModifiers())) {
                this.addAction(filter.filtertype.Source);
            }
            if (calcscript.class.isAssignableFrom(clazz)) {
                this.addAction(filter.filtertype.Scripts, new jcmAction(clazz.getSimpleName()){

                    @Override
                    public void act() {
                        try {
                            ((calcscript)clazz.newInstance()).start();
                        }
                        catch (Exception exception) {
                            report.deb(exception, "Problem Starting Script");
                        }
                    }
                });
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.addAction(filter.filtertype.Data);
        }
    }

    public boolean hasEnabledActions(Set<filter.filtertype> set) {
        if (this.actions != null) {
            for (jcmAction jcmAction2 : this.actions.keySet()) {
                if (!this.checkenabled((Action)jcmAction2, set)) continue;
                return true;
            }
        }
        return false;
    }

    public filter.filtertype doFirstEnabledAction(Set<filter.filtertype> set) {
        if (this.actions != null) {
            for (jcmAction jcmAction2 : this.actions.keySet()) {
                if (!this.checkenabled((Action)jcmAction2, set)) continue;
                jcmAction2.act();
                return this.actions.get(jcmAction2);
            }
        }
        return null;
    }

    public void mincomplexity() {
        this.mincomplexity(this.getObs());
    }

    public void mincomplexity(Collection<? extends infob> collection) {
        if (collection != null) {
            this.mycomplexity = complexity.experimental;
            for (infob infob2 : collection) {
                this.mycomplexity = infob2.getComplexity().compareTo(this.mycomplexity) < 0 ? infob2.getComplexity() : this.mycomplexity;
            }
        }
    }

    @Override
    public complexity getComplexity() {
        return this.mycomplexity != null ? this.mycomplexity : complexity.normal;
    }

    public boolean checkcomplexity() {
        return complexity.check(this.getComplexity());
    }

    public boolean checkenabled(Action action, filter.filtertype filtertype2) {
        return this.actions.get(action) == null || this.actions.get(action) == filtertype2;
    }

    public boolean checkenabled(Action action, Set<filter.filtertype> set) {
        for (filter.filtertype filtertype2 : set) {
            if (!this.checkenabled(action, filtertype2)) continue;
            return true;
        }
        return false;
    }

    public boolean checkenabled(filter.filtertype filtertype2) {
        return this.checkenabled(Collections.singleton(filtertype2));
    }

    public boolean checkenabled(Set<filter.filtertype> set) {
        if (!this.checkcomplexity()) {
            return false;
        }
        if (this instanceof param && (set.contains((Object)filter.filtertype.AllParams) || set.contains((Object)filter.filtertype.NeededParams) && ((param)this).checkneededforplot())) {
            return true;
        }
        if (this instanceof curveset && set.contains((Object)filter.filtertype.Curves)) {
            return true;
        }
        if (this.actions != null) {
            for (Action object : this.actions.keySet()) {
                if (!this.checkenabled(object, set)) continue;
                return true;
            }
        }
        if (this.obs != null) {
            for (infob infob2 : this.obs) {
                if (!infob2.checkenabled(set)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void fillMenu(jcmMenu jcmMenu2) {
        this.fillMenu(jcmMenu2, filter.all());
    }

    public void fillMenu(jcmMenu jcmMenu2, Set<filter.filtertype> set) {
        if (this.actions != null) {
            for (Action action : this.actions.keySet()) {
                if (set != null && !this.checkenabled(action, set)) continue;
                jcmMenu2.add(action);
            }
        }
    }

    public void fillTreeMenu(jcmMenu jcmMenu2) {
        List<infob> list = this.getEnabledObs(jcmMenu2.filters);
        if (jcmMenu2.isTopLevelMenu() && list != null && list.size() == 1 && !this.hasEnabledActions(jcmMenu2.filters)) {
            list.get(0).fillTreeMenu(jcmMenu2);
            return;
        }
        this.fillMenu(jcmMenu2, jcmMenu2.filters);
        if (list != null) {
            for (infob infob2 : list) {
                if (jcmMenu2.filters.size() == 1 && singleaction.containsAll(jcmMenu2.filters) && infob2.getEnabledObs(jcmMenu2.filters) == null && infob2.actions != null) {
                    for (jcmAction jcmAction2 : infob2.actions.keySet()) {
                        if (infob2.actions.get(jcmAction2) != jcmMenu2.filters.iterator().next()) continue;
                        jcmMenu2.add(jcmAction2.clone(infob2.name));
                    }
                    continue;
                }
                jcmMenu2.add(infob2);
            }
        }
        if (jcmMenu2.filters.size() == 1) {
            jcmMenu2.add(showpan.pan(docview.class, "About&" + (Object)((Object)jcmMenu2.filters.iterator().next()) + "Menu"));
        }
    }

    public world getworld() {
        if (this.owner instanceof world) {
            return (world)this.owner;
        }
        if (this.owner instanceof module) {
            return ((module)this.owner).world;
        }
        if (this.owner == this) {
            return null;
        }
        return this.owner.getworld();
    }

    public module getmodule() {
        if (this.owner instanceof module) {
            return (module)this.owner;
        }
        if (this.owner == this) {
            return null;
        }
        return this.owner.getmodule();
    }

    public infob getOwner() {
        return this.owner;
    }

    public Set<infob> getObs() {
        return this.obs;
    }

    public List<infob> getEnabledObs(Set<filter.filtertype> set) {
        if (set.contains((Object)filter.filtertype.Doc) && !this.expanded) {
            this.expandDocTree();
        }
        if (this.obs == null) {
            return null;
        }
        ArrayList<infob> arrayList = new ArrayList<infob>();
        for (infob infob2 : this.obs) {
            if (infob2 == null || !infob2.checkenabled(set)) continue;
            arrayList.add(infob2);
        }
        if (arrayList.size() > 0) {
            return arrayList;
        }
        return null;
    }

    public void addOb(infob infob2) {
        if (this.getObs() == null) {
            this.obs = new TreeSet<infob>();
        }
        this.getObs().add(infob2);
        infob2.level = this.level + 1;
        infob2.priority += this.cump;
        this.cump += 0.01;
    }

    @Override
    public int compareTo(infob infob2) {
        int n = (int)Math.signum(infob2.priority - this.priority);
        if (n == 0) {
            n = this.name.compareTo(infob2.name);
        }
        if (n == 0) {
            return this.equals(infob2) ? 0 : this.hashCode() - infob2.hashCode();
        }
        return n;
    }

    public void removeOb(Object object) {
        if (this.getObs() != null) {
            this.getObs().remove(object);
        }
    }

    public infob find(String string) {
        return this.find(this, string);
    }

    public infob find(Object object, String string) {
        String string2 = string.toLowerCase();
        if (this.obs != null) {
            for (infob infob2 : this.obs) {
                if (!infob2.toString().equals(string)) continue;
                return infob2;
            }
            for (infob infob2 : this.obs) {
                if (!infob2.toString().toLowerCase().equals(string2)) continue;
                return infob2;
            }
            for (infob infob2 : this.obs) {
                infob infob3;
                if (infob2 == object || (infob3 = infob2.find(object, string)) == null) continue;
                return infob3;
            }
        }
        return null;
    }

    public void disposeLater() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                loop.waitUntilLoopDone();
                infob.this.disposethis();
                jcmTree.restruclink.changed = true;
                loop.gonow();
            }
        });
    }

    public void disposethis() {
        if (this.disposed || ref.isstatic(this, this.owner)) {
            return;
        }
        this.disposed = true;
        this.name = this.name + "&disposed";
        if (this.obs != null) {
            for (infob infob2 : this.obs) {
                infob2.disposethis();
            }
            this.obs = null;
        }
    }

    public Color getColor() {
        return this.color;
    }

    public String hashcolor() {
        return infob.hashcolor(this.getColor());
    }

    public static String hashcolor(Color color) {
        int n = color.getRed() + color.getGreen() + color.getBlue() < 512 ? 1 : 2;
        return "<font color=#" + infob.hex2(color.getRed() / n) + infob.hex2(color.getGreen() / n) + infob.hex2(color.getBlue() / n) + " >";
    }

    public static String hex2(int n) {
        return (n < 16 ? "0" : "") + Integer.toHexString(n);
    }

    public static Color rcol() {
        return new Color((int)(255.0 * Math.random()), (int)(255.0 * Math.random()), (int)(255.0 * Math.random())).darker();
    }

    public static Color rcol(Color color) {
        if (color == null) {
            return infob.rcol();
        }
        return new Color((int)(127.0 * Math.random() + (double)((float)color.getRed() / 2.0f)), (int)(127.0 * Math.random() + (double)((float)color.getGreen() / 2.0f)), (int)(127.0 * Math.random() + (double)((float)color.getBlue() / 2.0f))).darker();
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return (this.owner != this ? this.owner.getFullName() + "&" : "") + this.name;
    }

    public String getNameWithWorld() {
        return world.worlds.size() > 1 ? (this.getworld() != null ? this.getworld().name + "&" : "null&") + this.name : this.name;
    }

    public static String removepackagename(String string) {
        int n = string.indexOf(".");
        return n > 0 ? infob.removepackagename(string.substring(n + 1)) : string;
    }

    public String type() {
        return this.getClass().getSimpleName();
    }

    public String getLabel() {
        return labman.getShort(this.name);
    }

    public String getTitle() {
        return labman.getTitle(this.name);
    }

    public String getExtraDoc() {
        return this.docNotes() + autodoc.javacodeforclass(this.name);
    }

    public String getSpecificDoc(Object ... objectArray) {
        return "<p><b>!specific doc request " + objectArray[0] + " for " + this.name + " no longer implemented!</b><p> ";
    }

    public String docSummary() {
        try {
            this.getClass();
            Class.forName(this.name);
            String string = infob.removepackagename(this.name);
            return autodoc.link(string) + "</font> " + "\u00a3%" + string + "<br>";
        }
        catch (ClassNotFoundException classNotFoundException) {
            return autodoc.link(this) + "</font> " + "\u00a3%" + labman.convertkey(this.name) + "<br>";
        }
    }

    public String docOwner() {
        return this.owner != this ? "<nobr>%%\u20ac\u20accogs \u00a3`memberof  " + autodoc.link(this.owner.name) + "%%</nobr><br>" : "";
    }

    public String docNotes() {
        String string = "";
        if (this.notes != null) {
            for (Annotation annotation : this.notes) {
                string = string + "<hr>  == \u20ac\u20accogs  \u00a3` " + annotation.annotationType().getSimpleName() + " == ";
                if (annotation instanceof todos) {
                    for (todo todo2 : ((todos)annotation).value()) {
                        string = string + this.docNote(todo2);
                    }
                    continue;
                }
                string = string + this.docNote(annotation);
            }
        }
        return string;
    }

    public String docNote(Annotation annotation) {
        String string = "\n";
        try {
            for (Method method : annotation.annotationType().getMethods()) {
                String string2 = method.getName();
                if (string2.equals("hashCode") || method.invoke((Object)annotation, new Object[0]).equals(method.getDefaultValue())) continue;
                Class<?> clazz = method.getReturnType();
                string = string + "<font color=" + (clazz == String.class ? "blue" : "green") + ">" + (clazz == String.class || clazz.isEnum() ? " " : " <i>" + string2 + "</i>: ") + method.invoke((Object)annotation, new Object[0]) + "</font>, ";
            }
        }
        catch (Exception exception) {
            report.deb(exception);
        }
        return string;
    }

    void expandDocTree() {
        int n;
        report.deb(this.name + " expand doc tree");
        ArrayList<String> arrayList = new ArrayList<String>(5);
        cs cs2 = new cs(labman.getDoc(this.name));
        cs2.swap("@", "\u00a3@");
        StringBuilder stringBuilder = cs2.s;
        String string = "\u00a3";
        int n2 = 0;
        int n3 = string.length();
        while ((n = stringBuilder.indexOf(string, n2)) >= 0) {
            n2 = cs2.nextspace(n + n3 + 1);
            String string2 = stringBuilder.substring(n + n3, n + n3 + 1);
            String string3 = stringBuilder.substring(n + n3 + 1, n2);
            if (!string2.equals("@") && !string2.equals("\u00a3") && !string2.equals("*") && !string2.equals("%")) continue;
            arrayList.add(string3);
        }
        for (String string4 : arrayList) {
            report.deb("-" + string4);
            label label2 = labman.getLabel(string4);
            if (label2 == null) continue;
            if (label2.jcmob == null) {
                label2.jcmob = autodoc.findob(string4);
            }
            if (label2.jcmob == null) {
                label2.jcmob = new infob(new Object[]{string4, complexity.simplest});
                label2.jcmob.addAction(filter.filtertype.Doc);
            }
            infob infob2 = label2.jcmob;
            boolean bl = infob2.actions != null && infob2.actions.keySet().size() == 1 && infob2.actions.get(infob2.actions.keySet().iterator().next()) == filter.filtertype.Doc;
            if (!bl || infob2 instanceof interacob || infob2 instanceof packageob || infob2.level <= this.level + 1) continue;
            if (infob2.owner != null) {
                infob2.owner.removeOb(infob2);
            }
            this.addOb(infob2);
            infob2.owner = this;
            report.deb("-ADDED");
        }
        this.expanded = true;
    }

    public JComponent getComponent(Object ... objectArray) {
        Box box = Box.createHorizontalBox();
        JLabel jLabel = new JLabel(this.getLabel(), this.getIcon(), 2);
        jLabel.setForeground(this.getColor());
        jLabel.setFont(this instanceof curveset ? colfont.italic : colfont.normalfont);
        box.add(jLabel);
        box.addMouseListener(showpan.moulist);
        box.addMouseMotionListener(showpan.moulist);
        showpan.moulist.cimap.put(box, this);
        return box;
    }

    public Icon getIcon() {
        return iconFinder.findIcon(this);
    }
}

