/*
 * Decompiled with CFR 0.152.
 */
package jcm.core.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.core.report;

public class interpolator {
    List<region> sourcereg;
    Map<region, region> natmap = new HashMap<region, region>();
    Map<region, Float> natfrac = new HashMap<region, Float>();
    Map<region, Float> corrfac = new HashMap<region, Float>();
    Map<region, Set<region>> sourcesubreg = new HashMap<region, Set<region>>();
    Map<region, Set<region>> destsubreg = new HashMap<region, Set<region>>();
    Object source;
    static Set<region> errormap = new HashSet<region>();
    int sy;
    int step;
    int scen;
    float scalar = 1.0f;
    boolean transposed;

    public interpolator(Object ... objectArray) {
        int n = 0;
        for (Object object : objectArray) {
            if (object instanceof curveset) {
                this.sourcereg = new ArrayList<region>();
                for (Object object2 : ((curveset)object).map.keySet()) {
                    this.sourcereg.add((region)object2);
                }
                this.source = (curveset)object;
            }
            if (object instanceof String) {
                this.sourcereg = regman.allreg.findormakereg((String)((String)object), (String)"interpolator").reg;
            }
            if (object instanceof List) {
                this.sourcereg = (List)object;
            }
            if (object instanceof double[] || object instanceof float[][] || object instanceof float[][][]) {
                this.source = object;
            }
            if (object instanceof Float) {
                this.scalar = ((Float)object).floatValue();
            }
            if (object instanceof Integer) {
                if (n == 0) {
                    this.sy = (Integer)object;
                }
                if (n == 1) {
                    this.step = (Integer)object;
                }
                if (n == 2) {
                    this.scen = (Integer)object;
                }
                ++n;
            }
            if (!(object instanceof Boolean)) continue;
            this.transposed = (Boolean)object;
        }
    }

    public void fill(curveset curveset2, region region2, int n, int n2, curveset curveset3) {
        this.fill(curveset2, region2, n, n2, curveset3, curveset3 != null ? curveset3.ey : n2);
    }

    public void fill(curveset curveset2, region region2, int n, int n2, curveset curveset3, int n3) {
        this.fill(curveset2, region2, n, n2, curveset3, n3, 100.0f);
    }

    public void fill(curveset curveset2, region region2, int n, int n2, curveset curveset3, float f) {
        this.fill(curveset2, region2, n, n2, curveset3, curveset3 != null ? curveset3.ey : n2, f);
    }

    public void fill(curveset curveset2, region region2, int n, int n2, curveset curveset3, int n3, float f) {
        int n4;
        errormap.clear();
        boolean bl = f < 100.0f;
        float f2 = 1.0f - f / 100.0f;
        float f3 = 0.0f;
        HashMap<region, Float> hashMap = new HashMap<region, Float>(region2.reg.size());
        for (region iterator : this.sourcereg) {
            this.sourcesubreg.put(iterator, iterator.subreg(regman.nations));
        }
        for (region region3 : region2.reg) {
            this.destsubreg.put(region3, region3.subreg(regman.nations));
        }
        for (region region4 : this.sourcereg) {
            for (region region5 : this.sourcesubreg.get(region4)) {
                this.natmap.put(region5, region4);
            }
        }
        int n5 = n4 = bl ? n - 1 : n;
        while (n4 <= n2) {
            if (this.natfrac.size() == 0 || n4 <= n3) {
                for (region region6 : this.sourcereg) {
                    float f4 = 0.0f;
                    for (region region7 : this.sourcesubreg.get(region6)) {
                        if (curveset3 == null) {
                            this.natfrac.put(region7, Float.valueOf(1.0f));
                        } else if (!curveset3.map.containsKey(region7)) {
                            if (!errormap.contains(region7)) {
                                errormap.add(region7);
                            }
                        } else {
                            int n6 = n > curveset3.sy ? (n4 < n3 ? n4 : n3) : (n4 < curveset3.sy ? curveset3.sy : n4);
                            float f5 = curveset3.get(region7, n6);
                            if (!Float.isNaN(f5)) {
                                this.natfrac.put(region7, Float.valueOf(f5));
                            }
                        }
                        if (!this.natfrac.containsKey(region7)) {
                            this.natfrac.put(region7, Float.valueOf(0.0f));
                        }
                        f4 += this.natfrac.get(region7).floatValue();
                    }
                    for (region region7 : this.sourcesubreg.get(region6)) {
                        this.natfrac.put(region7, Float.valueOf(this.natfrac.get(region7).floatValue() / f4));
                    }
                }
            }
            for (region region8 : region2.reg) {
                f3 = 0.0f;
                for (region region9 : this.destsubreg.get(region8)) {
                    region region10 = this.natmap.get(region9);
                    if (region10 == null) {
                        errormap.add(region9);
                        continue;
                    }
                    f3 += this.getdata(region10, n4) * this.natfrac.get(region9).floatValue();
                }
                if (bl) {
                    if (n4 >= n) {
                        curveset2.set(region8, n4, f3 + f2 * (curveset2.get(region8, n4 - 1) - ((Float)hashMap.get(region8)).floatValue()));
                    }
                    hashMap.put(region8, Float.valueOf(f3));
                    continue;
                }
                curveset2.set(region8, n4, f3);
            }
            ++n4;
        }
        if (errormap.size() > 0) {
            String string = "Interpolator errors dest=" + curveset2.name + " weights=" + curveset3.name + " regions: ";
            for (region region11 : errormap) {
                string = string + region11.name + " ";
            }
            report.deb(string);
        }
    }

    public float getdata(region region2, int n) {
        if (this.source instanceof curveset) {
            return this.scalar * ((curveset)this.source).get(region2, n);
        }
        return this.getdata(this.sourcereg.indexOf(region2), n);
    }

    public float getdata(int n, int n2) {
        int n3 = (n2 - this.sy) / this.step;
        float f = (float)((n2 - this.sy) % this.step) / (float)this.step;
        if (this.source instanceof double[]) {
            return this.scalar * (float)((double[])this.source)[n];
        }
        if (this.source instanceof float[][]) {
            float[][] fArray = (float[][])this.source;
            if (this.transposed) {
                return this.scalar * ((1.0f - f) * fArray[n3][n] + (f > 0.0f ? f * fArray[n3 + 1][n] : 0.0f));
            }
            return this.scalar * ((1.0f - f) * fArray[n][n3] + (f > 0.0f ? f * fArray[n][n3 + 1] : 0.0f));
        }
        if (this.source instanceof float[][][]) {
            float[][][] fArray = (float[][][])this.source;
            return this.scalar * ((1.0f - f) * fArray[n][this.scen][n3] + (f > 0.0f ? f * fArray[n][this.scen][n3 + 1] : 0.0f));
        }
        return Float.NaN;
    }

    public static void fillregdata(curveset curveset2, curveset curveset3, region region2, int n, int n2) {
        interpolator.fillregdata(curveset2, curveset3, region2, 1.0f, n, n2);
    }

    public static void fillregdata(curveset curveset2, curveset curveset3, region region2, float f) {
        interpolator.fillregdata(curveset2, curveset3, region2, f, curveset2.sy, curveset2.ey);
    }

    public static void fillregdata(curveset curveset2, curveset curveset3, region region2, float f, int n, int n2) {
        for (region region3 : region2.reg) {
            Set<region> set = region3.subreg(curveset2);
            for (int i = n; i <= n2; ++i) {
                float f2 = 0.0f;
                for (region region4 : set) {
                    f2 += Float.isNaN(curveset2.get(region4, i)) ? 0.0f : curveset2.get(region4, i) * f;
                }
                curveset3.set(region3, i, f2);
            }
        }
    }

    public static void linearinterp(curveset curveset2, int n, int n2) {
        for (curve curve2 : curveset2.map.values()) {
            for (int i = n + 1; i <= n2 - 1; ++i) {
                curve2.set(i, (curve2.get(n) * (float)(n2 - i) + curve2.get(n2) * (float)(i - n)) / (float)(n2 - n));
            }
        }
    }

    public static float interphfc(float[][][] fArray, int n, int n2, int n3) {
        int n4 = (n3 - 2000) / 10;
        int n5 = n3 % 10;
        int n6 = fArray[0][0].length;
        if (n6 == 12) {
            ++n4;
            ++n;
        }
        if (n4 >= n6 - 1) {
            n4 = n6 - 1;
            n5 = 0;
        }
        try {
            return (1.0f - (float)n5 / 10.0f) * fArray[n][n2][n4] + (n5 > 0 ? (float)n5 / 10.0f * fArray[n][n2][n4 + 1] : 0.0f);
        }
        catch (Exception exception) {
            report.log(exception, " sres interp error " + fArray + " reg=" + n + " sc=" + n2 + " bk=" + n4 + " by=" + n5);
            return 0.0f;
        }
    }

    public static float sresinterp(float[][] fArray, int n, int n2) {
        int n3 = (n2 - 2000) / 10;
        int n4 = n2 % 10;
        try {
            return (float)(n3 < 10 || n == 7 && n3 < 30 ? ((double)(10 - n4) * (double)fArray[n][n3] + (double)n4 * (double)fArray[n][n3 + 1]) / 10.0 : (n == 7 ? (double)fArray[n][30] : (double)fArray[n][10]));
        }
        catch (Exception exception) {
            report.log(exception, "sres interp error: " + fArray + " sc=" + n + " bk=" + n3 + " by=" + n4);
            return 0.0f;
        }
    }

    public static float simpinterp(float[] fArray, int n) {
        int n2 = (n - 2000) / 10;
        int n3 = n % 10;
        return (float)(n2 < 10 ? ((double)(10 - n3) * (double)fArray[n2] + (double)n3 * (double)fArray[n2 + 1]) / 10.0 : (double)fArray[10]);
    }
}

