/*
 * Decompiled with CFR 0.152.
 */
package jcm.core.cur;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import jcm.core.cur.curvar;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.itf.plotlink;
import jcm.core.loop;
import jcm.core.ob.infob;
import jcm.core.ob.module;
import jcm.core.ob.world;
import jcm.core.register;
import jcm.core.report;
import jcm.gui.doc.labman;
import jcm.gui.nav.jcmAction;
import jcm.gui.nav.jcmMenu;
import jcm.gui.nav.jcmTree;

public class makederiv {
    static Map<curveset, Map<module, List<curveset>>> potLink = new HashMap<curveset, Map<module, List<curveset>>>();

    public static jcmMenu makevariantmenu(final curveset curveset2) {
        jcmMenu jcmMenu2 = new jcmMenu(new Object[]{"CreateVariant"});
        jcmMenu2.add(new jcmAction("percent&change&per&yr"){

            @Override
            public void act() {
                makederiv.addnewderiv(curve.Type.ratefrac, curveset2);
            }
        });
        jcmMenu2.add(new jcmAction("percent&of&total"){

            @Override
            public void act() {
                makederiv.addnewderiv(curve.Type.frac, curveset2);
            }
        });
        jcmMenu2.add(new jcmAction("derivative"){

            @Override
            public void act() {
                makederiv.addnewderiv(curve.Type.rate, curveset2);
            }
        });
        jcmMenu2.add(new jcmAction("integral"){

            @Override
            public void act() {
                makederiv.addnewderiv(curve.Type.integral, curveset2);
            }
        });
        jcmMenu2.add(new jcmAction("smooth"){

            @Override
            public void act() {
                makederiv.addnewderiv(curve.Type.smooth, curveset2);
            }
        });
        jcmMenu2.add(makederiv.makeDerivMenu(curve.Type.ratio, curveset2));
        jcmMenu2.add(makederiv.makeDerivMenu(curve.Type.difference, curveset2));
        jcmMenu2.addSeparator();
        if (world.worlds.size() > 1) {
            jcmMenu2.add(makederiv.compareworldmenu(curveset2));
        }
        jcmMenu2.addSeparator();
        jcmMenu2.add(new jcmAction("Refresh Options"){

            @Override
            public void act() {
                makederiv.refreshopts(curveset2);
            }
        });
        return jcmMenu2;
    }

    public static void addnewderiv(curve.Type type2, curveset ... curvesetArray) {
        makederiv.addderiv(curvesetArray[0], new curvar(type2, curvesetArray));
    }

    public static void addnewderiv(curve.Type type2, List<curveset> list) {
        makederiv.addderiv(list.get(0), new curvar(type2, list));
    }

    public static void addderiv(curveset curveset2, curveset curveset3) {
        if (curveset3 == null) {
            return;
        }
        curveset2.addOb(curveset3);
        curveset3.temporary = true;
        curveset3.justadded = true;
        jcmTree.restruclink.changed = true;
        curveset3.owner = curveset2;
        curve.Type cfr_ignored_0 = curveset3.type;
        if (curveset3.type == curve.Type.smooth) {
            curveset3.setaffectedby(curve.smoothtype, curve.smoothinterval);
        }
        loop.golater("qtset add-deriv");
    }

    public static jcmMenu makeDerivMenu(curve.Type type2, curveset curveset2) {
        Map<module, List<curveset>> map2;
        if (potLink.get(curveset2) == null) {
            makederiv.findPotLink(curveset2);
        }
        if ((map2 = potLink.get(curveset2)).size() > 0) {
            jcmMenu jcmMenu2 = new jcmMenu(new Object[]{(Object)((Object)type2) + ":"});
            for (List<curveset> object2 : map2.values()) {
                for (Object object : object2) {
                    if (!((curveset)object).name.equals(curveset2.name) || !makederiv.checkUnitsMatch(curveset2, (curveset)object, type2)) continue;
                    jcmMenu2.add(makederiv.addVariantAction(((infob)object).getworld().name, curveset2, (curveset)object, type2));
                }
            }
            jcmMenu2.addSeparator();
            for (module module2 : map2.keySet()) {
                jcmMenu jcmMenu3 = new jcmMenu(new Object[]{labman.getTitle(module2.getworld() == curveset2.getmodule().getworld() ? module2.getName() : module2.getFullName())});
                for (curveset curveset3 : map2.get(module2)) {
                    if (!curveset3.checkcomplexity() || !makederiv.checkUnitsMatch(curveset2, curveset3, type2)) continue;
                    jcmMenu3.add(makederiv.addVariantAction(curveset3.getTitle(), curveset2, curveset3, type2));
                }
                if (jcmMenu3.list.size() > 1) {
                    jcmMenu2.add(jcmMenu3);
                }
                if (jcmMenu3.list.size() != 1) continue;
                jcmMenu2.add(jcmMenu3.list.get(0));
            }
            return jcmMenu2;
        }
        return null;
    }

    static void findPotLink(curveset curveset2) {
        try {
            if (potLink.get(curveset2) == null) {
                potLink.put(curveset2, new LinkedHashMap());
            }
            potLink.get(curveset2).clear();
            module module2 = curveset2.getmodule();
            makederiv.checkmod(curveset2, module2);
            for (infob infob2 : module2.owner.getObs()) {
                if (infob2 == module2 || !(infob2 instanceof module)) continue;
                makederiv.checkmod(curveset2, (module)infob2);
            }
            for (module module3 : module2.getworld().mods) {
                if (module3 == module2 || module3.owner == module2.owner) continue;
                makederiv.checkmod(curveset2, module3);
            }
            for (world world2 : world.worlds) {
                if (world2 == module2.getworld()) continue;
                for (module module4 : world2.mods) {
                    makederiv.checkmod(curveset2, module4);
                }
            }
        }
        catch (Exception exception) {
            report.deb("makederiv findPotLink " + curveset2 + " => " + exception);
        }
    }

    static void checkmod(curveset curveset2, module module2) {
        LinkedList<curveset> linkedList = new LinkedList<curveset>();
        for (curveset curveset3 : module2.curvesets) {
            if (curveset3.equals(curveset2)) continue;
            makederiv.checkoverlap(linkedList, curveset2, curveset3);
        }
        if (linkedList.size() > 0) {
            potLink.get(curveset2).put(module2, linkedList);
        }
    }

    static void checkoverlap(List<curveset> list, curveset curveset2, curveset curveset3) {
        if (curveset3.obs != null) {
            for (Object object : curveset3.obs) {
                if (!(object instanceof curveset)) continue;
                makederiv.checkoverlap(list, curveset2, (curveset)object);
            }
        }
        if (curveset3.name.equals(curveset2.name)) {
            list.add(curveset3);
            return;
        }
        for (Object object : curveset3.map.keySet()) {
            if (!curveset2.map.containsKey(object)) continue;
            list.add(curveset3);
            return;
        }
    }

    static void refreshopts(curveset curveset2) {
        if (curveset2.changed) {
            plotlink plotlink2 = new plotlink(){

                @Override
                public boolean isShowing() {
                    return true;
                }

                @Override
                public void doplot() {
                }
            };
            register.addlink(plotlink2, curveset2);
            loop.gonow();
            register.removelink(plotlink2, curveset2);
        }
        makederiv.findPotLink(curveset2);
    }

    static boolean checkUnitsMatch(curveset curveset2, curveset curveset3, curve.Type type2) {
        if (type2 == curve.Type.ratio) {
            return true;
        }
        if (type2 == curve.Type.extra) {
            return makederiv.checkUnitsMatch(((curvar)curveset2).linkqq.get(0), curveset3, curve.Type.sum);
        }
        return curveset2.units.substring(curveset2.units.indexOf("&") + 1).equals(curveset3.units.substring(curveset3.units.indexOf("&") + 1));
    }

    static Action addVariantAction(String string, final curveset curveset2, final curveset curveset3, final curve.Type type2) {
        return new jcmAction(string){

            @Override
            public void act() {
                if (type2 == curve.Type.ratio) {
                    makederiv.addnewderiv(curve.Type.ratio, curveset2, curveset3);
                }
                if (type2 == curve.Type.difference) {
                    makederiv.addnewderiv(curve.Type.difference, curveset2, curveset3);
                }
                if (type2 == curve.Type.extra) {
                    ((curvar)curveset2).addLink(curveset3);
                }
            }
        };
    }

    public static curveset compareworld(curveset curveset2, String string) {
        for (Object object : curveset2.map.keySet()) {
            if (!object.toString().equals(curveset2.name)) continue;
            return makederiv.compareworld(curveset2, curveset2.map.get(object));
        }
        return null;
    }

    public static curveset compareworld(curveset curveset2, curve curve2) {
        report.deb("compare worlds " + curve2.name);
        curveset curveset3 = new curveset("Compare&" + curve2.name, curveset2.units, curveset2.sy, curveset2.ey, curveset2.xstep);
        curveset3.register();
        for (world world2 : world.worlds) {
            for (module module2 : world2.mods) {
                for (curveset curveset4 : module2.curvesets) {
                    if (!curveset4.name.equals(curveset2.name)) continue;
                    for (Object object : curveset2.map.keySet()) {
                        if (curveset2.map.get(object) != curve2) continue;
                        try {
                            curveset3.addcurve(world2.name, new curve(curveset4.map.get(object).geta(), world2.name, world2.color, curveset2.sy, curveset2.ey, curveset2.xstep));
                        }
                        catch (NullPointerException nullPointerException) {
                            report.deb("cannot find curve " + object + " for " + world2.name);
                        }
                    }
                    curveset3.setaffectedby(module2);
                }
            }
        }
        return curveset3;
    }

    public static jcmMenu compareworldmenu(final curveset curveset2) {
        jcmMenu jcmMenu2 = new jcmMenu(new Object[]{" Compare Worlds... "});
        for (final curve curve2 : curveset2.map.values()) {
            jcmMenu2.add(new jcmAction("Compare&" + curve2.name){

                @Override
                public void act() {
                    makederiv.addderiv(curveset2, makederiv.compareworld(curveset2, curve2));
                }
            });
        }
        return jcmMenu2;
    }
}

