/*
 * Decompiled with CFR 0.152.
 */
package jcm.core.cur;

import java.awt.Color;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import jcm.core.complexity;
import jcm.core.cur.curvar;
import jcm.core.cur.curve;
import jcm.core.cur.makederiv;
import jcm.core.itf.hasColor;
import jcm.core.itf.menuFiller;
import jcm.core.ob.infob;
import jcm.core.ob.interacob;
import jcm.core.ob.module;
import jcm.core.par.param;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.gui.doc.autodoc;
import jcm.gui.doc.labman;
import jcm.gui.nav.filter;
import jcm.gui.nav.jcmMenu;
import jcm.gui.nav.showpan;
import jcm.gui.plot.datable;
import jcm.gui.plot.lineplot;
import jcm.gui.plot.mapplot;

public class curveset
extends interacob
implements menuFiller {
    public LinkedHashMap<Object, curve> map = new LinkedHashMap();
    public curve.Type type = curve.Type.normal;
    public int sy = module.gsy;
    public int ey = module.gey;
    public int xstep = 1;
    public String units = "nounits";
    public boolean justadded = false;
    public boolean unitschanged = false;
    boolean gotmap = false;
    public Set<param> assocparams;
    curve totalcurve = null;
    curve selectedcurve = null;

    public curveset(Object ... objectArray) {
        if (this instanceof curvar) {
            return;
        }
        this.color = null;
        int n = 0;
        int n2 = 0;
        for (Object object : objectArray) {
            if (object instanceof interacob) {
                this.owner = (interacob)object;
                this.setaffectedby((interacob)object);
                this.name = this.owner.name;
            }
            if (object instanceof Color) {
                this.color = (Color)object;
            }
            if (object instanceof complexity) {
                this.mycomplexity = (complexity)((Object)object);
            }
            if (object instanceof curve.Type) {
                this.type = (curve.Type)((Object)object);
            }
            if (object instanceof curve[]) {
                for (curve curve2 : (curve[])object) {
                    this.addcurve(curve2);
                }
            }
            if (object instanceof curve) {
                this.addcurve((curve)object);
            }
            if (object instanceof String) {
                switch (n) {
                    case 0: {
                        this.name = (String)object;
                        break;
                    }
                    case 1: {
                        this.units = (String)object;
                    }
                }
                ++n;
            }
            if (!(object instanceof Number)) continue;
            int n3 = ((Number)object).intValue();
            switch (n2) {
                case 0: {
                    this.sy = n3;
                    break;
                }
                case 1: {
                    this.ey = n3;
                    break;
                }
                case 2: {
                    this.xstep = n3;
                }
            }
            ++n2;
        }
        if (this.mycomplexity == null) {
            if (this.map.size() > 0) {
                this.mincomplexity(this.map.values());
            } else {
                this.mycomplexity = complexity.normal;
            }
        }
        this.priority = 2.0;
        if (this.color == null) {
            this.color = curveset.rcol(this.owner.color);
        }
        this.addActions();
        this.register();
    }

    void addActions() {
        this.addAction(filter.filtertype.Curves, showpan.pan("Plot", lineplot.class, this));
        this.addExtraPlotAction();
        this.addAction(filter.filtertype.Curves, showpan.pan("Table", datable.class, this));
        this.checkforMapAction();
        this.addAction(filter.filtertype.Doc);
    }

    void addExtraPlotAction() {
    }

    void checkforMapAction() {
        if (!this.gotmap) {
            for (Object object : this.map.keySet()) {
                if (!(object instanceof region)) continue;
                this.gotmap = true;
                this.addAction(filter.filtertype.Maps, showpan.pan("Map", mapplot.class, this));
                return;
            }
        }
    }

    @Override
    public void fillMenu(jcmMenu jcmMenu2) {
        this.fillMenu(jcmMenu2, filter.all());
    }

    @Override
    public void fillMenu(jcmMenu jcmMenu2, Set<filter.filtertype> set) {
        this.checkforMapAction();
        super.fillMenu(jcmMenu2, set);
        jcmMenu2.addSeparator();
        if (set.contains((Object)filter.filtertype.Curves)) {
            jcmMenu2.add(makederiv.makevariantmenu(this));
        }
    }

    public void associate(param ... paramArray) {
        if (this.assocparams == null) {
            this.assocparams = new HashSet<param>(3);
        }
        for (param param2 : paramArray) {
            this.assocparams.add(param2);
        }
    }

    @Override
    public void changeendyear(int n, int n2) {
        if (this.ey == n) {
            this.ey = n2;
            for (curve curve2 : this.map.values()) {
                curve2.changeendyear(n, n2);
            }
            this.changed = true;
        }
    }

    void addcurve(Object object, curve curve2) {
        this.map.put(object, curve2);
        if (object == regman.world && curve2.type == curve.Type.normal) {
            curve2.type = curve.Type.total;
        }
        if (this.totalcurve == null && curve2.type == curve.Type.total) {
            this.totalcurve = curve2;
        }
        if (this.mycomplexity == null) {
            this.mincomplexity(this.map.values());
        }
        if (curve2.owner == curve2) {
            curve2.owner = this;
        }
    }

    public void addcurve(curve ... curveArray) {
        for (curve curve2 : curveArray) {
            this.addcurve(curve2.name, curve2);
        }
    }

    public curve addNewCurve(Object object) {
        curve curve2 = this.makecurve(object);
        if (this.mycomplexity != null && object instanceof region) {
            curve2.mycomplexity = this.mycomplexity;
        }
        this.addcurve(object, curve2);
        return curve2;
    }

    public curve makecurve(Object object) {
        if (object instanceof infob) {
            infob infob2 = (infob)object;
            return new curve(infob2.getName(), infob2.getColor(), this.sy, this.ey, this.xstep, this);
        }
        Color color = object instanceof hasColor ? ((hasColor)object).getColor() : infob.rcol();
        return new curve(object.toString(), color, this.sy, this.ey, this.xstep, this);
    }

    public curve getcurve(Object object) {
        return this.map.get(object);
    }

    public void select(Object object) {
        this.selectedcurve = this.getOrAddCurve(object);
    }

    public curve getOrAddCurve(Object object) {
        if (this.map.containsKey(object)) {
            return this.map.get(object);
        }
        return this.addNewCurve(object);
    }

    @Override
    public infob find(String string) {
        infob infob2 = super.find(string);
        if (infob2 != null) {
            return infob2;
        }
        for (Object object : this.map.keySet()) {
            if (!object.toString().equals(string)) continue;
            return this.map.get(object);
        }
        return null;
    }

    public boolean gotdata(Object object, int n) {
        return !Float.isNaN(this.get(object, n));
    }

    public float get(Object object, int n) {
        try {
            return this.getcurve(object).get(n);
        }
        catch (NullPointerException nullPointerException) {
            return Float.NaN;
        }
    }

    public float get(Object object) {
        try {
            return this.getcurve(object).get();
        }
        catch (NullPointerException nullPointerException) {
            return Float.NaN;
        }
    }

    public float get(int n) {
        return this.selectedcurve.get(n);
    }

    public float get() {
        return this.selectedcurve.get();
    }

    public void set(Object object, int n, float f) {
        this.getOrAddCurve(object).set(n, f);
    }

    public void set(Object object, float f) {
        this.getOrAddCurve(object).set(f);
    }

    public void set(int n, float f) {
        this.selectedcurve.set(n, f);
    }

    public void set(float f) {
        this.selectedcurve.set(f);
    }

    public void add(Object object, int n, float f) {
        this.getOrAddCurve(object);
        float f2 = this.get(object, n);
        this.set(object, n, Float.isNaN(f) ? (Float.isNaN(f2) ? Float.NaN : f2) : (Float.isNaN(f2) ? f : f + f2));
    }

    public void multiply(Object object, int n, float f) {
        if (this.getcurve(object) != null) {
            this.set(n, this.get(object, n) * f);
        }
    }

    public String getunits() {
        return this.units;
    }

    public param getxscale() {
        boolean bl = this.sy < 2160 && this.ey > 1840;
        int n = bl ? Math.min(this.ey, 2160) : this.ey;
        int n2 = bl ? Math.max(this.sy, 1840) : this.sy;
        int n3 = bl ? 50 : (this.ey - this.sy) / 10;
        return new param(new Object[]{param.Type.Xscale, "Xscale", "year", 0, n2, n, n3});
    }

    public param getyscale() {
        return this.getyscale(false);
    }

    public param getyscale(boolean bl) {
        float f = this.getmin();
        float f2 = this.getmax(bl);
        param param2 = new param(new Object[]{param.Type.Yscale, "Yscale", this.units, 0, Float.valueOf(f), Float.valueOf(f2), 1});
        param2.units.checkunitfac(f2 - f);
        param2.units.checkunitcancel();
        return param2;
    }

    public float getmax() {
        float f = Float.MIN_VALUE;
        for (curve curve2 : this.map.values()) {
            if (!curve2.checkcomplexity()) continue;
            f = Math.max(f, curve2.getmax());
        }
        return f;
    }

    public float getmin() {
        float f = Float.MAX_VALUE;
        for (curve curve2 : this.map.values()) {
            if (!curve2.checkcomplexity()) continue;
            f = Math.min(f, curve2.getmin());
        }
        return f;
    }

    public float getmax(boolean bl) {
        if (!bl) {
            return this.getmax();
        }
        float f = Float.MIN_VALUE;
        for (int i = this.sy; i < this.ey; i += this.xstep) {
            float f2 = 0.0f;
            for (curve curve2 : this.mapwithouttotal().values()) {
                if (!curve2.gotdata(i)) continue;
                f2 += curve2.get(i);
            }
            if (!(f2 > f)) continue;
            f = f2;
        }
        return f;
    }

    public float calctot() {
        return this.calctot(module.year);
    }

    public float calctot(int n) {
        if (this.totalcurve == null) {
            this.totalcurve = this.getOrAddCurve(regman.world);
        }
        float f = 0.0f;
        for (curve curve2 : this.mapwithouttotal().values()) {
            float f2 = curve2.get(n);
            if (Float.isNaN(f2)) continue;
            f += f2;
        }
        this.totalcurve.set(n, f);
        return this.totalcurve.get(n);
    }

    public void topdownscale(float f) {
        this.topdownscale(f, false);
    }

    public void topdownscale(float f, boolean bl) {
        float f2;
        float f3 = this.calctot();
        if (bl && !Float.isNaN(f2 = this.get("bunker"))) {
            f3 -= f2;
            f -= f2;
        }
        float f4 = f / f3;
        if (f3 > 0.0f) {
            for (curve curve2 : this.map.values()) {
                float f5;
                if (bl && curve2.name.equals("bunker") || Float.isNaN(f5 = curve2.get())) continue;
                curve2.set(f5 * f4);
            }
        }
    }

    public Map<Object, curve> mapwithouttotal() {
        LinkedHashMap<Object, curve> linkedHashMap = new LinkedHashMap<Object, curve>();
        for (Map.Entry<Object, curve> entry : this.map.entrySet()) {
            if (entry.getValue().type == curve.Type.total) continue;
            linkedHashMap.put(entry.getKey(), entry.getValue());
        }
        return linkedHashMap;
    }

    public void postcalc() {
        if (this.type == curve.Type.integral) {
            for (curve curve2 : this.map.values()) {
                curve2.calcintegral();
            }
        }
    }

    @Override
    public String getExtraDoc() {
        return this.docUnits() + this.docCurves() + "----" + this.docNotes() + this.docInteracs() + autodoc.javacode(this);
    }

    public String docUnits() {
        String string = "==Units==";
        string = string + "units: " + labman.getTitle(this.units) + "<br>";
        string = string + "timescale (years) " + this.sy + "-" + this.ey + " (step " + this.xstep + ")<br>";
        return string;
    }

    public String docCurves() {
        String string = "==Curves==";
        if (this.map.size() == 0) {
            string = string + "\u00a3\u00a7nocurvesyet";
        } else {
            string = string + "<ul>";
            for (curve curve2 : this.map.values()) {
                if (!curve2.checkcomplexity()) continue;
                string = string + "<li>" + curve2.docSummary();
            }
            string = string + "</ul>";
        }
        return string;
    }

    public static enum prob {
        min,
        low2sd,
        low1sd,
        median,
        mean,
        hi1sd,
        hi2sd,
        max;

    }
}

