/*
 * Decompiled with CFR 0.152.
 */
package jcm.core.cur;

import java.awt.Color;
import jcm.core.complexity;
import jcm.core.cur.curveset;
import jcm.core.itf.hasColor;
import jcm.core.ob.infob;
import jcm.core.ob.interacob;
import jcm.core.ob.module;
import jcm.core.par.param;
import jcm.gui.doc.autodoc;
import jcm.gui.doc.labman;

public class curve
extends infob {
    public int sy;
    public int ey;
    public int xstep;
    public static final float dud = Float.NaN;
    public Type type;
    private float[] a;
    private curve qa;
    private curve qb;
    public linestyle style;
    public static param<smoothopt> smoothtype = new param(new Object[]{"smooth type", smoothopt.values(), smoothopt.triangular});
    public static param smoothinterval = new param("smooth spread", "", 4, 0, 7);

    public curve(Object ... objectArray) {
        boolean bl;
        block26: {
            block27: {
                this.sy = module.gsy;
                this.ey = module.gey;
                this.xstep = 1;
                this.type = Type.normal;
                this.style = linestyle.line;
                int n = 0;
                this.mycomplexity = complexity.normal;
                bl = false;
                this.color = curve.rcol();
                for (Object object : objectArray) {
                    if (object instanceof curve) {
                        if (this.qa == null) {
                            this.qa = (curve)object;
                            this.color = this.qa.color;
                            this.name = this.qa.name;
                            this.sy = this.qa.sy;
                            this.ey = this.qa.ey;
                            this.xstep = this.qa.xstep;
                            continue;
                        }
                        this.qb = (curve)object;
                        continue;
                    }
                    if (object instanceof Boolean) {
                        bl = (Boolean)object;
                    }
                    if (object instanceof interacob) {
                        this.owner = (interacob)object;
                    }
                    if (object instanceof float[]) {
                        this.a = (float[])object;
                    }
                    if (object instanceof hasColor) {
                        this.color = ((hasColor)object).getColor();
                    }
                    if (object instanceof Color) {
                        this.color = (Color)object;
                    }
                    if (object instanceof complexity) {
                        this.mycomplexity = (complexity)((Object)object);
                    }
                    if (object instanceof String) {
                        this.name = (String)object;
                    }
                    if (object instanceof Number) {
                        int n2 = ((Number)object).intValue();
                        switch (n) {
                            case 0: {
                                this.sy = n2;
                                break;
                            }
                            case 1: {
                                this.ey = n2;
                                break;
                            }
                            case 2: {
                                this.xstep = n2;
                            }
                        }
                        ++n;
                    }
                    if (!(object instanceof Type)) continue;
                    this.type = (Type)((Object)object);
                }
                if (this.a != null) break block26;
                if (bl || this.type == Type.normal || this.type == Type.total) break block27;
                if (this.type != Type.integral) break block26;
            }
            this.a = new float[1 + (this.ey - this.sy) / this.xstep];
        }
        if (this.type == Type.integral) {
            this.calcintegral();
        }
        if (bl) {
            if ((this.type == Type.normal || this.type == Type.total) && this.qa.xstep == this.xstep) {
                try {
                    System.arraycopy(this.qa.a, (this.sy - this.qa.sy) / this.xstep, this.a, 0, this.a.length);
                }
                catch (Exception exception) {
                    System.out.println("CLONE PROBLEM INFO: " + this.qa.a + " " + this.a + " " + (this.sy - this.qa.sy) / this.xstep + " 0 " + this.a.length);
                    exception.printStackTrace();
                }
            } else {
                for (int i = this.sy; i <= this.ey; i += this.xstep) {
                    this.set(i, this.get(i));
                }
                this.type = Type.normal;
                this.qa = null;
                this.qb = null;
            }
        }
    }

    public curve cloneIndependent(Object ... objectArray) {
        Object[] objectArray2 = this.type == Type.ratio ? new Object[]{true, this.qa, this.qb, Type.ratio} : new Object[]{true, this};
        Object[] objectArray3 = new Object[objectArray.length + objectArray2.length];
        System.arraycopy(objectArray2, 0, objectArray3, 0, objectArray2.length);
        System.arraycopy(objectArray, 0, objectArray3, objectArray2.length, objectArray.length);
        return new curve(objectArray3);
    }

    public void changeendyear(int n, int n2) {
        if (this.ey == n) {
            if (this.a != null) {
                float[] fArray = new float[1 + (n2 - this.sy) / this.xstep];
                System.arraycopy(this.a, 0, fArray, 0, Math.min(this.a.length, fArray.length));
                this.a = fArray;
            }
            this.ey = n2;
        }
        if (this.qa != null) {
            this.qa.changeendyear(n, n2);
        }
        if (this.qb != null) {
            this.qb.changeendyear(n, n2);
        }
    }

    public static boolean ok(float f) {
        return !Float.isNaN(f);
    }

    public boolean gotdata(int n) {
        return n >= this.sy && n <= this.ey && !Float.isNaN(this.get(n)) && !Float.isNaN(this.get(n)) && !Float.isInfinite(this.get(n));
    }

    public float get() {
        return this.get(module.year);
    }

    public float get(int n) {
        switch (this.type) {
            case difference: {
                return this.qa != null && this.qb != null && curve.ok(this.qa.get(n)) && curve.ok(this.qb.get(n)) ? this.qa.get(n) - this.qb.get(n) : Float.NaN;
            }
            case sum: {
                return this.qa != null && this.qb != null && curve.ok(this.qa.get(n)) && curve.ok(this.qb.get(n)) ? this.qa.get(n) + this.qb.get(n) : Float.NaN;
            }
            case ratio: {
                return this.qa != null && this.qb != null && curve.ok(this.qa.get(n)) && curve.ok(this.qb.get(n)) && this.qb.get(n) != 0.0f ? this.qa.get(n) / this.qb.get(n) : Float.NaN;
            }
            case frac: {
                return curve.ok(this.qa.get(n)) ? 100.0f * this.qa.get(n) / ((curveset)this.owner).calctot(n) : Float.NaN;
            }
            case rate: {
                return curve.ok(this.qa.get(n)) && curve.ok(this.qa.get(n - this.xstep)) ? (this.qa.get(n) - this.qa.get(n - this.xstep)) / (float)this.xstep : Float.NaN;
            }
            case ratefrac: {
                return curve.ok(this.qa.get(n)) && curve.ok(this.qa.get(n - this.xstep)) && this.qa.get(n - this.xstep) != 0.0f ? (100.0f * this.qa.get(n) / this.qa.get(n - this.xstep) - 100.0f) / (float)this.xstep : Float.NaN;
            }
            case smooth: {
                float f = Float.NaN;
                int n2 = 0;
                int n3 = (int)smoothinterval.getval();
                int n4 = 1;
                for (int i = -n3; i <= n3; ++i) {
                    float f2;
                    if (curve.smoothtype.chosen == smoothopt.triangular) {
                        n4 = (int)smoothinterval.getval() + 1 - Math.abs(i);
                    }
                    if (!curve.ok(f2 = this.qa.get(n + i))) continue;
                    n2 += n4;
                    f = curve.ok(f) ? f + f2 * (float)n4 : f2 * (float)n4;
                }
                return n2 > 0 ? f / (float)n2 : Float.NaN;
            }
        }
        if (n >= this.sy && n <= this.ey) {
            float f;
            if (this.xstep == 1) {
                return curve.ok(this.a[n - this.sy]) ? this.a[n - this.sy] : Float.NaN;
            }
            int n5 = (n - this.sy) / this.xstep;
            int n6 = (n - this.sy) % this.xstep;
            float f3 = f = n6 == 0 ? this.a[n5] : this.a[n5] + (this.a[n5 + 1] - this.a[n5]) * ((float)n6 / (float)this.xstep);
            if (curve.ok(f)) {
                return f;
            }
        }
        return Float.NaN;
    }

    public void set(float f) {
        this.set(module.year, f);
    }

    public void set(int n, float f) {
        if (n >= this.sy && n <= this.ey) {
            this.a[(n - this.sy) / this.xstep] = f;
        }
    }

    public float[] geta() {
        return this.a;
    }

    public int getyear(int n) {
        return this.sy + this.xstep * n;
    }

    public int getlength() {
        return this.type == Type.normal || this.type == Type.total ? this.a.length : this.qa.a.length;
    }

    void calcintegral() {
        float f = 0.0f;
        int n = this.sy;
        int n2 = this.ey;
        for (int i = n; i <= n2; i += this.xstep) {
            this.a[(i - this.sy) / this.xstep] = f += curve.ok(this.qa.get(i)) ? this.qa.get(i) : 0.0f;
        }
    }

    public float getmax() {
        float f = Float.MIN_VALUE;
        for (int i = this.sy; i < this.ey; i += this.xstep) {
            if (!curve.ok(this.get(i)) || !(this.get(i) > f)) continue;
            f = this.get(i);
        }
        return f;
    }

    public float getmin() {
        float f = Float.MAX_VALUE;
        for (int i = this.sy; i < this.ey; i += this.xstep) {
            if (!curve.ok(this.get(i)) || !(this.get(i) < f)) continue;
            f = this.get(i);
        }
        return f;
    }

    @Override
    public String getLabel() {
        return labman.getTitle(this.name);
    }

    @Override
    public String docSummary() {
        String string = labman.convertkey(this.name);
        return this.hashcolor() + autodoc.link(string, this.getTitle() + labman.getShortIfDifferent(string)) + "</font> " + "\u00a3%" + string + "<br>";
    }

    @Override
    public String getExtraDoc() {
        return this.docNotes() + this.docOwner() + autodoc.javacode(this.owner);
    }

    static enum smoothopt {
        even,
        triangular;

    }

    public static enum linestyle {
        line,
        dotted,
        dashed,
        dotdash;

    }

    public static enum Type {
        normal,
        difference,
        sum,
        ratio,
        ratefrac,
        rate,
        frac,
        total,
        integral,
        smooth,
        extra;

    }
}

