/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils.icon;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeState;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.utils.HashMapKey;
import org.jvnet.substance.utils.LazyResettableHashMap;
import org.jvnet.substance.utils.SubstanceColorSchemeUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceFadeUtilities;

public class TransitionAwareIcon
implements Icon {
    private JComponent comp;
    private ButtonModel model;
    protected Delegate delegate;
    private LazyResettableHashMap<Icon> iconMap;
    private int iconWidth;
    private int iconHeight;

    public TransitionAwareIcon(AbstractButton button, Delegate delegate) {
        this(button, button == null ? null : button.getModel(), delegate);
    }

    public TransitionAwareIcon(JComponent comp, ButtonModel model, Delegate delegate) {
        this.comp = comp;
        this.model = model;
        this.delegate = delegate;
        String suffix = comp == null ? "null" : comp.getClass().getSimpleName();
        this.iconMap = new LazyResettableHashMap("TransitionAwareIcon." + suffix);
        this.iconWidth = this.delegate.getColorSchemeIcon(SubstanceColorSchemeUtilities.getColorScheme(comp, ComponentState.DEFAULT)).getIconWidth();
        this.iconHeight = this.delegate.getColorSchemeIcon(SubstanceColorSchemeUtilities.getColorScheme(comp, ComponentState.DEFAULT)).getIconHeight();
    }

    private Icon getIconToPaint(Component c) {
        SubstanceColorScheme currScheme;
        ComponentState currState = ComponentState.getState(this.model, this.comp);
        ComponentState prevState = SubstanceCoreUtilities.getPrevComponentState(this.comp);
        if (!currState.isKindActive(FadeKind.ENABLE)) {
            prevState = currState;
        }
        float cyclePos = currState.getCyclePosition();
        SubstanceColorScheme prevScheme = currScheme = SubstanceColorSchemeUtilities.getColorScheme(this.comp, currState);
        FadeState fadeState = SubstanceFadeUtilities.getFadeState((Component)this.comp, FadeKind.ROLLOVER, FadeKind.SELECTION, FadeKind.PRESS, FadeKind.ARM);
        if (fadeState != null) {
            prevScheme = SubstanceColorSchemeUtilities.getColorScheme(this.comp, prevState);
            cyclePos = fadeState.getFadePosition();
            if (!fadeState.isFadingIn()) {
                cyclePos = 1.0f - cyclePos;
            }
        }
        float currAlpha = SubstanceColorSchemeUtilities.getAlpha(this.comp, currState);
        float prevAlpha = SubstanceColorSchemeUtilities.getAlpha(this.comp, prevState);
        HashMapKey key = SubstanceCoreUtilities.getHashKey(currScheme.getDisplayName(), prevScheme.getDisplayName(), Float.valueOf(currAlpha), Float.valueOf(prevAlpha), Float.valueOf(cyclePos));
        if (!this.iconMap.containsKey(key)) {
            Icon icon = this.delegate.getColorSchemeIcon(currScheme);
            Icon prevIcon = this.delegate.getColorSchemeIcon(prevScheme);
            BufferedImage temp = SubstanceCoreUtilities.getBlankImage(icon.getIconWidth(), icon.getIconHeight());
            Graphics2D g2d = temp.createGraphics();
            if (currScheme == prevScheme) {
                g2d.setComposite(AlphaComposite.getInstance(3, currAlpha));
                icon.paintIcon(this.comp, g2d, 0, 0);
            } else {
                if (cyclePos < 1.0f) {
                    g2d.setComposite(AlphaComposite.SrcOver.derive(prevAlpha));
                    prevIcon.paintIcon(this.comp, g2d, 0, 0);
                }
                if (cyclePos > 0.0f) {
                    g2d.setComposite(AlphaComposite.SrcOver.derive(currAlpha * cyclePos));
                    icon.paintIcon(this.comp, g2d, 0, 0);
                }
            }
            this.iconMap.put(key, new ImageIcon(temp));
            g2d.dispose();
        }
        Icon result = this.iconMap.get(key);
        return result;
    }

    @Override
    public int getIconHeight() {
        return this.iconHeight;
    }

    @Override
    public int getIconWidth() {
        return this.iconWidth;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.getIconToPaint(c).paintIcon(c, g, x, y);
    }

    public static interface Delegate {
        public Icon getColorSchemeIcon(SubstanceColorScheme var1);
    }
}

