/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.EnumSet;
import java.util.Set;
import javax.swing.AbstractButton;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeState;
import org.jvnet.lafwidget.animation.FadeTracker;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.api.SubstanceConstants;
import org.jvnet.substance.painter.border.SubstanceBorderPainter;
import org.jvnet.substance.painter.gradient.SubstanceGradientPainter;
import org.jvnet.substance.utils.HashMapKey;
import org.jvnet.substance.utils.LazyResettableHashMap;
import org.jvnet.substance.utils.SubstanceColorSchemeUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceImageCreator;
import org.jvnet.substance.utils.SubstanceOutlineUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;

public class PairwiseButtonBackgroundDelegate {
    private static LazyResettableHashMap<BufferedImage> pairwiseBackgrounds = new LazyResettableHashMap("PairwiseButtonBackgroundDelegate");

    public static void updatePairwiseBackground(Graphics g, AbstractButton button, int width, int height, SubstanceConstants.Side side, boolean toIgnoreOpenSides) {
        SubstanceColorScheme borderScheme;
        SubstanceColorScheme colorScheme;
        if (SubstanceCoreUtilities.isButtonNeverPainted(button)) {
            return;
        }
        BufferedImage resultNonFlat = null;
        ComponentState state = ComponentState.getState(button);
        ComponentState prevState = SubstanceCoreUtilities.getPrevComponentState(button);
        float cyclePos = state.getCyclePosition();
        SubstanceColorScheme colorScheme2 = colorScheme = SubstanceColorSchemeUtilities.getColorScheme(button, state);
        SubstanceColorScheme borderScheme2 = borderScheme = SubstanceColorSchemeUtilities.getBorderColorScheme(button, state);
        FadeTracker fadeTracker = FadeTracker.getInstance();
        FadeState fadeState = fadeTracker.getFadeState(button, FadeKind.ROLLOVER);
        if (fadeState != null) {
            BufferedImage imageDefault;
            colorScheme = SubstanceColorSchemeUtilities.getColorScheme(button, prevState);
            colorScheme2 = SubstanceColorSchemeUtilities.getColorScheme(button, state);
            borderScheme = SubstanceColorSchemeUtilities.getBorderColorScheme(button, prevState);
            borderScheme2 = SubstanceColorSchemeUtilities.getBorderColorScheme(button, state);
            cyclePos = fadeState.getFadePosition();
            if (!fadeState.isFadingIn()) {
                cyclePos = 1.0f - cyclePos;
            }
            if ((imageDefault = PairwiseButtonBackgroundDelegate.getPairwiseFullAlphaBackground(button, SubstanceImageCreator.SimplisticSoftBorderReverseGradientPainter.INSTANCE, width, height, side, cyclePos, colorScheme, colorScheme2, borderScheme, borderScheme2, toIgnoreOpenSides)) == null) {
                return;
            }
            resultNonFlat = imageDefault;
        } else {
            resultNonFlat = PairwiseButtonBackgroundDelegate.getPairwiseFullAlphaBackground(button, SubstanceImageCreator.SimplisticSoftBorderReverseGradientPainter.INSTANCE, width, height, side, 0.0f, colorScheme, colorScheme2, borderScheme, borderScheme2, toIgnoreOpenSides);
        }
        boolean isFlat = SubstanceCoreUtilities.hasFlatAppearance(button);
        boolean isSpecial = isFlat || !state.isKindActive(FadeKind.ENABLE);
        float extraAlpha = 1.0f;
        if (isSpecial) {
            if (isFlat) {
                if (FadeTracker.getInstance().isTracked(button, FadeKind.ROLLOVER) && !state.isKindActive(FadeKind.SELECTION) && state.isKindActive(FadeKind.ENABLE)) {
                    extraAlpha = FadeTracker.getInstance().getFade(button, FadeKind.ROLLOVER);
                } else if (state == ComponentState.DEFAULT) {
                    extraAlpha = 0.0f;
                }
                if (state == ComponentState.DISABLED_UNSELECTED) {
                    extraAlpha = 0.0f;
                }
            } else if (!state.isKindActive(FadeKind.ENABLE)) {
                extraAlpha = SubstanceColorSchemeUtilities.getAlpha(button, state);
            }
        }
        if (extraAlpha > 0.0f) {
            Graphics2D graphics = (Graphics2D)g.create();
            graphics.setComposite(TransitionLayout.getAlphaComposite(button, extraAlpha, g));
            graphics.drawImage((Image)resultNonFlat, 0, 0, null);
            graphics.dispose();
        }
    }

    private static BufferedImage getPairwiseFullAlphaBackground(AbstractButton button, SubstanceGradientPainter painter, int width, int height, SubstanceConstants.Side side, float cyclePos, SubstanceColorScheme colorScheme, SubstanceColorScheme colorScheme2, SubstanceColorScheme borderScheme, SubstanceColorScheme borderScheme2, boolean toIgnoreOpenSides) {
        if (SubstanceCoreUtilities.isButtonNeverPainted(button)) {
            return null;
        }
        Set<SubstanceConstants.Side> openSides = toIgnoreOpenSides ? EnumSet.noneOf(SubstanceConstants.Side.class) : SubstanceCoreUtilities.getSides(button, "substancelaf.buttonopenSide");
        String openKey = "";
        for (SubstanceConstants.Side oSide : openSides) {
            openKey = openKey + oSide.name() + "-";
        }
        boolean noBorder = SubstanceCoreUtilities.isSpinnerButton(button);
        String sideKey = side == null ? "null" : side.toString();
        HashMapKey key = SubstanceCoreUtilities.getHashKey(width, height, sideKey, Float.valueOf(cyclePos), openKey, colorScheme.getDisplayName(), colorScheme2.getDisplayName(), borderScheme.getDisplayName(), borderScheme2.getDisplayName(), button.getClass().getName(), painter.getDisplayName(), noBorder);
        if (!pairwiseBackgrounds.containsKey(key)) {
            boolean radius = false;
            int deltaLeft = openSides.contains((Object)SubstanceConstants.Side.LEFT) ? 3 : 0;
            int deltaRight = openSides.contains((Object)SubstanceConstants.Side.RIGHT) ? 3 : 0;
            int deltaTop = openSides.contains((Object)SubstanceConstants.Side.TOP) ? 3 : 0;
            int deltaBottom = openSides.contains((Object)SubstanceConstants.Side.BOTTOM) ? 3 : 0;
            GeneralPath contour = null;
            SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter(button);
            int borderDelta = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(button)) / 2.0);
            BufferedImage finalBackground = SubstanceCoreUtilities.getBlankImage(width, height);
            Graphics2D finalGraphics = (Graphics2D)finalBackground.getGraphics();
            finalGraphics.translate(-deltaLeft, -deltaTop);
            if (side != null) {
                switch (side) {
                    case TOP: 
                    case BOTTOM: {
                        contour = SubstanceOutlineUtilities.getBaseOutline(height + deltaTop + deltaBottom, width + deltaLeft + deltaRight, (float)radius, null, borderDelta);
                        int translateY = height;
                        if (SubstanceCoreUtilities.isScrollButton(button)) {
                            translateY += 1 + (side == SubstanceConstants.Side.BOTTOM ? 1 : -2);
                        }
                        AffineTransform at = AffineTransform.getTranslateInstance(0.0, translateY);
                        at.rotate(-1.5707963267948966);
                        finalGraphics.setTransform(at);
                        painter.paintContourBackground(finalGraphics, height + deltaTop + deltaBottom, width + deltaLeft + deltaRight, contour, false, colorScheme, colorScheme2, cyclePos, true, colorScheme != colorScheme2);
                        if (noBorder) break;
                        borderPainter.paintBorder(finalGraphics, button, height + deltaTop + deltaBottom, width + deltaLeft + deltaRight, contour, null, borderScheme, borderScheme2, cyclePos, borderScheme != borderScheme2);
                        break;
                    }
                    case RIGHT: 
                    case LEFT: {
                        contour = SubstanceOutlineUtilities.getBaseOutline(width + deltaLeft + deltaRight, height + deltaTop + deltaBottom, (float)radius, null, borderDelta);
                        painter.paintContourBackground(finalGraphics, width + deltaLeft + deltaRight, height + deltaTop + deltaBottom, contour, false, colorScheme, colorScheme2, cyclePos, true, colorScheme != colorScheme2);
                        if (noBorder) break;
                        borderPainter.paintBorder(finalGraphics, button, width + deltaLeft + deltaRight, height + deltaTop + deltaBottom, contour, null, borderScheme, borderScheme2, cyclePos, borderScheme != borderScheme2);
                    }
                }
            } else {
                contour = SubstanceOutlineUtilities.getBaseOutline(width + deltaLeft + deltaRight, height + deltaTop + deltaBottom, (float)radius, null, borderDelta);
                painter.paintContourBackground(finalGraphics, width + deltaLeft + deltaRight, height + deltaTop + deltaBottom, contour, false, colorScheme, colorScheme2, cyclePos, true, colorScheme != colorScheme2);
                if (!noBorder) {
                    borderPainter.paintBorder(finalGraphics, button, width + deltaLeft + deltaRight, height + deltaTop + deltaBottom, contour, null, borderScheme, borderScheme2, cyclePos, borderScheme != borderScheme2);
                }
            }
            pairwiseBackgrounds.put(key, finalBackground);
        }
        BufferedImage opaque = pairwiseBackgrounds.get(key);
        return opaque;
    }
}

