/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.painter.border;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.RenderingHints;
import java.awt.Shape;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.painter.border.SubstanceBorderPainter;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.scroll.SubstanceScrollButton;

public class StandardBorderPainter
implements SubstanceBorderPainter {
    @Override
    public String getDisplayName() {
        return "Standard";
    }

    @Override
    public void paintBorder(Graphics g, Component c, int width, int height, Shape contour, Shape innerContour, SubstanceColorScheme colorScheme1, SubstanceColorScheme colorScheme2, float cyclePos, boolean useCyclePosAsInterpolation) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        SubstanceColorScheme interpolationScheme1 = colorScheme1;
        SubstanceColorScheme interpolationScheme2 = useCyclePosAsInterpolation ? colorScheme2 : colorScheme1;
        double cycleCoef = 1.0 - (double)cyclePos;
        Color topBorderColor = this.getTopBorderColor(interpolationScheme1, interpolationScheme2, cycleCoef, useCyclePosAsInterpolation);
        Color midBorderColor = this.getMidBorderColor(interpolationScheme1, interpolationScheme2, cycleCoef, useCyclePosAsInterpolation);
        Color bottomBorderColor = this.getBottomBorderColor(interpolationScheme1, interpolationScheme2, cycleCoef, useCyclePosAsInterpolation);
        if (topBorderColor != null && midBorderColor != null && bottomBorderColor != null) {
            float strokeWidth = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(c));
            int joinKind = c instanceof SubstanceScrollButton ? 2 : 1;
            int capKind = 0;
            graphics.setStroke(new BasicStroke(strokeWidth, capKind, joinKind));
            LinearGradientPaint gradient = new LinearGradientPaint(0.0f, 0.0f, 0.0f, height, new float[]{0.0f, 0.5f, 1.0f}, new Color[]{topBorderColor, midBorderColor, bottomBorderColor}, MultipleGradientPaint.CycleMethod.REPEAT);
            graphics.setPaint(gradient);
            graphics.draw(contour);
        }
        graphics.dispose();
    }

    public Color getTopBorderColor(SubstanceColorScheme interpolationScheme1, SubstanceColorScheme interpolationScheme2, double cycleCoef, boolean useCyclePosAsInterpolation) {
        return SubstanceColorUtilities.getTopBorderColor(interpolationScheme1, interpolationScheme2, cycleCoef);
    }

    public Color getMidBorderColor(SubstanceColorScheme interpolationScheme1, SubstanceColorScheme interpolationScheme2, double cycleCoef, boolean useCyclePosAsInterpolation) {
        return SubstanceColorUtilities.getMidBorderColor(interpolationScheme1, interpolationScheme2, cycleCoef);
    }

    public Color getBottomBorderColor(SubstanceColorScheme interpolationScheme1, SubstanceColorScheme interpolationScheme2, double cycleCoef, boolean useCyclePosAsInterpolation) {
        return SubstanceColorUtilities.getBottomBorderColor(interpolationScheme1, interpolationScheme2, cycleCoef);
    }
}

