/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils.border;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeTracker;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.utils.HashMapKey;
import org.jvnet.substance.utils.LazyResettableHashMap;
import org.jvnet.substance.utils.SubstanceColorSchemeUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceImageCreator;
import org.jvnet.substance.utils.SubstanceSizeUtils;

public class SubstanceBorder
implements Border,
UIResource {
    protected Insets myInsets;
    protected float alpha = 1.0f;
    protected float radiusFactor = 0.5f;
    private static LazyResettableHashMap<BufferedImage> smallImageCache = new LazyResettableHashMap("SubstanceBorder");

    public SubstanceBorder() {
    }

    public SubstanceBorder(float radiusFactor) {
        this();
        this.radiusFactor = radiusFactor;
    }

    public SubstanceBorder(Insets insets) {
        this();
        this.myInsets = new Insets(insets.top, insets.left, insets.bottom, insets.right);
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    private void paintBorder(Component c, Graphics g, int x, int y, int width, int height, boolean isEnabled, boolean hasFocus, float alpha) {
        SubstanceColorScheme borderColorScheme;
        if (!SubstanceLookAndFeel.isCurrentLookAndFeel()) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        float cyclePos = 1.0f;
        FadeTracker fadeTracker = FadeTracker.getInstance();
        boolean isFocusAnimated = fadeTracker.isTracked(c, FadeKind.FOCUS);
        float radius = this.radiusFactor * SubstanceSizeUtils.getClassicButtonCornerRadius(SubstanceSizeUtils.getComponentFontSize(c));
        ComponentState state = isEnabled ? ComponentState.DEFAULT : ComponentState.DISABLED_UNSELECTED;
        SubstanceColorScheme borderColorScheme2 = borderColorScheme = SubstanceColorSchemeUtilities.getBorderColorScheme(c, state);
        float finalAlpha = alpha;
        if (isFocusAnimated || c.hasFocus()) {
            if (isFocusAnimated) {
                cyclePos = fadeTracker.getFade(c, FadeKind.FOCUS);
            }
            borderColorScheme2 = SubstanceColorSchemeUtilities.getBorderColorScheme(c, ComponentState.SELECTED);
        } else {
            finalAlpha *= SubstanceColorSchemeUtilities.getAlpha(c, state);
        }
        graphics.setComposite(TransitionLayout.getAlphaComposite(c, finalAlpha, g));
        if (width * height < 100000) {
            HashMapKey hashKey = SubstanceCoreUtilities.getHashKey(SubstanceCoreUtilities.getBorderPainter(c).getDisplayName(), SubstanceSizeUtils.getComponentFontSize(c), width, height, Float.valueOf(radius), borderColorScheme.getDisplayName(), borderColorScheme2.getDisplayName(), Float.valueOf(cyclePos));
            if (!smallImageCache.containsKey(hashKey)) {
                BufferedImage toCache = SubstanceCoreUtilities.getBlankImage(width, height);
                Graphics2D g2d = toCache.createGraphics();
                SubstanceImageCreator.paintBorder(c, g2d, 0, 0, width, height, radius, borderColorScheme, borderColorScheme2, cyclePos);
                g2d.dispose();
                smallImageCache.put(hashKey, toCache);
            }
            graphics.drawImage((Image)smallImageCache.get(hashKey), x, y, null);
        } else {
            graphics.translate(x, y);
            SubstanceImageCreator.paintSimpleBorder(graphics, width, height, borderColorScheme, borderColorScheme2, cyclePos);
        }
        graphics.dispose();
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        this.paintBorder(c, g, x, y, width, height, c.isEnabled(), c.hasFocus(), this.alpha);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        if (this.myInsets == null) {
            return SubstanceSizeUtils.getDefaultBorderInsets(SubstanceSizeUtils.getComponentFontSize(c));
        }
        return this.myInsets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

