/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.api;

import java.awt.Component;
import java.util.EnumMap;
import java.util.Map;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.substance.api.ColorSchemeTransform;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SubstanceApi;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.colorscheme.BlendBiColorScheme;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

@SubstanceApi
public class SubstanceColorSchemeBundle
implements Cloneable {
    protected SubstanceColorScheme activeColorScheme;
    protected SubstanceColorScheme defaultColorScheme;
    protected SubstanceColorScheme disabledColorScheme;
    protected Map<ComponentState, SubstanceColorScheme> stateColorSchemeMap;
    protected Map<ComponentState, Float> stateAlphaMap;
    protected Map<ComponentState, SubstanceColorScheme> stateHighlightColorSchemeMap;
    protected Map<ComponentState, Float> stateHighlightSchemeAlphaMap;
    protected Map<ComponentState, SubstanceColorScheme> stateBorderColorSchemeMap;
    protected SubstanceColorScheme pressedScheme;
    protected SubstanceColorScheme disabledSelectedScheme;

    public SubstanceColorSchemeBundle(SubstanceColorScheme activeColorScheme, SubstanceColorScheme defaultColorScheme, SubstanceColorScheme disabledColorScheme) {
        this.activeColorScheme = activeColorScheme;
        this.defaultColorScheme = defaultColorScheme;
        this.disabledColorScheme = disabledColorScheme;
        this.stateColorSchemeMap = new EnumMap<ComponentState, SubstanceColorScheme>(ComponentState.class);
        this.stateAlphaMap = new EnumMap<ComponentState, Float>(ComponentState.class);
        this.stateHighlightColorSchemeMap = new EnumMap<ComponentState, SubstanceColorScheme>(ComponentState.class);
        this.stateHighlightSchemeAlphaMap = new EnumMap<ComponentState, Float>(ComponentState.class);
        this.stateBorderColorSchemeMap = new EnumMap<ComponentState, SubstanceColorScheme>(ComponentState.class);
    }

    public void registerColorScheme(SubstanceColorScheme stateColorScheme, float alpha, ComponentState ... states) {
        if (states != null) {
            for (ComponentState state : states) {
                this.stateColorSchemeMap.put(state, stateColorScheme);
                this.stateAlphaMap.put(state, Float.valueOf(alpha));
            }
        }
    }

    public void registerColorScheme(SubstanceColorScheme stateColorScheme, ComponentState ... states) {
        this.registerColorScheme(stateColorScheme, 1.0f, states);
    }

    public void registerHighlightColorScheme(SubstanceColorScheme stateHighlightScheme, ComponentState ... states) {
        if (states == null || states.length == 0) {
            for (ComponentState state : ComponentState.values()) {
                if (this.stateHighlightColorSchemeMap.containsKey((Object)state) || !state.isKindActive(FadeKind.ENABLE) || state == ComponentState.DEFAULT) continue;
                this.stateHighlightColorSchemeMap.put(state, stateHighlightScheme);
            }
        } else {
            for (ComponentState state : states) {
                this.stateHighlightColorSchemeMap.put(state, stateHighlightScheme);
            }
        }
    }

    public void registerHighlightColorScheme(SubstanceColorScheme stateHighlightScheme, float alpha, ComponentState ... states) {
        if (states == null || states.length == 0) {
            for (ComponentState state : ComponentState.values()) {
                if (!state.isKindActive(FadeKind.ENABLE) || state == ComponentState.DEFAULT) continue;
                if (!this.stateHighlightColorSchemeMap.containsKey((Object)state)) {
                    this.stateHighlightColorSchemeMap.put(state, stateHighlightScheme);
                }
                if (this.stateHighlightSchemeAlphaMap.containsKey((Object)state)) continue;
                this.stateHighlightSchemeAlphaMap.put(state, Float.valueOf(alpha));
            }
        } else {
            for (ComponentState state : states) {
                this.stateHighlightColorSchemeMap.put(state, stateHighlightScheme);
                this.stateHighlightSchemeAlphaMap.put(state, Float.valueOf(alpha));
            }
        }
    }

    public SubstanceColorScheme getColorScheme(Component comp, ComponentState componentState, boolean toIgnoreHighlights) {
        if (!toIgnoreHighlights && SubstanceCoreUtilities.toUseHighlightColorScheme(comp)) {
            SubstanceColorScheme registered = this.stateHighlightColorSchemeMap.get((Object)componentState);
            if (registered != null) {
                return registered;
            }
        } else {
            SubstanceColorScheme registered = this.stateColorSchemeMap.get((Object)componentState);
            if (registered != null) {
                return registered;
            }
            if (componentState.isKindActive(FadeKind.PRESS)) {
                if (this.pressedScheme == null) {
                    this.pressedScheme = this.activeColorScheme.shade(0.2).saturate(0.1);
                }
                return this.pressedScheme;
            }
            if (componentState == ComponentState.DISABLED_SELECTED) {
                if (this.disabledSelectedScheme == null) {
                    this.disabledSelectedScheme = new BlendBiColorScheme(this.activeColorScheme, this.disabledColorScheme, 0.25);
                }
                return this.disabledSelectedScheme;
            }
            if (componentState == ComponentState.DEFAULT) {
                return this.defaultColorScheme;
            }
            if (!componentState.isKindActive(FadeKind.ENABLE)) {
                return this.disabledColorScheme;
            }
            return this.activeColorScheme;
        }
        return null;
    }

    public SubstanceColorScheme getHighlightColorScheme(Component comp, ComponentState componentState) {
        SubstanceColorScheme registered = this.stateHighlightColorSchemeMap.get((Object)componentState);
        if (registered != null) {
            return registered;
        }
        return null;
    }

    public float getHighlightAlpha(Component comp, ComponentState componentState) {
        Float registered = this.stateHighlightSchemeAlphaMap.get((Object)componentState);
        if (registered != null) {
            return registered.floatValue();
        }
        return -1.0f;
    }

    public float getAlpha(Component comp, ComponentState componentState) {
        Float registered = this.stateAlphaMap.get((Object)componentState);
        if (registered != null) {
            return registered.floatValue();
        }
        return -1.0f;
    }

    public SubstanceColorScheme getActiveColorScheme() {
        return this.activeColorScheme;
    }

    public SubstanceColorScheme getDefaultColorScheme() {
        return this.defaultColorScheme;
    }

    public SubstanceColorScheme getDisabledColorScheme() {
        return this.disabledColorScheme;
    }

    public SubstanceColorScheme getBorderColorScheme(Component comp, ComponentState componentState) {
        SubstanceColorScheme registered = this.stateBorderColorSchemeMap.get((Object)componentState);
        if (registered != null) {
            return registered;
        }
        return this.getColorScheme(comp, componentState, true);
    }

    public void registerBorderColorScheme(SubstanceColorScheme stateBorderScheme, ComponentState ... states) {
        if (states == null || states.length == 0) {
            for (ComponentState state : ComponentState.values()) {
                if (this.stateBorderColorSchemeMap.containsKey((Object)state)) continue;
                this.stateBorderColorSchemeMap.put(state, stateBorderScheme);
            }
        } else {
            for (ComponentState state : states) {
                this.stateBorderColorSchemeMap.put(state, stateBorderScheme);
            }
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        SubstanceColorSchemeBundle clone = new SubstanceColorSchemeBundle(this.activeColorScheme, this.defaultColorScheme, this.disabledColorScheme);
        if (this.stateColorSchemeMap != null) {
            clone.stateColorSchemeMap = new EnumMap<ComponentState, SubstanceColorScheme>(this.stateColorSchemeMap);
        }
        if (this.stateAlphaMap != null) {
            clone.stateAlphaMap = new EnumMap<ComponentState, Float>(this.stateAlphaMap);
        }
        if (this.stateBorderColorSchemeMap != null) {
            clone.stateBorderColorSchemeMap = new EnumMap<ComponentState, SubstanceColorScheme>(this.stateBorderColorSchemeMap);
        }
        if (this.stateHighlightColorSchemeMap != null) {
            clone.stateHighlightColorSchemeMap = new EnumMap<ComponentState, SubstanceColorScheme>(this.stateHighlightColorSchemeMap);
        }
        if (this.stateHighlightSchemeAlphaMap != null) {
            clone.stateHighlightSchemeAlphaMap = new EnumMap<ComponentState, Float>(this.stateHighlightSchemeAlphaMap);
        }
        return clone;
    }

    public SubstanceColorSchemeBundle transform(ColorSchemeTransform transform) {
        SubstanceColorSchemeBundle result = new SubstanceColorSchemeBundle(transform.transform(this.activeColorScheme), transform.transform(this.defaultColorScheme), transform.transform(this.disabledColorScheme));
        if (this.stateColorSchemeMap != null) {
            result.stateColorSchemeMap = new EnumMap<ComponentState, SubstanceColorScheme>(ComponentState.class);
            for (Map.Entry<ComponentState, SubstanceColorScheme> entry : this.stateColorSchemeMap.entrySet()) {
                result.stateColorSchemeMap.put(entry.getKey(), transform.transform(entry.getValue()));
            }
        }
        if (this.stateAlphaMap != null) {
            result.stateAlphaMap = new EnumMap<ComponentState, Float>(this.stateAlphaMap);
        }
        if (this.stateBorderColorSchemeMap != null) {
            result.stateBorderColorSchemeMap = new EnumMap<ComponentState, SubstanceColorScheme>(ComponentState.class);
            for (Map.Entry<ComponentState, SubstanceColorScheme> entry : this.stateBorderColorSchemeMap.entrySet()) {
                result.stateBorderColorSchemeMap.put(entry.getKey(), transform.transform(entry.getValue()));
            }
        }
        if (this.stateHighlightColorSchemeMap != null) {
            result.stateHighlightColorSchemeMap = new EnumMap<ComponentState, SubstanceColorScheme>(ComponentState.class);
            for (Map.Entry<ComponentState, SubstanceColorScheme> entry : this.stateHighlightColorSchemeMap.entrySet()) {
                result.stateHighlightColorSchemeMap.put(entry.getKey(), transform.transform(entry.getValue()));
            }
        }
        if (this.stateHighlightSchemeAlphaMap != null) {
            result.stateHighlightSchemeAlphaMap = new EnumMap<ComponentState, Float>(this.stateHighlightSchemeAlphaMap);
        }
        return result;
    }
}

