/*
 * Decompiled with CFR 0.152.
 */
package jcm.script;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.loop;
import jcm.core.report;
import jcm.core.tls.fileio;
import jcm.gui.gen.colfont;
import jcm.gui.gen.imagesaver;
import jcm.gui.gen.lookandfeel;
import jcm.gui.nav.showpan;
import jcm.gui.plot.datable;
import jcm.gui.plot.lineplot;
import jcm.mod.carbon.carboncycle;
import jcm.mod.cli.glotemp;
import jcm.mod.cli.radfor;
import jcm.mod.obj.controller;
import jcm.mod.obj.globco2emit;
import jcm.mod.obj.stabilisation;
import jcm.mod.regemit.emitquota;
import jcm.mod.regemit.pledges;
import jcm.mod.regemit.shares;
import jcm.script.calcscript;

public class swinf_regional
extends calcscript {
    globco2emit gc = this.gm(globco2emit.class);
    carboncycle car = this.gm(carboncycle.class);
    glotemp tem = this.gm(glotemp.class);
    radfor rf = this.gm(radfor.class);
    stabilisation stab = this.gm(stabilisation.class);
    shares sha = this.gm(shares.class);
    pledges ple = this.gm(pledges.class);
    emitquota eq = this.gm(emitquota.class);
    controller co = this.gm(controller.class);
    Map<curveset, curve> curvemap = new HashMap<curveset, curve>();
    String indics = " Scenario\t\t Emit CO2eq 2020 \t Emit CO2eq  2050 \t IntegC 2050 \t IntegC 2300 \n";
    String descriptions = "Scenario Descriptions\n";

    public void run() {
        lookandfeel.fontSize.set(12);
        this.link(this.tem.temp);
        this.link(this.car.conc);
        this.curvemap.put(new curveset("fossil_CO2_emissions", "mega&ton&carbon", 1850, 2250, 1), this.gc.fossil);
        this.curvemap.put(new curveset("CO2eq_emissions", "mega&ton&co2", 1850, 2250, 1), this.gc.co2eqtot);
        this.curvemap.put(new curveset("CO2 concentration", "ppm", 1850, 2250, 1), this.car.co2atppm);
        this.curvemap.put(new curveset("CO2eq concn allgas+aeros", "ppm", 1850, 2250, 1), this.rf.co2eqghgaero);
        this.curvemap.put(new curveset("Temperature", "degcbase", 1850, 2250, 1), this.tem.avchangeby);
        this.stab.peaking.set(true);
        this.co.botuptopdo.set(controller.butd.start_bottom_up);
        this.sha.distribution.set(shares.distriboptions.convergence);
        this.sha.rate_caps.set(true);
        this.ple.level.set(pledges.pledgelevel.conditional);
        for (scenarios scen2 : scenarios.values()) {
            report.log("Setting parameters for " + scen2.name());
            switch (scen2) {
                case fiftypercent_2C: {
                    this.stab.indicator.set(stabilisation.indicators.define_emit);
                    this.stab.stabemityear.set(2050);
                    this.stab.stabemitlevel.set(3850);
                    this.stab.stabemitendlevel.set(250);
                    this.stab.stabemitdeclinerate.set(1.25);
                    this.co.startyear_topdown.set(2020);
                    this.sha.rate_constraint.set(6.5);
                    scen2.info = "This scenario begins with a defined emissions trajectory to reach the key policy target of 50% of 1990 by 2050 (CO2eq emissions inc CH4, N2O+LUC), After 2050 the emissions curve continues along an trajectory in which total CO2 emissions decline exponentially at -1.25%/yr towards a minimum level of 0.25GtC. This trajectory is chosen to stabilise the temperature at 2\u00b0C with default model parameters. There is a marked relaxation in the emissions decline after 2050. As for other scenarios in this group, the scenario starts with  high pledges in 2020 and continues regionally by a increasing participation with convergence. A top-down constraint applies from 2020 onwards. As the decline from 2020 to 2050 is steep, the decline rate cap on individual countries cannot be set lower than 6.5%/year.";
                    break;
                }
                case fiftypercent_15C: {
                    this.stab.stabemityear.set(2050);
                    this.stab.stabemitlevel.set(3850);
                    this.stab.stabemitendlevel.set(0);
                    this.stab.stabemitdeclinerate.set(4.0);
                    this.co.startyear_topdown.set(2020);
                    this.sha.rate_constraint.set(6.5);
                    scen2.info = " This scenario is similar to the fiftypercent_2C until 2050. Thereafter total CO2 emissions decline exponentially at -4%/yr towards zero. This steep decline is a smooth continuation of the earlier part of the curve. Temperature peaks at around 1.8C in 2060 (CHECK) and declines thereafter, falling to 1.5C in 2250 (CHECK). Such a scenario may be particularly interesting to low-lying states as it has a greater chance to avoid catastrophic melting of the Greenland and WAIS ice caps.";
                    break;
                }
                case concpeak_2C: {
                    this.stab.indicator.set(stabilisation.indicators.stabconc);
                    this.stab.stabconclevel.set(470);
                    this.stab.stabyear.set(2110);
                    this.stab.stabconcendlevel.set(453);
                    this.stab.curveopt.set(stabilisation.curvetype.padequartic);
                    this.co.startyear_topdown.set(2045);
                    this.sha.rate_constraint.set(4);
                    scen2.info = " This is a more relaxed scenario also stabilising at 2C. It is defined by a peaking CO2 concentration curve at 470ppm in 2110, declining thereafter towards 453ppm in 2300. The temperature rises to 2C faster than in the other scenarios, reaching 1.9C by 2068 (CHECK). Consequently emissions can be higher in 2050  - around 25GtCO2eq (CHECK), or 65% of 1990.  This allows more flexibility in the individual country emissions - so the top-down constraint on all countries does not apply until 2045. And decline rate caps can be set at 4%/yr ";
                    break;
                }
                case stabrf3W: {
                    this.stab.indicator.set(stabilisation.indicators.stabrf_allghgaero);
                    this.stab.stabrflevel.set(3.0);
                    this.stab.stabyear.set(2125);
                    this.stab.curveopt.set(stabilisation.curvetype.padequintic);
                    this.co.startyear_topdown.set(2020);
                    this.sha.rate_constraint.set(6.5);
                    scen2.info = " This scenario follows a classic stabilise CO2equivalent concentration pathway. The stabilisation level is 3W/m2 (about 480ppm CO2eq )for all greenhouse gases and aerosols. The peak CO2eq concentration is a bit higher at around 490ppm. The temperature rises slowly towards 2C, reaching 1.9C only in 2125,  due to the gradual uptake of heat by the ocean. (which is not offset by declining forcing as in the other scenarios).  The eventual equilibrium temperature associated with this forcing will be higher than 2C (CALCULATE).  If the equilibrium would be 2C and the final CO2eq level may not be exceeded, the emissions decline would be even steeper.  It is this type of  scenario pathway that dominated the analyses of IPCC AR4 WG3.  Due to this pathway shape, the emissions are constrained in early years and are just below the 50% scenarios in 2050.  Therefore, the top-down constraint from 2020 and 6.5% decline rate cap also apply in this case. ";
                }
            }
            this.checkbut();
            loop.gonow(false);
            this.checkbutandsleep(500);
            try {
                for (curveset dest : this.curvemap.keySet()) {
                    dest.addcurve(this.curvemap.get(dest).cloneIndependent(1850, 2250, 1, scen2.name(), scen2.col));
                }
            }
            catch (Exception e) {
                report.deb(e);
                e.printStackTrace();
            }
            float emit2020 = this.gc.co2eqtot.get(2020);
            float emit2050 = this.gc.co2eqtot.get(2050);
            float integ2050 = 0.0f;
            for (int y = 2001; y <= 2050; ++y) {
                integ2050 += this.gc.totemit.get(y);
            }
            float integ2300 = integ2050;
            for (int y = 2051; y <= 2300; ++y) {
                integ2300 += this.gc.totemit.get(y);
            }
            this.indics = this.indics + scen2.name() + " \t" + emit2020 + " \t" + emit2050 + " \t " + integ2050 + " \t" + integ2300 + " \n";
            this.descriptions = this.descriptions + "\n======== " + scen2.name() + " ========\n" + scen2.info + "\n";
        }
        for (curveset dest : this.curvemap.keySet()) {
            lineplot plot = (lineplot)this.plot(dest);
            plot.xscale.min = 1850.0;
            plot.xscale.max = 2250.0;
            plot.xscale.units.scales = 100.0;
            plot.xscale.changed = true;
            showpan.toFront(plot);
            plot.doplot();
            this.checkbutandsleep(500);
            imagesaver.saveimage((Component)plot, "png", new File("jcmout" + this.fs + "results" + this.fs + dest.name + ".png"));
            datable.savetable(new File("jcmout" + this.fs + "results" + this.fs + dest.name + ".dat"), dest, "tab");
            this.checkbutandsleep(500);
        }
        fileio.savetextfile("jcmout" + this.fs + "results" + this.fs + "descriptions.txt", this.descriptions);
        fileio.savetextfile("jcmout" + this.fs + "results" + this.fs + "indicators.txt", this.indics);
        this.end();
        report.log("End of script swinf_global");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum scenarios {
        fiftypercent_2C(colfont.ltgreen),
        fiftypercent_15C(colfont.dkgreen),
        concpeak_2C(colfont.blue),
        stabrf3W(colfont.brown);

        Color col;
        String info;

        private scenarios(Color c) {
            this.col = c;
        }
    }
}

