/*
 * Decompiled with CFR 0.152.
 */
package jcm.script;

import java.awt.Component;
import java.io.File;
import jcm.core.cur.curvar;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.loop;
import jcm.core.report;
import jcm.gui.gen.imagesaver;
import jcm.gui.gen.lookandfeel;
import jcm.gui.nav.showpan;
import jcm.gui.plot.datable;
import jcm.gui.plot.histoplot;
import jcm.mod.carbon.carboncycle;
import jcm.mod.cli.glotemp;
import jcm.mod.cli.radfor;
import jcm.mod.obj.globco2emit;
import jcm.mod.obj.stabilisation;
import jcm.mod.regemit.emitquota;
import jcm.mod.regemit.pledges;
import jcm.mod.regemit.shares;
import jcm.mod.socio.popgdp;
import jcm.script.calcscript;

public class swinf_pledges
extends calcscript {
    globco2emit gc = this.gm(globco2emit.class);
    carboncycle car = this.gm(carboncycle.class);
    glotemp tem = this.gm(glotemp.class);
    radfor rf = this.gm(radfor.class);
    stabilisation stab = this.gm(stabilisation.class);
    shares sha = this.gm(shares.class);
    pledges ple = this.gm(pledges.class);
    emitquota eq = this.gm(emitquota.class);

    void checkready() {
        try {
            while (this.stab.running) {
                Thread.currentThread();
                Thread.sleep(500L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.checkbutandsleep(500);
    }

    float ro(float f) {
        return (float)Math.round(f / 100.0f) / 10.0f;
    }

    public histoplot histoplot(curveset qq) {
        return (histoplot)showpan.makepan(histoplot.class, qq, new Object[0]);
    }

    public void run() {
        lookandfeel.fontSize.set(18);
        this.link(this.eq.emitequiv);
        this.link(this.tem.temp);
        this.link(this.car.conc);
        this.checkready();
        loop.gonow(false);
        this.checkready();
        int[] years = new int[]{1990, 2005, 2010, 2020};
        curvar fospercap = new curvar(curve.Type.ratio, this.eq.emitfos_unitsCO2, this.gm(popgdp.class).pop);
        curvar fospergdp = new curvar(curve.Type.ratio, this.eq.emitfos_unitsCO2, this.gm(popgdp.class).gdp_ppp);
        this.eq.emitfos_unitsCO2.addOb(fospercap);
        histoplot hist_pc = this.histoplot(fospercap);
        hist_pc.highonleft = true;
        hist_pc.xscale.min = 0.0;
        hist_pc.xscale.max = 7800.0;
        hist_pc.yscale.min = 0.0;
        hist_pc.yscale.max = 20.0;
        hist_pc.xscale.changed = true;
        hist_pc.yscale.changed = true;
        hist_pc.hidechooser();
        hist_pc.legend.forcelong = true;
        hist_pc.labels = true;
        showpan.toFront(hist_pc);
        hist_pc.doplot();
        this.checkready();
        loop.gonow(false);
        hist_pc.yscale.changed = true;
        hist_pc.doplot();
        this.checkready();
        for (int y : years) {
            this.checkready();
            hist_pc.year.set(y);
            loop.gonow(false);
            this.checkready();
            imagesaver.saveimage((Component)hist_pc, "png", new File("jcmout" + this.fs + "results" + this.fs + "pledges" + this.fs + "emitpercap_" + y + ".png"));
        }
        datable.savetable(new File("jcmout" + this.fs + "results" + this.fs + "pledges" + this.fs + "emitpercap.dat"), (curveset)fospercap, "tab");
        this.checkready();
        histoplot hist_pg = this.histoplot(fospergdp);
        hist_pg.highonleft = true;
        hist_pg.xscale.min = 0.0;
        hist_pg.xscale.max = 9.0E7;
        hist_pg.yscale.min = 0.0;
        hist_pg.yscale.max = 0.0013;
        hist_pg.xscale.changed = true;
        hist_pg.yscale.changed = true;
        hist_pg.hidechooser();
        hist_pg.legend.forcelong = true;
        hist_pg.labels = true;
        showpan.toFront(hist_pg);
        hist_pg.yscale.units.units = hist_pg.yscale.units.units.replace("microton", "grams");
        hist_pg.doplot();
        hist_pg.yscale.units.scales = 0.001;
        hist_pg.yscale.changed = true;
        hist_pg.doplot();
        this.checkready();
        for (int y : years) {
            this.checkready();
            hist_pg.year.set(y);
            loop.gonow(false);
            this.checkready();
            imagesaver.saveimage((Component)hist_pg, "png", new File("jcmout" + this.fs + "results" + this.fs + "pledges" + this.fs + "emitpergdp_" + y + ".png"));
        }
        datable.savetable(new File("jcmout" + this.fs + "results" + this.fs + "pledges" + this.fs + "emitpergdp.dat"), (curveset)fospergdp, "tab");
        this.checkready();
        this.end();
        report.log("End of script swinf_pledges");
    }
}

