/*
 * Decompiled with CFR 0.152.
 */
package jcm.script;

import java.awt.Color;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.cur.units;
import jcm.core.loop;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.core.report;
import jcm.mod.carbon.berncarbon;
import jcm.mod.carbon.carboncycle;
import jcm.mod.luc.CalcLucEmit;
import jcm.mod.luc.LUCdata;
import jcm.mod.obj.regset;
import jcm.mod.resp.attribTracer;
import jcm.script.calcscript;

public class contribtemp
extends calcscript {
    berncarbon bc = this.gm(berncarbon.class);
    carboncycle cc = this.gm(carboncycle.class);
    CalcLucEmit cl = this.gm(CalcLucEmit.class);
    attribTracer rs = this.gm(attribTracer.class);
    curveset curves1 = new curveset("Brazil. relative", 1850, 2005, 5);
    curveset curves2 = new curveset("USA relative", 1850, 2005, 5);
    curveset curves3 = new curveset("India relative", 1850, 2005, 5);
    curve tot = new curve("surftemp", "degcbase");
    curve r1 = new curve(new Object[0]);
    curve r2 = new curve(new Object[0]);
    curve r3 = new curve(new Object[0]);
    String p = "";
    region regset;

    public void run() {
        this.link(this.rs.surftemp);
        this.gm(regset.class).regions.choose(regman.allreg.findreg("JCM25"));
        this.regset = (region)this.gm(regset.class).regions.chosen;
        for (String lu : CalcLucEmit.lucsources) {
            this.cl.lucsource.set(lu);
            if (this.cl.lucsource.chosen.equals("Houghton")) {
                for (double cor = 1700.0; cor <= 2500.0; cor += 458.0) {
                    this.cl.landuseemit1990.set(cor);
                    report.log("Houghton emission in 2000 " + cor);
                    this.calc();
                }
                continue;
            }
            if (!this.cl.lucsource.chosen.equals("IVIGmodel")) continue;
            for (LUCdata.biomeclassification bc : LUCdata.biomeclassification.values()) {
                this.cl.biomeclass.set(bc);
                report.log("IVIGmodel land use " + (Object)((Object)bc));
                for (double vc = 0.8; vc <= 1.2; vc += 0.2) {
                    this.cl.vegcerror.set(vc);
                    report.log("-veg carbon error " + vc);
                    for (double sa = 0.1; sa <= 0.3; sa += 0.1) {
                        this.cl.soillossagric.set(sa);
                        report.log("-agric soil loss " + sa);
                        for (double sp = 0.05; sp <= 0.1; sp += 0.025) {
                            this.cl.soillosspast.set(sp);
                            report.log(" past soil loss " + sp);
                            this.p = units.round(vc, 1.0, 1) + " " + units.round(sa, 1.0, 1) + " " + units.round(sp, 1.0, 2) + "_";
                            this.calc();
                        }
                    }
                }
            }
        }
        this.plot(this.curves2);
        this.plot(this.curves3);
        this.end();
        report.log("End of script contribtemp");
        this.cl.lucsource.choose("IVIGmodel");
    }

    public void calc() {
        for (double beta = 0.56; beta >= 0.0; beta -= 0.28) {
            this.bc.beta.set(beta);
            for (double respq10 = 1.0; respq10 <= 1.6; respq10 += 0.3) {
                this.bc.respq10.set(respq10);
                for (double diffu = 1.75; diffu >= 0.5; diffu -= 0.5) {
                    this.bc.diffufac.set(diffu);
                    this.checkbut();
                    loop.gonow(false);
                    String err = units.round(this.cc.error, 1.0, 0);
                    String c = " ";
                    c = this.cl.lucsource.chosen.equals("IVIGmodel") ? "-" + ((LUCdata.biomeclassification)((Object)this.cl.biomeclass.chosen)).name() + "_" + this.p : "_" + this.cl.landuseemit1990.getval() + "_";
                    String name = this.cl.lucsource.chosen + c + err + "_" + beta + " " + respq10 + " " + diffu;
                    if (this.cc.error <= 700.0) {
                        this.report(name);
                        for (int y = 1850; y <= 2005; ++y) {
                            this.tot.set(y, 0.0f);
                        }
                        for (region r : this.regset.reg) {
                            for (int y = 1850; y <= 2005; ++y) {
                                this.tot.set(y, this.tot.get(y) + this.rs.surftemp.get(r, y));
                            }
                        }
                        for (int y = 1850; y <= 2005; ++y) {
                            this.r1.set(y, this.rs.surftemp.get(this.regset.findreg("Brazil."), y) * 100.0f / this.tot.get(y));
                            this.r2.set(y, this.rs.surftemp.get(this.regset.findreg("United States"), y) * 100.0f / this.tot.get(y));
                            this.r3.set(y, this.rs.surftemp.get(this.regset.findreg("India"), y) * 100.0f / this.tot.get(y));
                        }
                        Color col = Color.black;
                        try {
                            col = new Color(255 * (this.cl.lucsource.chosen.equals("IVIGmodel") ? 0 : 1), 255 * (this.cl.lucsource.chosen.equals("IVIGmodel") ? 1 : 0) * (this.cl.biomeclass.chosen == LUCdata.biomeclassification.A ? 1 : 0), 255 * (this.cl.lucsource.chosen.equals("IVIGmodel") ? 1 : 0) * (this.cl.biomeclass.chosen == LUCdata.biomeclassification.A ? 0 : 1), (int)(5000.0 / (this.cc.error - 450.0)));
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        this.curves1.addcurve(this.r1.cloneIndependent(1850, 2005, 5, name, col));
                        this.curves2.addcurve(this.r2.cloneIndependent(1850, 2005, 5, name, col));
                        this.curves3.addcurve(this.r3.cloneIndependent(1850, 2005, 5, name, col));
                        continue;
                    }
                    report.log(name + " Bypassed, error > 700!");
                }
            }
        }
    }
}

