/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.socio;

import java.util.HashMap;
import java.util.List;
import jcm.core.complexity;
import jcm.core.cur.curveset;
import jcm.core.data.interpolator;
import jcm.core.ob.loopcalc;
import jcm.core.ob.module;
import jcm.core.par.param;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.core.report;
import jcm.mod.obj.regset;
import jcm.mod.obj.sres_base;
import jcm.mod.obj.sresdata;
import jcm.mod.socio.histsocdata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class popgdp
extends module {
    public curveset pop = new curveset(new Object[]{"population", "mega&person", complexity.simplest});
    public curveset gdp_ppp = new curveset("gdp_ppp", "mega&dollar&(2000)&per&year", 1950);
    public curveset gdp_mer = new curveset("gdp_mer", "mega&dollar&(2000)&per&year", 1950);
    public curveset pop_nat = new curveset(new Object[]{"population&national", "mega&person", 1995, 2050, complexity.expert});
    public curveset gdp_ppp_nat = new curveset(new Object[]{"gdp_ppp&national", "mega&dollar&(2000)&per&year", 1995, 2050, complexity.expert});
    public curveset gdp_mer_nat = new curveset(new Object[]{"gdp_mer&national", "mega&dollar&(2000)&per&year", 1995, 2050, complexity.expert});
    public param ppp_convfac = new param(new Object[]{"ppp_convfac", "%&per&yr", 2, 0, 100, complexity.experimental});
    public param ppp_powfac = new param(new Object[]{"ppp_powfac", "", 0.3, 0.1, 1, complexity.experimental});
    region regset;
    public loopcalc history = new loopcalc("socio-history"){

        public void precalc() {
            int y;
            popgdp.this.regset = (region)popgdp.this.gm(regset.class).regions.chosen;
            popgdp.this.gm(regset.class).clearoldregions(this);
            interpolator.fillregdata(histsocdata.histpop, popgdp.this.pop, popgdp.this.regset, 0.001f);
            interpolator.fillregdata(histsocdata.GDP_MER, popgdp.this.gdp_mer, popgdp.this.regset, 1.0f);
            interpolator.fillregdata(histsocdata.GDP_PPP, popgdp.this.gdp_ppp, popgdp.this.regset, 1.0f);
            interpolator.fillregdata(histsocdata.histpop, popgdp.this.pop_nat, regman.nations, 0.001f);
            interpolator.fillregdata(histsocdata.GDP_MER, popgdp.this.gdp_mer_nat, regman.nations, 1.0f);
            interpolator.fillregdata(histsocdata.GDP_PPP, popgdp.this.gdp_ppp_nat, regman.nations, 1.0f);
            for (y = gsy; y < fsypop; ++y) {
                popgdp.this.pop.calctot(y);
            }
            for (y = gsy; y < fsygdp; ++y) {
                popgdp.this.gdp_mer.calctot(y);
                popgdp.this.gdp_ppp.calctot(y);
            }
        }
    };
    public loopcalc future = new loopcalc("socio-future"){

        public void precalc() {
            sres_base sb = popgdp.this.gm(sres_base.class);
            float socconv = (float)sb.socconv.getval();
            interpolator popsource = new interpolator(sresdata.sres_image_popn.get((Object)sb.scpop));
            popsource.fill(popgdp.this.pop_nat, regman.nations, fsypop, 2050, histsocdata.histpop, socconv);
            interpolator.fillregdata(popgdp.this.pop_nat, popgdp.this.pop, popgdp.this.regset, fsypop, 2050);
            popsource.fill(popgdp.this.pop, popgdp.this.regset, 2051, 2100, popgdp.this.pop_nat, socconv);
            for (int y = fsypop; y <= 2100; ++y) {
                popgdp.this.pop.calctot(y);
            }
            float inflator = 1.0856584f;
            interpolator gdpsource = new interpolator(sresdata.sres_image_gdp.get((Object)sb.scgdp), Float.valueOf(inflator));
            gdpsource.fill(popgdp.this.gdp_mer_nat, regman.nations, fsygdp, 2050, histsocdata.GDP_MER, socconv);
            interpolator.fillregdata(popgdp.this.gdp_mer_nat, popgdp.this.gdp_mer, popgdp.this.regset, fsygdp, 2050);
            gdpsource.fill(popgdp.this.gdp_mer, popgdp.this.regset, 2051, 2100, popgdp.this.gdp_mer_nat, socconv);
            popgdp.this.futureppp(popgdp.this.gdp_mer_nat, popgdp.this.gdp_ppp_nat, popgdp.this.pop_nat, regman.nations.reg, fsygdp - 1, 2050);
            interpolator.fillregdata(popgdp.this.gdp_ppp_nat, popgdp.this.gdp_ppp, popgdp.this.regset, fsygdp, 2050);
            popgdp.this.futureppp(popgdp.this.gdp_mer, popgdp.this.gdp_ppp, popgdp.this.pop, ((region)popgdp.this.gm(regset.class).regions.chosen).reg, 2050, 2100);
            for (int y = fsygdp; y <= 2100; ++y) {
                popgdp.this.gdp_mer.calctot(y);
                popgdp.this.gdp_ppp.calctot(y);
            }
        }
    };

    @Override
    public void initsetup() {
        this.history.setaffectedby(this.gm(regset.class).regions);
        this.future.follows(this.history);
        sres_base sb = this.gm(sres_base.class);
        this.future.setaffectedby(sb.scenario);
        this.setaffectedby(sb.sresext);
        this.future.setaffectedby(sb.socconv);
    }

    public void futureppp(curveset mer, curveset ppp, curveset pop, List<region> regset2, int sy, int ey) {
        region USA = regman.nations.findreg("USA");
        if (!mer.map.keySet().contains(USA)) {
            report.deb("\nCan't calculate future PPP without USA in the chosen regionset!! ");
            return;
        }
        HashMap<region, Float> alpha = new HashMap<region, Float>();
        float acf = (float)this.ppp_convfac.getval() / 100.0f;
        float b = (float)(-this.ppp_powfac.getval());
        for (int y = sy; y < ey; ++y) {
            float u = mer.get(USA, y) / pop.get(USA, y);
            float du = (mer.get(USA, y + 1) / pop.get(USA, y + 1) - u) / u;
            ppp.set(USA, y + 1, mer.get(USA, y + 1));
            for (region r : regset2) {
                if (r == USA) continue;
                float m = mer.get(r, y) / pop.get(r, y);
                float dm = (mer.get(r, y + 1) / pop.get(r, y + 1) - m) / m;
                float p = ppp.get(r, y) / pop.get(r, y);
                float a = y == sy ? (float)((double)(p / m) / Math.pow(m / u, b)) : ((Float)alpha.get(r)).floatValue();
                float da = acf * (1.0f - a);
                alpha.put(r, Float.valueOf(a + da));
                float dp = p * (dm * (1.0f + b) - b * du + da / a);
                ppp.set(r, y + 1, pop.get(r, y + 1) * (p + dp));
            }
        }
    }
}

