/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.socio;

import jcm.core.complexity;
import jcm.core.cur.curveset;
import jcm.core.data.loadtable;
import jcm.core.itf.dataholder;
import jcm.core.ob.module;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.core.report;

public class histsocdata
extends module
implements dataholder {
    static double[] deflator = new double[]{54.04, 59.12, 62.73, 65.21, 67.66, 69.71, 71.25, 73.2, 75.69, 78.56, 81.59, 84.44, 86.39, 88.38, 90.26, 92.11, 93.85, 95.41, 96.47, 97.87, 100.0, 102.4, 104.19, 106.4, 109.46, 113.03, 116.68, 119.82, 122.42, 123.57, 124.06, 124.79, 126.64, 129.09, 131.64};
    public static curveset histpop = new curveset(new Object[]{"histpop", "kilo&person", 1700, 2004, complexity.expert});
    public static curveset GDP_PPP = new curveset(new Object[]{"hist_GDP_PPP", "mega&dollar&(2000)&-PPP", 1950, 2014, 1, complexity.expert});
    public static curveset GDP_MER = new curveset(new Object[]{"hist_GDP_MER", "mega&dollar&(2000)&-MER", 1950, 2014, 1, complexity.expert});
    public static curveset WEOGDP_PPP = new curveset(new Object[]{"WEO_GDP_PPP", "mega&dollar&(current)&-PPP", 1980, 2014, 1, complexity.expert});
    public static curveset WEOGDP_MER = new curveset(new Object[]{"WEO_GDP_MER", "mega&dollar&-PPP", 1980, 2014, 1, complexity.expert});
    public static curveset PWTCGDP = new curveset(new Object[]{"PWTGDP", "dollar&2000&-PPP&per&person", 1950, 2004, 1, complexity.expert});
    public static curveset PWTpop = new curveset(new Object[]{"PWTpop", "kilo&perso", 1950, 2004, 1, complexity.expert});
    public static curveset PWTppprate = new curveset(new Object[]{"PWTppp_rate", "localcurrency&per&ppp_dollar", 1950, 2004, 1, complexity.expert});
    public static curveset PWTmerate = new curveset(new Object[]{"PWTmex_rate", "localcurrency&per&dollar", 1950, 2004, 1, complexity.expert});

    public static void fillhistdata() {
        loadtable.loaddata(histpop, "data/hist/HYDE_pop_kkg.csv", "\t", true, 1.0f, 1700, 1995, 1700);
        loadtable.loaddata(PWTpop, "data/hist/PWTpop.csv", "\t", false, false, 1.0f, 1950, 2004, 1950, 1);
        loadtable.loaddata(PWTCGDP, "data/hist/PWTcgdp.csv", "\t", false, false, 1.0f, 1950, 2004, 1950, 1);
        loadtable.loaddata(PWTppprate, "data/hist/PWTppp.csv", "\t", false, false, 1.0f, 1950, 2004, 1950, 1);
        loadtable.loaddata(PWTmerate, "data/hist/PWTxrat.csv", "\t", false, false, 1.0f, 1950, 2004, 1950, 1);
        loadtable.loaddata(WEOGDP_MER, "data/hist/WEOgdp_mer.csv", "\t", false, 1000.0f, 1980, 2014, 1980);
        loadtable.loaddata(WEOGDP_PPP, "data/hist/WEOgdp_ppp.csv", "\t", false, 1000.0f, 1980, 2014, 1980);
        histsocdata.fixpop();
        histsocdata.combinePWT();
        histsocdata.blend(WEOGDP_MER, GDP_MER);
        histsocdata.blend(WEOGDP_PPP, GDP_PPP);
    }

    static void fixpop() {
        for (int y = 2002; y <= 2004; ++y) {
            PWTpop.set("Serbia and Montenegro", y, PWTpop.get("Serbia and Montenegro", 2001));
        }
    }

    static void combinePWT() {
        for (region r : regman.nations.reg) {
            for (int y = 1950; y <= 2004; ++y) {
                if (r != regman.nations.findreg("East Timor")) {
                    histpop.set(r, y, 0.0f);
                }
                GDP_PPP.set(r, y, Float.NaN);
                GDP_MER.set(r, y, Float.NaN);
            }
        }
        for (Object o : histsocdata.PWTpop.map.keySet()) {
            region r = regman.allreg.findreg(o.toString());
            if (r == null) {
                report.deb("PWT data: can't find region " + o + ": ignored ");
                continue;
            }
            for (int y = 1950; y <= 2004; ++y) {
                float pop = PWTpop.get(o, y);
                histpop.add(r, y, pop);
                if (!PWTCGDP.gotdata(o, y)) continue;
                float gdp_p = 0.001f * pop * PWTCGDP.get(o, y);
                GDP_PPP.add(r, y, gdp_p);
                if (!PWTppprate.gotdata(o, y)) continue;
                float ppper = PWTppprate.get(o, y);
                float mer = PWTmerate.get(o, y);
                float gdp_m = gdp_p * ppper / mer;
                GDP_MER.add(r, y, gdp_m);
            }
        }
    }

    static void blend(curveset extrasource, curveset gdp) {
        String lackdata = "";
        for (region r : regman.nations.reg) {
            int y;
            if (!(gdp.get(r, 2000) > 0.0f)) {
                lackdata = lackdata + r.name + " ";
                continue;
            }
            float corrfac = extrasource.get(r, 2000) / gdp.get(r, 2000);
            for (y = 1950; y < 2000; ++y) {
                gdp.set(r, y, gdp.get(r, y) > 0.0f ? gdp.get(r, y) * corrfac : 0.0f);
            }
            for (y = 2000; y < 2015; ++y) {
                gdp.set(r, y, extrasource.get(r, y) > 0.0f ? 100.0f / (float)deflator[y - 1980] * extrasource.get(r, y) : (gdp.get(r, y) > 0.0f ? gdp.get(r, y) * corrfac : (gdp.get(r, y - 1) > gdp.get(r, y - 6) ? gdp.get(r, y - 1) + 0.2f * (gdp.get(r, y - 1) - gdp.get(r, y - 6)) : gdp.get(r, y - 1))));
            }
        }
        if (lackdata.length() > 0) {
            report.deb(gdp.name + " lacks data in 2000 for: " + lackdata);
        }
    }
}

