/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.resp;

import java.util.List;
import jcm.core.cur.curveset;
import jcm.core.loop;
import jcm.core.ob.module;
import jcm.core.reg.region;
import jcm.core.register;
import jcm.mod.carbon.berncarbon;
import jcm.mod.carbon.carbonatechemistry;
import jcm.mod.carbon.carboncycle;
import jcm.mod.cli.glotemp;
import jcm.mod.cli.udebclimod;
import jcm.mod.obj.regset;
import jcm.mod.ogas.aerosol;
import jcm.mod.ogas.atchem;
import jcm.mod.ogas.fgas;
import jcm.mod.resp.responsibility;

public class attribTracer
extends module {
    public curveset atco2 = new curveset("atco2", "ppm");
    public curveset atch4 = new curveset("atch4", "ppb");
    public curveset atn2o = new curveset("atn2o", "ppb");
    public curveset rfco2 = new curveset("rfco2", "w&per&m2");
    public curveset rfch4 = new curveset("rfch4", "w&per&m2");
    public curveset rfn2o = new curveset("rfn2o", "w&per&m2");
    public curveset rftot = new curveset("rftot", "w&per&m2");
    public curveset surftemp = new curveset("surftemp", "degcbase");
    public curveset surftemprel = new curveset("surftemp&relative", "%");
    public curveset sealevte = new curveset("sealevte", "metres");
    static final int ncb = 43;
    static final int nhb = 40;
    float[] ls;
    float[] hs;
    float[] so;
    float[] hu;
    float[][] ciq;
    float[][][] hiq;
    float[][] acccbox;
    int nregs;
    int oldnregs = 0;
    int nrf;
    int nemit;
    int oth;
    List<region> reg;
    responsibility resp;
    carboncycle carbon;
    regset socreg;
    region bestafen;
    region othgasreg;
    region aerosolreg;
    region solvolreg;
    float sink;
    float atinc;
    float lsinc;
    float hsinc;
    float fracco2rise;
    float fracls;
    float frachs;
    float totls;
    float toths;
    float totat;
    float npinc;
    float dls;
    float dhs;
    float dnp;
    float dat;
    float soinc;
    float huinc;
    float totso;
    float tothu;
    float dso;
    float dhu;
    float glotemprise;
    float gloco2rise;
    float fraccarbfb;
    float fractemprise;
    float extrach4;
    float extran2o;
    float fracn2o;
    float dc;
    float qin;
    float qinold;
    float dqin;
    float[] rff = new float[2];
    float[] sf = new float[2];
    float[] mlt = new float[2];
    float[] boxtemp = new float[4];

    public void initsetup() {
        this.resp = this.gm(responsibility.class);
        this.carbon = this.gm(carboncycle.class);
        this.socreg = this.gm(regset.class);
        this.bestafen = this.resp.bestafen;
        this.othgasreg = this.resp.othgasreg;
        this.aerosolreg = this.resp.aerosolreg;
        this.solvolreg = this.resp.solvolreg;
        this.follows(this.resp);
        register.requires(this, this.carbon, true);
        register.requires(this, this.gm(glotemp.class), true);
        register.requires(this, this.gm(berncarbon.class), true);
        register.requires(this, this.gm(udebclimod.class), true);
    }

    public void precalc() {
        this.makeboxes();
        loop.calcfutureonly = false;
        for (curveset qq : this.curvesets) {
            this.gm(regset.class).clearoldregions(qq);
        }
        for (curveset qq : this.curvesets) {
            qq.associate(this.resp.startyear, this.resp.endyear);
        }
    }

    public void calcstep() {
        if (year > 2100 && (double)year > this.resp.endyear.getval()) {
            return;
        }
        this.carbonstep();
        this.atchemstep();
        this.rfstep();
        this.glotempstep();
        this.tottemp();
    }

    public void postcalc() {
        if (this.resp.removeextrareg.istrue()) {
            for (curveset qq : this.curvesets) {
                qq.map.remove(this.bestafen);
                qq.map.remove(this.aerosolreg);
                qq.map.remove(this.othgasreg);
                qq.map.remove(this.solvolreg);
            }
        }
    }

    void tottemp() {
        float totattrib = 0.0f;
        for (region r : this.reg) {
            totattrib += this.surftemp.get(r);
        }
        for (region r : this.reg) {
            this.surftemprel.set(r, 100.0f * this.surftemp.get(r) / totattrib);
        }
    }

    region reg(int n) {
        return this.resp.reg(n);
    }

    public void makeboxes() {
        this.reg = ((region)this.gm(regset.class).regions.chosen).reg;
        this.nregs = this.resp.nregs;
        if (this.nregs != this.oldnregs) {
            this.oldnregs = this.nregs;
            this.nemit = this.nregs + 1;
            this.nrf = this.nregs + 4;
            this.oth = this.nregs;
        }
        this.ciq = new float[this.nrf][43];
        this.ls = new float[this.nrf];
        this.hs = new float[this.nrf];
        this.so = new float[this.nrf];
        this.hu = new float[this.nrf];
        this.acccbox = new float[this.nrf][4];
        this.hiq = new float[this.nrf][2][40];
    }

    void carbonstep() {
        int nr;
        if (this.carbon.accccarbon.istrue()) {
            if (year == gsy) {
                for (int i = 0; i < 4; ++i) {
                    this.acccbox[this.oth][i] = this.carbon.acccbox[i];
                    for (int nr2 = 0; nr2 < this.nregs; ++nr2) {
                        this.acccbox[nr2][i] = 0.0f;
                    }
                }
            }
            for (int nr3 = 0; nr3 < this.nrf; ++nr3) {
                this.atco2.set(this.reg(nr3), this.carbon.acccmod(this.acccbox[nr3], this.resp.totco2emit(this.reg(nr3), year)));
            }
            return;
        }
        berncarbon bc = this.gm(berncarbon.class);
        carboncycle cc = this.carbon;
        boolean feedback = this.gm(carbonatechemistry.class).chemfeedback.istrue();
        this.gloco2rise = cc.co2atppm.get(year - 1) - 278.0f;
        this.glotemprise = this.gm(glotemp.class).avchange.get(year - 1);
        if (!feedback || (double)Math.abs(this.glotemprise) < 0.02) {
            this.fraccarbfb = 1.0f;
        } else {
            this.fraccarbfb = Math.abs(0.008f * this.gloco2rise / this.glotemprise);
            if (this.fraccarbfb > 1.0f) {
                this.fraccarbfb = 1.0f;
            }
        }
        for (nr = 0; nr < this.nrf; ++nr) {
            int n;
            region r = this.reg(nr);
            if (year == gsy) {
                for (n = 0; n < 43; ++n) {
                    this.ciq[nr][n] = nr == this.oth ? (float)bc.ciq[n] : 0.0f;
                }
            }
            if ((double)year < this.resp.startyear.getval() && nr < this.nregs) {
                this.atco2.set(r, 0.0f);
                continue;
            }
            this.fracco2rise = year > gsy ? this.atco2.get(r, year - 1) / this.gloco2rise : 0.0f;
            float f = this.fractemprise = year > gsy ? this.surftemp.get(r, year - 1) / this.glotemprise : 0.0f;
            if (Math.abs(this.gloco2rise) < 10.0f) {
                this.fracco2rise = 0.0f;
            }
            if ((double)Math.abs(this.glotemprise) < 0.1) {
                this.fractemprise = 0.0f;
            }
            this.fracls = year > gsy ? this.fraccarbfb * this.ls[nr] / this.totls + (1.0f - this.fraccarbfb) * this.fractemprise : 0.0f;
            this.frachs = year > gsy ? this.fraccarbfb * this.hs[nr] / this.toths + (1.0f - this.fraccarbfb) * this.fractemprise : 0.0f;
            this.atco2.set(r, 0.0f);
            this.ls[nr] = 0.0f;
            this.hs[nr] = 0.0f;
            this.so[nr] = 0.0f;
            this.hu[nr] = 0.0f;
            this.lsinc = (float)bc.oldlsinc * this.fracls;
            this.hsinc = (float)bc.oldhsinc * this.frachs;
            this.npinc = (float)bc.oldnpinc * this.fracco2rise;
            this.soinc = (float)bc.oldsoinc * this.fractemprise;
            this.huinc = (float)bc.oldhuinc * this.fractemprise;
            this.atinc = this.resp.totco2emit(r, year - 1) - (this.lsinc + this.hsinc + this.npinc + this.soinc + this.huinc);
            this.dls = (float)bc.dls * this.fracls;
            this.dhs = (float)bc.dhs * this.frachs;
            this.dnp = (float)bc.dnp * this.fracco2rise;
            this.dso = (float)bc.dso * this.fractemprise;
            this.dhu = (float)bc.dhu * this.fractemprise;
            this.dat = this.resp.totco2emit(r, year) - this.resp.totco2emit(r, year - 1) - (this.dls + this.dhs + this.dnp + this.dso + this.dhu);
            for (n = 0; n < 43; ++n) {
                this.ciq[nr][n] = (float)((double)this.ciq[nr][n] * bc.cpropf[n] + bc.scicAT[n] * (double)this.atinc + bc.scicLS[n] * (double)this.lsinc + bc.scicHS[n] * (double)this.hsinc + bc.scicNP[n] * (double)this.npinc + bc.rcicAT[n] * (double)this.dat + bc.rcicLS[n] * (double)this.dls + bc.rcicHS[n] * (double)this.dhs + bc.rcicNP[n] * (double)this.dnp + bc.scicSO[n] * (double)this.soinc + bc.rcicSO[n] * (double)this.dso + bc.scicHU[n] * (double)this.huinc + bc.rcicHU[n] * (double)this.dhu);
                this.atco2.set(r, this.atco2.get(r) + (float)bc.crAT[n] * this.ciq[nr][n]);
                int n2 = nr;
                this.ls[n2] = this.ls[n2] + (float)bc.crLS[n] * this.ciq[nr][n];
                int n3 = nr;
                this.hs[n3] = this.hs[n3] + (float)bc.crHS[n] * this.ciq[nr][n];
                int n4 = nr;
                this.so[n4] = this.so[n4] + (float)bc.crSO[n] * this.ciq[nr][n];
                int n5 = nr;
                this.hu[n5] = this.hu[n5] + (float)bc.crHU[n] * this.ciq[nr][n];
            }
            this.atco2.set(r, this.atco2.get(r) * 4.71E-4f);
        }
        this.totls = 0.0f;
        this.toths = 0.0f;
        this.totat = 0.0f;
        this.totso = 0.0f;
        this.tothu = 0.0f;
        for (nr = 0; nr < this.nrf; ++nr) {
            this.totls += this.ls[nr];
            this.toths += this.hs[nr];
            this.totat += this.atco2.get(this.reg(nr));
            this.totso += this.so[nr];
            this.tothu += this.hu[nr];
        }
    }

    void atchemstep() {
        if (year == gsy) {
            for (int nr = 0; nr < this.nregs; ++nr) {
                this.atch4.set(this.reg(nr), 0.0f);
                this.atn2o.set(this.reg(nr), 0.0f);
            }
            float f = this.gm(atchem.class).ch4conc.get();
            this.gm(atchem.class);
            this.atch4.set(this.bestafen, f - atchem.ch4prein);
            this.atch4.set(this.othgasreg, 0.0f);
            this.atn2o.set(this.bestafen, this.gm(atchem.class).n2oconc.get() - this.gm(atchem.class).n2oprein);
            this.atn2o.set(this.othgasreg, 0.0f);
        } else {
            for (int nr = 0; nr < this.nemit; ++nr) {
                region r = this.reg(nr);
                float f = this.atch4.get(r, year - 1) * (1.0f - 1.0f / this.gm(atchem.class).ch4life(year));
                this.gm(atchem.class);
                this.atch4.set(r, f + atchem.ppbpmtch4 * this.resp.ch4emit(r, year));
                this.atn2o.set(r, this.atn2o.get(r, year - 1) * (1.0f - 1.0f / this.gm(atchem.class).n2olife(year)) + this.gm(atchem.class).ppbpmtn * this.resp.n2oemit(r, year));
            }
            this.gm(atchem.class);
            float f = atchem.ppbpmtch4 * this.gm(atchem.class).ch4emitnat();
            this.gm(atchem.class);
            this.extrach4 = f - atchem.ch4prein / this.gm(atchem.class).ch4life(year);
            this.atch4.set(this.othgasreg, this.atch4.get(this.othgasreg, year - 1) * (1.0f - 1.0f / this.gm(atchem.class).ch4life(year)) + this.extrach4);
            this.extran2o = this.gm(atchem.class).ppbpmtn * this.gm(atchem.class).n2oemitnat() - this.gm(atchem.class).n2oprein / this.gm(atchem.class).n2olife(year);
            this.atn2o.set(this.othgasreg, this.atn2o.get(this.othgasreg, year - 1) * (1.0f - 1.0f / this.gm(atchem.class).n2olife(year)) + this.extran2o);
        }
    }

    void rfstep() {
        int nr;
        atchem atchem2 = this.gm(atchem.class);
        for (nr = 0; nr < this.nrf; ++nr) {
            region r = this.reg(nr);
            if (this.resp.method.equals("tracer+differentialRF") && (double)year > this.resp.startyear.getval() + 1.0) {
                int yy = year > gsy ? year - 1 : gsy;
                this.dc = this.carbon.co2atppm.get() - this.carbon.co2atppm.get(yy);
                this.rfco2.set(r, yy, this.rfco2.get(r, yy) + ((double)Math.abs(this.dc) > 1.0E-4 ? (this.carbon.co2rf.get() - this.carbon.co2rf.get(yy)) * (this.atco2.get(r) - this.atco2.get(r, yy)) / this.dc : 0.0f));
                if (nr >= this.nemit + 1) continue;
                this.dc = atchem2.n2oconc.get() - atchem2.n2oconc.get(yy);
                this.rfn2o.set(r, this.rfn2o.get(r, yy) + ((double)Math.abs(this.dc) > 1.0E-4 ? (atchem2.n2orf.get() - atchem2.n2orf.get(yy)) * (this.atn2o.get(r) - this.atn2o.get(r, yy)) / this.dc : 0.0f));
                this.dc = atchem2.ch4conc.get() - atchem2.ch4conc.get(yy);
                this.rfch4.set(r, this.rfch4.get(r, yy) + ((double)Math.abs(this.dc) > 1.0E-4 ? (atchem2.ch4rf.get() - atchem2.ch4rf.get(yy)) * (this.atch4.get(r) - this.atch4.get(r, yy)) / this.dc : 0.0f));
                continue;
            }
            this.dc = this.carbon.co2atppm.get() - 278.0f;
            this.rfco2.set(r, this.atco2.get(r) * ((double)Math.abs(this.dc) > 1.0E-4 ? this.carbon.co2rf.get() / this.dc : 0.0f));
            if (nr >= this.nemit + 1) continue;
            this.dc = atchem2.n2oconc.get() - atchem2.n2oprein;
            this.rfn2o.set(r, this.atn2o.get(r) * ((double)Math.abs(this.dc) > 1.0E-4 ? atchem2.n2orf.get() / this.dc : 0.0f));
            this.dc = atchem2.ch4conc.get() - atchem.ch4prein;
            this.rfch4.set(r, this.atch4.get(r) * ((double)Math.abs(this.dc) > 1.0E-4 ? atchem2.ch4rf.get() / this.dc : 0.0f));
        }
        for (nr = 0; nr < this.nemit; ++nr) {
            this.rftot.set(this.reg(nr), this.rfco2.get(this.reg(nr)) + (this.resp.includeCH4N2O.istrue() ? this.rfch4.get(this.reg(nr)) + this.rfn2o.get(this.reg(nr)) : 0.0f));
        }
        this.rftot.set(this.othgasreg, this.rfco2.get(this.othgasreg) + this.rfch4.get(this.othgasreg) + this.rfn2o.get(this.othgasreg) + this.gm(fgas.class).cfcrf.get() + this.gm(fgas.class).hfcrf.get() + atchem2.strath2orf.get() + atchem2.tropo3rf.get() + this.gm(fgas.class).strato3rf.get());
        if (!this.resp.includeCH4N2O.istrue()) {
            for (nr = 0; nr < this.nemit; ++nr) {
                this.rftot.set(this.othgasreg, this.rftot.get(this.othgasreg) + this.rfch4.get(this.reg(nr)) + this.rfn2o.get(this.reg(nr)));
            }
        }
        this.rftot.set(this.aerosolreg, this.rfco2.get(this.aerosolreg) + this.gm(aerosol.class).aerorf.get());
        this.rftot.set(this.solvolreg, this.rfco2.get(this.solvolreg) + this.gm(aerosol.class).natvrf.get());
    }

    void udebclimodsetup() {
        udebclimod udeb = this.gm(udebclimod.class);
        for (int o = 0; o < 2; ++o) {
            this.rff[o] = (float)(1.0 + udeb.frac[o * 3] / udeb.frac[o + 1] * udeb.klo / (udeb.kls * udeb.frac[o * 3] + udeb.klo));
            this.sf[o] = (float)(udeb.spaceflux[o] * udeb.qpt * udeb.tstart);
            for (int n = 0; n < 40; ++n) {
                for (int nr = 0; nr < this.nrf; ++nr) {
                    this.hiq[nr][o][n] = (float)(nr == this.oth ? udeb.hiq[o][n] : udeb.hiqstart[o][n]);
                }
            }
        }
    }

    void glotempstep() {
        if (year == gsy) {
            this.udebclimodsetup();
        }
        udebclimod udeb = this.gm(udebclimod.class);
        for (int nr = 0; nr < this.nrf; ++nr) {
            region r = this.reg(nr);
            this.surftemp.set(r, 0.0f);
            this.sealevte.set(r, 0.0f);
            if ((double)year < this.resp.startyear.getval() && nr < this.nregs || year == gsy && r == this.resp.othgasreg) continue;
            for (int o = 0; o < 2; ++o) {
                this.mlt[o] = 0.0f;
                this.qinold = this.sf[o] + (year > gsy ? this.rftot.get(r, year - 1) : 0.0f) * this.rff[o];
                this.qin = this.sf[o] + this.rftot.get(r) * this.rff[o];
                this.dqin = this.qin - this.qinold;
                for (int n = 0; n < 40; ++n) {
                    this.hiq[nr][o][n] = (float)(udeb.hpropf[o][n] * (double)this.hiq[nr][o][n] + udeb.shicML[o][n] * (double)this.qinold + udeb.rhicML[o][n] * (double)this.dqin);
                    int n2 = o;
                    this.mlt[n2] = this.mlt[n2] + (float)udeb.hrML[o][n] * this.hiq[nr][o][n];
                    this.sealevte.set(r, this.sealevte.get(r) + (float)udeb.hrsl[o][n] * this.hiq[nr][o][n]);
                }
                this.mlt[o] = (float)((double)this.mlt[o] / udeb.qpt - udeb.tstart);
            }
            this.sealevte.set(r, this.sealevte.get(r) - (float)udeb.sealevteinit);
            this.boxtemp[0] = (float)(((double)this.mlt[0] * udeb.cice * udeb.klo + udeb.frac[0] * (double)this.rftot.get(r)) / (udeb.kls * udeb.frac[0] + udeb.klo));
            this.boxtemp[3] = (float)(((double)this.mlt[1] * udeb.cice * udeb.klo + udeb.frac[3] * (double)this.rftot.get(r)) / (udeb.kls * udeb.frac[3] + udeb.klo));
            this.boxtemp[1] = (float)((double)this.mlt[0] * udeb.cice);
            this.boxtemp[2] = (float)((double)this.mlt[1] * udeb.cice);
            for (int i = 0; i < 4; ++i) {
                this.surftemp.set(r, this.surftemp.get(r) + (float)((double)this.boxtemp[i] * udeb.frac[i]));
            }
        }
    }
}

