/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.regemit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jcm.core.complexity;
import jcm.core.cur.curveset;
import jcm.core.ob.interacob;
import jcm.core.ob.loopcalc;
import jcm.core.ob.module;
import jcm.core.par.param;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.core.report;
import jcm.mod.carbon.carboncycle;
import jcm.mod.luc.futureLUC;
import jcm.mod.obj.controller;
import jcm.mod.obj.globco2emit;
import jcm.mod.obj.regset;
import jcm.mod.ogas.othgasemit;
import jcm.mod.regemit.AviaShipEmit;
import jcm.mod.regemit.emitbase;
import jcm.mod.regemit.emitquota;
import jcm.mod.regemit.pledges;
import jcm.mod.resp.attribTracer;
import jcm.mod.resp.responsibility;
import jcm.mod.socio.costs;
import jcm.mod.socio.popgdp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class shares
extends module {
    complexity[] distribcomplex = new complexity[]{complexity.normal, complexity.simplest, complexity.normal, complexity.expert, complexity.experimental, complexity.experimental, complexity.experimental};
    complexity[] igcomplex = new complexity[0];
    public param<igroup> initgroup = new param(new Object[]{"initial participating group", igroup.values(), igroup.Kyoto_Annex_B});
    public param<emitthreshold> emitlim = new param(new Object[]{"emissions threshold", emitthreshold.values(), emitthreshold.particip_emitpercap});
    public param richjoin = new param("join if high GDP", true);
    public param axb_gdp_threshold = new param("upper_GDP_threshold", "dollar&per&person", 20000, 10000, 30000);
    public param<distriboptions> distribution = new param(new Object[]{"distribmenu", distriboptions.values(), distriboptions.convergence, this.distribcomplex});
    public param<convcrit> conv_criteria = new param(new Object[]{"convergence criteria", convcrit.values(), convcrit.emissionspercapita, complexity.expert});
    public param percap_target = new param("per_capita target bottom-up", "ton&per&person", 0.4, 0, 2);
    public param pergdp_target = new param("intensity target bottom-up", "gram&per&dollar", 25, 0, 100);
    public param convergey = new param("convyear", "", 2060, 2010, 2100);
    public param exponential = new param(new Object[]{"expconvopt", false, complexity.expert});
    public param cvf = new param(new Object[]{"convfac", "", 6, 1, 13, complexity.expert});
    public param popcoyoption = new param(new Object[]{"popcoyopt", false, complexity.expert});
    public param popcoy = new param(new Object[]{"popcoy", "", 2030, 1990, 2100, complexity.expert});
    public param lc_iterative = new param(new Object[]{"iterative", false, complexity.experimental});
    public param intensityconstraint = new param(new Object[]{"constrain intensity non-pledged", true, complexity.expert});
    public param<intensity> midincaction = new param(new Object[]{"middle-income early action", intensity.values(), intensity.no_deviation, complexity.expert});
    public param ldc_gdp_threshold = new param(new Object[]{"lower_GDP_threshold", "dollar&per&person", 5000, 0, 20000, complexity.expert});
    public param dc_reduction = new param(new Object[]{"midinc intensity reduction", "percent&per&yr", 0.5, 0, 5, complexity.expert});
    public param rate_caps = new param(new Object[]{"use rate caps", false, complexity.expert});
    public param rate_constraint = new param(new Object[]{"max decline rate", "percent&per&yr", 4, 2, 20, complexity.expert});
    public param d2rate_constraint = new param(new Object[]{"max deceleration", "percent&per&yr", 3, 0.5, 5, complexity.expert});
    public param logparticip = new param(new Object[]{"record_transitions", false, complexity.expert});
    public param checkscaling = new param(new Object[]{"topdownscale", true, complexity.experimental});
    public param finertia = new param("inertia weight", "", 20, 0, 30);
    public param fconstant = new param("constant weight", "", 0, 0, 30);
    public param fbaseline = new param("baseline weight", "", 0, 0, 5);
    public param fbasetrend = new param("basetrend weight", "", 0, 0, 5);
    public param fglobemitpercap = new param("globemitpercap weight", "", 1, 0, 5);
    public param fglobemitpergdp = new param("globemitpergdp weight", "", 1, 0, 5);
    public param fresppercap = new param("resppercap weight", "", 0, 0, 5);
    attribTracer attr;
    responsibility resp;
    pledges pl;
    emitquota eq;
    emitbase eb;
    curveset efq;
    curveset efb;
    curveset elq;
    curveset elb;
    curveset emq;
    curveset emb;
    curveset enq;
    curveset eeq;
    curveset enb;
    curveset pop;
    curveset gdp;
    List<region> reg_all;
    List<region> reg_allnb = new ArrayList<region>();
    Set<region> particip = new HashSet<region>();
    Set<region> notparticip = new HashSet<region>();
    Set<region> capped = new HashSet<region>();
    Set<region> pledged = new HashSet<region>();
    Set<region> expledged = new HashSet<region>();
    Set<region> AXB = new HashSet<region>();
    Map<region, Float> mac = new HashMap<region, Float>();
    Map<region, Float> abateshare = new HashMap<region, Float>();
    Map<region, Float> intensitydecline = new HashMap<region, Float>();
    Map<region, Integer> midinc_sy = new HashMap<region, Integer>();
    Map<region, Integer> dur = new HashMap<region, Integer>(50);
    double cf;
    float participtot;
    boolean policyscenario;
    controller co;
    public loopcalc topdown = new loopcalc("shares-topdown-scaling"){

        public void calcstep() {
            if (year >= fsyfos) {
                if (shares.this.co.botuptopdo.chosen == controller.butd.top_down_only || shares.this.co.botuptopdo.chosen == controller.butd.start_bottom_up && year >= (int)shares.this.co.startyear_topdown.getval()) {
                    if (shares.this.policyscenario) {
                        shares.this.scaleandcapparticip();
                    }
                    if (shares.this.checkscaling.istrue()) {
                        shares.this.efq.topdownscale(shares.this.gm(carboncycle.class).fossil.get(), true);
                    }
                }
                shares.this.efq.calctot();
                shares.this.emq.topdownscale(shares.this.gm(othgasemit.class).ch4emit.get());
                shares.this.enq.topdownscale(shares.this.gm(othgasemit.class).n2oemit.get());
            }
        }
    };

    @Override
    public void initsetup() {
        this.eq = this.gm(emitquota.class);
        this.eb = this.gm(emitbase.class);
        this.attr = this.gm(attribTracer.class);
        this.resp = this.gm(responsibility.class);
        this.pl = this.gm(pledges.class);
        this.co = this.gm(controller.class);
        this.follows(popgdp.class);
        this.follows(emitbase.class);
        this.setaffectedby(this.co.objective);
        this.distribution.setaffectedby(this.co.objective);
        this.setaffectedby(emitquota.class);
        this.setaffectedby(this.gm(othgasemit.class).gwp_source);
        this.topdown.follows(this);
        this.topdown.follows(this.gm(AviaShipEmit.class).emitmitig);
        this.topdown.follows(this.gm(futureLUC.class).quota);
        this.topdown.follows(this.gm(globco2emit.class));
        this.topdown.follows(this.gm(othgasemit.class));
    }

    @Override
    public void setinteractions() {
        this.follows(pledges.class, this.co.objective.chosen != controller.objopt.nopolicy);
        boolean policyscen = this.gm(controller.class).objective.chosen != controller.objopt.nopolicy;
        boolean incpart = policyscen && this.initgroup.chosen != igroup.all_from_start;
        distriboptions dc = (distriboptions)((Object)this.distribution.chosen);
        this.setaffectedby((interacob)this.gm(attribTracer.class), policyscen && dc == distriboptions.responsibility);
        this.setaffectedby((interacob)this.gm(costs.class), policyscen && dc == distriboptions.leastcost);
        this.setaffectedby(this.distribution, policyscen);
        this.setaffectedby(this.initgroup, policyscen);
        this.setaffectedby((interacob)this.co.startyear_topdown, policyscen && this.co.botuptopdo.chosen == controller.butd.start_bottom_up);
        this.setaffectedby(this.emitlim, incpart);
        this.setaffectedby(this.conv_criteria, policyscen && dc == distriboptions.convergence);
        this.setaffectedby((interacob)this.convergey, policyscen && dc == distriboptions.convergence);
        this.setaffectedby((interacob)this.percap_target, policyscen && dc == distriboptions.convergence && this.conv_criteria.chosen == convcrit.emissionspercapita && this.co.botuptopdo.chosen != controller.butd.top_down_only);
        this.setaffectedby((interacob)this.pergdp_target, policyscen && dc == distriboptions.convergence && this.conv_criteria.chosen == convcrit.emissionspergdp && this.co.botuptopdo.chosen != controller.butd.top_down_only);
        this.setaffectedby((interacob)this.popcoyoption, policyscen && dc == distriboptions.convergence && this.conv_criteria.chosen == convcrit.emissionspercapita);
        this.setaffectedby((interacob)this.popcoy, policyscen && dc == distriboptions.convergence && this.conv_criteria.chosen == convcrit.emissionspercapita && this.popcoyoption.istrue());
        this.setaffectedby((interacob)this.exponential, policyscen && dc == distriboptions.convergence);
        this.setaffectedby((interacob)this.cvf, policyscen && dc == distriboptions.convergence && this.exponential.istrue());
        this.setaffectedby((interacob)this.lc_iterative, policyscen && dc == distriboptions.leastcost);
        this.setaffectedby((interacob)this.richjoin, incpart);
        this.setaffectedby((interacob)this.axb_gdp_threshold, incpart && this.richjoin.istrue());
        this.setaffectedby(this.midincaction, incpart);
        this.setaffectedby((interacob)this.rate_caps, policyscen);
        this.setaffectedby((interacob)this.rate_constraint, policyscen && (this.rate_caps.istrue() || dc == distriboptions.newmix));
        this.setaffectedby((interacob)this.d2rate_constraint, policyscen && this.rate_caps.istrue());
        this.setaffectedby((interacob)this.ldc_gdp_threshold, incpart && (this.midincaction.chosen != intensity.no_deviation || this.rate_caps.istrue()));
        this.setaffectedby((interacob)this.dc_reduction, incpart && this.midincaction.chosen != intensity.no_deviation);
        this.setaffectedby((interacob)this.finertia, dc == distriboptions.newmix);
        this.setaffectedby((interacob)this.fconstant, dc == distriboptions.newmix);
        this.setaffectedby((interacob)this.fbaseline, dc == distriboptions.newmix);
        this.setaffectedby((interacob)this.fbasetrend, dc == distriboptions.newmix);
        this.setaffectedby((interacob)this.fglobemitpercap, dc == distriboptions.newmix);
        this.setaffectedby((interacob)this.fglobemitpergdp, dc == distriboptions.newmix);
        this.setaffectedby((interacob)this.fresppercap, dc == distriboptions.newmix);
    }

    void setnational() {
        this.efq = this.eq.emitfos_nat;
        this.elq = this.eq.emitluc_nat;
        this.emq = this.eq.emitch4_nat;
        this.enq = this.eq.emitn2o_nat;
        this.eeq = this.eq.emitequiv_nat;
        this.efb = this.eb.emitfosbase_nat;
        this.emb = this.eb.emitch4base_nat;
        this.enb = this.eb.emitn2obase_nat;
        this.pop = this.gm(popgdp.class).pop_nat;
        this.gdp = this.gm(popgdp.class).gdp_ppp_nat;
    }

    void setregional() {
        this.efq = this.eq.emitfos;
        this.elq = this.eq.emitluc;
        this.emq = this.eq.emitch4;
        this.enq = this.eq.emitn2o;
        this.eeq = this.eq.emitequiv;
        this.efb = this.eb.emitfosbase;
        this.emb = this.eb.emitch4base;
        this.enb = this.eb.emitn2obase;
        this.pop = this.gm(popgdp.class).pop;
        this.gdp = this.gm(popgdp.class).gdp_ppp;
    }

    @Override
    public void precalc() {
        this.setnational();
        this.initregions(true);
        this.cf = this.cvf.getval() / (double)((int)this.convergey.getval() - fsyfos);
        this.dur.clear();
        this.policyscenario = this.gm(controller.class).objective.chosen != controller.objopt.nopolicy;
    }

    @Override
    public void calcstep() {
        if (year >= fsyfos) {
            if (year == 2051) {
                this.setregional();
                this.initregions(false);
            }
            if (!this.policyscenario) {
                this.settobase();
                this.settobase_ogas();
            }
            if (this.policyscenario) {
                distriboptions dc;
                this.setparticipate();
                this.settobase();
                this.settobase_ogas();
                if (this.midincaction.chosen != intensity.no_deviation) {
                    this.developing_bottomup();
                }
                if ((dc = (distriboptions)((Object)this.distribution.chosen)) == distriboptions.newmix) {
                    this.newmix();
                }
                if (dc == distriboptions.grandfather) {
                    for (region r : this.particip) {
                        this.efq.set(r, this.efq.get(r, year - 1));
                    }
                }
                if (dc == distriboptions.sresdist) {
                    for (region r : this.particip) {
                        this.efq.set(r, this.efb.get(r));
                    }
                }
                if (dc == distriboptions.convergence) {
                    this.converge();
                }
                if (dc == distriboptions.leastcost) {
                    this.leastcost();
                }
                if (dc == distriboptions.responsibility) {
                    this.responsibility();
                }
            }
            if (this.co.botuptopdo.chosen == controller.butd.bottom_up_only || this.co.botuptopdo.chosen == controller.butd.start_bottom_up && year < (int)this.co.startyear_topdown.getval()) {
                this.bottomup_total();
            }
        }
    }

    void settobase() {
        if (year == 2013 || year == 2021 || year == 2051) {
            this.intensitydecline.clear();
            for (region r : this.reg_allnb) {
                this.intensitydecline.put(r, Float.valueOf((float)Math.log(this.efq.get(r, year - 1) / this.gdp.get(r, year - 1) / (this.efq.get(r, year - 16) / this.gdp.get(r, year - 16))) / 15.0f));
            }
        }
        for (region r : this.reg_allnb) {
            if (this.pledged.contains(r)) continue;
            if (this.intensityconstraint.istrue()) {
                int baseyr = year > 2050 ? 2050 : (year > 2020 ? 2020 : 2012);
                float intensity_based_emit = this.gdp.get(r) * (this.efq.get(r, baseyr) / this.gdp.get(r, baseyr)) * (float)Math.exp(this.intensitydecline.get(r).floatValue() * (float)(year - baseyr));
                if (Float.isNaN(intensity_based_emit)) {
                    intensity_based_emit = this.efb.get(r);
                }
                if (this.expledged.contains(r)) {
                    this.efq.set(r, intensity_based_emit);
                    continue;
                }
                if (intensity_based_emit < this.efb.get(r)) {
                    this.efq.set(r, intensity_based_emit);
                    continue;
                }
                this.efq.set(r, this.efb.get(r));
                continue;
            }
            this.efq.set(r, this.efb.get(r));
        }
    }

    void settobase_ogas() {
        for (region r : this.reg_allnb) {
            this.emq.set(r, this.emb.get(r));
            this.enq.set(r, this.enb.get(r));
        }
    }

    void bottomup_total() {
        float emittot = 0.0f;
        for (region r : this.reg_all) {
            emittot += this.efq.get(r);
        }
        this.gm(carboncycle.class).fossil.set(emittot += this.efq.get("bunker", year - 1));
    }

    void initregions(boolean init) {
        if (init && this.logparticip.istrue()) {
            report.deb("\n===========================");
        }
        this.reg_all = init ? regman.nations.reg : ((region)this.gm(regset.class).regions.chosen).reg;
        this.reg_allnb.clear();
        this.reg_allnb.addAll(this.reg_all);
        this.reg_allnb.remove("bunker");
        if (init) {
            this.makeKyotoAxB();
        }
        if (!init && this.logparticip.istrue() && !this.notparticip.isEmpty()) {
            String finparticip = "\nAfter 2050 all join participating group, adding: ";
            for (region r : this.pledged) {
                finparticip = finparticip + r + " (end pledge), ";
            }
            for (region r : this.notparticip) {
                finparticip = finparticip + r + ", ";
            }
            report.deb(finparticip + "\n============================\n");
        }
        this.particip.clear();
        this.notparticip.clear();
        this.pledged.clear();
        this.expledged.clear();
        this.midinc_sy.clear();
        this.mac.clear();
        this.abateshare.clear();
        if (!init) {
            this.particip.addAll(this.reg_allnb);
            this.notparticip.clear();
            return;
        }
        Set<region> hastarget = this.pl.targets.keySet();
        boolean usepledges = this.pl.usepledges.istrue();
        if (usepledges) {
            this.pledged.addAll(hastarget);
        }
        if (this.initgroup.chosen == igroup.all_from_start && usepledges) {
            this.particip.addAll(this.pl.notarget);
        }
        if (this.initgroup.chosen == igroup.all_from_start && !usepledges) {
            this.particip.addAll(this.reg_allnb);
        }
        if (this.initgroup.chosen == igroup.all_CA_pledges && usepledges) {
            this.notparticip.addAll(this.pl.notarget);
        }
        if (this.initgroup.chosen == igroup.all_CA_pledges && !usepledges) {
            this.particip.addAll(hastarget);
            this.notparticip.addAll(this.pl.notarget);
        }
        if (this.initgroup.chosen == igroup.Kyoto_Annex_B && usepledges) {
            this.particip.addAll(this.AXB);
            this.particip.removeAll(this.pledged);
            this.notparticip.addAll(this.pl.notarget);
            this.notparticip.removeAll(this.AXB);
        }
        if (this.initgroup.chosen == igroup.Kyoto_Annex_B && !usepledges) {
            this.particip.addAll(this.AXB);
            this.notparticip.addAll(this.reg_allnb);
            this.notparticip.removeAll(this.AXB);
        }
        if (this.initgroup.chosen == igroup.none && usepledges) {
            this.notparticip.addAll(this.pl.notarget);
        }
        if (this.initgroup.chosen == igroup.none && !usepledges) {
            this.notparticip.addAll(this.reg_allnb);
        }
        if (this.logparticip.istrue()) {
            String initparticip = "";
            if (!this.pledged.isEmpty()) {
                initparticip = initparticip + "\nWith pledges: ";
            }
            for (region r : this.pledged) {
                initparticip = initparticip + r + ", ";
            }
            if (!this.particip.isEmpty()) {
                initparticip = initparticip + "\nOthers in initial group (" + this.initgroup.chosen + ") : ";
            }
            for (region r : this.particip) {
                initparticip = initparticip + r + ", ";
            }
            report.deb(initparticip);
        }
    }

    boolean init_participate(region r) {
        if (this.initgroup.chosen == igroup.all_from_start) {
            return true;
        }
        if (this.initgroup.chosen == igroup.Kyoto_Annex_B) {
            return this.AXB.contains(r);
        }
        if (this.initgroup.chosen == igroup.all_CA_pledges) {
            return this.pl.targets.keySet().contains(r);
        }
        return false;
    }

    void setparticipate() {
        String[] names = new String[]{"", "", "", ""};
        if (this.pl.usepledges.istrue()) {
            if (year <= 2020) {
                return;
            }
            boolean skip = year > 2020 && this.pl.beyond2020.isfalse();
            for (region r : this.reg_allnb) {
                if (!this.pledged.contains(r) || year <= this.pl.endtarget.get(r) && !skip) continue;
                this.pledged.remove(r);
                if (this.init_participate(r)) {
                    this.particip.add(r);
                    names[0] = names[0] + r.getName() + ", ";
                    continue;
                }
                this.notparticip.add(r);
                this.expledged.add(r);
                names[1] = names[1] + r.getName() + ", ";
            }
        }
        float poptot = 0.0f;
        float fostot = 0.0f;
        if (this.notparticip.isEmpty()) {
            return;
        }
        if (this.emitlim.chosen != emitthreshold.nolim) {
            for (region r : this.reg_allnb) {
                if (this.emitlim.chosen != emitthreshold.worldemitpercap && !this.init_participate(r) && !this.particip.contains(r)) continue;
                poptot += this.pop.get(r, year - 1);
                fostot += this.efq.get(r, year - 1);
            }
            for (region r : this.notparticip) {
                if (!(this.efq.get(r, year - 1) / this.pop.get(r, year - 1) > fostot / poptot)) continue;
                this.particip.add(r);
                names[2] = names[2] + r.getName() + ", ";
            }
            this.notparticip.removeAll(this.particip);
        }
        for (region r : this.notparticip) {
            float gdppercap = this.gdp.get(r) / this.pop.get(r);
            if (this.richjoin.istrue() && (double)gdppercap > this.axb_gdp_threshold.getval()) {
                this.particip.add(r);
                names[3] = names[3] + r.getName() + ", ";
            }
            if (this.midinc_sy.containsKey(r) || !((double)gdppercap > this.ldc_gdp_threshold.getval())) continue;
            this.midinc_sy.put(r, 0);
        }
        this.notparticip.removeAll(this.particip);
        this.expledged.removeAll(this.particip);
        if (this.logparticip.istrue()) {
            String[] info = new String[]{"" + year + ": end pledge & continue participating (within initial-group " + this.initgroup.chosen + ") : ", "" + year + ": end pledge & leave participating group : ", "" + year + ": participate as emit/cap > avg (" + fostot / poptot + ") : ", "" + year + ": participate as GDP/cap > " + this.axb_gdp_threshold.getval() + " : "};
            for (int i = 0; i < 4; ++i) {
                if (names[i].equals("")) continue;
                report.deb(info[i] + names[i]);
            }
            if (this.notparticip.isEmpty()) {
                report.deb("\n ============================\n");
            }
        }
    }

    void makeKyotoAxB() {
        Set<region> A1nat = regman.allreg.findreg("AXB").subreg(regman.nations);
        block0: for (region r : this.reg_allnb) {
            Set<region> rn = r.subreg(regman.nations);
            for (region rr : rn) {
                if (!A1nat.contains(rr)) continue;
                this.AXB.add(r);
                continue block0;
            }
        }
    }

    void developing_bottomup() {
        for (region r : this.midinc_sy.keySet()) {
            int yd = this.midinc_sy.get(r);
            if (this.notparticip.contains(r)) {
                this.midinc_sy.put(r, ++yd);
            }
            float fracreduce = (float)Math.pow(1.0 - this.dc_reduction.getval() / 100.0, yd);
            if (this.midincaction.chosen == intensity.redrelbase && yd > 0) {
                this.efq.set(r, this.efq.get(r) * fracreduce);
            }
            if (this.midincaction.chosen != intensity.redint || yd <= 0) continue;
            float intensity2 = this.efq.get(r, year - yd) / this.gdp.get(r, year - yd) * fracreduce;
            this.efq.set(r, Math.min(intensity2 * this.gdp.get(r), this.efq.get(r)));
        }
    }

    void scaleandcapparticip() {
        float emittot = 0.0f;
        for (region r : this.notparticip) {
            emittot += this.efq.get(r);
        }
        for (region r : this.pledged) {
            emittot += this.efq.get(r);
        }
        this.participtot = this.gm(carboncycle.class).fossil.get() - this.efq.get("bunker") - emittot;
        float excess = this.scaleandcap(this.particip, this.participtot);
        if (excess < 0.0f) {
            float midinctot = 0.0f;
            HashSet<region> midinc = new HashSet<region>(this.midinc_sy.keySet());
            midinc.removeAll(this.particip);
            for (region r : midinc) {
                midinctot += this.efq.get(r);
            }
            excess = this.scaleandcap(midinc, midinctot + excess);
        }
        if (excess < 0.0f) {
            float alltot = 0.0f;
            for (region r : this.reg_allnb) {
                alltot += this.efq.get(r);
            }
            float fac = (this.gm(carboncycle.class).fossil.get() - this.efq.get("bunker")) / alltot;
            for (region r : this.reg_allnb) {
                this.efq.set(r, this.efq.get(r) * fac);
            }
        }
    }

    float scaleandcap(Set<region> group, float grouptot) {
        boolean somechange;
        this.capped.clear();
        float rc = (float)this.rate_constraint.getval() / 100.0f;
        float d2rc = (float)this.d2rate_constraint.getval() / 100.0f;
        do {
            somechange = false;
            float emittot = 0.0f;
            for (region r : group) {
                if (this.capped.contains(r)) continue;
                emittot += this.efq.get(r);
            }
            float fac = grouptot / emittot;
            for (region r : group) {
                if (this.capped.contains(r)) continue;
                this.efq.set(r, this.efq.get(r) * fac);
            }
            if (!this.rate_caps.istrue() || year < fsyfos + 10) {
                return 0.0f;
            }
            for (region r : group) {
                if (this.capped.contains(r)) continue;
                float rate = this.efq.get(r, year) - this.efq.get(r, year - 1);
                float oldrate = this.efq.get(r, year - 1) - this.efq.get(r, year - 2);
                if (rate < 0.0f && (rate - oldrate) / this.efq.get(r) < -d2rc) {
                    this.efq.set(r, this.efq.get(r, year - 1) * (1.0f - d2rc) + oldrate);
                    somechange = true;
                }
                if ((rate = this.efq.get(r, year) - this.efq.get(r, year - 1)) / this.efq.get(r) < -rc) {
                    this.efq.set(r, this.efq.get(r, year - 1) * (1.0f - rc));
                    somechange = true;
                }
                if (!somechange) continue;
                this.capped.add(r);
                if (this.efq.get(r) < 0.0f) {
                    this.efq.set(r, 0.0f);
                }
                if (this.efq.get(r) > this.efb.get(r)) {
                    this.efq.set(r, this.efb.get(r));
                }
                grouptot -= this.efq.get(r);
            }
        } while (somechange);
        return grouptot;
    }

    void newmix() {
        float poptot = 0.0f;
        float gdptot = 0.0f;
        float emittot = 0.0f;
        float resptot = 0.0f;
        for (region r : this.reg_allnb) {
            poptot += this.pop.get(r);
            if (!Float.isNaN(this.gdp.get(r))) {
                gdptot += this.gdp.get(r);
            }
            emittot += this.efq.get(r, year - 1);
        }
        for (region r : this.particip) {
            double efqnew;
            if (!this.dur.containsKey(r)) {
                this.dur.put(r, 0);
            } else {
                this.dur.put(r, this.dur.get(r) + 1);
            }
            double efqold = this.efq.get(r, year - 1);
            double emit = this.fconstant.getval() * efqold;
            double sumf = this.fconstant.getval();
            emit += this.finertia.getval() / (double)(this.dur.get(r) + 1) * (efqold + (efqold - (double)this.efq.get(r, year - 6)) / 5.0);
            sumf += this.finertia.getval() / (double)(this.dur.get(r) + 1);
            double fbase = (double)this.dur.get(r).intValue() < this.fbaseline.getval() ? (double)this.dur.get(r).intValue() : this.fbaseline.getval();
            emit += fbase * (double)this.efb.get(r, year);
            sumf += fbase;
            if (efqold / (double)this.pop.get(r, year - 1) > (double)(emittot / poptot)) {
                sumf += this.fglobemitpercap.getval();
                emit += this.fglobemitpercap.getval() * (double)this.pop.get(r, year) * (double)(emittot / poptot);
            }
            if (!Float.isNaN(this.gdp.get(r)) && efqold / (double)this.gdp.get(r, year - 1) > (double)(emittot / gdptot) && this.gdp.get(r) / this.pop.get(r) > gdptot / poptot) {
                sumf += this.fglobemitpergdp.getval();
                emit += this.fglobemitpergdp.getval() * (double)this.gdp.get(r, year) * (double)(emittot / gdptot);
            }
            if ((efqold - (efqnew = emit / sumf)) / efqold > this.rate_constraint.getval() / 100.0) {
                efqnew = efqold * (100.0 - this.rate_constraint.getval()) / 100.0;
            }
            this.efq.set(r, (float)efqnew);
        }
    }

    void converge() {
        int cyear;
        int n = cyear = this.conv_criteria.chosen == convcrit.emissionspercapita && year > (int)this.popcoy.getval() && this.popcoyoption.istrue() ? (int)this.popcoy.getval() : year;
        double f = year >= (int)this.convergey.getval() ? 1.0 : (this.exponential.istrue() ? Math.exp(this.cf * (double)(year - (int)this.convergey.getval() - 1)) : 1.0 / (double)(1 + (int)this.convergey.getval() - year));
        float poptot = 0.0f;
        float gdptot = 0.0f;
        float emittot = 0.0f;
        for (region r : this.particip) {
            poptot += this.zeroifnan(this.pop.get(r, cyear));
            gdptot += this.zeroifnan(this.gdp.get(r, cyear));
            emittot += this.zeroifnan(this.efq.get(r, year - 1));
        }
        float cr = 1.0f;
        for (region r : this.particip) {
            float er;
            if (this.co.botuptopdo.chosen == controller.butd.bottom_up_only || this.co.botuptopdo.chosen == controller.butd.start_bottom_up && year < (int)this.co.startyear_topdown.getval()) {
                if (this.conv_criteria.chosen == convcrit.emissionspercapita) {
                    cr = (float)((double)this.pop.get(r, cyear) * this.percap_target.getval());
                }
                if (this.conv_criteria.chosen == convcrit.emissionspergdp) {
                    cr = (float)((double)this.gdp.get(r, cyear) * this.pergdp_target.getval()) / 1000000.0f;
                }
                er = this.efq.get(r, year - 1);
            } else {
                if (this.conv_criteria.chosen == convcrit.emissionspercapita) {
                    cr = this.pop.get(r, cyear) / poptot;
                }
                if (this.conv_criteria.chosen == convcrit.emissionspergdp) {
                    cr = this.gdp.get(r, cyear) / gdptot;
                }
                er = (Float.isNaN(this.efq.get(r, year - 1)) ? 0.0f : this.efq.get(r, year - 1)) / emittot;
            }
            this.efq.set(r, this.zeroifnan((float)((double)er - f * (double)(er - cr))));
        }
    }

    float zeroifnan(float i) {
        if (Float.isNaN(i)) {
            return 0.0f;
        }
        return i;
    }

    void responsibility() {
        float tempinctot = 0.0f;
        float tempincp = 0.0f;
        float oldemittot = 0.0f;
        int respyear = Math.min(year - 1, (int)this.resp.endyear.getval());
        for (region r : this.particip) {
            if (!(this.efq.get(r, year - 1) > 0.0f)) continue;
            tempinctot += this.attr.surftemp.get(r, respyear);
            oldemittot += this.efq.get(r, year - 1);
        }
        float totreduce = oldemittot - this.participtot;
        if (totreduce < 0.0f) {
            report.deb("Problem applying Brazilian proposal: total reduction positive in " + year);
            return;
        }
        for (region r : this.particip) {
            float fr = this.attr.surftemp.get(r, respyear) / tempinctot;
            this.efq.set(r, this.efq.get(r, year - 1) - totreduce * fr);
            if (!(this.efq.get(r, year) < 0.0f)) continue;
            this.efq.set(r, 0.0f);
        }
    }

    void leastcost() {
        float suma = 0.0f;
        float sumb = 0.0f;
        float sums = 0.0f;
        float summ = 0.0f;
        int nregs = this.particip.size();
        if (this.lc_iterative.istrue()) {
            for (region r : this.particip) {
                this.mac.put(r, Float.valueOf(1.0f / (this.gm(costs.class).mac(r, year - 1) * this.gm(costs.class).ew(r, year - 1))));
                if (Float.isInfinite(this.mac.get(r).floatValue()) || Float.isNaN(this.mac.get(r).floatValue())) {
                    this.mac.put(r, Float.valueOf(0.0f));
                }
                summ += this.mac.get(r).floatValue();
            }
            for (region r : this.particip) {
                this.abateshare.put(r, Float.valueOf(summ > 0.0f ? this.abateshare.get(r).floatValue() * (0.6f + 0.4f * this.mac.get(r).floatValue() / summ) : this.efb.get(r) / this.gm(carboncycle.class).fossil.get()));
                this.efq.set(r, this.efq.get(r, year - 1) + (this.efb.get(r) - this.efb.get(r, year - 1)));
            }
        } else {
            for (region r : this.particip) {
                this.abateshare.put(r, Float.valueOf(1.0f / (float)Math.pow(this.gm(costs.class).alpha(r), 1.0f / (this.gm(costs.class).beta(r) - 1.0f))));
                this.efq.set(r, this.efb.get(r));
            }
        }
        for (region r : this.particip) {
            sums += this.abateshare.get(r).floatValue();
            sumb += this.efq.get(r);
        }
        suma = sumb - this.gm(carboncycle.class).fossil.get();
        for (region r : this.particip) {
            this.efq.set(r, this.efq.get(r) - suma * this.abateshare.get(r).floatValue() / sums);
            if (this.efq.get(r) < 0.0f) {
                this.efq.set(r, 0.0f);
            }
            if (!(this.efq.get(r) > this.efb.get(r))) continue;
            this.efq.set(r, this.efb.get(r));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum intensity {
        redint,
        redrelbase,
        no_deviation;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum emitthreshold {
        worldemitpercap,
        particip_emitpercap,
        nolim;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum igroup {
        all_from_start,
        Kyoto_Annex_B,
        all_CA_pledges,
        none;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum convcrit {
        emissionspercapita,
        emissionspergdp;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum distriboptions {
        sresdist,
        convergence,
        newmix,
        grandfather,
        responsibility,
        leastcost,
        unspecified;

    }
}

