/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.regemit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jcm.core.complexity;
import jcm.core.cur.curveset;
import jcm.core.ob.interacob;
import jcm.core.ob.module;
import jcm.core.par.param;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.core.report;
import jcm.mod.regemit.AviaShipEmit;
import jcm.mod.regemit.emitbase;
import jcm.mod.regemit.emitquota;
import jcm.mod.regemit.histemitdata;
import jcm.mod.regemit.shares;
import jcm.mod.socio.popgdp;

public class pledges
extends module {
    public param usepledges = new param("apply pledges", true);
    public param beyond2020 = new param("apply beyond 2020", false);
    public param EU2050 = new param(new Object[]{"EU targets 2050", false, complexity.expert});
    public param<pledgelevel> level = new param(new Object[]{"pledge level", pledgelevel.values(), pledgelevel.conditional});
    public param<kyoto_opts> kyoto = new param(new Object[]{"Kyoto Protocol", kyoto_opts.values(), kyoto_opts.Kyoto_targets_excUSA_prolonged});
    public param sephotair = new param("Separate AAUsurplus", true);
    public param AAUfrac = new param("fraction surplus AAUs used", 50, 0, 100, "percent");
    public param<gdpopts> choosegdp = new param(new Object[]{"gdp for intensity", gdpopts.values(), gdpopts.GDP_PPP, complexity.expert});
    public Map<region, Integer> endtarget = new HashMap<region, Integer>(50);
    public Set<region> notarget = new LinkedHashSet<region>(50);
    Set<region> EU = new LinkedHashSet<region>(27);
    public Map<region, List<target>> targets = new LinkedHashMap<region, List<target>>();
    emitquota eq;
    emitbase eb;
    boolean fixedEU = false;
    curveset efb;
    curveset efq;
    curveset hfos;
    curveset gdp_mer;
    curveset gdp_ppp;

    public void initsetup() {
        this.eq = this.gm(emitquota.class);
        this.eb = this.gm(emitbase.class);
        this.follows(this.gm(emitbase.class));
        this.follows(this.gm(AviaShipEmit.class).emitbase);
        this.setaffectedby(this.gm(shares.class));
        this.EU = regman.allreg.findreg("EU27").subreg(regman.nations);
        this.settargets();
    }

    public void setinteractions() {
        this.setaffectedby(this.level, this.usepledges.istrue());
        this.setaffectedby(this.kyoto, this.usepledges.istrue());
        this.setaffectedby(this.choosegdp, this.usepledges.istrue());
        this.setaffectedby((interacob)this.beyond2020, this.usepledges.istrue());
        this.setaffectedby((interacob)this.sephotair, this.usepledges.istrue() || this.kyoto.chosen != kyoto_opts.real_emissions);
        this.setaffectedby((interacob)this.AAUfrac, (this.usepledges.istrue() || this.kyoto.chosen != kyoto_opts.real_emissions) && this.sephotair.istrue());
        this.setaffectedby((interacob)this.EU2050, this.beyond2020.istrue() && this.usepledges.istrue());
    }

    public void precalc() {
        this.efb = this.eb.emitfosbase_nat;
        this.efq = this.eq.emitfos_nat;
        this.gdp_mer = this.gm(popgdp.class).gdp_mer_nat;
        this.gdp_ppp = this.gm(popgdp.class).gdp_ppp_nat;
        this.hfos = histemitdata.fosCO2;
        if (!this.fixedEU) {
            this.fixEU();
        }
        for (region r : this.EU) {
            this.endtarget.put(r, this.EU2050.istrue() ? 2050 : 2020);
        }
        this.applytargets();
        this.fillhistory();
    }

    void settargets() {
        this.st("USA", 1990, 2010, -7, 2005, 2020, -17, 2025, -30, 2030, -42, 2050, -83);
        this.st("Australia", 1990, 2010, 8, 2000, 2020, -5, -25, -15);
        this.st("New Zealand", 1990, 2010, 0, 2020, -10, -20);
        this.st("Canada", 1990, 2010, -6, 2005, 2020, -17);
        this.st("Japan", 1990, 2010, -6, 2020, -15, -25);
        this.st("Russia", 1990, 2010, 0, 2020, -15, -25);
        this.st("Ukraine", 1990, 2010, 0, 2020, -15, -25);
        this.st("Belarus", 1990, 2010, -8, 2020, -5, -10);
        this.st("Kazakhstan", 1992, 2020, -15);
        this.st("Austria", 1990, 2010, -13, 2005, 2020, -16);
        this.st("Belgium", 1990, 2010, -7.5, 2005, 2020, -15);
        this.st("Bulgaria", 1988, 2010, -8, 2005, 2020, 20);
        this.st("Cyprus", 2005, 2020, -5);
        this.st("Czech Republic", 1990, 2010, -8, 2005, 2020, 9);
        this.st("Denmark", 1990, 2010, -21, 2005, 2020, -20);
        this.st("Estonia", 1990, 2010, -8, 2005, 2020, 11);
        this.st("Finland", 1990, 2010, 0, 2005, 2020, -16);
        this.st("France", 1990, 2010, 0, 2005, 2020, -14);
        this.st("Germany", 1990, 2010, -21, 2005, 2020, -14);
        this.st("Greece", 1990, 2010, 25, 2005, 2020, -4);
        this.st("Hungary", 1986, 2010, -6, 2005, 2020, 10);
        this.st("Ireland", 1990, 2010, 13, 2005, 2020, -20);
        this.st("Italy", 1990, 2010, -6.5, 2005, 2020, -13);
        this.st("Latvia", 1990, 2010, -8, 2005, 2020, 17);
        this.st("Lithuania", 1990, 2010, -8, 2005, 2020, 15);
        this.st("Luxembourg", 1990, 2010, -28, 2005, 2020, -20);
        this.st("Malta", 2005, 2020, 5);
        this.st("Netherlands", 1990, 2010, -6, 2005, 2020, -16);
        this.st("Poland", 1988, 2010, -6, 2005, 2020, 14);
        this.st("Portugal", 1990, 2010, 27, 2005, 2020, 1);
        this.st("Romania", 1989, 2010, -8, 2005, 2020, 19);
        this.st("Slovenia", 1986, 2010, -8, 2005, 2020, 4);
        this.st("Slovakia", 1990, 2010, -8, 2005, 2020, 13);
        this.st("Spain", 1990, 2010, 15, 2005, 2020, -10);
        this.st("Sweden", 1990, 2010, 4, 2005, 2020, -17);
        this.st("United Kingdom", 1990, 2010, -12.5, 2005, 2020, -16);
        this.st("Croatia", 1990, 2010, -5, 2020, -5);
        this.st("Switzerland", 1990, 2010, -8, 2020, -20, -30);
        this.st("Norway", 1990, 2010, 1, 2020, -30, -40);
        this.st("Iceland", 1990, 2010, 10, 2020, -30);
        this.st("Brazil", targettype.baseline, 2020, -36.1, -38.9);
        this.st("Mexico", targettype.baseline, 2020, -30);
        this.st("Korea", targettype.baseline, 2005, 2020, -30);
        this.st("South Africa", targettype.baseline, 2020, -34, 2025, -42);
        this.st("Indonesia", targettype.baseline, 2020, -26);
        this.st("Singapore", targettype.baseline, 2020, -16);
        this.st("China", targettype.intensity, 2005, 2020, -40, -45);
        this.st("India", targettype.intensity, 2005, 2020, -20, -25);
        this.notarget.addAll(regman.nations.reg);
        this.notarget.removeAll(this.targets.keySet());
    }

    void st(String s, Number ... i) {
        this.st(s, targettype.absolute, i);
    }

    void st(String regname, targettype type2, Number ... i) {
        region r = regman.allreg.findreg(regname);
        if (r == null) {
            report.deb("Targets error: no region " + regname);
            return;
        }
        List<Object> lt = !this.targets.containsKey(r) ? new ArrayList(3) : this.targets.get(r);
        int baseyear = 0;
        int targetyear = 0;
        boolean gotyear = false;
        int count = 0;
        float low = 0.0f;
        float high = 0.0f;
        float value = 0.0f;
        for (Number j : i) {
            if (j.intValue() > 1000) {
                if (count > 0) {
                    lt.add(new target(r, type2, baseyear, targetyear, low, high, value));
                    count = 0;
                }
                if (gotyear) {
                    baseyear = targetyear;
                }
                targetyear = j.intValue();
                gotyear = true;
                continue;
            }
            gotyear = false;
            if (++count == 1) {
                high = low = j.floatValue();
                value = low;
            }
            if (count == 2) {
                high = j.floatValue();
                value = (low + high) / 2.0f;
            }
            if (count != 3) continue;
            value = j.floatValue();
        }
        lt.add(new target(r, type2, baseyear, targetyear, low, high, value));
        this.endtarget.put(r, targetyear);
        if (regman.nations.contains(r)) {
            this.targets.put(r, lt);
            return;
        }
        for (region sr : r.subreg(regman.nations)) {
            this.targets.put(sr, lt);
        }
    }

    public void applytargets() {
        curveset gdp = this.choosegdp.chosen == gdpopts.GDP_PPP ? this.gdp_ppp : this.gdp_mer;
        for (int y = 1990; y <= 2020; ++y) {
            this.efq.set("AAUsurplus", y, 0.0f);
        }
        for (region r : this.targets.keySet()) {
            int year = 1990;
            float tarlin = 0.0f;
            for (target t : this.targets.get(r)) {
                float bau;
                float base = this.hfos.get(r, t.baseyear) / 1000.0f;
                float target2 = (100.0f + (this.level.chosen == pledgelevel.conditional ? t.high : (this.level.chosen == pledgelevel.unconditional ? t.low : t.likely))) / 100.0f * (t.type == targettype.baseline ? this.efb.get(r, t.targetyear) : base * (t.type == targettype.intensity ? gdp.get(r, t.targetyear) / gdp.get(r, t.baseyear) : 1.0f));
                while (year <= 2007) {
                    this.efq.set(r, year, this.hfos.get(r, year) / 1000.0f);
                    ++year;
                }
                if (!(t.targetyear != 2010 || this.kyoto.chosen == kyoto_opts.real_emissions || this.kyoto.chosen != kyoto_opts.Kyoto_targets_incUSA && r.name.equals("USA"))) {
                    while (year <= 2012) {
                        bau = this.hfos.get(r, year) / 1000.0f;
                        if (target2 > bau && this.sephotair.istrue() && year <= 2020) {
                            this.efq.set("AAUsurplus", year, this.efq.get("AAUsurplus", year) + (target2 - bau) * (float)this.AAUfrac.getval() / 100.0f);
                            this.efq.set(r, year, bau);
                        } else {
                            this.efq.set(r, year, target2);
                        }
                        ++year;
                    }
                    tarlin = this.kyoto.chosen == kyoto_opts.Kyoto_targets_excUSA_prolonged ? target2 : this.hfos.get(r, 2012) / 1000.0f;
                } else {
                    while (year <= 2012) {
                        this.efq.set(r, year, this.hfos.get(r, year) / 1000.0f);
                        if (year == 2012) {
                            tarlin = this.hfos.get(r, year) / 1000.0f;
                        }
                        ++year;
                    }
                }
                while (year <= t.targetyear) {
                    bau = this.efb.get(r, year);
                    if ((tarlin = (tarlin * (float)(t.targetyear - year) + target2) / (float)(1 + t.targetyear - year)) > bau && this.sephotair.istrue() && year <= 2020) {
                        this.efq.set("AAUsurplus", year, this.efq.get("AAUsurplus", year) + (tarlin - bau) * (float)this.AAUfrac.getval() / 100.0f);
                        this.efq.set(r, year, bau);
                    } else {
                        this.efq.set(r, year, tarlin);
                    }
                    ++year;
                }
            }
        }
        for (int y = 1990; y <= 2020; ++y) {
            float surplus = this.efq.get("AAUsurplus", y);
            this.eq.emitfos.set("AAUsurplus", y, surplus);
            this.eq.emitfos_unitsCO2.set("AAUsurplus", y, surplus * 44.0f / 12.0f);
            this.eq.emitequiv.set("AAUsurplus", y, surplus * 44.0f / 12.0f);
            this.eq.emitequiv_nat.set("AAUsurplus", y, surplus * 44.0f / 12.0f);
        }
    }

    void fixEU() {
        float tot2020 = 0.0f;
        float totbase = 0.0f;
        for (region r : this.EU) {
            List<target> tt = this.targets.get(r);
            target t = tt.get(tt.size() - 1);
            tot2020 += this.hfos.get(r, t.baseyear) / 1000.0f * (100.0f + t.low) / 100.0f;
            totbase += this.hfos.get(r, 1990) / 1000.0f;
        }
        float faclow20 = 0.8f * totbase / tot2020;
        float fachigh30 = 0.7f * totbase / tot2020;
        float faclow80 = 0.2f * totbase / tot2020;
        float fachigh95 = 0.05f * totbase / tot2020;
        for (region r : this.EU) {
            List<target> tt = this.targets.get(r);
            target t = tt.get(tt.size() - 1);
            float t2low = (100.0f + t.low) * faclow80 - 100.0f;
            float t2high = (100.0f + t.high) * fachigh95 - 100.0f;
            float t2likely = (t2low + t2high) / 2.0f;
            t.low = (100.0f + t.low) * faclow20 - 100.0f;
            t.high = (100.0f + t.high) * fachigh30 - 100.0f;
            t.likely = (t.low + t.high) / 2.0f;
            tt.add(new target(r, targettype.absolute, 1990, 2050, t2low, t2high, t2likely));
            this.endtarget.put(r, 2050);
        }
        this.fixedEU = true;
    }

    public void fillhistory() {
        int y;
        for (region r : this.notarget) {
            int y2;
            for (y2 = 1990; y2 <= this.hfos.ey; ++y2) {
                this.eq.emitfos_nat.set(r, y2, this.hfos.get(r, y2) / 1000.0f);
            }
            y2 = this.hfos.ey + 1;
            while (year <= 2050) {
                this.eq.emitfos_nat.set(r, y2, Float.NaN);
                ++y2;
            }
        }
        for (y = 1990; y <= this.hfos.ey; ++y) {
            this.eq.emitfos_nat.set("bunker", y, this.eb.emitfosbase.get("bunker", y));
        }
        for (y = 1990; y <= this.hfos.ey; ++y) {
            this.eq.emitfos_nat.calctot(y);
        }
    }

    public class target {
        public region reg;
        public int baseyear;
        public int targetyear;
        public targettype type;
        public float low;
        public float high;
        public float likely;

        target(region r, targettype t, int b, int y, float l, float h, float v) {
            this.reg = r;
            this.type = t;
            this.baseyear = b;
            this.targetyear = y;
            this.low = l;
            this.high = h;
            this.likely = v;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum targettype {
        absolute,
        intensity,
        baseline;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum gdpopts {
        GDP_PPP,
        GDP_MER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum kyoto_opts {
        real_emissions,
        Kyoto_targets_excUSA,
        Kyoto_targets_excUSA_prolonged,
        Kyoto_targets_incUSA;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum pledgelevel {
        unconditional,
        conditional,
        mixed;

    }
}

