/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.regemit;

import jcm.core.complexity;
import jcm.core.cur.curveset;
import jcm.core.data.loadtable;
import jcm.core.itf.dataholder;
import jcm.core.ob.module;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.core.report;
import jcm.mod.regemit.AviaShipEmit;
import jcm.mod.socio.histsocdata;

public class histemitdata
extends module
implements dataholder {
    boolean done = false;
    public static curveset fosCO2 = new curveset(new Object[]{"fosCO2", "kilo&ton&carbon", 1750, 2014, complexity.expert});
    public static curveset epaCH4 = new curveset(new Object[]{"epaCH4", "mega&ton&CH4", 1990, 2020, 5, complexity.expert});
    public static curveset epaN2O = new curveset(new Object[]{"epaN2O", "mega&ton&N", 1990, 2020, 5, complexity.expert});

    public void initsetup() {
        if (!this.done) {
            histsocdata.fillhistdata();
            histemitdata.fillhistdata();
            this.gm(AviaShipEmit.class).aviashiphistory();
            this.done = true;
        }
    }

    public static void fillhistdata() {
        loadtable.loaddata(fosCO2, "data/hist/cdiacrows.csv", ",", false, 1.0f, 1750, 2006, 1750);
        for (Object o : histemitdata.fosCO2.map.keySet()) {
            for (int y = 1750; y <= 2006; ++y) {
                if (!(fosCO2.get(o, y) < 0.0f)) continue;
                fosCO2.set(o, y, 0.0f);
            }
        }
        loadtable.loaddata(fosCO2, "data/hist/UNFCCC_CO2emit.csv", ",", false, 0.27272728f, 1990, 2002, 1990);
        histemitdata.extendFos2007();
        loadtable.oldsplit(fosCO2);
        loadtable.loaddata(epaCH4, "data/hist/EPA_CH4.csv", "\t", false, true, 0.04761905f, 1990, 2020, 1990, 5);
        loadtable.loaddata(epaN2O, "data/hist/EPA_N2O.csv", "\t", false, true, 0.0020527858f, 1990, 2020, 1990, 5);
        histemitdata.extrapfos(2008, 2014);
        for (int y = 1750; y < 2015; ++y) {
            fosCO2.calctot(y);
        }
    }

    static void extendFos2007() {
        double[][] d = new double[][]{{5.84, 5.87, 5.8, 5.9}, {3.42, 3.38, 3.39, 3.32}, {1.23, 1.25, 1.23, 1.25}, {0.56, 0.56, 0.55, 0.55}, {0.48, 0.5, 0.52, 0.51}, {1.58, 1.59, 1.67, 1.67}, {1.57, 1.57, 1.61, 1.61}, {5.03, 5.57, 6.23, 6.72}, {1.18, 1.22, 1.28, 1.36}, {0.36, 0.36, 0.37, 0.39}, {0.35, 0.38, 0.38, 0.37}, {1.51, 1.54, 1.56, 1.64}, {1.04, 1.11, 1.17, 1.23}, {0.91, 0.96, 0.99, 1.05}};
        Object[] sets = new Object[]{"USA", "West Europe", "Japan", "Canada", "Oceania", "Russia", new String[]{"East Europe +Ukraine", "Central Asia Stans", "Turkey"}, "China", "India", "Brazil", new String[]{"Mexico", "South Africa", "Saudi Arabia", "Iran"}, new String[]{"Indonesia", "Singapore", "Malaysia", "Thailand", "South Korea", "Taiwan"}, "Other", "Bunker"};
        for (int i = 0; i < 12; ++i) {
            if (sets[i] instanceof String) {
                histemitdata.extend((String)sets[i], d[i]);
                continue;
            }
            for (String s : (String[])sets[i]) {
                histemitdata.extend(s, d[i]);
            }
        }
        for (region r : regman.nations.reg) {
            if (fosCO2.get(r, 2007) > 0.0f) continue;
            histemitdata.extend(r, d[11]);
        }
    }

    static void extend(String s, double[] d) {
        region r = regman.allreg.findreg(s);
        if (r == null) {
            report.deb("extendfos can't find region set " + s);
            return;
        }
        if (regman.nations.contains(r)) {
            histemitdata.extend(r, d);
            return;
        }
        for (region rr : r.subreg(regman.nations)) {
            histemitdata.extend(rr, d);
        }
    }

    static void extend(region r, double[] d) {
        fosCO2.set(r, 2007, (float)((double)fosCO2.get(r, 2006) * d[3] / d[2]));
    }

    static void extrapfos(int y0, int ye) {
        String lackdata = "";
        curveset GDP_PPP = histsocdata.GDP_PPP;
        for (region r : regman.nations.reg) {
            float gdp0 = GDP_PPP.get(r, y0 - 1 - 10);
            float rate = 0.0f;
            boolean ok = true;
            for (int y = y0 - 1; y < ye; ++y) {
                float gdp = GDP_PPP.get(r, y);
                if (!(!ok || gdp > 0.0f && gdp0 > 0.0f)) {
                    ok = false;
                    lackdata = lackdata + r.name + " ";
                }
                if (!ok) {
                    fosCO2.set(r, y + 1, fosCO2.get(r, y));
                    continue;
                }
                float ei = fosCO2.get(r, y) / gdp;
                if (rate == 0.0f) {
                    rate = (float)Math.pow(ei / (fosCO2.get(r, y - 10) / gdp0), 0.1f);
                }
                fosCO2.set(r, y + 1, (ei *= rate) * GDP_PPP.get(r, y + 1));
            }
        }
        if (lackdata.length() > 0) {
            report.deb("Lacking GDP data to extrapolate to 2014 for: " + lackdata);
        }
    }
}

