/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.regemit;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jcm.core.complexity;
import jcm.core.cur.curvar;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.ob.interacob;
import jcm.core.ob.loopcalc;
import jcm.core.ob.module;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.core.report;
import jcm.gui.gen.colfont;
import jcm.mod.obj.controller;
import jcm.mod.obj.globco2emit;
import jcm.mod.obj.regset;
import jcm.mod.ogas.othgasemit;
import jcm.mod.regemit.emitbase;
import jcm.mod.regemit.pledges;
import jcm.mod.regemit.shares;
import jcm.mod.socio.popgdp;

public class emitquota
extends module {
    public curveset emitfos = new curveset(new Object[]{"emitfos", "mega&ton&carbon", complexity.simplest});
    public curveset emitfos_unitsCO2 = new curveset(new Object[]{"emitfos&unitsCO2", "mega&ton&CO2", 1890, 2100, complexity.expert});
    public curveset emitfos_nat = new curveset(new Object[]{"emitfos&national", "mega&ton&carbon", 1990, 2050, complexity.expert});
    public curveset emitluc = new curveset("emitluc", "mega&ton&carbon");
    public curveset emitluc_nat = new curveset(new Object[]{"emitluc&national", "mega&ton&carbon", 1990, 2050, complexity.experimental});
    public curveset emitch4 = new curveset("emitch4", "mega&ton&CH4");
    public curveset emitch4_nat = new curveset(new Object[]{"emitch4&national", "mega&ton&CH4", 1990, 2050, complexity.expert});
    public curveset emitn2o = new curveset("emitn2o", "mega&ton&N");
    public curveset emitn2o_nat = new curveset(new Object[]{"emitn2o&national", "mega&ton&N", 1990, 2050, complexity.expert});
    public curveset emitequiv = new curveset(new Object[]{"emitCO2eq", "mega&ton&CO2", 1890, 2100, complexity.normal});
    public curveset emitequiv_nat = new curveset(new Object[]{"emitCO2eq&national", "mega&ton&CO2", 1990, 2050, complexity.experimental});
    public curveset emitfosabate;
    curveset[] regional = new curveset[]{this.emitfos, this.emitluc, this.emitch4, this.emitn2o, this.emitequiv, this.emitfos_unitsCO2, this.emitfosabate};
    curveset[] national = new curveset[]{this.emitfos_nat, this.emitluc_nat, this.emitch4_nat, this.emitn2o_nat, this.emitequiv_nat};
    Map<region, Set<region>> reg_all_nb = new HashMap<region, Set<region>>();
    region regset;
    emitbase eb;
    boolean policyscenario = true;
    public loopcalc reghistory = new loopcalc("regional-emitquota-history"){

        public void calcstep() {
            if (year < fsyfos) {
                if (year >= 1990 && year < fsyfos && !emitquota.this.policyscenario) {
                    emitquota.this.settobase_nat();
                }
                if (year >= 1990 && year < fsyfos) {
                    emitquota.this.gm(shares.class).settobase_ogas();
                }
                emitquota.this.emitfos.set("bunker", emitquota.this.eb.emitfosbase.get("bunker"));
                emitquota.this.emitfos_nat.set("bunker", emitquota.this.eb.emitfosbase.get("bunker"));
                if (year < 1990) {
                    emitquota.this.settobase();
                    emitquota.this.emitfos.calctot();
                }
                if (year >= 1990 && year < fsyfos) {
                    emitquota.this.addupnat();
                }
                emitquota.this.fillemitCO2();
            }
        }
    };
    public loopcalc regfuture = new loopcalc("regional-emitquota-future"){

        public void precalc() {
        }

        public void calcstep() {
            if (year >= fsyfos) {
                if (!emitquota.this.policyscenario) {
                    if (year <= 2050) {
                        emitquota.this.settobase_nat();
                    } else {
                        emitquota.this.settobase();
                    }
                }
                if (year <= 2050) {
                    emitquota.this.addupnat();
                }
                emitquota.this.fillemitCO2();
            }
            emitquota.this.calcequiv();
        }
    };
    public loopcalc fixregions = new loopcalc("fix-regions"){

        public void precalc() {
            for (curveset c : emitquota.this.regional) {
                try {
                    emitquota.this.gm(regset.class).clearoldregions(c);
                }
                catch (Exception e) {
                    report.deb("errror clearing " + c);
                    report.log(e);
                }
            }
            emitquota.this.regset = (region)emitquota.this.gm(regset.class).regions.chosen;
            emitquota.this.reg_all_nb.clear();
            for (region r : emitquota.this.regset.reg) {
                emitquota.this.reg_all_nb.put(r, r.subreg(regman.nations));
            }
            emitquota.this.reg_all_nb.remove("bunker");
            emitquota.this.emitfos.getOrAddCurve((Object)"bunker").color = colfont.grey;
            emitquota.this.emitfos_nat.getOrAddCurve((Object)"bunker").color = colfont.grey;
            emitquota.this.emitfos_unitsCO2.getOrAddCurve((Object)"bunker").color = colfont.grey;
            emitquota.this.emitequiv.getOrAddCurve((Object)"bunker").color = colfont.grey;
            emitquota.this.emitequiv_nat.getOrAddCurve((Object)"bunker").color = colfont.grey;
            emitquota.this.emitfos.getOrAddCurve((Object)"AAUsurplus").color = colfont.black;
            emitquota.this.emitfos_nat.getOrAddCurve((Object)"AAUsurplus").color = colfont.grey;
            emitquota.this.emitfos_unitsCO2.getOrAddCurve((Object)"AAUsurplus").color = colfont.black;
            emitquota.this.emitequiv.getOrAddCurve((Object)"AAUsurplus").color = colfont.black;
            emitquota.this.emitequiv_nat.getOrAddCurve((Object)"AAUsurplus").color = colfont.black;
            emitquota.this.emitequiv.getOrAddCurve((Object)"HFC").color = colfont.pink;
            emitquota.this.emitequiv_nat.getOrAddCurve((Object)"HFC").color = colfont.pink;
            emitquota.this.emitequiv.getOrAddCurve((Object)"CFC").color = colfont.purple;
            emitquota.this.emitequiv_nat.getOrAddCurve((Object)"CFC").color = colfont.purple;
        }
    };

    public void initsetup() {
        this.eb = this.gm(emitbase.class);
        this.regional[this.regional.length - 1] = this.emitfosabate = new curvar(curve.Type.difference, this.eb.emitfosbase, this.emitfos);
        this.emitfosabate.mycomplexity = complexity.expert;
        this.emitfos.addOb(new curvar(curve.Type.ratio, this.emitfos, this.gm(popgdp.class).pop, this.emitluc));
        this.emitequiv.addOb(new curvar(curve.Type.ratio, this.emitequiv, this.gm(popgdp.class).pop));
        this.fixregions.setaffectedby(this.gm(regset.class).regions);
        this.reghistory.setaffectedby(this.gm(regset.class).regions);
        this.reghistory.follows(this.eb.history);
        this.regfuture.follows(this.reghistory);
        this.regfuture.follows(this.gm(globco2emit.class).calcco2eq);
    }

    public void setinteractions() {
        this.policyscenario = this.gm(controller.class).objective.chosen != controller.objopt.nopolicy;
        this.reghistory.setaffectedby((interacob)this.gm(pledges.class), this.policyscenario);
        this.reghistory.setaffectedby(this.gm(controller.class).objective);
        this.regfuture.follows(this.gm(shares.class).topdown, this.policyscenario);
    }

    void addupnat() {
        for (region r : this.reg_all_nb.keySet()) {
            for (int i = 0; i < 5; ++i) {
                if (i == 1 || i == 4) continue;
                float sum = 0.0f;
                for (region rr : this.reg_all_nb.get(r)) {
                    sum += Float.isNaN(this.national[i].get(rr)) ? 0.0f : this.national[i].get(rr);
                }
                this.regional[i].set(r, sum);
            }
        }
        for (int i = 0; i < 5; ++i) {
            this.regional[i].calctot();
        }
        this.emitfos.set("bunker", this.emitfos_nat.get("bunker"));
        this.emitfos.set("AAUsurplus", this.emitfos_nat.get("AAUsurplus"));
    }

    void settobase() {
        for (region r : this.reg_all_nb.keySet()) {
            this.emitfos.set(r, this.eb.emitfosbase.get(r));
            this.emitluc.set(r, this.eb.emitlucbase.get(r));
            this.emitch4.set(r, this.eb.emitch4base.get(r));
            this.emitn2o.set(r, this.eb.emitn2obase.get(r));
        }
        this.emitfos.set("bunker", this.eb.emitfosbase.get("bunker"));
        this.emitfos.set("AAUsurplus", 0.0f);
    }

    void settobase_nat() {
        for (region r : this.reg_all_nb.keySet()) {
            this.emitluc.set(r, this.eb.emitlucbase.get(r));
            for (region rr : this.reg_all_nb.get(r)) {
                this.emitfos_nat.set(rr, this.eb.emitfosbase_nat.get(rr));
                this.emitch4_nat.set(rr, this.eb.emitch4base_nat.get(rr));
                this.emitn2o_nat.set(rr, this.eb.emitn2obase_nat.get(rr));
            }
        }
        this.emitfos_nat.set("bunker", this.eb.emitfosbase.get("bunker"));
        this.emitfos_nat.set("AAUsurplus", 0.0f);
    }

    void fillemitCO2() {
        for (region r : this.regset.reg) {
            this.emitfos_unitsCO2.set(r, this.emitfos.get(r) * 44.0f / 12.0f);
        }
        this.emitfos_unitsCO2.set("bunker", this.emitfos.get("bunker") * 44.0f / 12.0f);
        this.emitfos_unitsCO2.calctot();
    }

    void calcequiv() {
        if (year >= 1890 && year <= 2100) {
            List<region> rr = ((region)this.gm(regset.class).regions.chosen).reg;
            rr.remove("bunker");
            for (region r : rr) {
                othgasemit.gwp gwp_chosen = (othgasemit.gwp)((Object)this.gm(othgasemit.class).gwp_source.chosen);
                this.emitequiv.set(r, (this.emitfos.get(r) + this.emitluc.get(r)) * 44.0f / 12.0f + this.emitch4.get(r) * gwp_chosen.ch4 + this.emitn2o.get(r) * gwp_chosen.n2o * 44.0f / 28.0f);
            }
            this.emitequiv.set("bunker", this.emitfos.get("bunker") * 44.0f / 12.0f);
            globco2emit gc = this.gm(globco2emit.class);
            this.emitequiv.set("HFC", gc.hfc_CO2eq.get());
            this.emitequiv.set("CFC", gc.cfc_CO2eq.get());
            this.emitequiv.calctot();
            this.emitch4.calctot();
            this.emitn2o.calctot();
            this.emitluc.calctot();
        }
    }
}

