/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.ogas;

import jcm.core.complexity;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.ob.interacob;
import jcm.core.ob.module;
import jcm.core.par.param;
import jcm.gui.gen.colfont;
import jcm.indata.matchdataOld;
import jcm.mod.carbon.carboncycle;
import jcm.mod.cli.radfor;
import jcm.mod.ogas.gas;
import jcm.mod.ogas.othgasemit;

public class aerosol
extends module {
    public param sulfrf2000 = new param("sulfrf2000", "w&per&m2", -1.2, -2.4, 0, colfont.cyan);
    public param solarrf2000 = new param("solarrf2000", "w&per&m2", 0.2, 0, 0.6, colfont.orange);
    public param volcfac = new param(new Object[]{"volcfac", "", -1.0, -3.0, 0, colfont.dkorange, complexity.expert});
    public param bcocwig = new param(new Object[]{"bcocwig", false, complexity.expert});
    public param hadleyaero = new param(new Object[]{"HadA", false, complexity.experimental});
    public param futuresolar = new param(new Object[]{"futsolopt", true, complexity.expert});
    public param solardata = new param("solardata", new String[]{"Lean", "Hoyt&Schatten", "none"}, "Lean");
    public param incvolc = new param("incvolc", true);
    public curve aerorf = new curve(new Object[]{"totaerosol", colfont.cyan, complexity.simplest, curve.Type.total});
    public curve sulfdirrf = new curve("sulfdir", colfont.blue);
    public curve sulfindrf = new curve("sulfind", colfont.ltblue);
    public curve bcrf = new curve("blackcarbon", colfont.dkgrey);
    public curve ocrf = new curve("orgcarbon", colfont.ltgrey);
    public curve natvrf = new curve(new Object[]{"totnatvar", colfont.orange, complexity.simplest, curve.Type.total});
    public curve solarrf = new curve("solvar", colfont.yellow);
    public curve volcanorf = new curve("volcano", colfont.dkorange);
    public curveset aerosol = new curveset(new Object[]{this.aerorf, this.sulfdirrf, this.sulfindrf, this.bcrf, this.ocrf, this.natvrf, this.solarrf, this.volcanorf, "aerosolrf", "w&per&m2", complexity.normal});
    boolean firsttime = true;
    double se2000 = 69.0;
    double senat = 42.0;
    double sdqdir2000 = -0.4;
    double sdqind2000 = -0.8;
    double[] HoytSchattenSolar = new double[]{-0.05, -0.035, -0.02, -0.005, 0.01, 0.025, 0.04, 0.055, 0.07, 0.08, 0.09, 0.054, 0.069, 0.084, 0.094, 0.16, 0.16, 0.16, 0.183, 0.207, 0.23, 0.22, 0.21, 0.2, 0.173, 0.145, 0.118, 0.09, 0.135, 0.18, 0.11, 0.033, -0.045, -0.122, -0.2, -0.19, -0.18, -0.185, -0.19, -0.22, -0.25, -0.28, -0.293, -0.306, -0.319, -0.331, -0.344, -0.357, -0.37, -0.37, -0.37, -0.362, -0.354, -0.346, -0.338, -0.33, -0.34, -0.35, -0.328, -0.306, -0.284, -0.262, -0.241, -0.219, -0.197, -0.175, -0.153, -0.131, -0.109, -0.087, -0.066, -0.044, -0.022, 0.0, 0.018, 0.035, 0.053, 0.07, 0.073, 0.077, 0.08, 0.05, 0.02, -0.01, 0.015, 0.04, 0.065, 0.09, 0.08, 0.07, 0.06, 0.05, 0.003, -0.045, -0.092, -0.14, -0.122, -0.105, -0.087, -0.07, -0.11, -0.15, -0.157, -0.165, -0.172, -0.18, -0.175, -0.17, -0.137, -0.103, -0.07, -0.082, -0.095, -0.107, -0.12, -0.155, -0.19, -0.19, -0.19, -0.135, -0.08, -0.094, -0.108, -0.122, -0.136, -0.15, -0.148, -0.146, -0.144, -0.142, -0.14, -0.127, -0.113, -0.1, -0.17, -0.195, -0.22, -0.245, -0.27, -0.27, -0.27, -0.247, -0.223, -0.2, -0.207, -0.213, -0.22, -0.208, -0.197, -0.185, -0.173, -0.162, -0.15, -0.12, -0.09, -0.06, -0.05, -0.04, -0.042, -0.044, -0.046, -0.048, -0.05, -0.025, 0.0, 0.025, 0.05, 0.075, 0.1, 0.088, 0.075, 0.063, 0.05, 0.072, 0.094, 0.116, 0.138, 0.16, 0.148, 0.136, 0.124, 0.112, 0.1, 0.12, 0.14, 0.16, 0.18, 0.2, 0.21, 0.198, 0.185, 0.173, 0.16, 0.165, 0.17, 0.235, 0.3, 0.283, 0.267, 0.25, 0.188, 0.125, 0.063, 0.0, 0.023, 0.047, 0.07, 0.046, 0.022, -0.002, -0.026, -0.05, -0.06, -0.07, -0.065, -0.06, -0.02, 0.02, 0.06, 0.065, 0.07, 0.04, 0.01, 0.04, 0.03, 0.02, 0.07, 0.12, 0.17, 0.22, 0.27, 0.273, 0.277, 0.28, 0.235, 0.19, 0.145, 0.1, 0.195, 0.29, 0.28, 0.24, 0.2, 0.16, 0.12, 0.1, 0.09, 0.09, 0.1, 0.12, 0.15};
    double nfH = 1.0 / (this.HoytSchattenSolar[250] - this.HoytSchattenSolar[0]);
    double[] LeanSolar = new double[]{1364.655, 1364.4856, 1364.4713, 1364.5011, 1364.4661, 1364.4956, 1364.5505, 1364.6743, 1364.7921, 1364.8596, 1364.8436, 1365.0159, 1364.9268, 1364.8948, 1364.8768, 1364.738, 1364.714, 1364.9026, 1365.1284, 1365.2963, 1365.3224, 1365.2742, 1365.2576, 1365.0886, 1365.073, 1364.9504, 1364.9908, 1365.13, 1365.3407, 1365.3878, 1365.2184, 1365.3258, 1365.0697, 1364.9484, 1364.77, 1364.7765, 1365.0347, 1365.1556, 1365.0844, 1365.0612, 1364.9716, 1364.8311, 1364.8021, 1364.7446, 1364.6022, 1364.444, 1364.3721, 1364.2897, 1364.2538, 1364.2601, 1364.3076, 1364.5537, 1364.4031, 1364.2324, 1364.1881, 1364.1506, 1364.0232, 1363.9309, 1363.8656, 1363.8068, 1363.7976, 1363.8395, 1363.9207, 1364.0035, 1364.0667, 1364.1497, 1364.2391, 1364.1935, 1364.1351, 1364.1268, 1364.0815, 1364.1232, 1364.2358, 1364.2893, 1364.3669, 1364.462, 1364.5746, 1364.6865, 1364.7704, 1364.7952, 1364.8501, 1364.7161, 1364.6519, 1364.6066, 1364.675, 1364.9484, 1365.3376, 1365.4343, 1365.2535, 1365.1826, 1365.0696, 1364.92, 1364.8647, 1364.806, 1364.8508, 1364.9818, 1365.0797, 1365.1847, 1365.3846, 1365.391, 1365.1982, 1365.1567, 1365.0192, 1364.882, 1364.7728, 1364.7249, 1364.7605, 1364.8938, 1365.0951, 1365.3092, 1365.3649, 1365.2426, 1365.0697, 1364.9423, 1364.8333, 1364.7239, 1364.6573, 1364.6069, 1364.7668, 1365.0073, 1365.2471, 1365.2012, 1365.1577, 1364.9529, 1364.7947, 1364.6147, 1364.5499, 1364.563, 1364.5669, 1364.6174, 1364.7728, 1364.9196, 1364.9546, 1364.9996, 1364.901, 1364.7394, 1364.5116, 1364.4189, 1364.3615, 1364.3398, 1364.3982, 1364.6823, 1364.8152, 1364.9875, 1365.1044, 1364.9883, 1364.787, 1364.6105, 1364.5564, 1364.4856, 1364.4579, 1364.4176, 1364.4843, 1364.744, 1365.0502, 1364.882, 1365.0778, 1364.932, 1364.9508, 1364.8024, 1364.6566, 1364.587, 1364.5724, 1364.6243, 1364.7195, 1365.0414, 1365.2614, 1365.4149, 1365.3726, 1365.1373, 1364.984, 1364.9114, 1364.8347, 1364.9006, 1364.9569, 1365.1799, 1365.2997, 1365.4958, 1365.3811, 1365.3519, 1365.3588, 1365.28, 1365.2067, 1365.1062, 1365.2339, 1365.4572, 1365.8521, 1365.7859, 1365.7197, 1365.7096, 1365.6804, 1365.6616, 1365.6266, 1365.527, 1365.5911, 1365.8702, 1365.972, 1366.2172, 1366.3531, 1366.2626, 1366.022, 1365.7882, 1365.7739, 1365.6204, 1365.6467, 1365.7719, 1366.3141, 1366.6812, 1366.6552, 1366.413, 1366.2997, 1365.9115, 1365.702, 1365.6451, 1365.6605, 1365.7242, 1365.9506, 1366.1831, 1366.259, 1366.3573, 1366.348, 1366.0192, 1366.0541, 1365.7612, 1365.6792, 1365.502, 1365.6442, 1365.8557, 1366.3101, 1366.6769, 1366.6913, 1366.728, 1366.2999, 1366.2001, 1365.8145, 1365.6506, 1365.647, 1365.799, 1366.0918, 1366.657, 1366.5624, 1366.4547, 1366.3112, 1366.0377, 1365.8063, 1365.7087, 1365.6211, 1365.7489, 1366.1111, 1366.3942, 1366.6744};
    double nfL = 1.0 / ((this.LeanSolar[250] - this.LeanSolar[0]) / 4.0);
    double scf = 0.5711986642890533;
    double scf2 = 0.25;
    double edf = 0.03;
    double[] volcano = new double[]{0.0, 0.0, 0.0, 3.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.0, 0.0, 0.0, 0.0, 0.0, 12.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 22.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 27.0, 0.0, 0.0, 0.0, 0.0, 0.0, 64.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.0, 0.0, 0.0, 0.0, 0.0, 0.0, 23.0, 0.0, 0.0, 0.0, 9.0, 0.0, 0.0, 0.0, 0.0, 5.0, 0.0, 4.0, 0.0, 0.0, 0.0, 0.0, 6.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 28.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.0, 0.0, 0.0, 0.0, 10.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.0, 0.0, 0.0, 0.0, 2.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0, 0.0, 0.0, 0.0, 0.0, 4.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 13.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 23.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    double volcdecay = 0.8;
    double firstyeardecay = (1.0 - Math.exp(-this.volcdecay)) / this.volcdecay;
    double othyeardecay = Math.exp(-this.volcdecay);

    public void initsetup() {
        super.initsetup();
        this.follows(othgasemit.class);
        this.aerosol.associate(this.sulfrf2000, this.solarrf2000);
        this.gm(radfor.class).allrf.associate(this.sulfrf2000, this.solarrf2000);
        this.gm(radfor.class).allrf2.associate(this.sulfrf2000, this.solarrf2000);
        this.setaffectedby(this.gm(radfor.class).applyefficacy);
    }

    public void setinteractions() {
        this.setaffectedby((interacob)this.volcfac, this.incvolc.istrue());
        this.setaffectedby((interacob)this.solarrf2000, this.solardata.chosen != "none");
    }

    public void calcstep() {
        this.bcocrf();
        this.sulfrf();
        this.solarrf();
        this.volcrf();
        this.aerorf.set(year, this.sulfdirrf.get(year) + this.sulfindrf.get(year) + this.bcrf.get(year) + this.ocrf.get(year));
        this.natvrf.set(year, this.solarrf.get(year) + this.volcanorf.get(year));
    }

    public void postcalc() {
        this.firsttime = false;
    }

    void sulfrf() {
        if (this.hadleyaero.istrue()) {
            int hai = year < 1860 ? 0 : (year < 2100 ? year - 1860 : 240);
            this.sulfdirrf.set(year, (float)matchdataOld.hadleyaerosol[hai][0]);
            this.sulfindrf.set(year, (float)matchdataOld.hadleyaerosol[hai][1]);
        } else {
            this.sulfdirrf.set(year, (float)(this.sulfrf2000.getval() / (this.sdqdir2000 + this.sdqind2000) * (this.sdqdir2000 * (double)this.gm(othgasemit.class).soxemit.get(year) / this.se2000)));
            this.sulfindrf.set(year, (float)(this.sulfrf2000.getval() / (this.sdqdir2000 + this.sdqind2000) * (this.sdqind2000 * (Math.log(1.0 + (double)this.gm(othgasemit.class).soxemit.get(year) / this.senat) / Math.log(1.0 + this.se2000 / this.senat)))));
        }
        this.sulfdirrf.set(year, this.sulfdirrf.get(year) * this.gm(radfor.class).getefficacy(gas.sulphate));
        this.sulfindrf.set(year, this.sulfindrf.get(year) * this.gm(radfor.class).getefficacy(gas.sulphate));
    }

    void bcocrf() {
        if (this.bcocwig.istrue()) {
            float ff = this.gm(othgasemit.class).soxemit.get(year) / this.gm(othgasemit.class).soxemit.get(1990);
            float bb = (this.grossdefor(year) > 0.0f ? this.grossdefor(year) : 0.0f) / this.grossdefor(1990);
            this.bcrf.set(year, 0.2f * ff + 0.2f * bb);
            this.ocrf.set(year, -0.1f * ff - 0.4f * bb);
        } else {
            this.bcrf.set(year, 0.4f * (this.gm(othgasemit.class).coemit.get(year) + 1036.0f - this.gm(othgasemit.class).coemit.get(2000)) / 1036.0f);
            this.ocrf.set(year, -0.5f * (this.gm(othgasemit.class).coemit.get(year) + 1036.0f - this.gm(othgasemit.class).coemit.get(2000)) / 1036.0f);
        }
        if (this.hadleyaero.istrue()) {
            this.bcrf.set(year, 0.0f);
            this.ocrf.set(year, 0.0f);
        }
        this.bcrf.set(year, this.bcrf.get(year) * (float)this.sulfrf2000.getval() / -1.2f);
        this.ocrf.set(year, this.ocrf.get(year) * (float)this.sulfrf2000.getval() / -1.2f);
        this.bcrf.set(year, this.bcrf.get(year) * this.gm(radfor.class).getefficacy(gas.bc));
        this.ocrf.set(year, this.ocrf.get(year) * this.gm(radfor.class).getefficacy(gas.oc));
    }

    float grossdefor(int year) {
        return this.gm(carboncycle.class).lucf.get(year) + 5.0f * (float)(year > 1850 ? (year < 2100 ? year - 1850 : 250) : 0);
    }

    void solarrf() {
        this.solarrf.set(year, this.solardata.chosen.equals("none") ? 0.0f : (float)(this.solarrf2000.getval() * (double)this.gm(radfor.class).getefficacy(gas.solar) * (year <= 2000 ? (this.solardata.chosen.equals("Lean") ? this.nfL * (this.LeanSolar[year - 1750] - this.LeanSolar[0]) / 4.0 : this.nfH * (this.HoytSchattenSolar[year - 1750] - this.HoytSchattenSolar[0])) : (this.futuresolar.istrue() || year <= fsyog ? Math.exp(-this.edf * (double)(year - 2000)) * (this.scf2 * Math.cos(this.scf * (double)(year - 2001)) + (1.0 - this.scf2 * Math.cos(this.scf))) : 0.0))));
    }

    void volcrf() {
        this.volcanorf.set(year, this.incvolc.istrue() ? (float)((year <= 2000 ? this.volcfac.getval() * (-0.1 + this.volcano[year - 1750] * 0.1 * this.firstyeardecay) : (year < 2007 ? this.volcfac.getval() * -0.1 : (year < 2027 ? this.volcfac.getval() * (double)(2027 - year) / 20.0 * -0.1 : 0.0))) + (year > gsy ? (double)this.volcanorf.get(year - 1) * this.othyeardecay : 0.0)) * this.gm(radfor.class).getefficacy(gas.volcano) : 0.0f);
    }
}

