/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.luc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jcm.core.complexity;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.data.interpolator;
import jcm.core.ob.loopcalc;
import jcm.core.ob.module;
import jcm.core.par.param;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.gui.gen.colfont;
import jcm.mod.carbon.carboncycle;
import jcm.mod.luc.CalcLucEmit;
import jcm.mod.luc.LUCdata;
import jcm.mod.obj.controller;
import jcm.mod.obj.globco2emit;
import jcm.mod.obj.regset;
import jcm.mod.obj.sres_base;
import jcm.mod.obj.sresdata;
import jcm.mod.regemit.emitbase;
import jcm.mod.regemit.emitquota;

public class futureLUC
extends module {
    public param potlucfrac = new param(new Object[]{"potlucfrac", "", colfont.green, 0.5, 0, 2, complexity.expert});
    public param potlucconvergence = new param(new Object[]{"potlucfracConverg", "", colfont.green, 0.5, 0, 2, complexity.expert});
    public curveset potlucregquotacurves = new curveset(new Object[]{"regpotlucquota", "mega&ton&carbon", fsyluc, gey, complexity.expert});
    public curveset potlucregbasecurves = new curveset(new Object[]{"regpotlucbase", "mega&ton&carbon", fsyluc, gey, complexity.expert});
    public static curveset lucscenario = new curveset(new Object[]{"LUC SRES", "mega&ton&carbon", 2000, 2100, complexity.experimental});
    List<region> regsetreg;
    List<region> sresreg;
    interpolator sreslucinterpolator;
    CalcLucEmit cle;
    globco2emit gc;
    sres_base sb;
    Map<region, Float> potlucregbase = new HashMap<region, Float>();
    Map<region, Float> srespotluc = new HashMap<region, Float>();
    Map<region, Float> srb4conv = new HashMap<region, Float>();
    Map<region, Float> srinitial = new HashMap<region, Float>();
    Map<region, Float> sreslucemit = new HashMap<region, Float>();
    Map<region, Float> potlucregquota = new HashMap<region, Float>();
    Map<region, Float> potlucregquota_init = new HashMap<region, Float>();
    Map<region, Float> potluchist = new HashMap<region, Float>();
    Map<region, Map<region, Float>> weight = new HashMap<region, Map<region, Float>>();
    boolean nopolicy;
    float corrfac;
    float fu;
    region totalreg;
    curveset emitlucbase;
    curveset emitlucquota;
    curveset histluc;
    curveset trend = new curveset("sres-trend", "", 2000, gey);
    public loopcalc history = new loopcalc("futluc-setup"){

        public void precalc() {
            futureLUC.this.regsetreg = ((region)futureLUC.this.gm(regset.class).regions.chosen).reg;
            for (curveset qq : futureLUC.this.curvesets) {
                futureLUC.this.gm(regset.class).clearoldregions(qq);
            }
            futureLUC.this.histluc = futureLUC.this.cle.lucsource.chosen.equals("Houghton") ? LUCdata.lucCO2CAIT1 : futureLUC.this.cle.lucemit;
            futureLUC.this.fu = futureLUC.this.cle.lucsource.chosen.equals("Houghton") ? 1.0f : 1000.0f;
        }

        public void calcstep() {
            if (year < fsyluc) {
                for (region r : futureLUC.this.regsetreg) {
                    futureLUC.this.emitlucquota.set(r, futureLUC.this.emitlucbase.get(r));
                }
                futureLUC.this.emitlucbase.calctot();
                futureLUC.this.emitlucquota.calctot();
            }
            if (year == fsyluc - 1) {
                futureLUC.this.histpotluc();
                futureLUC.this.setupweights();
            }
        }
    };
    public loopcalc base = new loopcalc("futluc-base"){

        public void precalc() {
            futureLUC.this.sreslucinterpolator = new interpolator(new Object[]{sresdata.sres4luc, "SRES4", 1990, 10, futureLUC.this.gm(sres_base.class).scre, Float.valueOf(1000.0f)});
            futureLUC.this.nopolicy = futureLUC.this.gm(controller.class).objective.chosen == controller.objopt.nopolicy;
        }

        public void calcstep() {
            if (year == fsyluc - 1) {
                futureLUC.this.initfut();
            }
            if (year >= fsyluc) {
                for (region r : futureLUC.this.regsetreg) {
                    futureLUC.this.potlucregbase.put(r, Float.valueOf(futureLUC.this.potlucregbase.get(r).floatValue() + futureLUC.this.emitlucbase.get(r, year - 1) * futureLUC.this.gc.plf));
                    futureLUC.this.potlucregbasecurves.set(r, futureLUC.this.potlucregbase.get(r).floatValue());
                    futureLUC.this.emitlucbase.set(r, futureLUC.this.potlucregbase.get(r).floatValue());
                }
                futureLUC.this.potlucregbasecurves.calctot();
                float totsres4 = 0.0f;
                if (year <= 2100) {
                    lucscenario.set(futureLUC.this.totalreg, futureLUC.this.sreslucinterpolator.getdata(futureLUC.this.totalreg, year));
                }
                for (region sr : futureLUC.this.sresreg) {
                    if (year <= 2100) {
                        lucscenario.set(sr, futureLUC.this.sreslucinterpolator.getdata(sr, year));
                        futureLUC.this.sreslucemit.put(sr, Float.valueOf((float)((double)lucscenario.get(sr) + (1.0 - futureLUC.this.sb.lucconv.getval() / 100.0) * (double)(futureLUC.this.sreslucemit.get(sr).floatValue() - lucscenario.get(sr, year - 1)))));
                    } else {
                        float convfac = futureLUC.this.sreslucemit.get(sr).floatValue() < futureLUC.this.srespotluc.get(sr).floatValue() ? 1.0f : (float)futureLUC.this.potlucconvergence.getval() / 100.0f;
                        futureLUC.this.sreslucemit.put(sr, Float.valueOf(convfac * futureLUC.this.srespotluc.get(sr).floatValue() + (1.0f - convfac) * futureLUC.this.sreslucemit.get(sr).floatValue()));
                    }
                    totsres4 += futureLUC.this.sreslucemit.get(sr).floatValue();
                }
                if (totsres4 > 10.0f || totsres4 < -10.0f) {
                    futureLUC.this.corrfac = futureLUC.this.gc.lucfbase.get() / totsres4;
                }
                for (region sr : futureLUC.this.sresreg) {
                    futureLUC.this.sreslucemit.put(sr, Float.valueOf(futureLUC.this.sreslucemit.get(sr).floatValue() * futureLUC.this.corrfac));
                    futureLUC.this.srespotluc.put(sr, Float.valueOf(futureLUC.this.srespotluc.get(sr).floatValue() + futureLUC.this.sreslucemit.get(sr).floatValue() * futureLUC.this.gc.plf));
                    futureLUC.this.trend.set(sr, (futureLUC.this.sreslucemit.get(sr).floatValue() - futureLUC.this.srespotluc.get(sr).floatValue()) / futureLUC.this.srinitial.get(sr).floatValue());
                    for (region r : futureLUC.this.regsetreg) {
                        futureLUC.this.emitlucbase.set(r, futureLUC.this.emitlucbase.get(r) + futureLUC.this.weight.get(r).get(sr).floatValue() * futureLUC.this.trend.get(sr));
                    }
                }
                futureLUC.this.emitlucbase.calctot();
                region world2 = regman.world;
                float f = 0.0f;
            }
        }
    };
    public loopcalc quota = new loopcalc("futluc-quota"){

        public void calcstep() {
            if (year == fsyluc - 1) {
                for (region r : futureLUC.this.regsetreg) {
                    futureLUC.this.potlucregquota.put(r, futureLUC.this.potlucregquota_init.get(r));
                }
            }
            if (year >= fsyluc) {
                for (region r : futureLUC.this.regsetreg) {
                    futureLUC.this.potlucregquota.put(r, Float.valueOf(futureLUC.this.potlucregquota.get(r).floatValue() + futureLUC.this.emitlucquota.get(r, year - 1) * futureLUC.this.gc.plf));
                    futureLUC.this.potlucregquotacurves.set(r, futureLUC.this.potlucregquota.get(r).floatValue());
                    futureLUC.this.emitlucquota.set(r, futureLUC.this.potlucregquota.get(r).floatValue());
                }
                float divisor = year <= fsyluc ? futureLUC.this.gc.lucquota.get(year - 1) - futureLUC.this.gc.potlucquota.get(year - 1) : futureLUC.this.gc.lucfbase.get(year - 1) - futureLUC.this.gc.potlucbase.get(year - 1);
                float scaledownquota = (futureLUC.this.gm(carboncycle.class).lucf.get(year - 1) - futureLUC.this.gc.potlucquota.get(year - 1)) / divisor;
                if (year == fsyluc) {
                    scaledownquota = 1.0f;
                }
                for (region sr : futureLUC.this.sresreg) {
                    for (region r : futureLUC.this.regsetreg) {
                        futureLUC.this.emitlucquota.set(r, futureLUC.this.emitlucquota.get(r) + futureLUC.this.weight.get(r).get(sr).floatValue() * scaledownquota * futureLUC.this.trend.get(sr));
                    }
                }
                futureLUC.this.emitlucquota.calctot();
            }
        }
    };

    public void initsetup() {
        this.totalreg = regman.allreg.findreg("TOTAL");
        this.sresreg = new ArrayList<region>(6);
        List<region> sresreg_orig = regman.allreg.findreg((String)"SRES4").reg;
        for (region sr : sresreg_orig) {
            if (sr == this.totalreg) continue;
            this.sresreg.add(sr);
        }
        this.cle = this.gm(CalcLucEmit.class);
        this.gc = this.gm(globco2emit.class);
        this.sb = this.gm(sres_base.class);
        this.emitlucbase = this.gm(emitbase.class).emitlucbase;
        this.emitlucquota = this.gm(emitquota.class).emitluc;
        futureLUC.lucscenario.getOrAddCurve((Object)this.totalreg).type = curve.Type.total;
        this.history.follows(this.cle);
        this.history.setaffectedby(this.gm(regset.class).regions);
        this.base.follows(this.history);
        this.base.setaffectedby(this.sb.scenario);
        this.base.setaffectedby(this.sb.lucconv, this.potlucconvergence, this.potlucfrac);
        this.base.setaffectedby(this.gm(sres_base.class).sresext);
        this.quota.follows(this.base);
        this.quota.follows(this.gc);
    }

    void initfut() {
        for (region sr : this.sresreg) {
            Set<region> srsubnat = sr.subreg(regman.nations);
            this.srespotluc.put(sr, Float.valueOf(0.0f));
            float srli = 0.0f;
            for (region rr : srsubnat) {
                this.srespotluc.put(sr, Float.valueOf(this.srespotluc.get(sr).floatValue() + this.potluchist.get(rr).floatValue() * this.gc.plf));
                for (int i = -5; i < 0; ++i) {
                    srli += this.histluc.get(rr, fsyluc + i) / (this.fu * 5.0f);
                }
            }
            this.sreslucemit.put(sr, Float.valueOf(srli));
            this.srinitial.put(sr, Float.valueOf(srli - this.srespotluc.get(sr).floatValue()));
        }
        for (region r : this.regsetreg) {
            this.potlucregbase.put(r, Float.valueOf(0.0f));
            for (region rr : r.subreg(regman.nations)) {
                this.potlucregbase.put(r, Float.valueOf(this.potlucregbase.get(r).floatValue() + this.potluchist.get(rr).floatValue() * this.gc.plf));
            }
            this.potlucregquota_init.put(r, this.potlucregbase.get(r));
        }
    }

    void setupweights() {
        for (region r : this.regsetreg) {
            this.weight.put(r, new HashMap());
            for (region sr : this.sresreg) {
                this.weight.get(r).put(sr, Float.valueOf(0.0f));
            }
            for (region rr : r.subreg(regman.nations)) {
                for (region sr : this.sresreg) {
                    if (!sr.contains(rr)) continue;
                    float w = this.weight.get(r).get(sr).floatValue() - this.potluchist.get(rr).floatValue() * this.gc.plf;
                    for (int i = -5; i < 0; ++i) {
                        w += this.histluc.get(rr, fsyluc + i) / (this.fu * 5.0f);
                    }
                    this.weight.get(r).put(sr, Float.valueOf(w));
                }
            }
        }
    }

    void histpotluc() {
        for (region r : regman.nations.reg) {
            int y;
            this.potluchist.put(r, Float.valueOf(0.0f));
            if (this.cle.lucsource.chosen.equals("IVIGmodel")) {
                for (y = 1750; y < fsyluc; ++y) {
                    this.potluchist.put(r, Float.valueOf(this.potluchist.get(r).floatValue() + this.cle.lucemit.get(r, y) / 1000.0f));
                }
            }
            if (!this.cle.lucsource.chosen.equals("Houghton")) continue;
            for (y = 1850; y < fsyluc; ++y) {
                this.potluchist.put(r, Float.valueOf(this.potluchist.get(r).floatValue() + LUCdata.lucCO2CAIT1.get(r, y)));
            }
        }
    }
}

