/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.luc;

import jcm.mod.luc.CalcLucEmit;
import jcm.mod.luc.LUCdata;

public class biomestock {
    CalcLucEmit CLE;
    static float[] decaytime = new float[]{0.5f, 1.0f, 10.0f, 1000.0f};
    static int[][] vegCarbon = new int[][]{{0, 5, 10, 0, 0, 1, 6, 7, 64, 81, 106, 117, 69, 7, 2, 18, 29, 80, 147}, {0, 5, 10, 114, 100, 110, 100, 117, 64, 81, 84, 29, 7, 18, 10, 6, 2, 0}, {0, 16, 15, 209, 165, 215, 100, 213, 71, 81, 84, 20, 3, 8, 10, 7, 6, 0}};
    static int[][] soilCarbon = new int[][]{{0, 16, 29, 0, 0, 1, 127, 167, 206, 170, 134, 134, 98, 153, 2, 77, 153, 63, 116}, {0, 16, 29, 89, 130, 150, 160, 134, 206, 170, 170, 153, 153, 77, 60, 127, 2, 116}, {0, 16, 29, 106, 60, 140, 160, 110, 263, 170, 170, 192, 47, 88, 88, 127, 56, 116}};
    static int[][] vegRegTime = new int[][]{{0, 2, 2, 0, 0, 100, 100, 100, 80, 42, 25, 25, 18, 2, 2, 2, 2, 20, 40}, {0, 2, 2, 30, 11, 21, 22, 25, 61, 80, 49, 10, 13, 5, 6, 71, 2, 0}};
    static int[][] soilRegTime = new int[][]{{0, 2, 10, 0, 0, 100, 100, 100, 80, 42, 25, 40, 18, 2, 2, 2, 2, 20, 40}, {0, 2, 10, 30, 11, 29, 22, 33, 61, 80, 49, 10, 13, 5, 6, 71, 2, 0}};
    float[] decay = new float[4];
    float totarea;
    float vegstock;
    float soilstock;
    float soildecay;
    float potvegstock;
    float potsoilstock;
    int type;

    biomestock(int t, float f, CalcLucEmit creator) {
        this.type = t;
        this.potvegstock = this.vegstock = f;
        this.CLE = creator;
    }

    float getdecayfrac(int box) {
        boolean grassy;
        boolean bl = this.CLE.biomeclass.chosen == LUCdata.biomeclassification.A ? this.type < 3 || this.type > 12 && this.type < 17 : (grassy = this.type < 3 || this.type > 10);
        if (this.CLE.biomeclass.chosen == LUCdata.biomeclassification.A) {
            switch (box) {
                case 0: {
                    return grassy ? 0.5f : (this.type == 17 ? 0.38f : 0.33f);
                }
                case 1: {
                    return grassy ? 0.48f : 0.3f;
                }
                case 2: {
                    return grassy ? 0.0f : (this.type == 17 ? 0.3f : 0.35f);
                }
                case 3: {
                    return 0.02f;
                }
            }
        } else {
            switch (box) {
                case 0: {
                    return grassy ? 0.5f : (this.type == 4 ? 0.38f : 0.33f);
                }
                case 1: {
                    return grassy ? 0.48f : 0.3f;
                }
                case 2: {
                    return grassy ? 0.0f : (this.type == 4 ? 0.3f : 0.35f);
                }
                case 3: {
                    return 0.02f;
                }
            }
        }
        return 0.0f;
    }

    void decayregrow(int dt) {
        for (int i = 0; i < 4; ++i) {
            int n = i;
            this.decay[n] = this.decay[n] * (float)Math.exp((float)(-dt) / decaytime[i]);
        }
        this.soildecay *= (float)Math.exp((double)(-dt) * (-Math.log(0.05) / this.CLE.soildecayrate.getval()));
        this.vegstock = this.potvegstock - (this.potvegstock - this.vegstock) * (float)Math.exp((float)(-dt) / (float)vegRegTime[this.CLE.biomeclass.getchosenindex()][this.type]);
        this.soilstock = this.potsoilstock - (this.potsoilstock - this.soilstock) * (float)Math.exp((float)(-dt) / (float)soilRegTime[this.CLE.biomeclass.getchosenindex()][this.type]);
    }

    void cutdown(float area, biomestock biometo) {
        float soillossagric = (float)this.CLE.soillossagric.getval() / 100.0f;
        float soillosspast = (float)this.CLE.soillosspast.getval() / 100.0f;
        boolean grassy = this.CLE.biomeclass.chosen == LUCdata.biomeclassification.A ? this.type < 3 || this.type > 12 && this.type < 17 : this.type < 3 || this.type > 10;
        float change = area / this.totarea * this.vegstock;
        this.vegstock -= change;
        this.potvegstock -= change;
        for (int i = 0; i < 4; ++i) {
            int n = i;
            this.decay[n] = this.decay[n] + this.getdecayfrac(i) * change;
        }
        float soilloss = 0.0f;
        float soilchange = area / this.totarea * this.soilstock;
        if (this.CLE.simplemethod.istrue()) {
            soilloss = soilchange * 0.2f;
        } else {
            if (!this.CLE.grassyon.istrue() && this.type > 2) {
                soilloss = soilchange * (biometo.type == 1 ? soillossagric : soillosspast);
            }
            if (this.CLE.grassyon.istrue() && this.type > 2 && !grassy) {
                soilloss = soilchange * (biometo.type == 1 ? soillossagric : soillosspast);
            }
            if (this.CLE.grassyon.istrue() && this.type > 2 && grassy) {
                soilloss = soilchange * (biometo.type == 1 ? soillossagric : 0.0f);
            }
            if (this.type == 2) {
                soilloss = soilchange * (biometo.type == 1 ? 1.0f / (1.0f - soillosspast) * (soillossagric - soillosspast) : 0.0f);
            }
            if (this.type == 1) {
                soilloss = 0.0f;
            }
        }
        this.soildecay += soilloss;
        this.soilstock -= soilchange;
        this.potsoilstock -= soilchange;
        biometo.soilstock += soilchange - soilloss;
        this.totarea -= area;
    }

    void setregrow(float area, biomestock biomefrom) {
        this.potvegstock = (float)((double)this.potvegstock + (double)(area * (float)vegCarbon[this.CLE.ccontentset][this.type]) * 0.1 * this.CLE.vegcerror.getval());
        if (this.type > 2) {
            this.potsoilstock = (float)((double)this.potsoilstock + (double)(area * (float)soilCarbon[this.CLE.ccontentset][this.type]) * 0.1);
        }
        if (this.type == 1 || this.type == 2 && biomefrom.type != 1) {
            this.potsoilstock = this.soilstock;
        }
        if (!this.CLE.simplemethod.istrue() && this.type == 2 && biomefrom.type == 1) {
            this.potsoilstock += 1.1875f * (area / biomefrom.totarea) * biomefrom.soilstock;
        }
        this.totarea += area;
    }

    void addarea(float area) {
        this.totarea += area;
        this.vegstock = (float)((double)this.vegstock + (double)(area * (float)vegCarbon[this.CLE.ccontentset][this.type]) * 0.1 * this.CLE.vegcerror.getval());
        this.soilstock = (float)((double)this.soilstock + (double)(area * (float)soilCarbon[this.CLE.ccontentset][this.type]) * 0.1);
    }

    float totstock() {
        float totstock = this.vegstock + this.soilstock + this.soildecay;
        for (float f : this.decay) {
            totstock += f;
        }
        return totstock;
    }
}

