/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.luc;

import java.awt.Rectangle;
import java.awt.geom.Area;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jcm.core.complexity;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.ob.interacob;
import jcm.core.ob.module;
import jcm.core.par.param;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.core.reg.regpoly;
import jcm.core.report;
import jcm.gui.gen.colfont;
import jcm.mod.luc.LUCdata;
import jcm.mod.luc.biomestock;
import jcm.mod.luc.cell;

public class CalcLucEmit
extends module {
    public static String[] lucsources = new String[]{"IVIGmodel", "Houghton", "Inverse"};
    public param lucsource = new param(new Object[]{"LUC emit dataset", lucsources, "IVIGmodel", complexity.simplest});
    public param LULUCF_UNFCCC_on = new param(new Object[]{"UNFCCC LULUCF data", false, complexity.experimental});
    public param<LUCdata.biomeclassification> biomeclass = new param<LUCdata.biomeclassification>(new Object[]{"Biome classification", LUCdata.biomeclassification.values(), LUCdata.defaultBC}){

        @Override
        public void precalc() {
            CalcLucEmit.this.biomeList.setlist(((LUCdata.biomeclassification)((Object)this.chosen)).names);
            CalcLucEmit.this.biomeList.choose("Cultivated land");
            CalcLucEmit.this.countryChosenBiomes.map.clear();
            if (!((LUCdata.biomeclassification)((Object)this.chosen)).loaded) {
                LUCdata.loadHYDEdata((LUCdata.biomeclassification)((Object)this.chosen));
            }
        }
    };
    public param biomeList;
    public param countryList;
    public param FAO2002;
    public param vegcerror;
    public param isam;
    public param soildecayrate;
    public param soillossagric;
    public param soillosspast;
    public param landuseemit1990;
    public param simplemethod;
    public param grassyon;
    public param shiftcultivation;
    public param shiftcultfrac;
    public param agricfacerr;
    public curveset lucemit;
    public curveset carbonstock;
    public curveset biomeChosenCountries;
    public curveset countryChosenBiomes;
    public curveset countryChosenAP;
    public curveset countryChosenEmission;
    Map<Integer, biomestock> biomestocks;
    Map<Integer, Map<Integer, Float>> bcm;
    Set<cell> cellset;
    float oldstock;
    float newstock;
    float countryModelArea;
    float correcAFAO1970;
    float correcPFAO1970;
    public int ccontentset;

    public CalcLucEmit() {
        this.biomeList = new param(new Object[]{"Biome chosen for plot", ((LUCdata.biomeclassification)((Object)this.biomeclass.chosen)).names, "Cultivated land", complexity.expert});
        this.countryList = new param(new Object[]{"Country chosen for plot", regman.nations.reg.toArray(new region[0]), regman.nations.findormakereg("Brazil", null), complexity.expert});
        this.FAO2002 = new param(new Object[]{"use FAO agric/past rates of change", true, complexity.expert});
        this.vegcerror = new param(new Object[]{"Vegetation Carbon uncertainty factor", "", 1, 0.8, 1.2, complexity.expert});
        this.isam = new param(new Object[]{"Biome B/ISAM carbon content", true, complexity.expert});
        this.soildecayrate = new param(new Object[]{"95% soil decay time", "", 20, 0.1, 30, complexity.expert});
        this.soillossagric = new param(new Object[]{"LUC agriculture carbon loss from soil (%)", "", 20, 0, 30, complexity.expert});
        this.soillosspast = new param(new Object[]{"LUC pasture carbon loss from soil (%)", "", 5, 0, 20, complexity.expert});
        this.landuseemit1990 = new param(new Object[]{"lucfemit1990", "mega&ton&carbon&per&yr", 2158.09, 0, 3000, complexity.expert});
        this.simplemethod = new param(new Object[]{"Simple soil emissions (IVIG31)", false, complexity.experimental});
        this.grassyon = new param(new Object[]{"Grassy soil carbon", false, complexity.experimental});
        this.shiftcultivation = new param(new Object[]{"Shifting cultivation", false, complexity.experimental});
        this.shiftcultfrac = new param(new Object[]{"Shifting cultivation fraction", "", 0.05, 0.01, 0.1, complexity.experimental});
        this.agricfacerr = new param(new Object[]{"Agric/Past error factor for selected country", "", 1, 0.5, 5, complexity.experimental});
        this.lucemit = new curveset("IVIG32 model LUC emission", "kilo&ton&carbon", 1700, 2002, 1);
        this.carbonstock = new curveset("IVIG32 model Carbon Stocks", "kilo&ton&carbon", 1700, 2002, 1);
        this.biomeChosenCountries = new curveset(new Object[]{"1 Biome area all countries plot", "mega&m2", 1700, 2002, complexity.expert});
        this.countryChosenBiomes = new curveset(new Object[]{"1 Country all biomes areas plot ", "mega&m2", 1700, 2002, complexity.expert});
        this.countryChosenAP = new curveset(new Object[]{"1 Country FAOxModel areas plot", "mega&m2", 1961, 2002, complexity.expert});
        this.countryChosenEmission = new curveset(new Object[]{"1 Country all emissions datasets", "mega&ton&carbon", 1700, 2002, complexity.expert});
        this.biomestocks = new HashMap<Integer, biomestock>();
        this.bcm = new HashMap<Integer, Map<Integer, Float>>();
        this.cellset = new HashSet<cell>();
    }

    public void setinteractions() {
        for (param p : this.allparam) {
            if (p == this.lucsource) continue;
            this.setaffectedby((interacob)p, this.lucsource.chosen.equals("IVIGmodel"));
        }
        this.setaffectedby((interacob)this.landuseemit1990, this.lucsource.chosen.equals("Houghton"));
    }

    public static void main(String[] args) {
        for (region r : regman.nations.reg) {
            r.makepolys();
        }
        new LUCdata().initsetup();
        new CalcLucEmit().precalc();
    }

    public void precalc() {
        switch (this.biomeclass.getchosenindex()) {
            case 0: {
                this.ccontentset = 0;
                break;
            }
            case 1: {
                int n = this.ccontentset = !this.isam.istrue() ? 1 : 2;
            }
        }
        if (this.lucsource.chosen.equals("IVIGmodel")) {
            this.runmodel();
        }
    }

    public void runmodel() {
        CalcLucEmit.reporttime("begin CLE runmodel");
        this.countryChosenBiomes.map.clear();
        this.countryChosenAP.map.clear();
        for (region r : regman.nations.reg) {
            this.findCells(r);
            this.calcInitialStock(r);
            this.setqtcolors(r);
            for (int i = 0; i < LUCdata.periods.length; ++i) {
                if (i == 0) continue;
                if (i < 8) {
                    this.calcBiomeChangeMap(i, i - 1, r);
                }
                for (int year = LUCdata.periods[i - 1] + 1; year <= LUCdata.periods[i]; year += this.lucemit.xstep) {
                    this.calcAreaChange(i, r, year);
                    this.calcEmit(i, r, year);
                }
            }
        }
        CalcLucEmit.reporttime("end CLE runmodel");
    }

    void calcAreaChange(int i, region r, int year) {
        float totachange = 0.0f;
        float totpchange = 0.0f;
        float totHYDEachange = 0.0f;
        float totHYDEpchange = 0.0f;
        float totaptransfer = 0.0f;
        if (year > 1961 && this.FAO2002.istrue()) {
            float area;
            float totFAOachange = LUCdata.faoagr.get(r, year) - LUCdata.faoagr.get(r, year - 1);
            float totFAOpchange = LUCdata.faopast.get(r, year) - LUCdata.faopast.get(r, year - 1);
            totHYDEachange = 0.0f;
            totHYDEpchange = 0.0f;
            for (Integer f : this.bcm.keySet()) {
                for (Integer t : this.bcm.get(f).keySet()) {
                    if (f <= 0 || t <= 0) continue;
                    area = this.bcm.get(f).get(t).floatValue();
                    if (t == 1) {
                        totHYDEachange += area;
                    }
                    if (f != 1) continue;
                    totHYDEachange -= area;
                }
            }
            if (totHYDEachange == 0.0f) {
                float flag = 10.0f;
                if (!this.bcm.containsKey(1)) {
                    this.bcm.put(1, new HashMap());
                }
                if (!this.bcm.get(1).containsKey(2)) {
                    this.bcm.get(1).put(2, Float.valueOf(flag));
                }
                totHYDEachange -= flag;
            }
            float correcfaca = totFAOachange / totHYDEachange;
            for (Integer f : this.bcm.keySet()) {
                for (Integer t : this.bcm.get(f).keySet()) {
                    if (f <= 0 || t <= 0) continue;
                    area = this.bcm.get(f).get(t).floatValue();
                    if (t == 1 && f == 2) {
                        totaptransfer -= area * correcfaca;
                    }
                    if (f != 1 || t != 2) continue;
                    totaptransfer += area * correcfaca;
                }
            }
            for (Integer f : this.bcm.keySet()) {
                for (Integer t : this.bcm.get(f).keySet()) {
                    if (f <= 1 || t <= 1) continue;
                    area = this.bcm.get(f).get(t).floatValue();
                    if (f == 2) {
                        totHYDEpchange += area;
                    }
                    if (t != 2) continue;
                    totHYDEpchange += area;
                }
            }
            if (totHYDEpchange == 0.0f) {
                int biomeC = 0;
                float areaB = 0.0f;
                for (int b = 3; b < ((LUCdata.biomeclassification)((Object)this.biomeclass.chosen)).names.length; ++b) {
                    if (!this.biomestocks.containsKey(b) || !(areaB < this.biomestocks.get((Object)Integer.valueOf((int)b)).totarea)) continue;
                    areaB = this.biomestocks.get((Object)Integer.valueOf((int)b)).totarea;
                    biomeC = b;
                }
                float flag = 10.0f;
                if (!this.bcm.containsKey(biomeC)) {
                    this.bcm.put(biomeC, new HashMap());
                }
                if (!this.bcm.get(biomeC).containsKey(2)) {
                    this.bcm.get(biomeC).put(2, Float.valueOf(flag));
                }
                totHYDEachange -= flag;
            }
            float correcfacp = totHYDEpchange != 0.0f ? (totFAOpchange - totaptransfer) / totHYDEpchange : 1.0f;
            for (Integer f : this.bcm.keySet()) {
                for (Integer t : this.bcm.get(f).keySet()) {
                    float available;
                    if (f <= 0 || t <= 0) continue;
                    area = this.bcm.get(f).get(t).floatValue();
                    if (f == 1 || t == 1) {
                        area *= correcfaca;
                    }
                    if (f == 2 && t != 1) {
                        area *= -correcfacp;
                    }
                    if (f != 1 && t == 2) {
                        area *= correcfacp;
                    }
                    float f2 = available = area >= 0.0f ? this.biomestocks.get((Object)f).totarea : this.biomestocks.get((Object)t).totarea;
                    if (available < Math.abs(area)) {
                        int biomeC = 0;
                        float areaB = 0.0f;
                        for (Integer from : this.bcm.keySet()) {
                            for (Integer to : this.bcm.get(from).keySet()) {
                                if (from > 2 && areaB < this.biomestocks.get((Object)from).totarea && this.biomestocks.get((Object)from).totarea > area) {
                                    biomeC = from;
                                    areaB = this.biomestocks.get((Object)from).totarea;
                                }
                                if (to <= 2 || !(areaB < this.biomestocks.get((Object)to).totarea) || !(this.biomestocks.get((Object)to).totarea > area)) continue;
                                biomeC = to;
                                areaB = this.biomestocks.get((Object)to).totarea;
                            }
                        }
                        if (biomeC == 0) {
                            for (int b = 3; b < ((LUCdata.biomeclassification)((Object)this.biomeclass.chosen)).names.length; ++b) {
                                if (!this.biomestocks.containsKey(b) || !(areaB < this.biomestocks.get((Object)Integer.valueOf((int)b)).totarea)) continue;
                                areaB = this.biomestocks.get((Object)Integer.valueOf((int)b)).totarea;
                                biomeC = b;
                            }
                        }
                        if (area > 0.0f && biomeC > 2) {
                            f = biomeC;
                        }
                        if (area < 0.0f && biomeC > 2) {
                            t = biomeC;
                        }
                    }
                    if (!(area > 1.0f) && !(area < -1.0f)) continue;
                    this.transfer(area, f, t);
                }
            }
            this.shiftcultivation();
        } else {
            for (Integer f : this.bcm.keySet()) {
                for (Integer t : this.bcm.get(f).keySet()) {
                    float available;
                    if (f <= 0 || t <= 0) continue;
                    float area = this.bcm.get(f).get(t).floatValue();
                    float f3 = available = area >= 0.0f ? this.biomestocks.get((Object)f).totarea : this.biomestocks.get((Object)t).totarea;
                    if (available < Math.abs(area)) {
                        int biomeC = 0;
                        float areaB = 0.0f;
                        for (Integer from : this.bcm.keySet()) {
                            for (Integer to : this.bcm.get(from).keySet()) {
                                if (from > 2 && areaB < this.biomestocks.get((Object)from).totarea && this.biomestocks.get((Object)from).totarea > area) {
                                    biomeC = from;
                                    areaB = this.biomestocks.get((Object)from).totarea;
                                }
                                if (to <= 2 || !(areaB < this.biomestocks.get((Object)to).totarea) || !(this.biomestocks.get((Object)to).totarea > area)) continue;
                                biomeC = to;
                                areaB = this.biomestocks.get((Object)to).totarea;
                            }
                        }
                        if (biomeC == 0) {
                            for (int b = 3; b < ((LUCdata.biomeclassification)((Object)this.biomeclass.chosen)).names.length; ++b) {
                                if (!this.biomestocks.containsKey(b) || !(areaB < this.biomestocks.get((Object)Integer.valueOf((int)b)).totarea)) continue;
                                areaB = this.biomestocks.get((Object)Integer.valueOf((int)b)).totarea;
                                biomeC = b;
                            }
                        }
                        if (area > 0.0f && biomeC > 2) {
                            f = biomeC;
                        }
                        if (area < 0.0f && biomeC > 2) {
                            t = biomeC;
                        }
                    }
                    this.transfer(area, f, t);
                    this.shiftcultivation();
                }
            }
        }
    }

    void calcEmit(int i, region r, int year) {
        this.newstock = 0.0f;
        for (biomestock s : this.biomestocks.values()) {
            s.decayregrow(this.lucemit.xstep);
            this.newstock += s.totstock();
        }
        float emit = (this.oldstock - this.newstock) / (float)this.lucemit.xstep;
        if (Float.isNaN(emit) || Float.isInfinite(emit)) {
            emit = 0.0f;
        }
        this.oldstock = Float.isNaN(this.newstock) ? this.oldstock : this.newstock;
        this.lucemit.set(r, year, emit);
        this.carbonstock.set(r, year, this.oldstock);
        this.setcountryqts(r, year);
    }

    void transfer(float area, int f, int t) {
        if (area < 0.0f) {
            int ff = f;
            f = t;
            t = ff;
            area = -area;
        }
        this.biomestocks.get(f).cutdown(area, this.biomestocks.get(t));
        this.biomestocks.get(t).setregrow(area, this.biomestocks.get(f));
    }

    void calcInitialStock(region r) {
        this.biomestocks.clear();
        this.biomestocks.put(1, new biomestock(1, 0.0f, this));
        this.biomestocks.put(2, new biomestock(2, 0.0f, this));
        int bc = ((LUCdata.biomeclassification)((Object)this.biomeclass.chosen)).ordinal();
        for (cell c : this.cellset) {
            int x = (int)((double)(c.lon * 2.0f) + 359.5);
            int y = (int)((double)(-c.lat * 2.0f) + 180.5);
            try {
                byte biome = LUCdata.luTables[bc][0][x][y];
                if (biome == 0) continue;
                if (!this.biomestocks.containsKey(biome)) {
                    this.biomestocks.put(Integer.valueOf(biome), new biomestock(biome, 0.0f, this));
                }
                this.biomestocks.get(biome).addarea(c.area);
            }
            catch (Exception e) {
                report.deb(e, x + " " + y);
            }
        }
        this.setcountryqts(r, 1700);
        this.countryAreasCorrection(r);
        this.oldstock = 0.0f;
        for (biomestock bs : this.biomestocks.values()) {
            this.oldstock += bs.totstock();
            bs.potvegstock = bs.vegstock;
            bs.potsoilstock = bs.soilstock;
        }
    }

    void calcBiomeChangeMap(int b, int a, region r) {
        int nstep = (LUCdata.periods[b] - LUCdata.periods[a]) / this.lucemit.xstep;
        int bc = ((LUCdata.biomeclassification)((Object)this.biomeclass.chosen)).ordinal();
        this.bcm.clear();
        for (cell c : this.cellset) {
            int x = (int)((double)(c.lon * 2.0f) + 359.5);
            int y = (int)((double)(-c.lat * 2.0f) + 180.5);
            byte biomeTo = LUCdata.luTables[bc][b][x][y];
            byte biomeFrom = LUCdata.luTables[bc][a][x][y];
            if (biomeTo == biomeFrom) continue;
            if (!this.bcm.containsKey(biomeFrom)) {
                this.bcm.put(Integer.valueOf(biomeFrom), new HashMap());
            }
            if (!this.bcm.get(biomeFrom).containsKey(biomeTo)) {
                this.bcm.get(biomeFrom).put(Integer.valueOf(biomeTo), Float.valueOf(0.0f));
            }
            this.bcm.get(biomeFrom).put(Integer.valueOf(biomeTo), Float.valueOf(this.bcm.get(biomeFrom).get(biomeTo).floatValue() + c.area / (float)nstep));
        }
    }

    void shiftcultivation() {
        if (this.shiftcultivation.istrue() && this.biomestocks.get((Object)Integer.valueOf((int)1)).totarea > 100000.0f) {
            float areaB = 0.0f;
            int B = 0;
            for (int b = 3; b < ((LUCdata.biomeclassification)((Object)this.biomeclass.chosen)).names.length; ++b) {
                if (!this.biomestocks.containsKey(b) || !(areaB < this.biomestocks.get((Object)Integer.valueOf((int)b)).totarea)) continue;
                B = b;
            }
            this.transfer(this.biomestocks.get((Object)Integer.valueOf((int)1)).totarea * (float)this.shiftcultfrac.getval() / 100.0f, 1, B);
            this.transfer(this.biomestocks.get((Object)Integer.valueOf((int)1)).totarea * (float)this.shiftcultfrac.getval() / 100.0f, B, 1);
        }
    }

    void countryAreasCorrection(region r) {
        float totHYDEachange = 0.0f;
        float totHYDEpchange = 0.0f;
        if (LUCdata.countryArcviewAreas.containsKey(r) && this.countryModelArea != 0.0f) {
            float correcArea = LUCdata.countryArcviewAreas.get(r).floatValue() / this.countryModelArea - 1.0f;
            for (int b = 1; b < ((LUCdata.biomeclassification)((Object)this.biomeclass.chosen)).names.length; ++b) {
                if (!this.biomestocks.containsKey(b)) continue;
                this.biomestocks.get(b).addarea(correcArea * this.biomestocks.get((Object)Integer.valueOf((int)b)).totarea);
            }
        }
    }

    void setcountryqts(region r, int year) {
        float carea = 0.0f;
        this.biomeChosenCountries.set(r, year, this.biomestocks.containsKey(this.biomeList.getchosenindex()) ? this.biomestocks.get((Object)Integer.valueOf((int)this.biomeList.getchosenindex())).totarea : 0.0f);
        if (r == this.countryList.getchosen()) {
            this.countryChosenAP.set("Model Agric", year, this.biomestocks.get((Object)Integer.valueOf((int)1)).totarea);
            this.countryChosenAP.set("FAO Agric", year, LUCdata.faoagr.get(r, year));
            this.countryChosenAP.set("Model Past", year, this.biomestocks.get((Object)Integer.valueOf((int)2)).totarea);
            this.countryChosenAP.set("FAO Past", year, LUCdata.faopast.get(r, year));
            if (year < 2003) {
                this.countryChosenEmission.set("IVIG32 model", year, this.lucemit.get(r, year) * 0.001f);
            }
            if (year > 1989 && year < 2003) {
                this.countryChosenEmission.set("UNFCCC", year, LUCdata.lucCO2UNFCCC.get(r, year));
            }
            if (year > 1850 && year < 2001) {
                this.countryChosenEmission.set("CAIT/Houghton", year, LUCdata.lucCO2CAIT1.get(r, year));
            }
        }
        for (int b = 1; b < ((LUCdata.biomeclassification)((Object)this.biomeclass.chosen)).names.length; ++b) {
            if (!this.biomestocks.containsKey(b)) continue;
            carea += this.biomestocks.get((Object)Integer.valueOf((int)b)).totarea;
            if (r != this.countryList.getchosen() || !this.biomestocks.containsKey(b)) continue;
            this.countryChosenBiomes.set(this.biomeList.getname(b), year, this.biomestocks.get((Object)Integer.valueOf((int)b)).totarea);
        }
        this.countryModelArea = carea;
    }

    void setqtcolors(region r) {
        if (r == this.countryList.getchosen()) {
            this.countryChosenAP.addcurve(new curve("Model Agric", colfont.red, 1962, 2002));
            this.countryChosenAP.addcurve(new curve("FAO Agric", colfont.dkred, 1962, 2002));
            this.countryChosenAP.addcurve(new curve("Model Past", colfont.pink, 1962, 2002));
            this.countryChosenAP.addcurve(new curve("FAO Past", colfont.magenta, 1962, 2002));
            this.countryChosenEmission.addcurve(new curve("IVIG32 model", colfont.red, 1700, 2002));
            this.countryChosenEmission.addcurve(new curve("UNFCCC", colfont.blue, 1990, 2002));
            this.countryChosenEmission.addcurve(new curve("CAIT/Houghton", colfont.yellow, 1850, 2000));
            for (int b = 1; b < ((LUCdata.biomeclassification)((Object)this.biomeclass.chosen)).names.length; ++b) {
                if (!this.biomestocks.containsKey(b)) continue;
                this.countryChosenBiomes.addcurve(new curve(this.biomeList.getname(b), ((LUCdata.biomeclassification)((Object)this.biomeclass.chosen)).colors[b], 1700, 2002));
            }
        }
    }

    void findCells(region r) {
        this.cellset.clear();
        double area = 0.0;
        double sum = 0.0;
        double sumarea = 0.0;
        double dudarea = 0.0;
        for (regpoly p : r.polyset) {
            Area a = new Area(p);
            Rectangle box = a.getBounds();
            int step = 5;
            for (int xo = box.x; xo < box.x + box.width; xo += step) {
                int xd = Math.min(box.x + box.width - xo, step);
                for (int yo = box.y; yo < box.y + box.height; yo += step) {
                    int yd = Math.min(box.y + box.height - yo, step);
                    if (!a.intersects(xo, yo, xd, yd)) continue;
                    boolean inbox = a.contains(xo, yo, xd, yd);
                    float yi = -0.25f + (float)yo;
                    while (yi < -0.25f + (float)yo + (float)yd) {
                        area = Math.cos(Math.PI * (double)yi / 180.0);
                        float xi = 0.25f + (float)xo;
                        while (xi < 0.25f + (float)xo + (float)xd) {
                            if (inbox || a.contains(xi, yi)) {
                                cell c = new cell();
                                c.lon = xi;
                                c.lat = yi;
                                c.area = (float)(area * Math.pow(55.563, 2.0));
                                this.cellset.add(c);
                            }
                            xi = (float)((double)xi + 0.5);
                        }
                        yi = (float)((double)yi + 0.5);
                    }
                }
            }
        }
    }
}

