/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.plot;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.event.MouseInputListener;
import jcm.core.itf.menuFiller;
import jcm.core.loop;
import jcm.core.par.param;
import jcm.core.report;
import jcm.gui.doc.labman;
import jcm.gui.gen.colfont;
import jcm.gui.gen.lookandfeel;
import jcm.gui.nav.jcmAction;
import jcm.gui.nav.jcmMenu;

public class scaleview
extends JPanel
implements MouseInputListener,
menuFiller {
    param sp;
    float fac = (float)colfont.normalfont.getSize() / 12.0f;
    double origmin;
    double origmax;
    Component aboveleft;
    int lw = 0;
    int w;
    int h;
    boolean isyear = false;
    public double origin;
    public double dp;
    public double oldmax;
    public double oldmin;
    int ep;
    int op;
    boolean dragorigin = false;

    public scaleview() {
    }

    public scaleview(param sp) {
        this.sp = sp;
        sp.units.checkunitfac(sp.max() - sp.min());
        sp.units.checkunitcancel();
        sp.units.units = sp.units.units.replace("per&person", "per&capita");
        this.origmin = sp.min;
        this.origmax = sp.max;
        param.Type cfr_ignored_0 = sp.type;
        this.origin = sp.type == param.Type.Xscale ? 2000.0 : 0.0;
        this.setBackground(Color.white);
        param.Type cfr_ignored_1 = sp.type;
        if (sp.type == param.Type.Xscale && sp.units.units.equals("year")) {
            this.isyear = true;
        }
        param.Type cfr_ignored_2 = sp.type;
        this.setPreferredSize(sp.type == param.Type.Xscale ? new Dimension(0, this.isyear ? (int)(24.0f * this.fac) : (int)(45.0f * this.fac)) : new Dimension((int)(45.0f * this.fac), 0));
        this.setToolTipText(labman.getTitle(sp.getstate()));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        param.Type cfr_ignored_3 = sp.type;
        this.setCursor(new Cursor(sp.type == param.Type.Xscale ? 11 : 8));
        new jcmMenu(this);
    }

    public void fillMenu(jcmMenu popup) {
        popup.add(new jcmAction("Restore Original"){

            public void act() {
                scaleview.this.restore();
            }
        });
    }

    public void restore() {
        this.sp.min = this.origmin;
        this.sp.max = this.origmax;
        this.sp.changed = true;
        loop.golater("Scale Restore");
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.getdim();
        lookandfeel.setAntiAlias(g);
        param.Type cfr_ignored_0 = this.sp.type;
        if (this.sp.type == param.Type.Xscale) {
            g.drawLine(this.lw, 0, this.lw + this.w, 0);
        }
        param.Type cfr_ignored_1 = this.sp.type;
        if (this.sp.type == param.Type.Yscale) {
            g.drawLine(this.w - 1, 0, this.w - 1, this.h);
        }
        if (lookandfeel.bigscales.istrue()) {
            g.setFont(colfont.normalfont);
        } else {
            g.setFont(colfont.smallfont);
        }
        this.drawnums(g);
        if (lookandfeel.bigscales.istrue()) {
            g.setFont(colfont.bigfont);
        } else {
            g.setFont(colfont.normalfont);
        }
        param.Type cfr_ignored_2 = this.sp.type;
        if (this.sp.type == param.Type.Xscale && !this.isyear) {
            g.drawString(labman.getTitle(this.sp.units.units), 40, this.h - 4);
        }
        param.Type cfr_ignored_3 = this.sp.type;
        if (this.sp.type == param.Type.Yscale) {
            Graphics2D g2 = (Graphics2D)g;
            g.translate((int)(12.0f * this.fac), 20 + this.h / 2);
            g2.rotate(-1.5707963267948966);
            g.drawString(labman.getTitle(this.sp.units.units), -this.h / 3, 0);
        }
        g.setFont(colfont.normalfont);
    }

    void drawnums(Graphics g) {
        g.setColor(Color.black);
        double vststep = this.sp.units.scales / 5.0;
        double vstbase = vststep * (double)((int)Math.ceil((double)this.sp.min() / vststep));
        if (this.sp.units.scales != 0.0) {
            for (double v = vstbase; v <= (double)this.sp.max(); v += vststep) {
                int p = this.pixel(v);
                String s = this.sp.units.round(v);
                int sw = this.sw(g, s);
                param.Type cfr_ignored_0 = this.sp.type;
                if (this.sp.type == param.Type.Xscale) {
                    if (this.w > 8 && Math.abs(Math.abs(v) - this.sp.units.scales * (double)((int)(0.5 + Math.abs(v) / this.sp.units.scales))) < (double)0.01f) {
                        g.drawLine(p, 0, p, 6);
                        g.drawString(s, p - sw / 2, this.isyear ? this.h - 4 : this.h / 2 - 4);
                    } else {
                        g.drawLine(p, 0, p, 3);
                    }
                }
                param.Type cfr_ignored_1 = this.sp.type;
                if (this.sp.type != param.Type.Yscale) continue;
                if (this.w > 8 && Math.abs(Math.abs(v) - this.sp.units.scales * (double)((int)(0.5 + Math.abs(v) / this.sp.units.scales))) < (double)0.01f) {
                    g.drawLine(this.w - 6, p, this.w, p);
                    g.drawString(s, this.w - (sw + 5), p + 4);
                    continue;
                }
                g.drawLine(this.w - 3, p, this.w, p);
            }
        } else {
            report.deb("sp.units.scales=0");
        }
    }

    void getdim() {
        param.Type cfr_ignored_0 = this.sp.type;
        this.lw = this.sp.type == param.Type.Xscale && this.aboveleft != null ? this.aboveleft.getWidth() : 0;
        this.w = this.getWidth() - this.lw;
        this.h = this.getHeight();
    }

    int pixel(double v) {
        param.Type cfr_ignored_0 = this.sp.type;
        if (this.sp.type == param.Type.Xscale) {
            return (int)((double)this.lw + (double)this.w * (v - (double)this.sp.min()) / (double)this.sp.range());
        }
        return this.h - (int)((double)this.h * (v - (double)this.sp.min()) / (double)this.sp.range());
    }

    double real(int p) {
        param.Type cfr_ignored_0 = this.sp.type;
        if (this.sp.type == param.Type.Xscale) {
            return this.sp.min() + (float)(p - this.lw) * this.sp.range() / (float)this.w;
        }
        return this.sp.min() + (float)(this.h - p) * this.sp.range() / (float)this.h;
    }

    public int sw(Graphics g, String s) {
        return colfont.sw(g, s);
    }

    public void mouseDragged(MouseEvent e) {
        try {
            param.Type cfr_ignored_0 = this.sp.type;
            int n = this.ep = this.sp.type == param.Type.Xscale ? e.getX() : e.getY();
            if (this.dragorigin) {
                param.Type cfr_ignored_1 = this.sp.type;
                this.dp = (double)((float)(this.ep - this.op) * this.sp.range()) / (double)(this.sp.type == param.Type.Xscale ? -this.w : this.h);
                this.sp.max += this.dp;
                this.sp.min += this.dp;
            } else {
                this.dp = ((double)this.op - (double)this.pixel(this.sp.min)) / ((double)this.ep - (double)this.pixel(this.sp.min));
                if (this.dp < (double)0.8f) {
                    this.dp = 0.8f;
                }
                this.sp.max = (double)this.sp.min() + (double)(this.sp.max() - this.sp.min()) * this.dp;
            }
            this.op = this.ep;
            this.sp.changed = true;
            loop.gonow(false);
            this.setToolTipText(labman.getTitle(this.sp.getstate()));
            this.sp.units.checkunitfac(this.sp.max() - this.sp.min());
            this.sp.units.checkunitcancel();
            this.repaint();
        }
        catch (Exception ex) {
            report.deb("Mouse Dragging Scale => " + ex);
            this.sp.max = this.oldmax;
            this.sp.min = this.oldmin;
            this.sp.changed = true;
        }
    }

    public void mousePressed(MouseEvent e) {
        param.Type cfr_ignored_0 = this.sp.type;
        this.op = this.sp.type == param.Type.Xscale ? e.getX() : e.getY();
        boolean bl = this.dragorigin = e.getClickCount() > 1;
        if (this.dragorigin) {
            this.origin = this.real(this.op);
        }
        this.oldmax = this.sp.max;
        this.oldmin = this.sp.min;
    }

    public void mouseReleased(MouseEvent e) {
        this.dragorigin = false;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }
}

