/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.plot;

import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.par.param;
import jcm.core.reg.region;
import jcm.gui.plot.colormap;

public class qtsetcolormap
implements colormap {
    curveset qq;
    param year;
    double min;
    double max;
    boolean hasresetscale = true;
    float scalar = 1.0f;

    qtsetcolormap(curveset qq) {
        this.qq = qq;
        this.year = new param("mapyear", 2000, qq.sy, qq.ey, "");
    }

    public float getValue(region r) {
        return this.scalar * this.qq.get(r, (int)this.year.val);
    }

    public String getMapInfo(region r) {
        return "" + (float)((int)this.scalar) * this.qq.get(r, (int)this.year.val) * 100.0f / 100.0f;
    }

    public double getmin() {
        return this.min;
    }

    public double getrange() {
        if (this.max - this.min < 10.0) {
            this.scalar = 1000.0f;
            this.resetscale();
        }
        return this.max - this.min;
    }

    public void resetscale() {
        this.min = Double.MAX_VALUE;
        this.max = Double.MIN_VALUE;
        for (curve q : this.qq.mapwithouttotal().values()) {
            float f = this.scalar * q.get((int)this.year.val);
            this.min = Math.min(this.min, (double)f);
            this.max = Math.max(this.max, (double)f);
        }
        this.hasresetscale = true;
    }

    public boolean hasresetscale() {
        if (this.hasresetscale) {
            this.hasresetscale = false;
            return true;
        }
        return false;
    }
}

