/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.plot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import jcm.core.complexity;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.ob.infob;
import jcm.core.par.param;
import jcm.core.report;
import jcm.gui.doc.labman;
import jcm.gui.gen.colfont;
import jcm.gui.gen.lookandfeel;
import jcm.gui.nav.jcmAction;
import jcm.gui.nav.jcmMenu;
import jcm.gui.plot.arrow;
import jcm.gui.plot.backImage;
import jcm.gui.plot.baseplot;

public class lineplot
extends baseplot {
    boolean stacked = false;
    boolean showarrows = true;
    public int[] labyear = new int[]{1990, 2020};
    Set<arrow> arrows;
    EnumMap<curve.linestyle, BasicStroke> strokes = new EnumMap(curve.linestyle.class);
    public static int thin = 250;

    public lineplot(curveset qq) {
        this(new Object[]{qq});
    }

    public lineplot(Object[] args) {
        for (Object o : args) {
            if (o.toString().contains("stacked")) {
                this.stacked = true;
            }
            if (o instanceof curveset) {
                this.qq = (curveset)o;
            }
            try {
                this.scalesetup.add(Float.valueOf(Float.parseFloat(o.toString())));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        this.setup();
        if (this.stacked) {
            this.legend.stacked = true;
        }
    }

    void extrasavesetup(List al) {
        if (this.stacked) {
            al.add("stacked");
        }
    }

    void makescales() {
        this.xscale = this.qq.getxscale();
        this.yscale = this.qq.getyscale(this.stacked);
    }

    void makeplot() {
        this.plot = new lineplotmainpan();
    }

    public void fillMenu(jcmMenu popup) {
        curve.Type cfr_ignored_0 = this.qq.type;
        if (this.qq.type != curve.Type.ratio) {
            curve.Type cfr_ignored_1 = this.qq.type;
            if (this.qq.type != curve.Type.ratefrac) {
                popup.add(new jcmAction("Stack Curves", complexity.simplest){

                    public void act() {
                        lineplot.this.changestack();
                    }
                });
                if (this.arrows != null) {
                    popup.add(new jcmAction("Remove/Show Arrows", complexity.simplest){

                        public void act() {
                            lineplot.this.changearrows();
                        }
                    });
                }
                popup.addSeparator();
            }
        }
        super.fillMenu(popup);
    }

    void changestack() {
        this.legend.stacked = this.stacked = !this.stacked;
        this.yscale.max = this.qq.getmax(this.stacked);
        this.yscale.units.checkunitfac(this.yscale.max() - this.yscale.min());
        this.ysv.repaint();
        this.doplot();
    }

    void changearrows() {
        this.showarrows = !this.showarrows;
        this.doplot();
    }

    class lineplotmainpan
    extends JPanel
    implements MouseListener,
    MouseMotionListener {
        backImage b;
        arrow dragarrow = null;

        public lineplotmainpan() {
            this.setLayout(null);
            this.setBackground(Color.white);
            this.add(lineplot.this.info);
            lineplot.this.info.setOpaque(true);
            this.setOpaque(true);
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
            this.setCursor(new Cursor(1));
            if (lineplot.this.qq.assocparams != null) {
                lineplot.this.arrows = new HashSet<arrow>(lineplot.this.qq.assocparams.size());
                for (param p : lineplot.this.qq.assocparams) {
                    lineplot.this.arrows.add(new arrow(p, lineplot.this.xscale, lineplot.this.yscale, this));
                }
            }
        }

        public void validate() {
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            lookandfeel.setAntiAlias(g);
            g.setFont(colfont.smallfont);
            Graphics2D g2 = (Graphics2D)g;
            AffineTransform oldat = g2.getTransform();
            float xsf = (float)this.getWidth() / lineplot.this.xscale.range();
            float ysf = (float)(-this.getHeight()) / lineplot.this.yscale.range();
            float xyf = xsf / ysf;
            g2.scale(ysf, ysf);
            g2.translate(-lineplot.this.xscale.min() * xyf, -lineplot.this.yscale.max());
            float w = Math.abs(lineplot.this.yscale.range() / (float)thin);
            lineplot.this.strokes.put(curve.linestyle.line, new BasicStroke(Math.abs(lineplot.this.yscale.range()) / (float)thin));
            lineplot.this.strokes.put(curve.linestyle.dotted, new BasicStroke(w, 1, 1, w / 2.0f, new float[]{w * 1.0f, w * 4.0f}, 0.0f));
            lineplot.this.strokes.put(curve.linestyle.dashed, new BasicStroke(w, 1, 1, w / 2.0f, new float[]{w * 4.0f, w * 3.0f}, 0.0f));
            lineplot.this.strokes.put(curve.linestyle.dotdash, new BasicStroke(w, 1, 1, w / 2.0f, new float[]{w * 1.0f, w * 4.0f, w * 4.0f, w * 3.0f}, 0.0f));
            g2.setStroke(lineplot.this.strokes.get((Object)curve.linestyle.line));
            if (lineplot.this.stacked) {
                int xmin = (int)lineplot.this.xscale.min();
                int xmax = (int)lineplot.this.xscale.max();
                curve c = lineplot.this.qq.map.values().iterator().next();
                int xstep = (int)Math.max((float)c.xstep, lineplot.this.xscale.range() / (float)this.getWidth());
                if (xstep < 1) {
                    xstep = 1;
                }
                if (xmax > c.ey) {
                    xmax = c.ey;
                }
                if (xmin < c.sy) {
                    xmin = c.sy;
                }
                if (xstep > 1) {
                    xmin += (c.sy - xmin) % xstep;
                    xmax += (c.ey - xmax) % xstep;
                }
                int ns = (xmax - xmin) / xstep;
                float[] totpos = new float[1 + ns];
                float[] totneg = new float[1 + ns];
                GeneralPath basepos = new GeneralPath();
                GeneralPath baseneg = new GeneralPath();
                basepos.moveTo((float)xmin * xyf, 0.0f);
                baseneg.moveTo((float)xmin * xyf, 0.0f);
                basepos.lineTo((float)lineplot.this.qq.ey * xyf, 0.0f);
                baseneg.lineTo((float)lineplot.this.qq.ey * xyf, 0.0f);
                int x = xmin;
                int i = 0;
                while (x <= xmax) {
                    totpos[i] = 0.0f;
                    totneg[i] = 0.0f;
                    x += xstep;
                    ++i;
                }
                boolean even = true;
                boolean first = true;
                for (curve q : lineplot.this.qq.mapwithouttotal().values()) {
                    if (!q.checkcomplexity()) continue;
                    try {
                        int i2;
                        even = !even;
                        GeneralPath linepos = basepos;
                        GeneralPath lineneg = baseneg;
                        first = true;
                        int x2 = even ? xmin : xmax;
                        int n = i2 = even ? 0 : ns;
                        while (even ? x2 <= xmax : x2 >= xmin) {
                            float dy = q.gotdata(x2) ? q.get(x2) : 0.0f;
                            int n2 = i2;
                            totpos[n2] = totpos[n2] + (dy > 0.0f ? dy : 0.0f);
                            int n3 = i2;
                            totneg[n3] = totneg[n3] + (dy < 0.0f ? dy : 0.0f);
                            linepos.lineTo((float)x2 * xyf, totpos[i2]);
                            lineneg.lineTo((float)x2 * xyf, totneg[i2]);
                            if (first) {
                                basepos = new GeneralPath();
                                baseneg = new GeneralPath();
                                basepos.moveTo((float)x2 * xyf, totpos[i2]);
                                baseneg.moveTo((float)x2 * xyf, totneg[i2]);
                                first = false;
                            } else {
                                basepos.lineTo((float)x2 * xyf, totpos[i2]);
                                baseneg.lineTo((float)x2 * xyf, totneg[i2]);
                            }
                            x2 += even ? xstep : -xstep;
                            i2 += even ? 1 : -1;
                        }
                        g2.setColor(q.color);
                        g2.fill(linepos);
                        g2.fill(lineneg);
                    }
                    catch (Exception e) {
                        report.deb("! lineplot => " + e + " for curve " + q.name);
                    }
                }
            } else {
                for (curve q : lineplot.this.qq.map.values()) {
                    if (!q.checkcomplexity()) continue;
                    g2.setStroke(lineplot.this.strokes.get((Object)q.style));
                    GeneralPath line = new GeneralPath();
                    boolean haddata = false;
                    int xstep = (int)Math.max((float)q.xstep, lineplot.this.xscale.range() / (float)this.getWidth());
                    if (xstep < 1) {
                        xstep = 1;
                    }
                    for (int x = (int)lineplot.this.xscale.min(); x <= (int)lineplot.this.xscale.max(); x += xstep) {
                        if (!q.gotdata(x)) {
                            haddata = false;
                        }
                        if (q.gotdata(x) && !haddata) {
                            line.moveTo((float)x * xyf, q.get(x));
                            haddata = true;
                        }
                        if (!q.gotdata(x) || !haddata) continue;
                        line.lineTo((float)x * xyf, q.get(x));
                    }
                    g2.setColor(q.color);
                    try {
                        g2.draw(line);
                    }
                    catch (Throwable e) {}
                }
            }
            g2.setTransform(oldat);
            if (lineplot.this.labels && !lineplot.this.stacked) {
                for (curve q : lineplot.this.qq.map.values()) {
                    if (!q.checkcomplexity()) continue;
                    String s = labman.getShort(q.name);
                    int sw = colfont.sw(g, s);
                    int sh = colfont.sh(g);
                    int sd = colfont.sd(g);
                    g2.setColor(q.color);
                    for (int yr : lineplot.this.labyear) {
                        int sx = (int)(((float)yr - lineplot.this.xscale.min()) * (float)this.getWidth() / lineplot.this.xscale.range()) - sw / 2;
                        int sy = this.getHeight() - (int)((q.get(yr) - lineplot.this.yscale.min()) * (float)this.getHeight() / lineplot.this.yscale.range()) + sh / 2 - sd;
                        g.drawString(s, sx, sy);
                    }
                }
            }
            lineplot.this.ready = true;
            if (lineplot.this.showarrows && lineplot.this.arrows != null) {
                for (arrow a : lineplot.this.arrows) {
                    if (!a.checkenabled()) continue;
                    try {
                        a.getpos();
                        a.draw(g);
                    }
                    catch (Throwable e) {
                        report.deb(e, "arrow drawing error" + a + " " + e);
                    }
                }
            }
            if (this.dragarrow == null) {
                lineplot.this.info.repaint();
            }
            g2.dispose();
        }

        public void mouseMoved(MouseEvent e) {
            try {
                if (lineplot.this.showarrows && lineplot.this.arrows != null) {
                    for (arrow a : lineplot.this.arrows) {
                        if (!a.checkenabled() || !a.poly.contains(e.getPoint())) continue;
                        lineplot.this.info.setText(a.getinfo());
                        break;
                    }
                }
                infob best = null;
                float x = lineplot.this.xscale.min() + lineplot.this.xscale.range() * (float)e.getX() / (float)this.getWidth();
                float y = lineplot.this.yscale.max() - lineplot.this.yscale.range() * (float)e.getY() / (float)this.getHeight();
                float y2 = 0.0f;
                int xi = (int)((double)x + 0.5);
                if (x > lineplot.this.xscale.min() && x < lineplot.this.xscale.max() && y > lineplot.this.yscale.min() && y < lineplot.this.yscale.max()) {
                    int locx = Math.min(e.getX() + 4, this.getWidth() - lineplot.this.info.getWidth() - 4);
                    lineplot.this.info.setLocation(locx, e.getY() + 4);
                    if (lineplot.this.stacked) {
                        float sum = 0.0f;
                        for (curve q : lineplot.this.qq.mapwithouttotal().values()) {
                            if (!q.checkcomplexity()) continue;
                            y2 = q.get(xi);
                            if (Math.signum(y) == Math.signum(y2)) {
                                sum += y2;
                                best = q;
                            }
                            if (!(Math.abs(sum) > Math.abs(y))) {
                                best = null;
                                continue;
                            }
                            break;
                        }
                    } else {
                        for (curve q : lineplot.this.qq.map.values()) {
                            if (!q.checkcomplexity()) continue;
                            float y2t = q.get(xi);
                            float f = Math.abs(y2t - y);
                            float f2 = best == null ? lineplot.this.yscale.range() / 20.0f : Math.abs(y2 - y);
                            if (!(f < f2)) continue;
                            best = q;
                            y2 = y2t;
                        }
                    }
                    lineplot.this.info.setText((best == null ? "" : "<html>" + best.hashcolor() + labman.getTitle(((curve)best).name) + " </font>") + xi + ": " + lineplot.this.yscale.units.round(best == null ? y : y2, 2));
                }
                lineplot.this.info.setSize(lineplot.this.info.getPreferredSize());
            }
            catch (Throwable ex) {
                report.deb(ex, "lineplot mouse moved error");
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (this.dragarrow != null) {
                this.dragarrow.move(e.getX(), e.getY());
            }
        }

        public void mousePressed(MouseEvent e) {
            if (this.dragarrow == null && lineplot.this.showarrows && lineplot.this.arrows != null) {
                for (arrow a : lineplot.this.arrows) {
                    if (!a.poly.contains(e.getPoint())) continue;
                    this.dragarrow = a;
                    lineplot.this.info.setSize(0, 0);
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.dragarrow = null;
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
            lineplot.this.info.setText("");
            lineplot.this.info.setSize(new Dimension(0, 0));
        }
    }
}

