/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.plot;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.itf.menuFiller;
import jcm.core.itf.plotlink;
import jcm.core.loop;
import jcm.core.register;
import jcm.core.report;
import jcm.core.tls.fileio;
import jcm.gui.doc.labman;
import jcm.gui.nav.jcmAction;
import jcm.gui.nav.jcmMenu;
import jcm.gui.plot.jcmTM;

public class datable
extends JScrollPane
implements plotlink {
    jcmTM tm;
    boolean ready = false;

    public datable(final curveset qq) {
        this.setName(labman.getTitle(qq.getNameWithWorld()));
        this.setToolTipText(this.getName());
        register.addlink(this, qq);
        loop.gonow();
        this.tm = new jcmTM(qq);
        JTable tab = new JTable(this.tm);
        tab.setColumnSelectionAllowed(true);
        this.setcolor(tab, 0, Color.black);
        int c = 1;
        for (curve q : qq.map.values()) {
            this.setcolor(tab, c, q.color);
            ++c;
        }
        tab.setAutoResizeMode(0);
        this.setViewportView(tab);
        new jcmMenu(tab, new menuFiller(){

            public void fillMenu(jcmMenu pop) {
                pop.add(datable.savetablemenu(qq));
                pop.addSeparator();
                qq.fillMenu(pop);
            }
        });
        this.ready = true;
    }

    void setcolor(JTable tab, int column, final Color color) {
        tab.getColumnModel().getColumn(column).setCellRenderer(new DefaultTableCellRenderer(){

            public void setValue(Object value) {
                this.setForeground(datable.this.darken(color));
                super.setValue(value);
            }
        });
    }

    boolean ispale(Color c) {
        return c.getRed() + c.getGreen() + c.getBlue() > 650;
    }

    Color inverse(Color c) {
        return new Color(390 - c.getRed(), 390 - c.getGreen(), 390 - c.getBlue());
    }

    Color darken(Color c) {
        return c.getRed() + c.getGreen() + c.getBlue() < 650 ? c : new Color(c.getRed() - 100, c.getGreen() - 100, c.getBlue() - 100);
    }

    public void doplot() {
        try {
            this.tm.fireTableDataChanged();
            this.repaint();
        }
        catch (Exception e) {
            report.deb(e, "table plot problem");
        }
    }

    public boolean isShowing() {
        return !this.ready || super.isShowing();
    }

    static jcmMenu savetablemenu(final curveset qq) {
        jcmMenu savetable = new jcmMenu(new Object[]{"Save table"});
        for (final String s : new String[]{"csv", "tab"}) {
            savetable.add(new jcmAction(s){

                public void act() {
                    fileio f = new fileio("tables", qq.name, s, "Save Table", "save");
                    datable.savetable(f, qq, s);
                }
            });
        }
        return savetable;
    }

    public static void savetable(File f, curveset qq, String type2) {
        datable.savetable(new fileio(f), qq, type2);
    }

    static void savetable(fileio f, curveset qq, String type2) {
        if (f.os != null) {
            try {
                jcmTM tm = new jcmTM(qq);
                OutputStreamWriter fw = new OutputStreamWriter(f.os);
                int rows = tm.getRowCount();
                int cols = tm.getColumnCount();
                for (int row = 0; row < rows; ++row) {
                    String line = "";
                    for (int col = 0; col < cols; ++col) {
                        line = line + tm.getValueAt(row, col) + (type2 == "csv" ? ", " : "\t");
                    }
                    fw.write(line + "\n");
                    if (row % 50 != 0) continue;
                    fw.flush();
                }
                fw.flush();
                fw.close();
                report.log("Saved " + f.fullname + " OK");
            }
            catch (IOException e) {
                report.deb(e, "savetable error");
                e.printStackTrace();
            }
        }
    }
}

