/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.nav;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import jcm.core.report;
import jcm.gui.doc.labman;
import jcm.gui.gen.lookandfeel;
import jcm.gui.nav.showpan;

public class jcmTabbedPane
extends JTabbedPane {
    List<Rectangle> rect = new LinkedList<Rectangle>();
    JSplitPane jsp;
    List<String> names = new LinkedList<String>();

    public jcmTabbedPane() {
        this.setPreferredSize(new Dimension(100, 200));
        this.addMouseListener(showpan.moulist);
        this.addMouseMotionListener(showpan.moulist);
        this.setOpaque(false);
        showpan.addpanmenu(this);
    }

    public void addTab(String s, Component c) {
        this.addTab(s, null, c);
    }

    public void addTab(String s, Icon i, Component c) {
        this.names.add(s);
        super.addTab(labman.getTitle(s), i, c);
        int n = this.getTabCount() - 1;
        this.setToolTipTextAt(n, labman.getTitle(this.names.get(n)));
        this.adjustToSpace();
    }

    void adjustToSpace() {
        int n;
        if (this.getTabRunCount() < 2) {
            for (n = 0; n < this.getTabCount(); ++n) {
                this.setTitleAt(n, labman.getTitle(this.names.get(n)));
            }
        }
        this.revalidate();
        if (this.getTabRunCount() > 1) {
            for (n = 0; n < this.getTabCount(); ++n) {
                this.setTitleAt(n, labman.getShort(this.names.get(n)));
            }
        }
        this.revalidate();
        if (this.getTabRunCount() > 1) {
            for (n = 0; n < this.getTabCount(); ++n) {
                this.setTitleAt(n, "");
            }
        }
    }

    public void doLayout() {
        try {
            super.doLayout();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void remove(int i) {
        this.remove(this.getComponentAt(i));
    }

    public void remove(Component c) {
        int i = this.indexOfComponent(c);
        this.names.remove(i);
        super.remove(c);
        try {
            c.removeNotify();
        }
        catch (Exception e) {
            report.deb(e, " removing tabbed pane");
        }
        c = null;
        this.revalidate();
        this.adjustToSpace();
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.adjustToSpace();
    }

    public void paintComponent(Graphics g) {
        try {
            lookandfeel.setAntiAlias(g);
            super.paintComponent(g);
            this.rect.clear();
            for (int i = 0; i < this.getTabCount(); ++i) {
                Rectangle r = this.getUI().getTabBounds(this, i);
                int w = 9;
                int h = 9;
                int x = r.x + r.width - 5 - w;
                int y = r.y + r.height / 2 - h / 2;
                this.rect.add(new Rectangle(x, y, w, h));
                g.setColor(Color.red);
                g.drawRoundRect(x, y, w, h, 4, 4);
                g.drawLine(x + w, y, x, y + h);
                g.drawLine(x, y, x + w, y + h);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    int intab(MouseEvent e) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (!this.getUI().getTabBounds(this, i).contains(e.getPoint())) continue;
            return i;
        }
        return -1;
    }

    void tryclose(MouseEvent e) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (!this.rect.get(i).contains(e.getPoint())) continue;
            this.remove(i);
        }
    }
}

