/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.gen;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.File;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import jcm.core.complexity;
import jcm.core.par.param;
import jcm.core.register;
import jcm.core.report;
import jcm.core.tls.fileio;
import jcm.gui.gen.colfont;
import jcm.gui.nav.showpan;
import jcm.java6methods;

public class lookandfeel {
    static final MetalTheme ocean = MetalLookAndFeel.getCurrentTheme();
    static final MetalTheme metal = new DefaultMetalTheme();
    static UIManager.LookAndFeelInfo systemlf;
    static UIManager.LookAndFeelInfo substance;
    static UIManager.LookAndFeelInfo nimrod;
    static UIManager.LookAndFeelInfo lastchosen;
    static UIManager.LookAndFeelInfo deflaf;
    public static boolean gotmac;
    public static param antiAlias;
    public static param fontSize;
    public static param bigscales;
    public static param<UIManager.LookAndFeelInfo> lookAndFeelParam;
    public static param macMenuBar;

    public static void setFontSizeForFrame() {
        int size = (int)(12.0 * (double)showpan.mf.getWidth() / 1024.0);
        if (size < 8) {
            size = 10;
        }
        if (size > 16) {
            size = 16;
        }
        if ((int)fontSize.getval() != size) {
            fontSize.set(size);
        }
    }

    public static void setAntiAlias(Graphics g) {
        if (antiAlias.istrue()) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
    }

    static void setlf(UIManager.LookAndFeelInfo lfi) {
        if (lfi != null) {
            String name = lfi.getName();
            String classname = lfi.getClassName();
            if (name.startsWith("Metal")) {
                MetalLookAndFeel.setCurrentTheme(metal);
            }
            if (name.equals("Ocean")) {
                MetalLookAndFeel.setCurrentTheme(ocean);
            }
            try {
                UIManager.setLookAndFeel(classname);
                report.deb("L&F updating UI");
                if (showpan.mf != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SwingUtilities.updateComponentTreeUI(showpan.mf);
                        }
                    });
                }
            }
            catch (Exception ex) {
                report.deb(ex, "problem for " + classname + " look & feel: ");
            }
        }
    }

    static {
        gotmac = false;
        try {
            String[][] elfs;
            for (UIManager.LookAndFeelInfo lafi : UIManager.getInstalledLookAndFeels()) {
                if (!lafi.getName().contains("Mac")) continue;
                gotmac = true;
                report.deb("Found Mac Look and Feel");
            }
            UIManager.installLookAndFeel("Ocean", "javax.swing.plaf.metal.MetalLookAndFeel");
            java6methods.installSubstance();
            for (String[] elf : elfs = fileio.loadtab(new File(fileio.getOutDir("lookfeel"), "lookandfeel.info"), ",")) {
                if (elf.length <= 0) continue;
                UIManager.installLookAndFeel(elf[0], elf[1]);
            }
        }
        catch (Exception ex) {
            report.deb(ex, "look&feel install not complete: ");
        }
        for (UIManager.LookAndFeelInfo lafi : UIManager.getInstalledLookAndFeels()) {
            if (lafi.getClassName().equals(UIManager.getSystemLookAndFeelClassName())) {
                systemlf = lafi;
            }
            if (lafi.getName().equals("Substance")) {
                substance = lafi;
            }
            if (!lafi.getName().equals("NimROD")) continue;
            nimrod = lafi;
        }
        deflaf = gotmac ? systemlf : (nimrod != null ? nimrod : (substance != null ? substance : systemlf));
        antiAlias = new param(new Object[]{"AntiAlias", true}){

            public void precalc() {
                if (showpan.mf != null) {
                    showpan.mf.repaint();
                }
            }
        };
        fontSize = new param(new Object[]{"FontSize", "", Float.valueOf(12.0f), Float.valueOf(0.0f), Float.valueOf(36.0f), complexity.simplest}){

            public void precalc() {
                colfont.setFontSize(this.val);
                if (showpan.mf != null) {
                    showpan.mf.repaint();
                }
            }
        };
        bigscales = new param(new Object[]{"Larger Scales", false}){

            public void precalc() {
                if (showpan.mf != null) {
                    showpan.mf.repaint();
                }
            }
        };
        lookAndFeelParam = new param<UIManager.LookAndFeelInfo>(new Object[]{"lookandfeelmenu", UIManager.getInstalledLookAndFeels(), deflaf, complexity.simplest}){

            @Override
            public void precalc() {
                if (this.chosen != null && !((UIManager.LookAndFeelInfo)this.chosen).equals(lastchosen)) {
                    lookandfeel.setlf((UIManager.LookAndFeelInfo)this.getchosen());
                }
                lastchosen = (UIManager.LookAndFeelInfo)this.chosen;
            }
        };
        macMenuBar = new param(new Object[]{"Use Mac Menu Bar", false}){

            public void precalc() {
                System.setProperty("apple.laf.useScreenMenuBar", Boolean.toString(this.istrue()));
                if (lastchosen.getName().contains("Mac")) {
                    lookandfeel.setlf(lastchosen);
                }
            }
        };
        register.setAlwaysOutput(lookAndFeelParam);
        register.setAlwaysOutput(antiAlias);
        register.setAlwaysOutput(fontSize);
        register.setAlwaysOutput(bigscales);
        if (gotmac) {
            register.setAlwaysOutput(macMenuBar);
        }
    }
}

