/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.gen;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JButton;
import jcm.core.complexity;
import jcm.core.par.param;
import jcm.gui.doc.labman;
import jcm.gui.gen.colfont;
import jcm.gui.gen.lookandfeel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Gauge
extends JButton
implements MouseListener,
MouseMotionListener {
    public int lev;
    public int max;
    public int ov = -1;
    int w;
    int h;
    int xs = 6;
    int ys = 5;
    Color ca = colfont.dkred;
    Color cb = colfont.dkgreen;
    Color cc = colfont.orange;
    param<complexity> p;

    public Gauge(int l, int n) {
        this.lev = l;
        this.max = n;
        this.setSize();
    }

    public Gauge(param<complexity> p) {
        this.p = p;
        this.lev = ((complexity)((Object)p.chosen)).ordinal();
        complexity cfr_ignored_0 = (complexity)((Object)p.chosen);
        this.max = complexity.values().length;
        this.setTip();
        this.setSize();
    }

    void setSize() {
        this.w = this.max * this.xs + 2;
        this.h = this.max * this.ys + 4;
        Dimension d = new Dimension(this.w + 4, this.h + 2);
        this.setPreferredSize(d);
        this.setMinimumSize(d);
        this.setMaximumSize(d);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    void setTip() {
        this.setToolTipText(labman.getShort("complexity&colon&" + ((complexity)((Object)this.p.chosen)).toString()));
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        lookandfeel.setAntiAlias(g);
        for (int i = 0; i < this.max; ++i) {
            int bh = (i + 1) * this.ys;
            Color base = i == this.ov ? this.cc : (i <= this.lev ? this.ca : this.cb);
            g.setColor(base.brighter());
            g.drawRect(1 + i * this.xs, this.h - (i + 1) * this.ys - 2, this.xs - 1, bh);
            g.setColor(base.darker());
            g.drawRect(2 + i * this.xs, this.h - (i + 1) * this.ys - 1, this.xs - 2, bh - 1);
            g.setColor(base);
            g.fillRect(2 + i * this.xs, this.h - (i + 1) * this.ys - 1, this.xs - 2, bh - 1);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int nov = e.getX() / this.xs;
        if (nov != this.ov) {
            this.ov = nov;
            this.repaint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int nov = e.getX() / this.xs;
        this.lev = this.ov;
        if (this.p != null) {
            this.p.set(this.lev);
            this.setTip();
        }
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.ov = -1;
        this.repaint();
    }
}

