/*
 * Decompiled with CFR 0.152.
 */
package jcm.gui.doc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Stack;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.html.FormSubmitEvent;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.rtf.RTFEditorKit;
import jcm.core.complexity;
import jcm.core.itf.hasSetupInfo;
import jcm.core.itf.menuFiller;
import jcm.core.itf.plotlink;
import jcm.core.loop;
import jcm.core.ob.infob;
import jcm.core.par.param;
import jcm.core.register;
import jcm.core.report;
import jcm.core.setup;
import jcm.core.tls.cs;
import jcm.core.tls.txt;
import jcm.gui.doc.autodoc;
import jcm.gui.doc.labdoctable;
import jcm.gui.doc.label;
import jcm.gui.doc.labman;
import jcm.gui.doc.sourceview;
import jcm.gui.gen.colfont;
import jcm.gui.gen.iconFinder;
import jcm.gui.gen.lookandfeel;
import jcm.gui.nav.jcmAction;
import jcm.gui.nav.jcmMenu;
import jcm.gui.nav.jcmTabbedPane;
import jcm.gui.nav.showpan;
import jcm.java6methods;

public class docview
extends JPanel
implements DocumentListener,
plotlink,
menuFiller,
hasSetupInfo {
    public param<label.langcode> language;
    public static param helpmode = new param("helpmode", false);
    public static param autosave = new param("autosave", true);
    public String page;
    public static docview current;
    JSplitPane jsp;
    JCMEditorPane ep;
    JPanel edit;
    JTextField search;
    JTextField key;
    JTextField tfs;
    JTextField tfm;
    JTextField tfc;
    JTextField tfi;
    JLabel jlc;
    JLabel jli;
    JLabel jls;
    JLabel jlm;
    JLabel jld;
    JLabel changeddate;
    JTextArea tal;
    JTextArea tal2;
    label curlab;
    label.langcode lang;
    Stack<String> history;
    Stack<String> forward;
    boolean changepage;
    boolean showedit;
    boolean showhtml;
    static long timelastsave;
    static int countchanges;

    public docview() {
        this("welcome");
    }

    public docview(Object o) {
        this(o.toString());
    }

    public docview(String startpage) {
        this.language = new param(new Object[]{"languagemenu", label.langcode.values(), labman.language.chosen});
        this.page = "mainmenu";
        this.jsp = new JSplitPane();
        this.ep = new JCMEditorPane();
        this.edit = new JPanel(new GridBagLayout());
        this.search = new JTextField();
        this.key = new JTextField();
        this.tfs = new JTextField();
        this.tfm = new JTextField();
        this.tfc = new JTextField();
        this.tfi = new JTextField();
        this.jlc = new JLabel(" cat ");
        this.jli = new JLabel(" info ");
        this.jls = new JLabel(" sho ");
        this.jlm = new JLabel(" med ");
        this.jld = new JLabel(" chg ");
        this.changeddate = new JLabel("");
        this.tal = new JTextArea();
        this.tal2 = new JTextArea();
        this.history = new Stack();
        this.forward = new Stack();
        this.changepage = true;
        this.showedit = false;
        this.showhtml = false;
        this.setupcomponents();
        this.makeeditlayout();
        this.makemenus();
        current = this;
        this.page = startpage;
        this.page = this.page.trim().replace(" ", "_");
        this.setpage(this.page);
        register.addlink(this, complexity.defaultcomplexity);
        register.addlink(this, lookandfeel.fontSize);
        register.addlink(this, lookandfeel.antiAlias);
        this.language.register();
        register.addlink(this, this.language);
    }

    void setupcomponents() {
        this.setLayout(new BorderLayout());
        this.jsp.setName("JCM Documentation");
        this.jsp.setOrientation(1);
        this.jsp.setPreferredSize(new Dimension(400, 600));
        this.add((Component)this.jsp, "Center");
        this.setPreferredSize(new Dimension(400, 600));
        this.tfs.getDocument().addDocumentListener(this);
        this.tfm.getDocument().addDocumentListener(this);
        this.tfc.getDocument().addDocumentListener(this);
        this.tfi.getDocument().addDocumentListener(this);
        this.tfc.setMinimumSize(new Dimension(50, 16));
        this.tal.getDocument().addDocumentListener(this);
        this.tal.setFont(colfont.normalfont);
        this.tal2.setFont(colfont.normalfont);
        this.tal2.setEditable(false);
        this.tal2.setForeground(colfont.brown);
        this.tal2.setWrapStyleWord(true);
        this.tal.setWrapStyleWord(true);
        this.tal.setLineWrap(true);
        this.tal2.setLineWrap(true);
        JPanel docpan = new JPanel(new BorderLayout());
        JCMEditorPane top = new JCMEditorPane();
        top.setText(autodoc.maketopmenu());
        docpan.add((Component)top, "North");
        docpan.add((Component)new JScrollPane(this.ep), "Center");
        this.jsp.setLeftComponent(docpan);
        this.jsp.setRightComponent(this.edit);
        this.jsp.setResizeWeight(1.0);
    }

    void makeeditlayout() {
        JSplitPane editsp = new JSplitPane(0, new JScrollPane(this.tal), new JScrollPane(this.tal2));
        editsp.setResizeWeight(0.7);
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.fill = 2;
        c.gridx = 0;
        this.edit.add((Component)this.jlc, c);
        c.gridx = 1;
        this.edit.add((Component)this.tfc, c);
        c.gridx = 2;
        this.edit.add((Component)this.jli, c);
        c.gridx = 3;
        this.edit.add((Component)this.tfi, c);
        c.gridy = 1;
        c.gridx = 0;
        this.edit.add((Component)this.jls, c);
        c.gridx = 1;
        c.gridwidth = 0;
        this.edit.add((Component)this.tfs, c);
        c.gridy = 2;
        c.gridx = 0;
        this.edit.add((Component)this.jlm, c);
        c.gridx = 1;
        this.edit.add((Component)this.tfm, c);
        c.gridy = 3;
        c.gridx = 0;
        this.edit.add((Component)this.jld, c);
        c.gridx = 1;
        this.edit.add((Component)this.changeddate, c);
        c.gridy = 4;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.gridx = 0;
        this.edit.add((Component)editsp, c);
    }

    public void savesetup() {
        List al = register.getargs(this);
        al.clear();
        al.add(this.page);
    }

    public void showpage() {
        this.lang = (label.langcode)((Object)this.language.chosen);
        long changed = 0L;
        for (label.smd t : label.smd.values()) {
            changed = Math.max(changed, this.curlab.getchanged(this.lang, t));
        }
        this.changeddate.setText(changed == 0L ? "" : new Date(changed).toGMTString());
        labman.currentlangchooser = this.language;
        final Rectangle r = this.changepage ? new Rectangle(1, 1, 1, 1) : new Rectangle(this.ep.getVisibleRect());
        this.ep.setText(autodoc.makedoc(this.page));
        labman.currentlangchooser = labman.language;
        r.x = 0;
        r.width = this.ep.getWidth() - 10;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                docview.this.ep.scrollRectToVisible(r);
            }
        });
    }

    public void doplot() {
        this.setpage(this.page);
    }

    public void setpage(String newpage) {
        jcmTabbedPane t;
        if ((newpage = newpage.trim().replace(" ", "_")).equals("back")) {
            if (!this.history.isEmpty()) {
                this.forward.push(this.page);
                this.page = this.history.pop();
            }
        } else if (newpage.equals("forward")) {
            if (!this.forward.isEmpty()) {
                this.history.push(this.page);
                this.page = this.forward.pop();
            }
        } else {
            this.history.push(this.page);
            this.page = newpage;
            autodoc.visited.add(newpage);
        }
        report.deb("show doc page " + this.page);
        Container c = this.getParent();
        if (c instanceof jcmTabbedPane && (t = (jcmTabbedPane)c).getSelectedComponent().equals(this)) {
            t.setTitleAt(t.getSelectedIndex(), labman.getTitle(this.page));
            t.setIconAt(t.getSelectedIndex(), iconFinder.findIcon(this.page));
        }
        this.curlab = labman.getLabel(this.page);
        if (this.curlab == null) {
            this.curlab = new label(this.page, "new");
        }
        this.changepage = true;
        labman.currentlangchooser = this.language;
        this.tfs.setText(this.curlab.getorig((label.langcode)((Object)this.language.chosen), label.smd.s));
        this.tfm.setText(this.curlab.getorig((label.langcode)((Object)this.language.chosen), label.smd.m));
        this.tfi.setText(this.curlab.getorig((label.langcode)((Object)this.language.chosen), label.smd.i));
        this.tfc.setText(this.curlab.cat);
        this.tal.setText(this.curlab.getorig((label.langcode)((Object)this.language.chosen), label.smd.d));
        infob i = autodoc.findob(this.page);
        this.tal2.setText(i == null ? "" : i.getExtraDoc());
        this.key.setText(this.page);
        this.changepage = false;
        this.setName(this.page);
        this.showpage();
    }

    public void changedUpdate(DocumentEvent e) {
        this.updatedoc(e);
    }

    public void removeUpdate(DocumentEvent e) {
        this.updatedoc(e);
    }

    public void insertUpdate(DocumentEvent e) {
        this.updatedoc(e);
    }

    public void updatedoc(DocumentEvent e) {
        if (this.curlab != null && !this.changepage) {
            if (this.curlab.cat.equals("new")) {
                labman.addLabel(this.page, this.curlab);
            }
            Document doc = e.getDocument();
            if (e.getDocument() == this.tal.getDocument()) {
                this.curlab.set(this.lang, label.smd.d, this.nullifempty(this.tal.getText()));
            } else if (doc == this.tfm.getDocument()) {
                this.curlab.set(this.lang, label.smd.m, this.nullifempty(this.tfm.getText()));
            } else if (doc == this.tfs.getDocument()) {
                this.curlab.set(this.lang, label.smd.s, this.nullifempty(this.tfs.getText()));
            } else if (doc == this.tfi.getDocument()) {
                this.curlab.set(this.lang, label.smd.i, this.nullifempty(this.tfi.getText()));
            } else if (doc == this.tfc.getDocument()) {
                this.curlab.cat = this.tfc.getText();
                this.curlab.setchanged(this.lang);
                labman.category.add(this.tfc.getText());
            }
            this.showpage();
            this.autosave();
        }
    }

    String nullifempty(String s) {
        return s.equals("") ? null : s;
    }

    void autosave() {
        if (autosave.istrue()) {
            long timesincesave = System.currentTimeMillis() - timelastsave;
            if (++countchanges % 50 == 0) {
                report.deb("doc-edit (unsaved): " + countchanges + " changes during " + timesincesave / 60000L + " minutes");
            }
            if (countchanges > 250 && timesincesave > 60000L || countchanges > 50 && timesincesave > 120000L || countchanges > 10 && timesincesave > 300000L) {
                loop.waitUntilLoopDone();
                labman.saveonexit();
                setup.savesetupdefault();
                report.log("Auto-saved labdoc and setup OK");
                System.gc();
                countchanges = 0;
                timelastsave = System.currentTimeMillis();
            }
        }
    }

    void makemenus() {
        new jcmMenu(this.tal, this);
        new jcmMenu(this.tal2, this);
        final JMenuBar mb = new JMenuBar();
        mb.add(this.language.getMenuItem());
        jcmMenu editmenu = new jcmMenu(new Object[]{"Edit Doc"});
        editmenu.add(new JCheckBoxMenuItem(new jcmAction("Edit Doc Source"){

            public void act() {
                boolean bl = docview.this.showedit = !docview.this.showedit;
                if (docview.this.showedit) {
                    docview.this.edit.setVisible(true);
                    docview.this.jsp.setDividerLocation(0.6);
                    docview.this.setpage(docview.this.page);
                } else {
                    docview.this.edit.setVisible(false);
                }
            }
        }));
        editmenu.add(new JCheckBoxMenuItem(new jcmAction("Show HTML"){

            public void act() {
                docview.this.showhtml = !docview.this.showhtml;
                docview.this.ep.setContentType("text/" + (docview.this.showhtml ? "plain;" : "html;"));
                docview.this.ep.setup();
                docview.this.showpage();
            }
        }));
        editmenu.addSeparator();
        editmenu.add(labman.loadchangesaction);
        editmenu.add(labman.savechangesaction);
        editmenu.add(labman.savecopyaction);
        editmenu.add(autosave);
        editmenu.addSeparator();
        editmenu.add(showpan.pan(labdoctable.class));
        editmenu.add(showpan.pan("New Doc Window", docview.class, this.page));
        editmenu.add(showpan.pan("Help about Edit-Doc", docview.class, "EditDoc"));
        editmenu.add(new JCheckBoxMenuItem(new jcmAction("Print"){

            public void act() {
                docview.this.print();
            }
        }));
        editmenu.add(new JCheckBoxMenuItem(new jcmAction("Export RTF", complexity.experimental){

            public void act() {
                docview.this.exportRTF();
            }
        }));
        editmenu.add(new jcmAction("Change Key"){

            public void act() {
                String newkey = JOptionPane.showInputDialog(docview.this.ep, "New name for this label/doc item?", docview.this.curlab.key).trim().replace(" ", "_");
                docview.this.curlab.changekey(newkey);
                docview.this.setpage(newkey);
            }
        });
        editmenu.add(new jcmAction("Delete Key"){

            public void act() {
                docview.this.curlab.setdeleted(docview.this.lang);
                docview.this.setpage(docview.this.key.getText());
            }
        });
        mb.add(editmenu);
        this.key.setPreferredSize(new Dimension(120, 16));
        mb.add(new JLabel("key:"));
        mb.add(this.key);
        this.key.addActionListener(new jcmAction("Goto Item"){

            public void act() {
                docview.this.setpage(docview.this.key.getText());
            }
        });
        mb.add(new JLabel("search"));
        mb.add(this.search);
        this.search.addActionListener(new jcmAction("Search"){

            public void act() {
                labman.search(docview.this.search.getText(), false, false);
                docview.this.setpage("docsearch");
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                docview.this.edit.setVisible(false);
                docview.this.add((Component)mb, "North");
            }
        });
    }

    public void fillMenu(jcmMenu popup) {
        String text = ((JTextArea)popup.getInvoker()).getText();
        popup.add("goto subcomponent: ");
        cs s = new cs(text);
        int i = 0;
        while ((i = s.s.indexOf("\u00a3", i) + 2) > 1) {
            int j = s.nextspace(i);
            final String link = s.s.substring(i, j);
            popup.add(new jcmAction(link){

                public void act() {
                    docview.this.setpage(link);
                }
            });
            i = j;
        }
    }

    public static jcmAction showdocaction(final infob o) {
        jcmAction a = new jcmAction("Doc&" + o.name, o.mycomplexity){

            public void act() {
                if (helpmode.istrue()) {
                    docview.helponclick(o.name);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            showpan.makepan(docview.class, o.name, new Object[0]);
                        }
                    });
                }
            }
        };
        a.addIcon(o.name, o, docview.class);
        return a;
    }

    public static void helponclick(final String name) {
        if (helpmode.istrue()) {
            if (current == null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        showpan.makepan(docview.class, name, new Object[0]);
                    }
                });
            } else {
                current.setpage(name);
                showpan.toFront(current);
            }
        }
    }

    public void removeNotify() {
        if (current == this) {
            current = null;
        }
        super.removeNotify();
    }

    public void addNotify() {
        current = this;
        super.addNotify();
    }

    public void print() {
        java6methods.print(this.ep);
    }

    public void exportRTF() {
        Document doc = this.ep.getDocument();
        RTFEditorKit rtfEditorKit = new RTFEditorKit();
        try {
            FileOutputStream fo = new FileOutputStream("/java/jcm/jcm-svn/test.rtf");
            rtfEditorKit.write(fo, doc, 0, doc.getLength());
            report.deb("exported RTF OK");
            fo.close();
        }
        catch (IOException ex) {
            report.deb("problem creating RTF: " + ex);
        }
        catch (BadLocationException ex) {
            report.deb("problem creating RTF: " + ex);
        }
    }

    static {
        timelastsave = System.currentTimeMillis();
        countchanges = 0;
    }

    public class JCMEditorPane
    extends JEditorPane
    implements HyperlinkListener,
    MouseListener {
        public JCMEditorPane() {
            this.setContentType("text/html;");
            this.setup();
            this.fixkit();
        }

        void fixkit() {
            EditorKit kit = this.getEditorKit();
            if (kit instanceof HTMLEditorKit) {
                ((HTMLEditorKit)kit).setAutoFormSubmission(false);
            }
        }

        public void paintComponent(Graphics g) {
            lookandfeel.setAntiAlias(g);
            super.paintComponent(g);
        }

        void setup() {
            this.setEditable(false);
            this.addHyperlinkListener(this);
            this.addMouseListener(this);
            try {
                ((HTMLDocument)this.getDocument()).setBase(register.class.getResource("/png/"));
            }
            catch (Exception e) {
                report.deb(e);
            }
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                report.log("linkto: " + e.getDescription());
            }
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String s = e.getDescription();
                if (e instanceof FormSubmitEvent) {
                    s = ((FormSubmitEvent)e).getData();
                    report.deb("HTML Form data: " + ((FormSubmitEvent)e).getData());
                    s = s.replace("=", "!");
                }
                if (s.startsWith("#")) {
                    docview.this.ep.scrollToReference(e.getDescription().substring(1));
                    return;
                }
                if (s.indexOf("!") > 0) {
                    String[] ss = txt.split(s, "!");
                    if (ss[0].equals("source")) {
                        showpan.makepan(sourceview.class, "src/" + ss[1].replace(".", "/") + ".java", new Object[0]);
                    }
                    if (ss[0].equals("setup")) {
                        setup.loadpacksetup(ss[1].replace(".", "/"));
                    }
                    return;
                }
                docview.this.setpage(s);
            }
        }
    }
}

