/*
 * Decompiled with CFR 0.152.
 */
package jcm.core.tls;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import jcm.JNLP_methods;
import jcm.core.report;
import jcm.gui.nav.showpan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class fileio {
    static String outdirname = "jcmout";
    static File outdir = null;
    public static String lastloaded = null;
    public String subfolder;
    public String name;
    public String extension;
    public String fullname;
    public OutputStream os;
    boolean usingJWSsandbox = false;

    public static URL getURL(String filename) {
        return fileio.class.getResource("/" + filename);
    }

    public static Enumeration<JarEntry> getJarEntries(URL u) {
        try {
            JarURLConnection j = (JarURLConnection)u.openConnection();
            return j.getJarFile().entries();
        }
        catch (Exception e) {
            report.log(e, "Can't find Jar of : " + u);
            return null;
        }
    }

    static InputStream getStream(String filename) {
        return fileio.class.getResourceAsStream("/" + filename);
    }

    static InputStream getStream(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (IOException e) {
            report.deb(e);
            return null;
        }
    }

    static BufferedInputStream getBuffStream(String filename) {
        return new BufferedInputStream(fileio.getStream(filename));
    }

    static LineNumberReader getLNR(String filename) {
        return new LineNumberReader(new BufferedReader(new InputStreamReader(fileio.getStream(filename))));
    }

    public static DataInputStream getDIS(String filename) {
        return new DataInputStream(fileio.getBuffStream(filename));
    }

    static InputStream getStreamFromDialog(String subfolder, String name, String title) {
        try {
            try {
                File f = fileio.getFileFromDialog(subfolder, name, title, "load");
                return new FileInputStream(f);
            }
            catch (SecurityException e) {
                return JNLP_methods.JWS_fos_IS();
            }
        }
        catch (Exception e) {
            report.msg(e, "Problem Opening File");
            return null;
        }
    }

    public static String[][] loadtab(String filename, String separator) {
        return fileio.loadtab(fileio.getStream(filename), separator);
    }

    public static String[][] loadtab(File file, String separator) {
        return fileio.loadtab(fileio.getStream(file), separator);
    }

    public static String[][] loadtabfromdialog(String subfolder, String name, String title, String separator) {
        return fileio.loadtab(fileio.getStreamFromDialog(subfolder, name, title), separator);
    }

    public static String[][] loadtabfrompersist(String subfolder, String name, String separator) {
        return JNLP_methods.JWS_loadtabfrompersist(subfolder, name, separator);
    }

    public static String[][] loadtab(InputStream is, String separator) {
        LineNumberReader lnr = new LineNumberReader(new BufferedReader(new InputStreamReader(is)));
        ArrayList<String[]> as = new ArrayList<String[]>();
        ArrayList<String> a = new ArrayList<String>();
        try {
            String s;
            while ((s = lnr.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(s, separator);
                a.clear();
                while (st.hasMoreTokens()) {
                    a.add(st.nextToken().trim());
                }
                as.add(a.toArray(new String[a.size()]));
            }
        }
        catch (IOException e) {
            report.deb(e);
        }
        return (String[][])as.toArray((T[])new String[as.size()][]);
    }

    public static String loadstring(String filename) {
        return fileio.loadstring(filename, null);
    }

    public static String loadstring(String filename, String encoding) {
        return fileio.loadstring(fileio.getBuffStream(filename), filename, encoding);
    }

    public static String loadstring(File file, String encoding) {
        return fileio.loadstring(new BufferedInputStream(fileio.getStream(file)), file.getAbsolutePath(), encoding);
    }

    static String loadstring(File file) {
        return fileio.loadstring(new BufferedInputStream(fileio.getStream(file)), file.getAbsolutePath(), null);
    }

    static String loadstring(BufferedInputStream bis, String filename, String encoding) {
        StringBuffer sb = new StringBuffer();
        try {
            new InputStreamReader((InputStream)bis, encoding);
        }
        catch (Exception e) {
            encoding = null;
        }
        try {
            if (encoding != null) {
                int db;
                InputStreamReader isr = new InputStreamReader((InputStream)bis, encoding);
                while ((db = isr.read()) != -1) {
                    sb.append((char)db);
                }
                isr.close();
            } else {
                int db;
                while ((db = bis.read()) != -1) {
                    sb.append((char)db);
                }
                bis.close();
            }
        }
        catch (IOException e) {
            if (fileio.getURL(filename) == null) {
                report.deb("! Couldn't locate file: " + filename);
                return "";
            }
            report.deb(e, "IO Error loading " + filename);
            return "";
        }
        return sb.toString();
    }

    static int readnext(InputStreamReader isr) {
        try {
            return isr.read();
        }
        catch (IOException e) {
            report.deb(e);
            try {
                isr.skip(1L);
            }
            catch (IOException e2) {
                report.deb(e2, "noskip ");
            }
            return 0;
        }
    }

    public static String loadtextfile(String filename) {
        try {
            int db;
            StringBuffer sb = new StringBuffer();
            FileReader fr = new FileReader(filename);
            while ((db = fr.read()) != -1) {
                sb.append((char)db);
            }
            fr.close();
            return sb.toString();
        }
        catch (IOException e) {
            report.log(e, "IO Error loading " + filename);
            return "";
        }
    }

    static float[] loadfloat(String a, int len) {
        try {
            DataInputStream dis = new DataInputStream(new FileInputStream(new File(a)));
            float[] f = new float[len];
            for (int i = 0; i < len; ++i) {
                f[i] = dis.readFloat();
            }
            dis.close();
            return f;
        }
        catch (IOException e) {
            report.log(e, "loadfloat: " + a);
            return null;
        }
    }

    static File getOutDir() {
        if (outdir != null) {
            return outdir;
        }
        String base = fileio.class.getClassLoader().toString().contains("jnlp") ? "user.home" : "user.dir";
        String basedir = System.getProperty(base);
        if (basedir.endsWith("dist")) {
            basedir = basedir.substring(0, basedir.length() - 5);
        }
        report.deb("home directory is " + basedir);
        File f = new File(basedir + File.separator + outdirname);
        fileio.makedir(f);
        outdir = f;
        return f;
    }

    public static File getOutDir(String subfolder) {
        File f = new File(fileio.getOutDir(), subfolder);
        fileio.makedir(f);
        report.deb("dirpath= " + f.getAbsolutePath() + " " + f.isDirectory());
        return f;
    }

    public static void setDefDir() {
        try {
            try {
                outdir = fileio.getFileFromDialog("", "", "Choose Default Directory", "select");
                fileio.makedir(outdir);
            }
            catch (SecurityException e) {
                JNLP_methods.JWS_setdir();
            }
        }
        catch (Exception e) {
            report.msg(e, "Can't Select Directory");
        }
    }

    static void makedir(File f) {
        if (!f.isDirectory()) {
            try {
                f.mkdir();
            }
            catch (Exception e) {
                report.msg(e, "Couldn't Make Directory " + f.getAbsolutePath());
            }
        }
    }

    public static void savetextfile(String name, String text) {
        try {
            fileio.savetextfile(new FileWriter(new File("").getPath() + name), text);
        }
        catch (IOException e) {
            report.msg(e, "Couldn't Save " + name);
        }
    }

    public static void savetextfile(File dir, String name, String text, String encoding) {
        String s = dir.getPath() + "/" + name;
        try {
            fileio.savetextfile(new OutputStreamWriter((OutputStream)new FileOutputStream(s), encoding), text);
        }
        catch (IOException e) {
            report.msg(e, "Couldn't Save " + s);
        }
    }

    public static void savetextfile(String subfolder, String name, String text) {
        try {
            try {
                File f = new File(fileio.getOutDir(subfolder), name);
                fileio.savetextfile(new FileWriter(f), text);
            }
            catch (SecurityException e) {
                fileio.savetextfile(new OutputStreamWriter(JNLP_methods.JWS_PS_getOutputStream(name)), text);
            }
        }
        catch (IOException e) {
            report.msg(e, "Couldn't Save " + name);
        }
    }

    public static void savetextfile(OutputStreamWriter f, String text) {
        try {
            for (int a = 0; a < text.length(); a += 100) {
                int b = text.length() - a;
                f.write(text, a, b > 100 ? 100 : b);
                f.flush();
            }
            report.log("- saved OK");
            f.close();
        }
        catch (IOException e) {
            report.msg(e, "Couldn't Save Text File ");
        }
    }

    public fileio(File f) {
        try {
            this.fullname = f.getName();
            this.os = new FileOutputStream(f);
        }
        catch (IOException e) {
            report.msg(e, "Can't Get File " + this.fullname);
            this.os = null;
        }
    }

    public fileio(String subfolder, String suggestname, String extension, String title, String action) {
        this.subfolder = subfolder;
        this.name = suggestname;
        this.extension = extension;
        this.fullname = this.name + "." + extension;
        try {
            File f = fileio.getFileFromDialog(subfolder, this.fullname, title, action);
            this.fullname = f.getName();
            try {
                this.os = new FileOutputStream(f);
            }
            catch (IOException e) {
                report.msg(e, "Can't Get File " + this.fullname);
                this.os = null;
            }
        }
        catch (SecurityException e) {
            this.usingJWSsandbox = true;
            this.os = new ByteArrayOutputStream();
        }
    }

    public void save() {
        try {
            if (this.usingJWSsandbox) {
                this.fullname = JNLP_methods.JWS_sfd_getfilename(this.os, this.name, this.extension);
            } else {
                this.os.flush();
                this.os.close();
            }
            report.log("Saved " + this.fullname + " OK");
        }
        catch (Exception e) {
            report.msg(e, "Problem Saving " + this.fullname);
        }
    }

    public static File getFileFromDialog(String dirpath, String filename, String title, String action) {
        JFileChooser fc = new JFileChooser(fileio.getOutDir(dirpath));
        fc.setDialogTitle(title);
        fc.setSelectedFile(new File(filename));
        JFrame c = showpan.mf;
        if (filename.equals("")) {
            fc.setFileSelectionMode(1);
        }
        int result = action == "save" ? fc.showSaveDialog(c) : (action == "load" ? fc.showOpenDialog(c) : fc.showDialog(c, action));
        return result == 0 ? fc.getSelectedFile() : null;
    }
}

