/*
 * Decompiled with CFR 0.152.
 */
package jcm.core;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.OutputStreamWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import jcm.core.complexity;
import jcm.core.cur.curvar;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.cur.makederiv;
import jcm.core.itf.hasSetupInfo;
import jcm.core.loop;
import jcm.core.ob.infob;
import jcm.core.ob.interacob;
import jcm.core.ob.root;
import jcm.core.ob.world;
import jcm.core.par.param;
import jcm.core.register;
import jcm.core.report;
import jcm.core.tls.fileio;
import jcm.gui.doc.labman;
import jcm.gui.gen.lookandfeel;
import jcm.gui.gen.splash;
import jcm.gui.nav.jcmAction;
import jcm.gui.nav.jcmMenu;
import jcm.gui.nav.jcmTabbedPane;
import jcm.gui.nav.jcmTree;
import jcm.gui.nav.showpan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class setup {
    public static String savedir = "setup";
    public static String current = "current";
    public static boolean loadcurrent = true;
    public static boolean doingsetup = false;
    public static boolean restart = false;
    static Rectangle orig;
    static Rectangle newr;
    static float sx;
    static float sy;
    static JFrame mf;
    static Set<JComponent> onTop;

    public static void fillMenu(jcmMenu setupm) {
        setupm.add(new jcmAction("Reset All Parameters", complexity.simplest){

            public void act() {
                register.resetall(true, false);
            }
        });
        setupm.add(new jcmAction("Reset Sci-Model Params"){

            public void act() {
                register.resetall(false, false);
            }
        });
        setupm.add(new jcmAction("Reset Sci-Model Params +Force All Calc"){

            public void act() {
                register.resetall(false, true);
            }
        });
        setupm.addSeparator();
        setupm.add(new jcmAction("Load Setup"){

            public void act() {
                setup.loadsetupdialog();
            }
        });
        setupm.add(new jcmAction("Save Setup"){

            public void act() {
                setup.savesetupdialog();
            }
        });
        setupm.add(new jcmAction("Set Directory"){

            public void act() {
                fileio.setDefDir();
            }
        });
        setupm.addSeparator();
        setup.makemenu(setupm, root.rootob.find("defsetup"));
        setupm.addSeparator();
    }

    static void makemenu(jcmMenu m, infob io) {
        for (infob o : io.getObs()) {
            String s1;
            if (o.getObs() != null) {
                s1 = o.toString().substring(o.toString().lastIndexOf(".") + 1);
                jcmMenu m2 = new jcmMenu(new Object[]{s1, complexity.simplest});
                setup.makemenu(m2, o);
                m.add(m2);
                continue;
            }
            s1 = o.toString();
            int ld = s1.lastIndexOf(".");
            final String s2 = s1.substring(s1.lastIndexOf(".", ld - 1) + 1, ld);
            final String s3 = s1.substring(0, ld).replace(".", "/") + ".jcms";
            m.add(new jcmAction(s2, complexity.simplest){

                public void act() {
                    report.deb("called loadsetup from menu action");
                    setup.loadsetup(fileio.loadtab(s3, "\t"), s2);
                }
            });
        }
    }

    public static void savesetupdialog() {
        fileio f = new fileio(savedir, current, "jcms", "Save Setup", "save");
        fileio.savetextfile(new OutputStreamWriter(f.os), setup.savesetup());
        f.save();
    }

    public static void savesetupdefault() {
        fileio.savetextfile(savedir, current + ".jcms", setup.savesetup());
    }

    public static String savesetup() {
        mf = showpan.mf;
        String list = "";
        for (world world2 : world.worlds) {
            list = list + "world\t" + world2.getName() + "\t" + world2.getColor().getRed() + "\t" + world2.getColor().getGreen() + "\t" + world2.getColor().getBlue() + "\n";
        }
        for (interacob interacob2 : register.alliobs) {
            if (interacob2 instanceof param && !((param)interacob2).isdefault()) {
                list = list + "param\t" + ((param)interacob2).save();
            }
            if (!(interacob2 instanceof curveset) || !((curveset)interacob2).temporary) continue;
            list = list + setup.saveqtset((curveset)interacob2);
        }
        list = list + setup.savemainwin();
        list = list + setup.recordSplit((JSplitPane)mf.getContentPane()) + "\n";
        for (WeakReference weakReference : register.winmap.keySet()) {
            if (weakReference.get() == null || ((JComponent)weakReference.get()).getParent() == null || !((JComponent)weakReference.get()).getRootPane().isShowing()) continue;
            list = list + setup.savecomp(weakReference);
        }
        return list;
    }

    public static boolean loadcurrentsetup() {
        report.deb("called loadcurrentsetup");
        try {
            if (loadcurrent && setup.loadsetup(fileio.loadtabfrompersist(savedir, current + ".jcms", "\t"), current)) {
                return true;
            }
        }
        catch (Exception e) {
            report.deb(e);
        }
        return setup.loadpacksetup("default");
    }

    static boolean loadsetupdialog() {
        report.deb("called loadsetupdialog");
        return setup.loadsetup(fileio.loadtabfromdialog(savedir, current + ".jcms", "Load Setup", "\t"), fileio.lastloaded);
    }

    public static boolean loadpacksetup(String s) {
        report.deb("called loadpacksetup");
        return setup.loadsetup(fileio.loadtab("defsetup/" + s + ".jcms", "\t"), s);
    }

    static boolean loadsetup(final String[][] list, final String name) {
        if (SwingUtilities.isEventDispatchThread()) {
            report.deb("starting new thread for loading setup");
            new Thread("Setup Thread"){

                public void run() {
                    setup.loadsetup2(list, name);
                }
            }.start();
            try {
                while (doingsetup) {
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException ex) {
                report.deb(ex, "waiting for setup to finish interrupted");
            }
            return true;
        }
        return setup.loadsetup2(list, name);
    }

    static boolean loadsetup2(String[][] list, String name) {
        if (list.length == 0) {
            return false;
        }
        doingsetup = true;
        report.deb("setup start");
        setup.invoke(new String[]{"closeold"});
        for (String[] s : list) {
            setup.invoke(s);
        }
        setup.invoke(new String[]{"loopgonow"});
        setup.setontop();
        report.deb("setup finished");
        doingsetup = false;
        if (restart) {
            restart = false;
            setup.loadcurrentsetup();
        }
        return true;
    }

    static void invoke(final String[] s) {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                report.deb("error - shouldn't call setup from Event Dispatch Thread! - setup ignored ");
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        setup.setup(s);
                    }
                });
            }
        }
        catch (Exception ex) {
            String a = "";
            for (String ss : s) {
                a = a + " _ " + ss;
            }
            report.deb(ex, "setup error " + a);
        }
    }

    static void setup(String[] s) {
        if (restart) {
            return;
        }
        if (s.length == 0) {
            return;
        }
        String type2 = s[0];
        if (type2.equals("closeold")) {
            setup.closeold();
        }
        if (type2.equals("loopgonow")) {
            loop.gonow();
        }
        if (s[0].equals("worlds")) {
            for (int i = 1; i < s.length; ++i) {
                String[] s2 = new String[]{"world", s[i]};
                setup.setup(s2);
            }
            return;
        }
        if (s[0].equals("window") && s[1].equals("Main")) {
            String[] s2 = new String[]{"mainwin", s[4], s[5], s[2], s[3], "maximised"};
            setup.setup(s2);
            return;
        }
        if (s[0].equals("window")) {
            String[] s2 = new String[s.length + 1];
            s2[0] = "panel";
            s2[1] = s[1];
            s2[2] = s[4];
            s2[3] = s[5];
            s2[4] = s[2];
            s2[5] = s[3];
            s2[6] = "true";
            for (int i = 6; i < s.length; ++i) {
                s2[i + 1] = s[i];
            }
            setup.setup(s2);
            return;
        }
        mf = showpan.mf;
        loop.waitUntilLoopDone();
        String all = "Setup: ";
        for (String ss : s) {
            all = all + " \t " + ss;
        }
        splash.report(all);
        try {
            interacob i;
            if (s[0].equals("world")) {
                String wname = s[1];
                Color wcol = s.length > 2 ? new Color(Integer.parseInt(s[2]), Integer.parseInt(s[3]), Integer.parseInt(s[4])) : Color.black;
                world.makeworld(wname, wcol);
            }
            if (s[0].equals("param") && (i = register.findiobfullname(s[1])) != null) {
                ((param)i).load(s[2]);
                if (mf != null) {
                    mf.validate();
                }
            }
            if (s[0].equals("qtset")) {
                setup.addqtset(s);
            }
            if (s[0].equals("split")) {
                if (mf == null) {
                    showpan.makeMainframeDefSize();
                }
                setup.applySplit(s, 1, (JSplitPane)mf.getContentPane());
            }
            if (s[0].equals("mainwin")) {
                setup.setmainwin(s);
            }
            if (s[0].equals("panel")) {
                setup.loadcomp(s);
            }
        }
        catch (Exception e) {
            report.deb(e, "setup error ");
            e.printStackTrace();
        }
    }

    static String saveqtset(curveset qq) {
        String s = "qtset\t" + (Object)((Object)qq.type);
        if (qq.name.startsWith("Compare&")) {
            s = s + "\t" + qq.owner.name + "\t" + qq.name;
        }
        if (qq instanceof curvar) {
            curvar qv = (curvar)qq;
            if (qv.linkqq != null) {
                for (curveset qqb : qv.linkqq) {
                    s = s + "\t" + qqb.getFullName();
                }
            }
        }
        return s + "\n";
    }

    static void addqtset(String[] s) {
        curve.Type type2 = null;
        ArrayList<curveset> lqq = new ArrayList<curveset>(3);
        block0: for (int i = 1; i < s.length; ++i) {
            String ss = s[i];
            if (type2 == null) {
                for (curve.Type ty : curve.Type.values()) {
                    if (!ty.toString().equals(ss)) continue;
                    type2 = ty;
                    continue block0;
                }
            }
            if (ss.startsWith("Compare&")) {
                makederiv.addderiv((curveset)lqq.get(0), makederiv.compareworld((curveset)lqq.get(0), ss.substring(8)));
                return;
            }
            interacob io = register.findiobfullname(ss);
            if (!(io instanceof curveset)) continue;
            lqq.add((curveset)io);
        }
        if (type2 == null) {
            report.deb("can't match type " + s[2]);
            return;
        }
        makederiv.addnewderiv(type2, lqq);
    }

    static void setname(String name) {
        showpan.mf.setTitle(showpan.mf.getTitle() + " :-" + name);
    }

    static String savemainwin() {
        Point loc = mf.getLocationOnScreen();
        loc.translate(8, 8);
        boolean mfonscreen = showpan.screenbounds().contains(loc);
        return "mainwin" + setup.sizelocinfo(mf) + "\t" + (mfonscreen ? (mf.getExtendedState() == 6 ? "maximised" : "normal") : "other_screen") + "\n";
    }

    static void setmainwin(String[] s) {
        orig = new Rectangle(setup.pin(s[1]), setup.pin(s[2]), setup.pin(s[3]), setup.pin(s[4]));
        if (s.length > 5 && s[5].equals("maximised")) {
            if (mf == null) {
                mf = showpan.makeMainframeMaximised();
            }
            mf.setExtendedState(6);
            newr = showpan.screenbounds();
        } else {
            Rectangle rectangle = newr = s[5].equals("other_screen") ? orig : orig.intersection(showpan.screenbounds());
            if (mf == null) {
                mf = showpan.makeMainframe(newr);
            } else {
                mf.setBounds(newr);
            }
        }
        lookandfeel.setFontSizeForFrame();
        mf.validate();
        setup.setwindim();
        report.deb("main window: scale: " + sx + " " + sy + " origpos:  " + setup.orig.x + " " + setup.orig.y + " newpos: " + setup.newr.x + " " + setup.newr.y);
        Thread.currentThread();
        Thread.yield();
    }

    static void closeold() {
        loop.waitUntilLoopDone();
        report.deb("removing old window refs");
        try {
            for (WeakReference<JComponent> wrc : register.winmap.keySet()) {
                if (wrc.get() == null) continue;
                showpan.dispose((JComponent)wrc.get());
            }
        }
        catch (Exception ex) {
            report.deb(ex, "setup dispose error ");
        }
        register.winmap.clear();
        report.deb("removing temporary interacobs");
        for (interacob i : register.alliobs) {
            if (!i.temporary) continue;
            i.owner.removeOb(i);
            i.disposeLater();
        }
        report.deb("removing old worlds");
        world.disposeAllButOne();
        report.deb("reset all");
        jcmTree.restruclink.changed = true;
        complexity.defaultcomplexity.changed = true;
        register.resetall(true, true);
        System.gc();
    }

    static String savecomp(WeakReference<JComponent> wrc) {
        JComponent c = (JComponent)wrc.get();
        if (c.isShowing()) {
            onTop.add(c);
        }
        if (c instanceof hasSetupInfo) {
            ((hasSetupInfo)((Object)c)).savesetup();
        }
        String info = "panel\t" + c.getClass().getName() + setup.sizelocinfo(c) + "\t" + c.isShowing();
        for (Object o : register.winmap.get(wrc)) {
            if (o instanceof WeakReference) {
                o = ((WeakReference)o).get();
            }
            if (o instanceof Object[]) {
                for (Object oo : (Object[])o) {
                    info = info + "\t" + setup.getname(oo);
                }
                continue;
            }
            info = info + "\t" + setup.getname(o);
        }
        info = info + "\n";
        return info;
    }

    static void loadcomp(String[] s) {
        try {
            Point p2;
            Object[] args;
            int a1 = 7;
            int nargs = s.length - a1;
            if (nargs > 1) {
                Object[] args2 = new Object[nargs];
                for (int a = 0; a < nargs; ++a) {
                    args2[a] = setup.findob(s[a1 + a]);
                }
                args = args2;
            } else {
                args = setup.findob(s[a1]);
            }
            setup.setwindim();
            Point p = setup.convert(new Point(Integer.parseInt(s[2]), Integer.parseInt(s[3])));
            Dimension d = setup.convert(new Dimension(Integer.parseInt(s[4]), Integer.parseInt(s[5])));
            Container co = showpan.findContainerAbsolute(p);
            if (co == null) {
                p2 = new Point(p);
                p2.translate(20, 20);
                co = showpan.findContainerAbsolute(p2);
            }
            if (co == null) {
                p2 = new Point(p);
                p2.translate(-20, -20);
                co = showpan.findContainerAbsolute(p2);
            }
            if (co == null) {
                p2 = new Point(p);
                p2.translate(-d.width / 2, -d.height / 2);
                co = new JFrame(labman.getTitle(s.length > 7 ? s[7] : s[1]));
                co.setLocation(p2);
            }
            JComponent c = showpan.makepan(Class.forName(s[1]), args, co);
            c.setPreferredSize(d);
            if (Boolean.parseBoolean(s[6])) {
                onTop.add(c);
            }
        }
        catch (Exception e) {
            report.deb("setup window error" + e);
        }
    }

    static String sizelocinfo(Component c) {
        try {
            Point p;
            Dimension d = c.getSize();
            Point point = c.isShowing() ? c.getLocationOnScreen() : (p = c.getParent() != null && c.getParent().isShowing() ? c.getParent().getLocationOnScreen() : new Point(4, 4));
            if (!(c instanceof JFrame)) {
                p.x += d.width / 2;
                p.y += d.height / 2;
            }
            return "\t" + p.x + "\t" + p.y + "\t" + d.width + "\t" + d.height;
        }
        catch (Exception e) {
            report.deb(e + " for sizeloc of " + c);
            return "\t50\t50\t50\t50";
        }
    }

    static void setwindim() {
        newr = mf.getBounds();
        sx = (float)setup.newr.width / (float)setup.orig.width;
        sy = (float)setup.newr.height / (float)setup.orig.height;
    }

    static Point convert(Point p) {
        return new Point(setup.newr.x + (int)(sx * (float)(p.x - setup.orig.x)), setup.newr.y + (int)(sy * (float)(p.y - setup.orig.y)));
    }

    static Dimension convert(Dimension d) {
        return new Dimension((int)(sx * (float)d.width), (int)(sy * (float)d.height));
    }

    public static void setsizeloc(JComponent c, Point p, Dimension d) {
        jcmTabbedPane jtp = showpan.findTabbedPane(c);
        if (jtp != null) {
            c.setPreferredSize(setup.convert(d));
            jtp.getParent().validate();
        } else {
            setup.setsizeloc(c.getRootPane().getParent(), setup.convert(p), setup.convert(d));
        }
    }

    public static void setsizeloc(Container c, Point p, Dimension d) {
        c.setLocation(setup.convert(p));
        c.setSize(setup.convert(d));
        mf.validate();
        Thread.currentThread();
        Thread.yield();
    }

    static String recordSplit(JSplitPane jsp) {
        String s = "split\t" + jsp.getOrientation() + "\t" + jsp.getDividerLocation();
        Component c = jsp.getTopComponent();
        s = s + "\t" + (c instanceof JSplitPane ? setup.recordSplit((JSplitPane)c) : (c instanceof JTabbedPane ? "tab" : "dtp"));
        c = jsp.getBottomComponent();
        s = s + "\t" + (c instanceof JSplitPane ? setup.recordSplit((JSplitPane)c) : (c instanceof JTabbedPane ? "tab" : "dtp"));
        return s;
    }

    static int applySplit(String[] s, int i, JSplitPane jsp) {
        JSplitPane jsp2;
        int orient = Integer.parseInt(s[i]);
        int divloc = (int)((float)Integer.parseInt(s[i + 1]) * (orient == 1 ? sx : sy));
        jsp.setOrientation(orient);
        jsp.setDividerLocation(divloc);
        if (s[i += 2].equals("split")) {
            jsp2 = new JSplitPane();
            jsp2.setResizeWeight(0.5);
            jsp.setTopComponent(jsp2);
            i = setup.applySplit(s, i + 1, jsp2);
        } else {
            jsp.setTopComponent(s[i].equals("tab") ? new jcmTabbedPane() : showpan.makejdp());
            ++i;
        }
        if (s[i].equals("split")) {
            jsp2 = new JSplitPane();
            jsp2.setResizeWeight(0.5);
            jsp.setBottomComponent(jsp2);
            i = setup.applySplit(s, i + 1, jsp2);
        } else {
            jsp.setBottomComponent(s[i].equals("tab") ? new jcmTabbedPane() : showpan.makejdp());
            ++i;
        }
        Thread.currentThread();
        Thread.yield();
        return i;
    }

    static void setontop() {
        for (JComponent c : onTop) {
            showpan.toFront(c);
        }
        onTop.clear();
    }

    static int pin(String s) {
        return Integer.parseInt(s);
    }

    static Object findob(String s) {
        interacob o = register.findiobfullname(s);
        return o != null ? o : (s.equals("null") ? null : s);
    }

    static String getname(Object o) {
        return o == null ? "null" : (o instanceof infob ? ((infob)o).getFullName() : o.toString());
    }

    static {
        sx = 1.0f;
        sy = 1.0f;
        onTop = new HashSet<JComponent>(8);
    }
}

